/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.columns.dom.datepicker;

import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.junit.GWTMockUtilities;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.dom.datepicker.DatePickerSingletonDOMElementFactory;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;
import org.kie.workbench.common.widgets.client.util.TimeZoneUtils;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.uberfire.ext.widgets.common.client.common.DatePicker;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.GridLienzoPanel;

@PrepareForTest(value={DatePickerSingletonDOMElementFactory.class, DateTimeFormat.class, TimeZoneUtils.class})
@RunWith(value=PowerMockRunner.class)
public class DatePickerSingletonDOMElementFactoryTest {
    private static final String TEST_DATE_FORMAT = "MM-dd-yyyy HH:mm:ss Z";
    @Mock
    private GridLienzoPanel gridPanel;
    @Mock
    private GridLayer gridLayer;
    @Mock
    private GuidedDecisionTableView gridWidget;
    @Mock
    private DatePicker datePicker;

    @BeforeClass
    public static void setupStatic() {
        DatePickerSingletonDOMElementFactoryTest.preventGWTCreateError();
        DatePickerSingletonDOMElementFactoryTest.setStandardTimeZone();
        DatePickerSingletonDOMElementFactoryTest.mockStaticMethods();
        DatePickerSingletonDOMElementFactoryTest.initializeApplicationPreferences();
    }

    private static void preventGWTCreateError() {
        GWTMockUtilities.disarm();
    }

    private static void initializeApplicationPreferences() {
        ApplicationPreferences.setUp((Map)new HashMap<String, String>(){
            {
                this.put("kie_timezone_offset", "10800000");
                this.put("drools.dateformat", DatePickerSingletonDOMElementFactoryTest.TEST_DATE_FORMAT);
            }
        });
    }

    private static void mockStaticMethods() {
        PowerMockito.mockStatic(DateTimeFormat.class, (Class[])new Class[0]);
        PowerMockito.when((Object)DateTimeFormat.getFormat((String)Matchers.anyString())).thenReturn(Mockito.mock(DateTimeFormat.class));
    }

    private static void setStandardTimeZone() {
        System.setProperty("user.timezone", "Europe/Vilnius");
    }

    @Test
    public void testGetValue() {
        DatePickerSingletonDOMElementFactory factory = (DatePickerSingletonDOMElementFactory)Mockito.spy((Object)this.makeFactory());
        Date date = (Date)Mockito.mock(Date.class);
        Date convertedDate = (Date)Mockito.mock(Date.class);
        ((DatePickerSingletonDOMElementFactory)Mockito.doReturn((Object)this.datePicker).when((Object)factory)).getWidget();
        Mockito.when((Object)this.datePicker.getValue()).thenReturn((Object)date);
        PowerMockito.mockStatic(TimeZoneUtils.class, (Class[])new Class[0]);
        PowerMockito.when((Object)TimeZoneUtils.convertToServerTimeZone((Date)date)).thenReturn((Object)convertedDate);
        Date actualDate = factory.getValue();
        Assert.assertEquals((Object)convertedDate, (Object)actualDate);
    }

    private DatePickerSingletonDOMElementFactory makeFactory() {
        return new DatePickerSingletonDOMElementFactory(this.gridPanel, this.gridLayer, this.gridWidget);
    }
}

