/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.lockmanager;

import com.google.gwtmockito.GwtMockito;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.lang.reflect.Field;
import java.util.Optional;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.lockmanager.GuidedDecisionTableLockManagerImpl;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.backend.vfs.impl.LockInfo;
import org.uberfire.backend.vfs.impl.ObservablePathImpl;
import org.uberfire.client.mvp.LockManagerImpl;
import org.uberfire.client.mvp.LockTarget;
import org.uberfire.client.resources.WorkbenchResources;
import org.uberfire.client.workbench.VFSLockServiceProxy;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class GuidedDecisionTableLockManagerImplTest {
    @Mock
    private LockInfo lockInfo;
    @Mock
    private VFSLockServiceProxy lockService;
    @Mock
    private User user;
    private EventSourceMock<ChangeTitleWidgetEvent> changeTitleEvent = (EventSourceMock)Mockito.spy((Object)new EventSourceMock<ChangeTitleWidgetEvent>(){

        public void fire(ChangeTitleWidgetEvent event) {
        }
    });
    @Mock
    private GuidedDecisionTableModellerView.Presenter modellerPresenter;
    private GuidedDecisionTableLockManagerImpl lockManager;

    @Before
    public void setup() throws NoSuchFieldException, IllegalAccessException {
        PathFactory.PathImpl filename = this.makePathImpl("filename");
        GwtMockito.useProviderForType(WorkbenchResources.class, type -> null);
        this.lockManager = new GuidedDecisionTableLockManagerImpl();
        this.setLockManagerField("lockService", this.lockService);
        this.setLockManagerField("lockInfo", this.lockInfo);
        this.setLockManagerField("changeTitleEvent", this.changeTitleEvent);
        this.setLockManagerField("user", this.user);
        Mockito.when((Object)this.lockInfo.getFile()).thenReturn((Object)filename);
        Mockito.when((Object)this.user.getIdentifier()).thenReturn((Object)"user");
    }

    private void setLockManagerField(String fieldName, Object value) {
        try {
            Field field = LockManagerImpl.class.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(this.lockManager, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testFireChangeTitleEvent_NoActiveDecisionTable() {
        this.lockManager.init((LockTarget)Mockito.mock(LockTarget.class), this.modellerPresenter);
        Mockito.when((Object)this.modellerPresenter.getActiveDecisionTable()).thenReturn(Optional.empty());
        this.lockManager.fireChangeTitleEvent();
        ((EventSourceMock)Mockito.verify(this.changeTitleEvent, (VerificationMode)Mockito.never())).fire(Mockito.any(ChangeTitleWidgetEvent.class));
    }

    @Test
    public void testFireChangeTitleEvent_LockInfoUpdateForActiveDecisionTable() {
        this.lockManager.init((LockTarget)Mockito.mock(LockTarget.class), this.modellerPresenter);
        GuidedDecisionTableView.Presenter dtPresenter = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        PathFactory.PathImpl lockInfoPath = this.makePathImpl("filename");
        ObservablePath presenterPath = this.makeObservablePath("filename");
        Mockito.when((Object)this.lockInfo.getFile()).thenReturn((Object)lockInfoPath);
        Mockito.when((Object)dtPresenter.getCurrentPath()).thenReturn((Object)presenterPath);
        Mockito.when((Object)this.modellerPresenter.getActiveDecisionTable()).thenReturn(Optional.of(dtPresenter));
        this.lockManager.fireChangeTitleEvent();
        ((EventSourceMock)Mockito.verify(this.changeTitleEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(ChangeTitleWidgetEvent.class));
    }

    @Test
    public void testFireChangeTitleEvent_LockInfoUpdateForNonActiveDecisionTable() {
        this.lockManager.init((LockTarget)Mockito.mock(LockTarget.class), this.modellerPresenter);
        GuidedDecisionTableView.Presenter dtPresenter = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        Mockito.when((Object)dtPresenter.getCurrentPath()).thenReturn(Mockito.mock(ObservablePath.class));
        Mockito.when((Object)this.modellerPresenter.getActiveDecisionTable()).thenReturn(Optional.of(dtPresenter));
        this.lockManager.fireChangeTitleEvent();
        ((EventSourceMock)Mockito.verify(this.changeTitleEvent, (VerificationMode)Mockito.never())).fire(Mockito.any(ChangeTitleWidgetEvent.class));
    }

    private PathFactory.PathImpl makePathImpl(final String name) {
        return new PathFactory.PathImpl(){

            public String getFileName() {
                return name + ".txt";
            }

            public String toURI() {
                return "/directory/" + name + ".txt";
            }
        };
    }

    private ObservablePath makeObservablePath(String name) {
        return new ObservablePathImpl().wrap(this.makePath(name));
    }

    private Path makePath(final String name) {
        return new Path(){

            public String getFileName() {
                return name + ".txt";
            }

            public String toURI() {
                return "/directory/" + name + ".txt";
            }

            public int compareTo(Path o) {
                return 0;
            }
        };
    }
}

