/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.MetadataCol52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.StringUiColumn;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.ModelSynchronizer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.impl.BaseSynchronizer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.impl.BaseSynchronizerTest;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.impl.MetaDataColumnSynchronizer;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;

public class MetaDataColumnSynchronizerTest
extends BaseSynchronizerTest {
    @Test
    public void testAppend() throws ModelSynchronizer.VetoException {
        MetadataCol52 column = new MetadataCol52();
        column.setMetadata("smurf");
        this.modelSynchronizer.appendColumn((BaseColumn)column);
        Assert.assertEquals((long)1L, (long)this.model.getMetadataCols().size());
        Assert.assertEquals((Object)"smurf", (Object)((MetadataCol52)this.model.getMetadataCols().get(0)).getMetadata());
        Assert.assertEquals((long)4L, (long)this.uiModel.getColumns().size());
        Assert.assertEquals((Object)"smurf", (Object)((GridColumn.HeaderMetaData)((GridColumn)this.uiModel.getColumns().get(3)).getHeaderMetaData().get(0)).getTitle());
    }

    @Test
    public void testUpdate1() throws ModelSynchronizer.VetoException {
        MetadataCol52 column = (MetadataCol52)Mockito.spy((Object)new MetadataCol52());
        column.setMetadata("smurf");
        this.modelSynchronizer.appendColumn((BaseColumn)column);
        MetadataCol52 edited = new MetadataCol52();
        edited.setWidth(column.getWidth());
        edited.setMetadata("changed");
        List diffs = this.modelSynchronizer.updateColumn((BaseColumn)column, (BaseColumn)edited);
        Assert.assertEquals((long)1L, (long)diffs.size());
        ((MetadataCol52)Mockito.verify((Object)column)).diff((BaseColumn)edited);
        Assert.assertEquals((long)1L, (long)this.model.getMetadataCols().size());
        Assert.assertEquals((Object)"changed", (Object)((MetadataCol52)this.model.getMetadataCols().get(0)).getMetadata());
        Assert.assertEquals((long)4L, (long)this.uiModel.getColumns().size());
        Assert.assertEquals((Object)"changed", (Object)((GridColumn.HeaderMetaData)((GridColumn)this.uiModel.getColumns().get(3)).getHeaderMetaData().get(0)).getTitle());
    }

    @Test
    public void testUpdate2() throws ModelSynchronizer.VetoException {
        MetadataCol52 column = (MetadataCol52)Mockito.spy((Object)new MetadataCol52());
        column.setMetadata("smurf");
        this.modelSynchronizer.appendColumn((BaseColumn)column);
        MetadataCol52 edited = new MetadataCol52();
        edited.setWidth(column.getWidth());
        edited.setMetadata("smurf");
        edited.setHideColumn(true);
        List diffs = this.modelSynchronizer.updateColumn((BaseColumn)column, (BaseColumn)edited);
        Assert.assertEquals((long)1L, (long)diffs.size());
        ((MetadataCol52)Mockito.verify((Object)column)).diff((BaseColumn)edited);
        Assert.assertEquals((long)1L, (long)this.model.getMetadataCols().size());
        Assert.assertEquals((Object)"smurf", (Object)((MetadataCol52)this.model.getMetadataCols().get(0)).getMetadata());
        Assert.assertEquals((long)4L, (long)this.uiModel.getColumns().size());
        Assert.assertEquals((Object)"smurf", (Object)((GridColumn.HeaderMetaData)((GridColumn)this.uiModel.getColumns().get(3)).getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)false, (Object)((GridColumn)this.uiModel.getColumns().get(3)).isVisible());
    }

    @Test
    public void testDelete() throws ModelSynchronizer.VetoException {
        MetadataCol52 column = new MetadataCol52();
        column.setMetadata("smurf");
        this.modelSynchronizer.appendColumn((BaseColumn)column);
        Assert.assertEquals((long)1L, (long)this.model.getMetadataCols().size());
        Assert.assertEquals((long)4L, (long)this.uiModel.getColumns().size());
        this.modelSynchronizer.deleteColumn((BaseColumn)column);
        Assert.assertEquals((long)0L, (long)this.model.getMetadataCols().size());
        Assert.assertEquals((long)3L, (long)this.uiModel.getColumns().size());
    }

    @Test
    public void testMoveColumnTo_MoveLeft() throws ModelSynchronizer.VetoException {
        MetadataCol52 column1 = new MetadataCol52();
        column1.setMetadata("metadata1");
        MetadataCol52 column2 = new MetadataCol52();
        column2.setMetadata("metadata2");
        this.modelSynchronizer.appendColumn((BaseColumn)column1);
        this.modelSynchronizer.appendColumn((BaseColumn)column2);
        this.modelSynchronizer.appendRow();
        this.uiModel.setCellValue(0, 3, (GridCellValue)new BaseGridCellValue((Object)"metadata1"));
        this.uiModel.setCellValue(0, 4, (GridCellValue)new BaseGridCellValue((Object)"metadata2"));
        Assert.assertEquals((long)2L, (long)this.model.getMetadataCols().size());
        Assert.assertEquals((Object)column1, this.model.getMetadataCols().get(0));
        Assert.assertEquals((Object)column2, this.model.getMetadataCols().get(1));
        Assert.assertEquals((Object)"metadata1", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(3)).getStringValue());
        Assert.assertEquals((Object)"metadata2", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(4)).getStringValue());
        Assert.assertEquals((long)5L, (long)this.uiModel.getColumns().size());
        GridColumn uiModelColumn1_1 = (GridColumn)this.uiModel.getColumns().get(3);
        GridColumn uiModelColumn2_1 = (GridColumn)this.uiModel.getColumns().get(4);
        Assert.assertEquals((Object)"metadata1", (Object)((GridColumn.HeaderMetaData)uiModelColumn1_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"metadata2", (Object)((GridColumn.HeaderMetaData)uiModelColumn2_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertTrue((boolean)(uiModelColumn1_1 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn2_1 instanceof StringUiColumn));
        Assert.assertEquals((long)3L, (long)uiModelColumn1_1.getIndex());
        Assert.assertEquals((long)4L, (long)uiModelColumn2_1.getIndex());
        Assert.assertEquals((Object)"metadata1", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn1_1.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"metadata2", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn2_1.getIndex())).getValue().getValue());
        this.uiModel.moveColumnTo(3, uiModelColumn2_1);
        Assert.assertEquals((long)2L, (long)this.model.getMetadataCols().size());
        Assert.assertEquals((Object)column2, this.model.getMetadataCols().get(0));
        Assert.assertEquals((Object)column1, this.model.getMetadataCols().get(1));
        Assert.assertEquals((Object)"metadata2", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(3)).getStringValue());
        Assert.assertEquals((Object)"metadata1", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(4)).getStringValue());
        Assert.assertEquals((long)5L, (long)this.uiModel.getColumns().size());
        GridColumn uiModelColumn1_2 = (GridColumn)this.uiModel.getColumns().get(3);
        GridColumn uiModelColumn2_2 = (GridColumn)this.uiModel.getColumns().get(4);
        Assert.assertEquals((Object)"metadata2", (Object)((GridColumn.HeaderMetaData)uiModelColumn1_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"metadata1", (Object)((GridColumn.HeaderMetaData)uiModelColumn2_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertTrue((boolean)(uiModelColumn1_2 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn2_2 instanceof StringUiColumn));
        Assert.assertEquals((long)4L, (long)uiModelColumn1_2.getIndex());
        Assert.assertEquals((long)3L, (long)uiModelColumn2_2.getIndex());
        Assert.assertEquals((Object)"metadata2", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn1_2.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"metadata1", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn2_2.getIndex())).getValue().getValue());
    }

    @Test
    public void testMoveColumnTo_MoveRight() throws ModelSynchronizer.VetoException {
        MetadataCol52 column1 = new MetadataCol52();
        column1.setMetadata("metadata1");
        MetadataCol52 column2 = new MetadataCol52();
        column2.setMetadata("metadata2");
        this.modelSynchronizer.appendColumn((BaseColumn)column1);
        this.modelSynchronizer.appendColumn((BaseColumn)column2);
        this.modelSynchronizer.appendRow();
        this.uiModel.setCellValue(0, 3, (GridCellValue)new BaseGridCellValue((Object)"metadata1"));
        this.uiModel.setCellValue(0, 4, (GridCellValue)new BaseGridCellValue((Object)"metadata2"));
        Assert.assertEquals((long)2L, (long)this.model.getMetadataCols().size());
        Assert.assertEquals((Object)column1, this.model.getMetadataCols().get(0));
        Assert.assertEquals((Object)column2, this.model.getMetadataCols().get(1));
        Assert.assertEquals((Object)"metadata1", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(3)).getStringValue());
        Assert.assertEquals((Object)"metadata2", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(4)).getStringValue());
        Assert.assertEquals((long)5L, (long)this.uiModel.getColumns().size());
        GridColumn uiModelColumn1_1 = (GridColumn)this.uiModel.getColumns().get(3);
        GridColumn uiModelColumn2_1 = (GridColumn)this.uiModel.getColumns().get(4);
        Assert.assertEquals((Object)"metadata1", (Object)((GridColumn.HeaderMetaData)uiModelColumn1_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"metadata2", (Object)((GridColumn.HeaderMetaData)uiModelColumn2_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertTrue((boolean)(uiModelColumn1_1 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn2_1 instanceof StringUiColumn));
        Assert.assertEquals((long)3L, (long)uiModelColumn1_1.getIndex());
        Assert.assertEquals((long)4L, (long)uiModelColumn2_1.getIndex());
        Assert.assertEquals((Object)"metadata1", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn1_1.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"metadata2", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn2_1.getIndex())).getValue().getValue());
        this.uiModel.moveColumnTo(4, uiModelColumn1_1);
        Assert.assertEquals((long)2L, (long)this.model.getMetadataCols().size());
        Assert.assertEquals((Object)column2, this.model.getMetadataCols().get(0));
        Assert.assertEquals((Object)column1, this.model.getMetadataCols().get(1));
        Assert.assertEquals((Object)"metadata2", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(3)).getStringValue());
        Assert.assertEquals((Object)"metadata1", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(4)).getStringValue());
        Assert.assertEquals((long)5L, (long)this.uiModel.getColumns().size());
        GridColumn uiModelColumn1_2 = (GridColumn)this.uiModel.getColumns().get(3);
        GridColumn uiModelColumn2_2 = (GridColumn)this.uiModel.getColumns().get(4);
        Assert.assertEquals((Object)"metadata2", (Object)((GridColumn.HeaderMetaData)uiModelColumn1_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"metadata1", (Object)((GridColumn.HeaderMetaData)uiModelColumn2_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertTrue((boolean)(uiModelColumn1_2 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn2_2 instanceof StringUiColumn));
        Assert.assertEquals((long)4L, (long)uiModelColumn1_2.getIndex());
        Assert.assertEquals((long)3L, (long)uiModelColumn2_2.getIndex());
        Assert.assertEquals((Object)"metadata2", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn1_2.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"metadata1", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn2_2.getIndex())).getValue().getValue());
    }

    @Test
    public void testMoveColumnTo_OutOfBounds() throws ModelSynchronizer.VetoException {
        MetadataCol52 column1 = new MetadataCol52();
        column1.setMetadata("metadata1");
        MetadataCol52 column2 = new MetadataCol52();
        column2.setMetadata("metadata2");
        this.modelSynchronizer.appendColumn((BaseColumn)column1);
        this.modelSynchronizer.appendColumn((BaseColumn)column2);
        this.modelSynchronizer.appendRow();
        this.uiModel.setCellValue(0, 3, (GridCellValue)new BaseGridCellValue((Object)"metadata1"));
        this.uiModel.setCellValue(0, 4, (GridCellValue)new BaseGridCellValue((Object)"metadata2"));
        Assert.assertEquals((long)2L, (long)this.model.getMetadataCols().size());
        Assert.assertEquals((Object)column1, this.model.getMetadataCols().get(0));
        Assert.assertEquals((Object)column2, this.model.getMetadataCols().get(1));
        Assert.assertEquals((Object)"metadata1", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(3)).getStringValue());
        Assert.assertEquals((Object)"metadata2", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(4)).getStringValue());
        Assert.assertEquals((long)5L, (long)this.uiModel.getColumns().size());
        GridColumn uiModelColumn1_1 = (GridColumn)this.uiModel.getColumns().get(3);
        GridColumn uiModelColumn2_1 = (GridColumn)this.uiModel.getColumns().get(4);
        Assert.assertEquals((Object)"metadata1", (Object)((GridColumn.HeaderMetaData)uiModelColumn1_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"metadata2", (Object)((GridColumn.HeaderMetaData)uiModelColumn2_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertTrue((boolean)(uiModelColumn1_1 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn2_1 instanceof StringUiColumn));
        Assert.assertEquals((long)3L, (long)uiModelColumn1_1.getIndex());
        Assert.assertEquals((long)4L, (long)uiModelColumn2_1.getIndex());
        Assert.assertEquals((Object)"metadata1", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn1_1.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"metadata2", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn2_1.getIndex())).getValue().getValue());
        this.uiModel.moveColumnTo(1, uiModelColumn1_1);
        Assert.assertEquals((long)2L, (long)this.model.getMetadataCols().size());
        Assert.assertEquals((Object)column1, this.model.getMetadataCols().get(0));
        Assert.assertEquals((Object)column2, this.model.getMetadataCols().get(1));
        Assert.assertEquals((Object)"metadata1", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(3)).getStringValue());
        Assert.assertEquals((Object)"metadata2", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(4)).getStringValue());
        Assert.assertEquals((long)5L, (long)this.uiModel.getColumns().size());
        GridColumn uiModelColumn1_2 = (GridColumn)this.uiModel.getColumns().get(3);
        GridColumn uiModelColumn2_2 = (GridColumn)this.uiModel.getColumns().get(4);
        Assert.assertEquals((Object)"metadata1", (Object)((GridColumn.HeaderMetaData)uiModelColumn1_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"metadata2", (Object)((GridColumn.HeaderMetaData)uiModelColumn2_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertTrue((boolean)(uiModelColumn1_2 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn2_2 instanceof StringUiColumn));
        Assert.assertEquals((long)3L, (long)uiModelColumn1_2.getIndex());
        Assert.assertEquals((long)4L, (long)uiModelColumn2_2.getIndex());
        Assert.assertEquals((Object)"metadata1", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn1_2.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"metadata2", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn2_2.getIndex())).getValue().getValue());
    }

    @Test
    public void testMoveColumnsTo_MoveLeft() throws ModelSynchronizer.VetoException {
        MetadataCol52 column1 = new MetadataCol52();
        column1.setMetadata("metadata1");
        MetadataCol52 column2 = new MetadataCol52();
        column2.setMetadata("metadata2");
        MetadataCol52 column3 = new MetadataCol52();
        column3.setMetadata("metadata3");
        this.modelSynchronizer.appendColumn((BaseColumn)column1);
        this.modelSynchronizer.appendColumn((BaseColumn)column2);
        this.modelSynchronizer.appendColumn((BaseColumn)column3);
        this.modelSynchronizer.appendRow();
        this.uiModel.setCellValue(0, 3, (GridCellValue)new BaseGridCellValue((Object)"metadata1"));
        this.uiModel.setCellValue(0, 4, (GridCellValue)new BaseGridCellValue((Object)"metadata2"));
        this.uiModel.setCellValue(0, 5, (GridCellValue)new BaseGridCellValue((Object)"metadata3"));
        GridColumn uiModelColumn1_1 = (GridColumn)this.uiModel.getColumns().get(3);
        final GridColumn uiModelColumn2_1 = (GridColumn)this.uiModel.getColumns().get(4);
        final GridColumn uiModelColumn3_1 = (GridColumn)this.uiModel.getColumns().get(5);
        this.assertTestMoveColumnsTo(column1, column2, column3, uiModelColumn1_1, uiModelColumn2_1, uiModelColumn3_1);
        this.uiModel.moveColumnsTo(3, (List)new ArrayList<GridColumn<?>>(){
            {
                this.add(uiModelColumn2_1);
                this.add(uiModelColumn3_1);
            }
        });
        GridColumn uiModelColumn1_2 = (GridColumn)this.uiModel.getColumns().get(3);
        GridColumn uiModelColumn2_2 = (GridColumn)this.uiModel.getColumns().get(4);
        GridColumn uiModelColumn3_2 = (GridColumn)this.uiModel.getColumns().get(5);
        this.assertTestMoveColumnsTo(column1, column2, column3, uiModelColumn1_2, uiModelColumn2_2, uiModelColumn3_2);
    }

    @Test
    public void testMoveColumnsTo_MoveRight() throws ModelSynchronizer.VetoException {
        MetadataCol52 column1 = new MetadataCol52();
        column1.setMetadata("metadata1");
        MetadataCol52 column2 = new MetadataCol52();
        column2.setMetadata("metadata2");
        MetadataCol52 column3 = new MetadataCol52();
        column3.setMetadata("metadata3");
        this.modelSynchronizer.appendColumn((BaseColumn)column1);
        this.modelSynchronizer.appendColumn((BaseColumn)column2);
        this.modelSynchronizer.appendColumn((BaseColumn)column3);
        this.modelSynchronizer.appendRow();
        this.uiModel.setCellValue(0, 3, (GridCellValue)new BaseGridCellValue((Object)"metadata1"));
        this.uiModel.setCellValue(0, 4, (GridCellValue)new BaseGridCellValue((Object)"metadata2"));
        this.uiModel.setCellValue(0, 5, (GridCellValue)new BaseGridCellValue((Object)"metadata3"));
        final GridColumn uiModelColumn1_1 = (GridColumn)this.uiModel.getColumns().get(3);
        final GridColumn uiModelColumn2_1 = (GridColumn)this.uiModel.getColumns().get(4);
        GridColumn uiModelColumn3_1 = (GridColumn)this.uiModel.getColumns().get(5);
        this.assertTestMoveColumnsTo(column1, column2, column3, uiModelColumn1_1, uiModelColumn2_1, uiModelColumn3_1);
        this.uiModel.moveColumnsTo(5, (List)new ArrayList<GridColumn<?>>(){
            {
                this.add(uiModelColumn1_1);
                this.add(uiModelColumn2_1);
            }
        });
        GridColumn uiModelColumn1_2 = (GridColumn)this.uiModel.getColumns().get(3);
        GridColumn uiModelColumn2_2 = (GridColumn)this.uiModel.getColumns().get(4);
        GridColumn uiModelColumn3_2 = (GridColumn)this.uiModel.getColumns().get(5);
        this.assertTestMoveColumnsTo(column1, column2, column3, uiModelColumn1_2, uiModelColumn2_2, uiModelColumn3_2);
    }

    @Test
    public void checkHandlesMoveColumnsToWithEmptyMetadata() throws ModelSynchronizer.VetoException {
        MetaDataColumnSynchronizer synchronizer = new MetaDataColumnSynchronizer();
        Assert.assertFalse((boolean)synchronizer.handlesMoveColumnsTo(Collections.emptyList()));
    }

    @Test
    public void checkHandlesMoveColumnsToWithMultipleMetadata() throws ModelSynchronizer.VetoException {
        final BaseSynchronizer.MoveColumnToMetaData md0 = (BaseSynchronizer.MoveColumnToMetaData)Mockito.mock(BaseSynchronizer.MoveColumnToMetaData.class);
        final BaseSynchronizer.MoveColumnToMetaData md1 = (BaseSynchronizer.MoveColumnToMetaData)Mockito.mock(BaseSynchronizer.MoveColumnToMetaData.class);
        MetaDataColumnSynchronizer synchronizer = new MetaDataColumnSynchronizer();
        Mockito.when((Object)md0.getColumn()).thenReturn(Mockito.mock(MetadataCol52.class));
        Mockito.when((Object)md1.getColumn()).thenReturn(Mockito.mock(MetadataCol52.class));
        Assert.assertFalse((boolean)synchronizer.handlesMoveColumnsTo((List)new ArrayList<BaseSynchronizer.MoveColumnToMetaData>(){
            {
                this.add(md0);
                this.add(md1);
            }
        }));
    }

    @Test
    public void checkHandlesMoveColumnsToWithSingleMetadata() throws ModelSynchronizer.VetoException {
        BaseSynchronizer.MoveColumnToMetaData md0 = (BaseSynchronizer.MoveColumnToMetaData)Mockito.mock(BaseSynchronizer.MoveColumnToMetaData.class);
        MetaDataColumnSynchronizer synchronizer = new MetaDataColumnSynchronizer();
        Mockito.when((Object)md0.getColumn()).thenReturn(Mockito.mock(MetadataCol52.class));
        Assert.assertTrue((boolean)synchronizer.handlesMoveColumnsTo(Collections.singletonList(md0)));
    }

    private void assertTestMoveColumnsTo(MetadataCol52 column1, MetadataCol52 column2, MetadataCol52 column3, GridColumn<?> uiModelColumn1, GridColumn<?> uiModelColumn2, GridColumn<?> uiModelColumn3) {
        Assert.assertEquals((long)3L, (long)this.model.getMetadataCols().size());
        Assert.assertEquals((Object)column1, this.model.getMetadataCols().get(0));
        Assert.assertEquals((Object)column2, this.model.getMetadataCols().get(1));
        Assert.assertEquals((Object)column3, this.model.getMetadataCols().get(2));
        Assert.assertEquals((Object)"metadata1", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(3)).getStringValue());
        Assert.assertEquals((Object)"metadata2", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(4)).getStringValue());
        Assert.assertEquals((Object)"metadata3", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(5)).getStringValue());
        Assert.assertEquals((long)6L, (long)this.uiModel.getColumns().size());
        Assert.assertEquals((Object)"metadata1", (Object)((GridColumn.HeaderMetaData)uiModelColumn1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"metadata2", (Object)((GridColumn.HeaderMetaData)uiModelColumn2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"metadata3", (Object)((GridColumn.HeaderMetaData)uiModelColumn3.getHeaderMetaData().get(0)).getTitle());
        Assert.assertTrue((boolean)(uiModelColumn1 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn2 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn3 instanceof StringUiColumn));
        Assert.assertEquals((long)3L, (long)uiModelColumn1.getIndex());
        Assert.assertEquals((long)4L, (long)uiModelColumn2.getIndex());
        Assert.assertEquals((long)5L, (long)uiModelColumn3.getIndex());
        Assert.assertEquals((Object)"metadata1", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn1.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"metadata2", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn2.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"metadata3", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn3.getIndex())).getValue().getValue());
    }
}

