/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.popovers.definitions;

import java.util.concurrent.atomic.AtomicBoolean;
import org.drools.workbench.models.datamodel.rule.ActionFieldValue;
import org.drools.workbench.models.datamodel.rule.ActionInsertFact;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.RowNumberCol52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.popovers.definitions.BRLActionColumnDefinitionBuilder;
import org.drools.workbench.screens.guided.dtable.client.widget.table.popovers.definitions.BaseColumnDefinitionBuilderTest;
import org.drools.workbench.screens.guided.dtable.client.widget.table.popovers.definitions.ColumnDefinitionBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class BRLActionColumnDefinitionBuilderTest
extends BaseColumnDefinitionBuilderTest {
    @Override
    protected ColumnDefinitionBuilder getBuilder() {
        return new BRLActionColumnDefinitionBuilder(this.serviceCaller);
    }

    @Test
    public void checkColumnType() {
        Assert.assertEquals(BRLActionVariableColumn.class, (Object)this.builder.getSupportedColumnType());
    }

    @Test
    public void unknownColumnTypeDoesNotTriggerBuilder() {
        RowNumberCol52 column = new RowNumberCol52();
        this.builder.generateDefinition(this.dtPresenter, (BaseColumn)column, definition -> Assert.fail((String)"RowNumberCol52 should not be handled by ConditionCol52DefinitionBuilder"));
    }

    @Test
    public void simpleBRLActionColumn() {
        AtomicBoolean calledBack = new AtomicBoolean(false);
        this.setupBRLActionColumn();
        this.builder.generateDefinition(this.dtPresenter, (BaseColumn)this.model.getExpandedColumns().get(3), definition -> {
            calledBack.set(true);
            Assert.assertEquals((Object)"Person $a = new Person();<br/>$a.setName( \"x\" );<br/>$a.setAge( \"1\" );<br/>insert( $a );", (Object)definition);
        });
        Assert.assertTrue((boolean)calledBack.get());
    }

    private void setupBRLActionColumn() {
        BRLActionColumn brl = new BRLActionColumn();
        ActionInsertFact ifc1 = new ActionInsertFact();
        ifc1.setFactType("Person");
        ifc1.setBoundName("$a");
        ActionFieldValue afv1 = new ActionFieldValue();
        afv1.setNature(7);
        afv1.setField("name");
        afv1.setValue("f1");
        ifc1.addFieldValue(afv1);
        ActionFieldValue afv2 = new ActionFieldValue();
        afv2.setNature(7);
        afv2.setField("age");
        afv2.setValue("f2");
        ifc1.addFieldValue(afv2);
        brl.getDefinition().add(ifc1);
        brl.getChildColumns().add(new BRLActionVariableColumn("f1", "String"));
        brl.getChildColumns().add(new BRLActionVariableColumn("f2", "Integer"));
        this.model.getActionCols().add(brl);
    }
}

