/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.popovers.definitions;

import java.util.concurrent.atomic.AtomicBoolean;
import org.drools.workbench.models.datamodel.rule.FactPattern;
import org.drools.workbench.models.datamodel.rule.FieldConstraint;
import org.drools.workbench.models.datamodel.rule.SingleFieldConstraint;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.RowNumberCol52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.popovers.definitions.BRLConditionColumnDefinitionBuilder;
import org.drools.workbench.screens.guided.dtable.client.widget.table.popovers.definitions.BaseColumnDefinitionBuilderTest;
import org.drools.workbench.screens.guided.dtable.client.widget.table.popovers.definitions.ColumnDefinitionBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class BRLConditionColumnDefinitionBuilderTest
extends BaseColumnDefinitionBuilderTest {
    @Override
    protected ColumnDefinitionBuilder getBuilder() {
        return new BRLConditionColumnDefinitionBuilder(this.serviceCaller);
    }

    @Test
    public void checkColumnType() {
        Assert.assertEquals(BRLConditionVariableColumn.class, (Object)this.builder.getSupportedColumnType());
    }

    @Test
    public void unknownColumnTypeDoesNotTriggerBuilder() {
        RowNumberCol52 column = new RowNumberCol52();
        this.builder.generateDefinition(this.dtPresenter, (BaseColumn)column, definition -> Assert.fail((String)"RowNumberCol52 should not be handled by ConditionCol52DefinitionBuilder"));
    }

    @Test
    public void simpleBRLConditionColumn() {
        AtomicBoolean calledBack = new AtomicBoolean(false);
        this.setupBRLConditionColumn();
        this.builder.generateDefinition(this.dtPresenter, (BaseColumn)this.model.getExpandedColumns().get(3), definition -> {
            calledBack.set(true);
            Assert.assertEquals((Object)"Person( name == \"x\" )<br/>Smurf( colour == \"x\" )", (Object)definition);
        });
        Assert.assertTrue((boolean)calledBack.get());
    }

    private void setupBRLConditionColumn() {
        BRLConditionColumn brl = new BRLConditionColumn();
        FactPattern fp1 = new FactPattern();
        fp1.setFactType("Person");
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setConstraintValueType(7);
        sfc1.setFactType("Person");
        sfc1.setOperator("==");
        sfc1.setFieldName("name");
        sfc1.setValue("f1");
        fp1.addConstraint((FieldConstraint)sfc1);
        FactPattern fp2 = new FactPattern();
        fp2.setFactType("Smurf");
        SingleFieldConstraint sfc2 = new SingleFieldConstraint();
        sfc2.setConstraintValueType(7);
        sfc2.setFactType("Smurf");
        sfc2.setOperator("==");
        sfc2.setFieldName("colour");
        sfc2.setValue("f2");
        fp2.addConstraint((FieldConstraint)sfc2);
        brl.getDefinition().add(fp1);
        brl.getDefinition().add(fp2);
        brl.getChildColumns().add(new BRLConditionVariableColumn("f1", "String"));
        brl.getChildColumns().add(new BRLConditionVariableColumn("f2", "String"));
        this.model.getConditions().add(brl);
    }
}

