/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.utilities;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.utilities.CellUtilities;
import org.drools.workbench.screens.guided.dtable.model.JVMDateConverter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.soup.project.datamodel.oracle.DataType;
import org.kie.soup.project.datamodel.oracle.DateConverter;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;

@RunWith(value=Parameterized.class)
public class CellUtilitiesConvertToDateTest {
    private Object expected;
    private Object value;
    private boolean isOtherwise;
    private CellUtilities cellUtilities;

    public CellUtilitiesConvertToDateTest(Object expected, Object value, boolean isOtherwise) {
        this.expected = expected;
        this.value = value;
        this.isOtherwise = isOtherwise;
    }

    @Before
    public void setup() {
        this.cellUtilities = new CellUtilities();
    }

    @Parameterized.Parameters
    public static Collection testParameters() {
        ApplicationPreferences.setUp((Map)new HashMap<String, String>(){
            {
                this.put("drools.dateformat", "dd-MM-yyyy");
            }
        });
        DateConverter dateConverter = JVMDateConverter.getInstance();
        Date date = dateConverter.parse("28-06-2016");
        CellUtilities.injectDateConvertor((DateConverter)dateConverter);
        return Arrays.asList({null, new BigDecimal("1"), false}, {null, new BigInteger("2"), false}, {null, new Byte("3"), false}, {null, new Double("4.0"), false}, {null, new Float("5.0"), false}, {null, new Integer("6"), false}, {null, new Long("7"), false}, {null, new Short("8"), false}, {null, "9", false}, {null, true, false}, {date, date, false}, {null, "banana", false}, {date, "28-06-2016", false}, {null, null, true});
    }

    @Test
    public void conversion() {
        DTCellValue52 dcv = new DTCellValue52(this.value);
        dcv.setOtherwise(this.isOtherwise);
        Assert.assertEquals((Object)this.expected, (Object)this.cellUtilities.convertToDate(dcv));
    }

    @Test
    public void conversionToDataType() {
        DTCellValue52 dcv = new DTCellValue52(this.value);
        dcv.setOtherwise(this.isOtherwise);
        this.cellUtilities.convertDTCellValueType(DataType.DataTypes.DATE, dcv);
        Assert.assertEquals((Object)this.expected, (Object)dcv.getDateValue());
    }
}

