/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.NewGuidedDecisionTableColumnWizard;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.commons.HasDefaultValuesPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.commons.HasPatternPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.AdditionalInfoPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.OperatorPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.PatternPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.SummaryPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.common.DecisionTablePopoverUtils;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.ActionRetractFactPlugin;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.ActionSetFactPlugin;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.ActionWorkItemPlugin;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.ActionWorkItemSetFieldPlugin;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.BRLActionColumnPlugin;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.BRLConditionColumnPlugin;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.ConditionColumnPlugin;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.DecisionTableColumnPlugin;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.widgets.core.client.wizards.WizardPage;
import org.uberfire.ext.widgets.core.client.wizards.WizardView;

@RunWith(value=GwtMockitoTestRunner.class)
public class NewGuidedDecisionTableColumnWizardTest {
    private List<WizardPage> pages;
    @Mock(extraInterfaces={HasDefaultValuesPage.class, HasPatternPage.class})
    private ConditionColumnPlugin plugin;
    @Mock
    private ActionWorkItemSetFieldPlugin actionWorkItemSetFieldPlugin;
    @Mock
    private ActionSetFactPlugin actionSetFactPlugin;
    @Mock
    private ActionRetractFactPlugin actionRetractFactPlugin;
    @Mock
    private ActionWorkItemPlugin actionWorkItemPlugin;
    @Mock
    private BRLActionColumnPlugin brlActionColumnPlugin;
    @Mock
    private BRLConditionColumnPlugin brlConditionColumnPlugin;
    @Mock
    private ConditionColumnPlugin conditionColumnPlugin;
    @Mock
    private SummaryPage summaryPage;
    @Mock
    private PatternPage patternPage;
    @Mock
    private AdditionalInfoPage additionalInfoPage;
    @Mock
    private OperatorPage operatorPage;
    @Mock
    private WizardView view;
    @Mock
    private TranslationService translationService;
    @Mock
    private DecisionTablePopoverUtils popoverUtils;
    private NewGuidedDecisionTableColumnWizard wizard;

    @Before
    public void setup() {
        this.wizard = (NewGuidedDecisionTableColumnWizard)Mockito.spy((Object)new NewGuidedDecisionTableColumnWizard(this.view, this.summaryPage, this.translationService, this.popoverUtils));
        this.pages = (List)Mockito.spy(new ArrayList());
        this.wizard.setPages(this.pages);
    }

    @Test
    public void testLoadPagesWhenTheColumnIsNew() {
        ArrayList wizardPages = new ArrayList();
        Mockito.when((Object)this.plugin.getPages()).thenReturn(wizardPages);
        Mockito.when((Object)this.plugin.isNewColumn()).thenReturn((Object)Boolean.TRUE);
        this.wizard.loadPages((DecisionTableColumnPlugin)this.plugin);
        ((List)Mockito.verify(this.pages)).clear();
        ((List)Mockito.verify(this.pages)).addAll(wizardPages);
        ((List)Mockito.verify(this.pages)).add(this.summaryPage);
    }

    @Test
    public void testLoadPagesWhenTheColumnIsNotNew() {
        ArrayList wizardPages = new ArrayList();
        Mockito.when((Object)this.plugin.getPages()).thenReturn(wizardPages);
        Mockito.when((Object)this.plugin.isNewColumn()).thenReturn((Object)Boolean.FALSE);
        this.wizard.loadPages((DecisionTableColumnPlugin)this.plugin);
        ((List)Mockito.verify(this.pages)).clear();
        ((List)Mockito.verify(this.pages)).addAll(wizardPages);
        ((List)Mockito.verify(this.pages, (VerificationMode)Mockito.never())).add(this.summaryPage);
    }

    @Test
    public void testStart() {
        ((NewGuidedDecisionTableColumnWizard)Mockito.doNothing().when((Object)this.wizard)).parentStart();
        this.wizard.start((DecisionTableColumnPlugin)this.plugin);
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).init(this.wizard);
        ((NewGuidedDecisionTableColumnWizard)Mockito.verify((Object)this.wizard)).setupTitle((DecisionTableColumnPlugin)this.plugin);
        ((NewGuidedDecisionTableColumnWizard)Mockito.verify((Object)this.wizard)).loadPages((DecisionTableColumnPlugin)this.plugin);
        ((NewGuidedDecisionTableColumnWizard)Mockito.verify((Object)this.wizard)).initPages((DecisionTableColumnPlugin)this.plugin);
    }

    @Test
    public void testSetupTitleWhenColumnIsNew() {
        String title = "title";
        ((TranslationService)Mockito.doReturn((Object)"title").when((Object)this.translationService)).format("NewGuidedDecisionTableColumnWizard.AddNewColumn", new Object[0]);
        ((ConditionColumnPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isNewColumn();
        this.wizard.setupTitle((DecisionTableColumnPlugin)this.plugin);
        ((NewGuidedDecisionTableColumnWizard)Mockito.verify((Object)this.wizard)).setTitle("title");
    }

    @Test
    public void testSetupTitleWhenColumnIsNotNew() {
        String title = "title";
        ((TranslationService)Mockito.doReturn((Object)"title").when((Object)this.translationService)).format("NewGuidedDecisionTableColumnWizard.EditColumn", new Object[0]);
        ((ConditionColumnPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).isNewColumn();
        this.wizard.setupTitle((DecisionTableColumnPlugin)this.plugin);
        ((NewGuidedDecisionTableColumnWizard)Mockito.verify((Object)this.wizard)).setTitle("title");
    }

    @Test
    public void testIfIsCompleteDoNotCheckIfColumnIsNewOrEdited() {
        ((NewGuidedDecisionTableColumnWizard)Mockito.doNothing().when((Object)this.wizard)).parentStart();
        List<WizardPage> wizardPages = Arrays.asList(this.patternPage, this.operatorPage, this.additionalInfoPage);
        Mockito.when((Object)this.plugin.getPages()).thenReturn(wizardPages);
        this.wizard.start((DecisionTableColumnPlugin)this.plugin);
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin, (VerificationMode)Mockito.times((int)2))).isNewColumn();
        this.wizard.isComplete((Callback)Mockito.mock(Callback.class));
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin, (VerificationMode)Mockito.times((int)2))).isNewColumn();
        wizardPages.forEach(page -> ((WizardPage)Mockito.verify((Object)page)).isComplete((Callback)Mockito.any()));
    }

    @Test
    public void testWizardCompleteActionWorkItemSetFieldPlugin() {
        this.testCompleteWizard((DecisionTableColumnPlugin)this.actionWorkItemSetFieldPlugin);
    }

    @Test
    public void testWizardCompleteActionSetFactPlugin() {
        this.testCompleteWizard((DecisionTableColumnPlugin)this.actionSetFactPlugin);
    }

    @Test
    public void testCompleteWizardActionRetractFactPlugin() {
        this.testCompleteWizard((DecisionTableColumnPlugin)this.actionRetractFactPlugin);
    }

    @Test
    public void testCompleteWizardActionWorkItemPlugin() {
        this.testCompleteWizard((DecisionTableColumnPlugin)this.actionWorkItemPlugin);
    }

    @Test
    public void testCompleteWizardBRLActionColumnPlugin() {
        this.testCompleteWizard((DecisionTableColumnPlugin)this.brlActionColumnPlugin);
    }

    @Test
    public void testCompleteWizardBRLConditionColumnPlugin() {
        this.testCompleteWizard((DecisionTableColumnPlugin)this.brlConditionColumnPlugin);
    }

    @Test
    public void testCompleteWizardConditionColumnPlugin() {
        this.testCompleteWizard((DecisionTableColumnPlugin)this.conditionColumnPlugin);
    }

    @Test
    public void testClosureDestroysPopovers() {
        this.wizard.close();
        ((DecisionTablePopoverUtils)Mockito.verify((Object)this.popoverUtils)).destroyPopovers();
    }

    private void testCompleteWizard(DecisionTableColumnPlugin plugin) {
        ((DecisionTableColumnPlugin)Mockito.doCallRealMethod().when((Object)plugin)).init(this.wizard);
        this.wizard.start(plugin);
        this.wizard.complete();
        ((DecisionTableColumnPlugin)Mockito.verify((Object)plugin)).generateColumn();
    }
}

