/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.pages;

import com.google.gwt.junit.GWTMockUtilities;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.workbench.models.datamodel.rule.Attribute;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.AttributeColumnPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.AttributeColumnPlugin;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class AttributeColumnPageTest {
    @Mock
    private GuidedDecisionTableView.Presenter presenter;
    @Mock
    private AttributeColumnPage.View view;
    @Mock
    private TranslationService translationService;
    @Mock
    private SimplePanel content;
    @Mock
    private AttributeColumnPlugin plugin;
    @InjectMocks
    private AttributeColumnPage page;

    public AttributeColumnPageTest() {
        this.page = (AttributeColumnPage)Mockito.spy((Object)new AttributeColumnPage(this.view, this.translationService));
    }

    @BeforeClass
    public static void setupPreferences() {
        HashMap<String, String> preferences = new HashMap<String, String>(){
            {
                this.put("drools.dateformat", "dd/mm/yyyy");
            }
        };
        ApplicationPreferences.setUp((Map)preferences);
        GWTMockUtilities.disarm();
    }

    @Test
    public void testGetAttributesWhenThereAreReservedAttributes() {
        this.reservedAttributeNamesMock(Attribute.SALIENCE.getAttributeName(), Attribute.AGENDA_GROUP.getAttributeName());
        List result = this.page.getAttributes();
        List<String> expected = this.attributesList();
        expected.remove(Attribute.AGENDA_GROUP.getAttributeName());
        expected.remove(Attribute.SALIENCE.getAttributeName());
        Assert.assertEquals(expected, (Object)result);
    }

    @Test
    public void testGetAttributesWhenThereIsNoReservedAttribute() {
        this.reservedAttributeNamesMock(new String[0]);
        List result = this.page.getAttributes();
        List<String> expected = this.attributesList();
        Assert.assertEquals(expected, (Object)result);
    }

    @Test
    public void testIsCompleteWhenAttributeIsNull() {
        Mockito.when((Object)this.plugin.getAttribute()).thenReturn(null);
        this.page.isComplete(Assert::assertFalse);
    }

    @Test
    public void testIsCompleteWhenAttributeIsBlank() {
        Mockito.when((Object)this.plugin.getAttribute()).thenReturn(null);
        this.page.isComplete(Assert::assertFalse);
    }

    @Test
    public void testIsCompleteWhenAttributeIsNotNull() {
        Mockito.when((Object)this.plugin.getAttribute()).thenReturn((Object)Attribute.SALIENCE.getAttributeName());
        this.page.isComplete(Assert::assertTrue);
    }

    @Test
    public void testGetTitle() throws Exception {
        String errorKey = "AttributeColumnPage.AddNewAttribute";
        String errorMessage = "Title";
        Mockito.when((Object)this.translationService.format("AttributeColumnPage.AddNewAttribute", new Object[0])).thenReturn((Object)"Title");
        String title = this.page.getTitle();
        Assert.assertEquals((Object)"Title", (Object)title);
    }

    @Test
    public void testPrepareView() throws Exception {
        this.page.prepareView();
        ((AttributeColumnPage.View)Mockito.verify((Object)this.view)).init((Object)this.page);
    }

    @Test
    public void testAsWidget() {
        Widget contentWidget = this.page.asWidget();
        Assert.assertEquals((Object)contentWidget, (Object)this.content);
    }

    @Test
    public void testSelectItem() {
        String item = "attributeMock";
        this.page.selectItem("attributeMock");
        ((AttributeColumnPlugin)Mockito.verify((Object)this.plugin)).setAttribute("attributeMock");
    }

    @Test
    public void testSelectedAttribute() {
        this.page.selectedAttribute();
        ((AttributeColumnPlugin)Mockito.verify((Object)this.plugin)).getAttribute();
    }

    private void reservedAttributeNamesMock(final String ... attributes) {
        HashSet<String> reservedAttributeNames = new HashSet<String>(){
            {
                for (String attribute : attributes) {
                    this.add(attribute);
                }
            }
        };
        Mockito.when((Object)this.presenter.getReservedAttributeNames()).thenReturn((Object)reservedAttributeNames);
    }

    private List<String> attributesList() {
        return Stream.of(Attribute.values()).map(Attribute::getAttributeName).collect(Collectors.toList());
    }
}

