/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.pages;

import com.google.gwt.junit.GWTMockUtilities;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.AdditionalInfoPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.CalculationTypePage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.FieldPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.OperatorPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.PatternPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.ValueOptionsPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.ConditionColumnPlugin;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.PatternWrapper;
import org.drools.workbench.screens.guided.rule.client.util.ModelFieldUtil;
import org.gwtbootstrap3.client.ui.TextBox;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.commons.util.Lists;
import org.kie.soup.project.datamodel.oracle.FieldAccessorsAndMutators;
import org.kie.soup.project.datamodel.oracle.ModelField;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageStatusChangeEvent;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class FieldPageTest {
    @Mock
    private ConditionColumnPlugin plugin;
    @Mock
    private GuidedDecisionTableView.Presenter presenter;
    @Mock
    private AsyncPackageDataModelOracle oracle;
    @Mock
    private PatternWrapper pattern52;
    @Mock
    private ConditionCol52 editingCol;
    @Mock
    private GuidedDecisionTable52 model;
    @Mock
    private FieldPage.View view;
    @Mock
    private SimplePanel content;
    @Mock
    private PatternPage<ConditionColumnPlugin> patternPage;
    @Mock
    private CalculationTypePage calculationTypePage;
    @Mock
    private FieldPage<ConditionColumnPlugin> fieldPage;
    @Mock
    private OperatorPage operatorPage;
    @Mock
    private AdditionalInfoPage<ConditionColumnPlugin> additionalInfoPage;
    @Mock
    private ValueOptionsPage<ConditionColumnPlugin> valueOptionsPage;
    @Mock
    private TranslationService translationService;
    @Mock
    private EventSourceMock<WizardPageStatusChangeEvent> changeEvent;
    @Captor
    private ArgumentCaptor<Consumer<String>> consumer;
    @InjectMocks
    private FieldPage<ConditionColumnPlugin> page;

    public FieldPageTest() {
        this.page = (FieldPage)Mockito.spy((Object)new FieldPage(this.view, this.translationService));
    }

    @BeforeClass
    public static void setupPreferences() {
        GWTMockUtilities.disarm();
    }

    @Before
    public void setup() {
        Mockito.when((Object)this.page.plugin()).thenReturn((Object)this.plugin);
    }

    @Test
    public void testSetEditingCol() throws Exception {
        this.page.setEditingCol("factField");
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).setFactField((String)Mockito.eq((Object)"factField"));
    }

    @Test
    public void testIsConstraintValuePredicateWhenItIsTypePredicate() throws Exception {
        Mockito.when((Object)this.plugin.constraintValue()).thenReturn((Object)5);
        Assert.assertTrue((boolean)this.page.isConstraintValuePredicate());
    }

    @Test
    public void testIsConstraintValuePredicateWhenItIsNotTypePredicate() throws Exception {
        Mockito.when((Object)this.plugin.constraintValue()).thenReturn((Object)0);
        Assert.assertFalse((boolean)this.page.isConstraintValuePredicate());
    }

    @Test
    public void testHasEditingPatternWhenFactPatternIsNotNull() throws Exception {
        Mockito.when((Object)this.pattern52.getFactType()).thenReturn((Object)"factType");
        Mockito.when((Object)this.plugin.patternWrapper()).thenReturn((Object)this.pattern52);
        Assert.assertTrue((boolean)this.page.hasEditingPattern());
    }

    @Test
    public void testHasEditingPatternWhenFactPatternIsNull() throws Exception {
        Mockito.when((Object)this.pattern52.getFactType()).thenReturn((Object)"");
        Mockito.when((Object)this.plugin.patternWrapper()).thenReturn((Object)this.pattern52);
        Assert.assertFalse((boolean)this.page.hasEditingPattern());
    }

    @Test
    public void testIsConstraintRetValueWhenItIsTypeRetValue() throws Exception {
        this.page.filterEnumFields();
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).filterEnumFields();
    }

    @Test
    public void testForEachFactFieldWhenEditingPatternIsNotNull() throws Exception {
        Mockito.when((Object)this.pattern52.getFactType()).thenReturn((Object)"factType");
        Mockito.when((Object)this.plugin.patternWrapper()).thenReturn((Object)this.pattern52);
        Mockito.when((Object)this.plugin.getAccessor()).thenReturn((Object)FieldAccessorsAndMutators.ACCESSOR);
        Mockito.when((Object)this.presenter.getDataModelOracle()).thenReturn((Object)this.oracle);
        this.page.forEachFactField(s -> {});
        ((AsyncPackageDataModelOracle)Mockito.verify((Object)this.oracle)).getFieldCompletions((String)Mockito.eq((Object)"factType"), (FieldAccessorsAndMutators)Mockito.eq((Object)FieldAccessorsAndMutators.ACCESSOR), (Callback)Mockito.any());
    }

    @Test
    public void testForEachFactFieldWhenEditingPatternIsNull() throws Exception {
        Mockito.when((Object)this.plugin.patternWrapper()).thenReturn((Object)this.pattern52);
        Mockito.when((Object)this.presenter.getDataModelOracle()).thenReturn((Object)this.oracle);
        this.page.forEachFactField(s -> {});
        ((AsyncPackageDataModelOracle)Mockito.verify((Object)this.oracle, (VerificationMode)Mockito.never())).getFieldCompletions((String)Mockito.any(), (FieldAccessorsAndMutators)Mockito.any(), (Callback)Mockito.any());
    }

    @Test
    public void testFieldsCallbackWhenConstraintIsRetValue() throws Exception {
        ConditionColumnPlugin plugin = (ConditionColumnPlugin)Mockito.spy((Object)new ConditionColumnPlugin(this.patternPage, this.calculationTypePage, this.fieldPage, this.operatorPage, this.valueOptionsPage, this.additionalInfoPage, this.changeEvent, this.translationService));
        ((ConditionColumnPlugin)Mockito.doReturn((Object)3).when((Object)plugin)).constraintValue();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)this.editingCol).when((Object)plugin)).editingCol();
        ((ConditionCol52)Mockito.doReturn((Object)"modelField3").when((Object)this.editingCol)).getFactField();
        Mockito.when((Object)this.page.plugin()).thenReturn((Object)plugin);
        Mockito.when((Object)this.pattern52.getFactType()).thenReturn((Object)"factType");
        Mockito.when((Object)plugin.patternWrapper()).thenReturn((Object)this.pattern52);
        Mockito.when((Object)this.presenter.getDataModelOracle()).thenReturn((Object)this.oracle);
        Mockito.when((Object)this.oracle.hasEnums("factType", "modelField2")).thenReturn((Object)true);
        List expected = new Lists.Builder().add((Object)"modelField1").add((Object)"modelField3").build();
        ArrayList result = new ArrayList();
        ModelField[] modelFields = new ModelField[]{ModelFieldUtil.modelField((String)"modelField1", (String)"Object"), ModelFieldUtil.modelField((String)"modelField2", (String)"Object"), ModelFieldUtil.modelField((String)"modelField3", (String)"Object")};
        Callback fieldsCallback = this.page.fieldsLoadedCallback(result::add);
        fieldsCallback.callback((Object)modelFields);
        Assert.assertEquals((Object)expected, result);
        ((FieldPage.View)Mockito.verify((Object)this.view)).setupEmptyFieldList();
        ((FieldPage.View)Mockito.verify((Object)this.view)).selectField("modelField3");
    }

    @Test
    public void testFieldsCallbackWhenConstraintIsNotRetValue() throws Exception {
        ((ConditionColumnPlugin)Mockito.doReturn((Object)1).when((Object)this.plugin)).constraintValue();
        Mockito.when((Object)this.pattern52.getFactType()).thenReturn((Object)"factType");
        Mockito.when((Object)this.plugin.patternWrapper()).thenReturn((Object)this.pattern52);
        Mockito.when((Object)this.plugin.getFactField()).thenReturn((Object)"modelField3");
        Mockito.when((Object)this.presenter.getDataModelOracle()).thenReturn((Object)this.oracle);
        Mockito.when((Object)this.oracle.hasEnums("factType", "modelField2")).thenReturn((Object)true);
        List expected = new Lists.Builder().add((Object)"modelField1").add((Object)"modelField2").add((Object)"modelField3").build();
        ArrayList result = new ArrayList();
        ModelField[] modelFields = new ModelField[]{ModelFieldUtil.modelField((String)"modelField1", (String)"Object"), ModelFieldUtil.modelField((String)"modelField2", (String)"Object"), ModelFieldUtil.modelField((String)"modelField3", (String)"Object")};
        Callback fieldsCallback = this.page.fieldsLoadedCallback(result::add);
        fieldsCallback.callback((Object)modelFields);
        Assert.assertEquals((Object)expected, result);
        ((FieldPage.View)Mockito.verify((Object)this.view)).setupEmptyFieldList();
        ((FieldPage.View)Mockito.verify((Object)this.view)).selectField("modelField3");
    }

    @Test
    public void testFieldsCallbackWhenConstraintIsRetValueButItDoesNotHaveEnums() throws Exception {
        ((ConditionColumnPlugin)Mockito.doReturn((Object)3).when((Object)this.plugin)).constraintValue();
        Mockito.when((Object)this.pattern52.getFactType()).thenReturn((Object)"factType");
        Mockito.when((Object)this.plugin.patternWrapper()).thenReturn((Object)this.pattern52);
        Mockito.when((Object)this.plugin.getFactField()).thenReturn((Object)"modelField3");
        Mockito.when((Object)this.presenter.getDataModelOracle()).thenReturn((Object)this.oracle);
        Mockito.when((Object)this.oracle.hasEnums("factType", "modelField2")).thenReturn((Object)false);
        List expected = new Lists.Builder().add((Object)"modelField1").add((Object)"modelField2").add((Object)"modelField3").build();
        ArrayList result = new ArrayList();
        ModelField[] modelFields = new ModelField[]{ModelFieldUtil.modelField((String)"modelField1", (String)"Object"), ModelFieldUtil.modelField((String)"modelField2", (String)"Object"), ModelFieldUtil.modelField((String)"modelField3", (String)"Object")};
        Callback fieldsCallback = this.page.fieldsLoadedCallback(result::add);
        fieldsCallback.callback((Object)modelFields);
        Assert.assertEquals((Object)expected, result);
        ((FieldPage.View)Mockito.verify((Object)this.view)).setupEmptyFieldList();
        ((FieldPage.View)Mockito.verify((Object)this.view)).selectField("modelField3");
    }

    @Test
    public void testIsCompleteWhenFactFieldIsNull() throws Exception {
        Mockito.when((Object)this.plugin.isFieldBindingValid()).thenReturn((Object)true);
        Mockito.when((Object)this.plugin.constraintValue()).thenReturn((Object)1);
        Mockito.when((Object)this.plugin.getFactField()).thenReturn(null);
        this.page.isComplete(Assert::assertFalse);
        ((FieldPage)Mockito.verify(this.page)).fieldBindingWarningToggle(true);
        ((FieldPage)Mockito.verify(this.page)).factFieldWarningToggle(false);
    }

    @Test
    public void testIsCompleteWhenBindingIsNotValid() throws Exception {
        Mockito.when((Object)this.plugin.isFieldBindingValid()).thenReturn((Object)false);
        Mockito.when((Object)this.plugin.constraintValue()).thenReturn((Object)1);
        Mockito.when((Object)this.plugin.getFactField()).thenReturn((Object)"factField");
        this.page.isComplete(Assert::assertFalse);
        ((FieldPage)Mockito.verify(this.page)).fieldBindingWarningToggle(false);
        ((FieldPage)Mockito.verify(this.page)).factFieldWarningToggle(true);
    }

    @Test
    public void testIsCompleteWhenFactFieldIsNotNull() throws Exception {
        Mockito.when((Object)this.plugin.isFieldBindingValid()).thenReturn((Object)true);
        Mockito.when((Object)this.plugin.constraintValue()).thenReturn((Object)1);
        Mockito.when((Object)this.plugin.getFactField()).thenReturn((Object)"factField");
        this.page.isComplete(Assert::assertTrue);
        ((FieldPage)Mockito.verify(this.page)).fieldBindingWarningToggle(true);
        ((FieldPage)Mockito.verify(this.page)).factFieldWarningToggle(true);
    }

    @Test
    public void testIsCompleteWhenConstraintValueIsPredicate() throws Exception {
        Mockito.when((Object)this.plugin.isFieldBindingValid()).thenReturn((Object)true);
        Mockito.when((Object)this.plugin.constraintValue()).thenReturn((Object)5);
        Mockito.when((Object)this.plugin.getFactField()).thenReturn(null);
        this.page.isComplete(Assert::assertTrue);
        ((FieldPage)Mockito.verify(this.page)).fieldBindingWarningToggle(true);
        ((FieldPage)Mockito.verify(this.page)).factFieldWarningToggle(true);
    }

    @Test
    public void testGetFactField() {
        this.page.getFactField();
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).getFactField();
    }

    @Test
    public void testGetTitle() throws Exception {
        String errorKey = "FieldPage.Field";
        String errorMessage = "Title";
        Mockito.when((Object)this.translationService.format("FieldPage.Field", new Object[0])).thenReturn((Object)"Title");
        String title = this.page.getTitle();
        Assert.assertEquals((Object)"Title", (Object)title);
    }

    @Test
    public void testPrepareView() throws Exception {
        ((ConditionColumnPlugin)Mockito.doReturn((Object)this.pattern52).when((Object)this.plugin)).patternWrapper();
        this.page.prepareView();
        ((FieldPage.View)Mockito.verify((Object)this.view)).init(this.page);
        ((FieldPage)Mockito.verify(this.page)).setupPatternWarningMessages();
        ((FieldPage)Mockito.verify(this.page)).setupPredicateBindingInfoBox();
        ((FieldPage)Mockito.verify(this.page)).setupBinding();
        ((FieldPage)Mockito.verify(this.page)).setupField();
    }

    @Test
    public void testAsWidget() {
        Widget contentWidget = this.page.asWidget();
        Assert.assertEquals((Object)contentWidget, (Object)this.content);
    }

    @Test
    public void testSetupFieldWhenConstraintValueIsNotPredicate() {
        String factField = "factField";
        ((FieldPage)Mockito.doReturn((Object)false).when(this.page)).isConstraintValuePredicate();
        ((FieldPage)Mockito.doReturn((Object)"factField").when(this.page)).getFactField();
        ((FieldPage)Mockito.doNothing().when(this.page)).forEachFactField((Consumer)this.consumer.capture());
        this.page.setupField();
        ((Consumer)this.consumer.getValue()).accept("factField");
        ((FieldPage.View)Mockito.verify((Object)this.view)).enableListFieldView();
        ((FieldPage.View)Mockito.verify((Object)this.view)).addItem("factField", "factField");
    }

    @Test
    public void testSetupFieldWhenConstraintValueIsPredicate() {
        String factField = "factField";
        ((FieldPage)Mockito.doReturn((Object)true).when(this.page)).isConstraintValuePredicate();
        ((FieldPage)Mockito.doReturn((Object)"factField").when(this.page)).getFactField();
        this.page.setupField();
        this.view.enablePredicateFieldView();
        this.view.setField("factField");
    }

    @Test
    public void testSetupFieldWhenConstraintValueIsFormula() {
        String factField = "age";
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)this.oracle).when((Object)this.presenter)).getDataModelOracle();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)3).when((Object)this.plugin)).constraintValue();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)new PatternWrapper("Person", "p")).when((Object)this.plugin)).patternWrapper();
        ((FieldPage)Mockito.doReturn((Object)"age").when(this.page)).getFactField();
        this.page.setupField();
        ((FieldPage.View)Mockito.verify((Object)this.view)).enableListFieldView();
        ((FieldPage)Mockito.verify(this.page)).forEachFactField((Consumer)Mockito.any(Consumer.class));
        ((FieldPage.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).enablePredicateFieldView();
    }

    @Test
    public void testSetupPatternWarningMessagesWhenFactTypeIsNotNil() {
        String factType = "factType";
        ((FieldPage)Mockito.doReturn((Object)"factType").when(this.page)).factType();
        this.page.setupPatternWarningMessages();
        ((FieldPage.View)Mockito.verify((Object)this.view)).patternWarningToggle(false);
    }

    @Test
    public void testSetupPatternWarningMessagesWhenFactTypeIsNil() {
        String factType = "";
        ((FieldPage)Mockito.doReturn((Object)"").when(this.page)).factType();
        this.page.setupPatternWarningMessages();
        ((FieldPage.View)Mockito.verify((Object)this.view)).patternWarningToggle(true);
    }

    @Test
    public void testFactFieldWarningToggleWhenFactFieldIsValid() {
        boolean isFactFieldValid = true;
        this.page.factFieldWarningToggle(true);
        ((FieldPage.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showSelectFieldWarning();
        ((FieldPage.View)Mockito.verify((Object)this.view)).hideSelectFieldWarning();
    }

    @Test
    public void testFactFieldWarningToggleWhenFactFieldIsNotValid() {
        boolean isFactFieldValid = false;
        this.page.factFieldWarningToggle(false);
        ((FieldPage.View)Mockito.verify((Object)this.view)).showSelectFieldWarning();
        ((FieldPage.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).hideSelectFieldWarning();
    }

    @Test
    public void testFieldBindingWarningToggleWhenFieldBindingIsValid() {
        boolean isFieldBindingValid = true;
        this.page.fieldBindingWarningToggle(true);
        ((FieldPage.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showFieldBindingWarning();
        ((FieldPage.View)Mockito.verify((Object)this.view)).hideFieldBindingWarning();
    }

    @Test
    public void testFieldBindingWarningToggleWhenFieldBindingIsNotValid() {
        boolean isFieldBindingValid = false;
        this.page.fieldBindingWarningToggle(false);
        ((FieldPage.View)Mockito.verify((Object)this.view)).showFieldBindingWarning();
        ((FieldPage.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).hideFieldBindingWarning();
    }

    @Test
    public void testSetupPredicateBindingInfoBoxWhenConstraintValueIsPredicate() {
        ((ConditionColumnPlugin)Mockito.doReturn((Object)5).when((Object)this.plugin)).constraintValue();
        this.page.setupPredicateBindingInfoBox();
        ((FieldPage.View)Mockito.verify((Object)this.view)).showPredicateBindingInfo();
        ((FieldPage.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).hidePredicateBindingInfo();
    }

    @Test
    public void testSetupPredicateBindingInfoBoxWhenConstraintValueIsNotPredicate() {
        ((ConditionColumnPlugin)Mockito.doReturn((Object)1).when((Object)this.plugin)).constraintValue();
        this.page.setupPredicateBindingInfoBox();
        ((FieldPage.View)Mockito.verify((Object)this.view)).hidePredicateBindingInfo();
        ((FieldPage.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showPredicateBindingInfo();
    }

    @Test
    public void testSetupPredicateBindingInfoBoxWhenConstraintValueIsFormula() {
        ((ConditionColumnPlugin)Mockito.doReturn((Object)3).when((Object)this.plugin)).constraintValue();
        this.page.setupPredicateBindingInfoBox();
        ((FieldPage.View)Mockito.verify((Object)this.view)).hidePredicateBindingInfo();
        ((FieldPage.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showPredicateBindingInfo();
    }

    @Test
    public void testSetupBindingWhenItIsBindable() {
        TextBox textBox = (TextBox)Mockito.mock(TextBox.class);
        boolean isBindable = true;
        ((ConditionColumnPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isBindable();
        ((FieldPage)Mockito.doReturn((Object)textBox).when(this.page)).newBindingTextBox();
        this.page.setupBinding();
        ((FieldPage.View)Mockito.verify((Object)this.view)).setupBinding((IsWidget)textBox);
        ((FieldPage.View)Mockito.verify((Object)this.view)).bindingToggle(true);
    }

    @Test
    public void testSetupBindingWhenItIsNotBindable() {
        TextBox textBox = (TextBox)Mockito.mock(TextBox.class);
        boolean isBindable = false;
        ((ConditionColumnPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).isBindable();
        ((FieldPage)Mockito.doReturn((Object)textBox).when(this.page)).newBindingTextBox();
        this.page.setupBinding();
        ((FieldPage.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setupBinding((IsWidget)textBox);
        ((FieldPage.View)Mockito.verify((Object)this.view)).bindingToggle(false);
    }
}

