/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.pages;

import com.google.gwt.junit.GWTMockUtilities;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.List;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.PatternToDeletePage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.ActionRetractFactPlugin;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class PatternToDeletePageTest {
    @Mock
    private PatternToDeletePage.View view;
    @Mock
    private ActionRetractFactPlugin plugin;
    @Mock
    private GuidedDecisionTableView.Presenter presenter;
    @Mock
    private TranslationService translationService;
    @Mock
    private GuidedDecisionTable52 model;
    @Mock
    private SimplePanel content;
    @InjectMocks
    private PatternToDeletePage page;

    public PatternToDeletePageTest() {
        this.page = (PatternToDeletePage)Mockito.spy((Object)new PatternToDeletePage(this.view, this.translationService));
    }

    @BeforeClass
    public static void staticSetup() {
        GWTMockUtilities.disarm();
    }

    @Test
    public void testIsComplete() throws Exception {
        ((ActionRetractFactPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isPatternToDeletePageCompleted();
        this.page.isComplete(Assert::assertTrue);
        ((ActionRetractFactPlugin)Mockito.verify((Object)this.plugin)).isPatternToDeletePageCompleted();
    }

    @Test
    public void testPrepareView() throws Exception {
        ((PatternToDeletePage)Mockito.doReturn(new ArrayList()).when((Object)this.page)).getLHSBoundFacts();
        this.page.prepareView();
        ((PatternToDeletePage.View)Mockito.verify((Object)this.view)).init((Object)this.page);
        ((PatternToDeletePage)Mockito.verify((Object)this.page)).markAsViewed();
    }

    @Test
    public void testLoadPatterns() throws Exception {
        ArrayList<String> lhsBoundFacts = new ArrayList<String>(){
            {
                this.add("boundFact1");
                this.add("");
                this.add("boundFact3");
            }
        };
        ArrayList<String> expectedPatterns = new ArrayList<String>(){
            {
                this.add("boundFact1");
                this.add("boundFact3");
            }
        };
        ((PatternToDeletePage)Mockito.doReturn((Object)lhsBoundFacts).when((Object)this.page)).getLHSBoundFacts();
        List patterns = this.page.loadPatterns();
        Assert.assertEquals((Object)expectedPatterns, (Object)patterns);
    }

    @Test
    public void testBinding() throws Exception {
        this.page.binding();
        ((ActionRetractFactPlugin)Mockito.verify((Object)this.plugin)).getEditingColStringValue();
    }

    @Test
    public void testGetLHSBoundFacts() throws Exception {
        ArrayList<Pattern52> patterns = new ArrayList<Pattern52>(){
            {
                this.add(PatternToDeletePageTest.this.pattern("pattern1"));
                this.add(PatternToDeletePageTest.this.pattern("pattern2"));
            }
        };
        ArrayList<String> expectedLHSBoundFacts = new ArrayList<String>(){
            {
                this.add("pattern1");
                this.add("pattern2");
            }
        };
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)this.model).when((Object)this.presenter)).getModel();
        ((GuidedDecisionTable52)Mockito.doReturn((Object)patterns).when((Object)this.model)).getConditions();
        List lhsBoundFacts = this.page.getLHSBoundFacts();
        Assert.assertEquals((Object)expectedLHSBoundFacts, (Object)lhsBoundFacts);
    }

    @Test
    public void testSetTheSelectedPattern() throws Exception {
        this.page.setTheSelectedPattern();
        ((ActionRetractFactPlugin)Mockito.verify((Object)this.plugin)).setEditingColStringValue(this.view.selectedPattern());
    }

    @Test
    public void testMarkAsViewed() throws Exception {
        this.page.markAsViewed();
        ((ActionRetractFactPlugin)Mockito.verify((Object)this.plugin)).setPatternToDeletePageAsCompleted();
    }

    @Test
    public void testGetTitle() throws Exception {
        String errorKey = "PatternToDeletePage.Pattern";
        String errorMessage = "Title";
        Mockito.when((Object)this.translationService.format("PatternToDeletePage.Pattern", new Object[0])).thenReturn((Object)"Title");
        String title = this.page.getTitle();
        Assert.assertEquals((Object)"Title", (Object)title);
    }

    @Test
    public void testAsWidget() {
        Widget contentWidget = this.page.asWidget();
        Assert.assertEquals((Object)contentWidget, (Object)this.content);
    }

    private Pattern52 pattern(final String pattern1) {
        return new Pattern52(){
            {
                this.setBoundName(pattern1);
            }
        };
    }
}

