/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.drools.workbench.models.datamodel.workitems.PortableWorkDefinition;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemCol52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.ModelSynchronizer;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.NewGuidedDecisionTableColumnWizard;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.AdditionalInfoPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.WorkItemPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.ActionWorkItemPlugin;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.DecisionTableColumnPlugin;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.widgets.core.client.wizards.WizardPage;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageStatusChangeEvent;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class ActionWorkItemPluginTest {
    @Mock
    private NewGuidedDecisionTableColumnWizard wizard;
    @Mock
    private AdditionalInfoPage<ActionWorkItemPlugin> additionalInfoPage;
    @Mock
    private WorkItemPage workItemPage;
    @Mock
    private GuidedDecisionTableView.Presenter presenter;
    @Mock
    private TranslationService translationService;
    @Mock
    private EventSourceMock<WizardPageStatusChangeEvent> changeEvent;
    @Mock
    private ActionWorkItemCol52 editingCol;
    @Mock
    private GuidedDecisionTable52 model;
    @InjectMocks
    private ActionWorkItemPlugin plugin;

    public ActionWorkItemPluginTest() {
        this.plugin = (ActionWorkItemPlugin)Mockito.spy((Object)new ActionWorkItemPlugin(this.additionalInfoPage, this.workItemPage, this.changeEvent, this.translationService));
    }

    @Test
    public void testSetWorkItemWithABlankValue() throws Exception {
        this.plugin.setWorkItem("");
        ((ActionWorkItemCol52)Mockito.verify((Object)this.editingCol)).setWorkItemDefinition(null);
        ((ActionWorkItemPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.workItemPage);
    }

    @Test
    public void testSetWorkItemWithAValidValue() throws Exception {
        PortableWorkDefinition workDefinition = (PortableWorkDefinition)Mockito.mock(PortableWorkDefinition.class);
        String workItem = "workItem";
        ((ActionWorkItemPlugin)Mockito.doReturn((Object)workDefinition).when((Object)this.plugin)).findWorkItemDefinition("workItem");
        this.plugin.setWorkItem("workItem");
        ((ActionWorkItemCol52)Mockito.verify((Object)this.editingCol)).setWorkItemDefinition(workDefinition);
        ((ActionWorkItemPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.workItemPage);
    }

    @Test
    public void testIsWorkItemSetWhenWorkItemDefinitionIsNotNull() throws Exception {
        PortableWorkDefinition workDefinition = (PortableWorkDefinition)Mockito.mock(PortableWorkDefinition.class);
        Mockito.when((Object)this.editingCol.getWorkItemDefinition()).thenReturn((Object)workDefinition);
        Boolean isWorkItemSet = this.plugin.isWorkItemSet();
        Assert.assertTrue((boolean)isWorkItemSet);
    }

    @Test
    public void testIsWorkItemSetWhenWorkItemDefinitionIsNull() throws Exception {
        Mockito.when((Object)this.editingCol.getWorkItemDefinition()).thenReturn(null);
        Boolean isWorkItemSet = this.plugin.isWorkItemSet();
        Assert.assertFalse((boolean)isWorkItemSet);
    }

    @Test
    public void testSetHeader() throws Exception {
        String header = "Header";
        this.plugin.setHeader("Header");
        ((ActionWorkItemCol52)Mockito.verify((Object)this.editingCol)).setHeader("Header");
        ((ActionWorkItemPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent(this.additionalInfoPage);
    }

    @Test
    public void testGetPages() throws Exception {
        List pages = this.plugin.getPages();
        Assert.assertEquals((long)2L, (long)pages.size());
    }

    @Test
    public void testGetTitle() {
        String errorKey = "ActionWorkItemPlugin.ExecuteWorkItem";
        String errorMessage = "Title";
        Mockito.when((Object)this.translationService.format("ActionWorkItemPlugin.ExecuteWorkItem", new Object[0])).thenReturn((Object)"Title");
        String title = this.plugin.getTitle();
        Assert.assertEquals((Object)"Title", (Object)title);
    }

    @Test
    public void testInitializedWorkItemPage() {
        this.plugin.workItemPage();
        ((WorkItemPage)Mockito.verify((Object)this.workItemPage)).enableParameters();
    }

    @Test
    public void testInitializedAdditionalInfoPage() throws Exception {
        this.plugin.additionalInfoPage();
        ((AdditionalInfoPage)Mockito.verify(this.additionalInfoPage)).setPlugin((DecisionTableColumnPlugin)this.plugin);
        ((AdditionalInfoPage)Mockito.verify(this.additionalInfoPage)).enableHeader();
        ((AdditionalInfoPage)Mockito.verify(this.additionalInfoPage)).enableHideColumn();
    }

    @Test
    public void testInit() throws Exception {
        NewGuidedDecisionTableColumnWizard wizard = (NewGuidedDecisionTableColumnWizard)Mockito.mock(NewGuidedDecisionTableColumnWizard.class);
        this.plugin.init(wizard);
        Assert.assertNotNull((Object)this.plugin.editingCol());
    }

    @Test
    public void testGetHeader() {
        ActionWorkItemCol52 actionCol52 = (ActionWorkItemCol52)Mockito.mock(ActionWorkItemCol52.class);
        ((ActionWorkItemPlugin)Mockito.doReturn((Object)actionCol52).when((Object)this.plugin)).editingCol();
        this.plugin.getHeader();
        ((ActionWorkItemCol52)Mockito.verify((Object)actionCol52)).getHeader();
    }

    @Test
    public void testWorkItemDefinition() {
        ActionWorkItemCol52 actionCol52 = (ActionWorkItemCol52)Mockito.mock(ActionWorkItemCol52.class);
        ((ActionWorkItemPlugin)Mockito.doReturn((Object)actionCol52).when((Object)this.plugin)).editingCol();
        this.plugin.getWorkItemDefinition();
        ((ActionWorkItemCol52)Mockito.verify((Object)actionCol52)).getWorkItemDefinition();
    }

    @Test
    public void testWorkItemWhenItDoesNotHaveWorkItemDefinition() {
        PortableWorkDefinition workDefinition = (PortableWorkDefinition)Mockito.mock(PortableWorkDefinition.class);
        String workItemName = "workItem";
        ((PortableWorkDefinition)Mockito.doReturn((Object)"workItem").when((Object)workDefinition)).getName();
        ((ActionWorkItemPlugin)Mockito.doReturn((Object)workDefinition).when((Object)this.plugin)).getWorkItemDefinition();
        String workItem = this.plugin.getWorkItem();
        Assert.assertEquals((Object)"workItem", (Object)workItem);
    }

    @Test
    public void testWorkItemWhenItHasWorkItemDefinition() {
        ((ActionWorkItemPlugin)Mockito.doReturn(null).when((Object)this.plugin)).getWorkItemDefinition();
        String workItem = this.plugin.getWorkItem();
        Assert.assertEquals((Object)"", (Object)workItem);
    }

    @Test
    public void testFindWorkItemDefinition() {
        final PortableWorkDefinition workItem1 = this.getMock("workItem1");
        final PortableWorkDefinition workItem2 = this.getMock("workItem2");
        HashSet<PortableWorkDefinition> fakeDefinitions = new HashSet<PortableWorkDefinition>(){
            {
                this.add(workItem1);
                this.add(workItem2);
            }
        };
        Mockito.when((Object)this.presenter.getWorkItemDefinitions()).thenReturn((Object)fakeDefinitions);
        PortableWorkDefinition workItem = this.plugin.findWorkItemDefinition("workItem1");
        Assert.assertEquals((Object)workItem1, (Object)workItem);
    }

    @Test
    public void testForEachWorkItem() {
        final PortableWorkDefinition workItem1 = this.getMock("workItem1");
        final PortableWorkDefinition workItem2 = this.getMock("workItem2");
        HashMap actualWorkItems = new HashMap();
        HashMap<String, String> expectedWorkItems = new HashMap<String, String>(){
            {
                this.put("workItem1", "workItem1");
                this.put("workItem2", "workItem2");
            }
        };
        HashSet<PortableWorkDefinition> fakeDefinitions = new HashSet<PortableWorkDefinition>(){
            {
                this.add(workItem1);
                this.add(workItem2);
            }
        };
        Mockito.when((Object)this.presenter.getWorkItemDefinitions()).thenReturn((Object)fakeDefinitions);
        Mockito.when((Object)this.presenter.getModel()).thenReturn((Object)this.model);
        Mockito.when((Object)this.model.getActionCols()).thenReturn(Collections.emptyList());
        this.plugin.forEachWorkItem(actualWorkItems::put);
        Assert.assertEquals((Object)expectedWorkItems, actualWorkItems);
    }

    @Test
    public void testForEachWorkItemWhenOneHasBeenExecutedNewColumn() {
        final PortableWorkDefinition workItem1 = this.getMock("workItem1");
        final PortableWorkDefinition workItem2 = this.getMock("workItem2");
        HashMap actualWorkItems = new HashMap();
        HashMap<String, String> expectedWorkItems = new HashMap<String, String>(){
            {
                this.put("workItem2", "workItem2");
            }
        };
        HashSet<PortableWorkDefinition> fakeDefinitions = new HashSet<PortableWorkDefinition>(){
            {
                this.add(workItem1);
                this.add(workItem2);
            }
        };
        Mockito.when((Object)this.presenter.getWorkItemDefinitions()).thenReturn((Object)fakeDefinitions);
        Mockito.when((Object)this.presenter.getModel()).thenReturn((Object)this.model);
        Mockito.when((Object)this.model.getActionCols()).thenReturn(Collections.singletonList(new ActionWorkItemCol52(){
            {
                this.setWorkItemDefinition(workItem1);
            }
        }));
        Mockito.when((Object)this.plugin.isNewColumn()).thenReturn((Object)true);
        this.plugin.forEachWorkItem(actualWorkItems::put);
        Assert.assertEquals((Object)expectedWorkItems, actualWorkItems);
    }

    @Test
    public void testForEachWorkItemWhenOneHasBeenExecutedUpdatedColumn() {
        final PortableWorkDefinition workItem1 = this.getMock("workItem1");
        final PortableWorkDefinition workItem2 = this.getMock("workItem2");
        HashMap actualWorkItems = new HashMap();
        HashMap<String, String> expectedWorkItems = new HashMap<String, String>(){
            {
                this.put("workItem1", "workItem1");
                this.put("workItem2", "workItem2");
            }
        };
        HashSet<PortableWorkDefinition> fakeDefinitions = new HashSet<PortableWorkDefinition>(){
            {
                this.add(workItem1);
                this.add(workItem2);
            }
        };
        Mockito.when((Object)this.presenter.getWorkItemDefinitions()).thenReturn((Object)fakeDefinitions);
        Mockito.when((Object)this.presenter.getModel()).thenReturn((Object)this.model);
        Mockito.when((Object)this.model.getActionCols()).thenReturn(Collections.singletonList(new ActionWorkItemCol52(){
            {
                this.setWorkItemDefinition(workItem1);
            }
        }));
        Mockito.when((Object)this.plugin.isNewColumn()).thenReturn((Object)false);
        Mockito.when((Object)this.plugin.getWorkItemDefinition()).thenReturn((Object)workItem1);
        this.plugin.forEachWorkItem(actualWorkItems::put);
        Assert.assertEquals((Object)expectedWorkItems, actualWorkItems);
    }

    @Test
    public void testGetAlreadyUsedColumnNames() throws Exception {
        GuidedDecisionTable52 model = new GuidedDecisionTable52();
        model.getActionCols().add(new ActionCol52(){
            {
                this.setHeader("a");
            }
        });
        model.getActionCols().add(new ActionCol52(){
            {
                this.setHeader("b");
            }
        });
        Mockito.when((Object)this.presenter.getModel()).thenReturn((Object)model);
        Assert.assertEquals((long)2L, (long)this.plugin.getAlreadyUsedColumnHeaders().size());
        Assert.assertTrue((boolean)this.plugin.getAlreadyUsedColumnHeaders().contains("a"));
        Assert.assertTrue((boolean)this.plugin.getAlreadyUsedColumnHeaders().contains("b"));
    }

    @Test
    public void testSetupDefaultValuesWhenColumnIsNotNew() throws Exception {
        ActionWorkItemCol52 column = (ActionWorkItemCol52)Mockito.mock(ActionWorkItemCol52.class);
        ((ActionWorkItemPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).isNewColumn();
        ((ActionWorkItemPlugin)Mockito.doReturn((Object)column).when((Object)this.plugin)).clone((ActionWorkItemCol52)Mockito.any());
        this.plugin.setupDefaultValues();
        Assert.assertEquals((Object)column, (Object)this.plugin.editingCol());
        ((ActionWorkItemPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.workItemPage);
        ((ActionWorkItemPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent(this.additionalInfoPage);
    }

    @Test
    public void testSetupDefaultValuesWhenColumnIsNew() throws Exception {
        ActionWorkItemCol52 column = (ActionWorkItemCol52)Mockito.mock(ActionWorkItemCol52.class);
        ((ActionWorkItemPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isNewColumn();
        ((ActionWorkItemPlugin)Mockito.doReturn((Object)column).when((Object)this.plugin)).newActionWorkItemCol52();
        this.plugin.setupDefaultValues();
        Assert.assertEquals((Object)column, (Object)this.plugin.editingCol());
        ((ActionWorkItemPlugin)Mockito.verify((Object)this.plugin, (VerificationMode)Mockito.never())).fireChangeEvent((WizardPage)this.workItemPage);
        ((ActionWorkItemPlugin)Mockito.verify((Object)this.plugin, (VerificationMode)Mockito.never())).fireChangeEvent(this.additionalInfoPage);
    }

    @Test
    public void testGenerateColumnWhenColumnIsNew() throws Exception {
        ((ActionWorkItemPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isNewColumn();
        this.plugin.generateColumn();
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)this.presenter)).appendColumn((ActionCol52)this.editingCol);
    }

    @Test
    public void testGenerateColumnWhenColumnIsNotNew() throws Exception {
        ActionWorkItemCol52 column = (ActionWorkItemCol52)Mockito.mock(ActionWorkItemCol52.class);
        ((ActionWorkItemPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).isNewColumn();
        ((ActionWorkItemPlugin)Mockito.doReturn((Object)column).when((Object)this.plugin)).getOriginalColumnConfig52();
        this.plugin.generateColumn();
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)this.presenter)).updateColumn((ActionCol52)column, (ActionCol52)this.editingCol);
    }

    @Test
    public void testGenerateColumnWhenColumnIsNotNewAndVetoed() throws Exception {
        ((ActionWorkItemPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).isNewColumn();
        ((GuidedDecisionTableView.Presenter)Mockito.doThrow(ModelSynchronizer.VetoException.class).when((Object)this.presenter)).updateColumn((ActionCol52)Mockito.any(ActionCol52.class), (ActionCol52)Mockito.any(ActionCol52.class));
        Assert.assertFalse((boolean)this.plugin.generateColumn());
        ((NewGuidedDecisionTableColumnWizard)Mockito.verify((Object)this.wizard)).showGenericVetoError();
    }

    @Test
    public void testIsHideColumn() {
        ActionWorkItemCol52 actionCol52 = (ActionWorkItemCol52)Mockito.mock(ActionWorkItemCol52.class);
        ((ActionWorkItemPlugin)Mockito.doReturn((Object)actionCol52).when((Object)this.plugin)).editingCol();
        this.plugin.isHideColumn();
        ((ActionWorkItemCol52)Mockito.verify((Object)actionCol52)).isHideColumn();
    }

    @Test
    public void testSetHideColumn() {
        boolean hideColumn = false;
        ActionWorkItemCol52 actionCol52 = (ActionWorkItemCol52)Mockito.mock(ActionWorkItemCol52.class);
        ((ActionWorkItemPlugin)Mockito.doReturn((Object)actionCol52).when((Object)this.plugin)).editingCol();
        this.plugin.setHideColumn(false);
        ((ActionWorkItemCol52)Mockito.verify((Object)actionCol52)).setHideColumn(false);
    }

    private PortableWorkDefinition getMock(String name) {
        PortableWorkDefinition mock = (PortableWorkDefinition)Mockito.mock(PortableWorkDefinition.class);
        Mockito.when((Object)mock.getDisplayName()).thenReturn((Object)name);
        Mockito.when((Object)mock.getName()).thenReturn((Object)name);
        return mock;
    }
}

