/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins;

import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.event.Event;
import org.drools.workbench.models.datamodel.rule.FactPattern;
import org.drools.workbench.models.datamodel.rule.FieldConstraint;
import org.drools.workbench.models.datamodel.rule.IPattern;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.models.datamodel.rule.SingleFieldConstraint;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLRuleModel;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.DTColumnConfig52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.AdditionalInfoPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.DefaultValuesPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.RuleModellerPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.BRLConditionColumnPlugin;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageStatusChangeEvent;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
@WithClassesToStub(value={BRLRuleModel.class})
public class BRLConditionColumnPluginOperatorTest {
    @Captor
    private ArgumentCaptor<List<BRLConditionVariableColumn>> listArgumentCaptor;
    @Mock
    private RuleModellerPage ruleModellerPage;
    @Mock
    private AdditionalInfoPage additionalInfoPage;
    @Mock
    private EventSourceMock<WizardPageStatusChangeEvent> changeEvent;
    @Mock
    private GuidedDecisionTableView.Presenter presenter;
    @Mock
    private GuidedDecisionTable52 model;
    @Mock
    private TranslationService translationService;
    @Mock
    private BRLConditionColumn editingCol;
    @InjectMocks
    private BRLConditionColumnPlugin plugin;

    public BRLConditionColumnPluginOperatorTest() {
        this.plugin = (BRLConditionColumnPlugin)Mockito.spy((Object)new BRLConditionColumnPlugin(this.ruleModellerPage, (DefaultValuesPage)Mockito.mock(DefaultValuesPage.class), this.additionalInfoPage, (Event)this.changeEvent, this.translationService){

            public RuleModel getRuleModel() {
                RuleModel ruleModel = new RuleModel();
                ruleModel.lhs = new IPattern[1];
                FactPattern factPattern = new FactPattern();
                SingleFieldConstraint constraint = new SingleFieldConstraint();
                constraint.setValue("var1");
                constraint.setFieldType("fieldType");
                constraint.setFactType("factType");
                constraint.setFieldName("fieldName");
                constraint.setOperator("in");
                constraint.setConstraintValueType(7);
                factPattern.addConstraint((FieldConstraint)constraint);
                ruleModel.lhs[0] = factPattern;
                return ruleModel;
            }
        });
    }

    @Before
    public void setup() {
        ((BRLConditionColumnPlugin)Mockito.doReturn((Object)this.presenter).when((Object)this.plugin)).getPresenter();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)this.model).when((Object)this.presenter)).getModel();
    }

    @Test
    public void getDefinedVariables() {
        ((BRLConditionColumnPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isNewColumn();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)this.model).when((Object)this.presenter)).getModel();
        ((BRLConditionColumn)Mockito.doReturn((Object)"header").when((Object)this.editingCol)).getHeader();
        this.plugin.generateColumn();
        ((BRLConditionColumn)Mockito.verify((Object)this.editingCol)).setChildColumns((List)this.listArgumentCaptor.capture());
        List value = (List)this.listArgumentCaptor.getValue();
        Assert.assertEquals((long)1L, (long)value.size());
        BRLConditionVariableColumn brlConditionVariableColumn = (BRLConditionVariableColumn)value.get(0);
        Assert.assertEquals((Object)"fieldType", (Object)brlConditionVariableColumn.getFieldType());
        Assert.assertEquals((Object)"var1", (Object)brlConditionVariableColumn.getVarName());
        Assert.assertEquals((Object)"fieldName", (Object)brlConditionVariableColumn.getFactField());
        Assert.assertEquals((Object)"in", (Object)brlConditionVariableColumn.getOperator());
        Assert.assertNull((Object)brlConditionVariableColumn.getDefaultValue());
    }

    @Test
    public void getDefinedVariables2() {
        ((BRLConditionColumnPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isNewColumn();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)this.model).when((Object)this.presenter)).getModel();
        ((BRLConditionColumn)Mockito.doReturn((Object)"header").when((Object)this.editingCol)).getHeader();
        ArrayList<BRLConditionVariableColumn> childColumns = new ArrayList<BRLConditionVariableColumn>();
        BRLConditionVariableColumn brlConditionVariableColumn1 = new BRLConditionVariableColumn("var1", "fieldType");
        DTCellValue52 defaultValue = new DTCellValue52();
        brlConditionVariableColumn1.setDefaultValue(defaultValue);
        childColumns.add(brlConditionVariableColumn1);
        childColumns.add(new BRLConditionVariableColumn("var2", "fieldType"));
        ((BRLConditionColumn)Mockito.doReturn(childColumns).when((Object)this.editingCol)).getChildColumns();
        this.plugin.generateColumn();
        ((BRLConditionColumn)Mockito.verify((Object)this.editingCol)).setChildColumns((List)this.listArgumentCaptor.capture());
        List value = (List)this.listArgumentCaptor.getValue();
        Assert.assertEquals((long)1L, (long)value.size());
        BRLConditionVariableColumn brlConditionVariableColumn = (BRLConditionVariableColumn)value.get(0);
        Assert.assertEquals((Object)defaultValue, (Object)brlConditionVariableColumn.getDefaultValue());
    }

    @Test
    public void cloneBRLConditionColumn() {
        BRLConditionColumn original = new BRLConditionColumn();
        original.setHeader("header");
        original.setOperator("==");
        BRLConditionColumn clone = this.plugin.clone((DTColumnConfig52)original);
        Assert.assertEquals((Object)"header", (Object)clone.getHeader());
        Assert.assertEquals((Object)"==", (Object)clone.getOperator());
    }

    @Test
    public void cloneVariable() {
        BRLConditionVariableColumn original = new BRLConditionVariableColumn();
        original.setHeader("header");
        original.setOperator("==");
        BRLConditionVariableColumn clone = this.plugin.cloneVariable(original);
        Assert.assertEquals((Object)"header", (Object)clone.getHeader());
        Assert.assertEquals((Object)"==", (Object)clone.getOperator());
    }
}

