/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.drools.workbench.models.datamodel.rule.FactPattern;
import org.drools.workbench.models.datamodel.rule.IFactPattern;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLRuleModel;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.models.guided.dtable.shared.model.adaptors.FactPatternPattern52Adaptor;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.ModelSynchronizer;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.NewGuidedDecisionTableColumnWizard;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.AdditionalInfoPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.CalculationTypePage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.FieldPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.OperatorPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.PatternPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.ValueOptionsPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.ConditionColumnPlugin;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.PatternWrapper;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.project.datamodel.oracle.DataType;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.mockito.InOrder;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.widgets.core.client.wizards.WizardPage;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageStatusChangeEvent;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class ConditionColumnPluginTest {
    @Mock
    private PatternPage<ConditionColumnPlugin> patternPage;
    @Mock
    private CalculationTypePage calculationTypePage;
    @Mock
    private FieldPage fieldPage;
    @Mock
    private OperatorPage operatorPage;
    @Mock
    private AdditionalInfoPage<ConditionColumnPlugin> additionalInfoPage;
    @Mock
    private ValueOptionsPage valueOptionsPage;
    @Mock
    private GuidedDecisionTableView.Presenter presenter;
    @Mock
    private TranslationService translationService;
    @Mock
    private EventSourceMock<WizardPageStatusChangeEvent> changeEvent;
    @Mock
    private ConditionCol52 editingCol;
    @Mock
    private GuidedDecisionTable52 model;
    @Mock
    private AsyncPackageDataModelOracle oracle;
    @Mock
    private NewGuidedDecisionTableColumnWizard wizard;
    @InjectMocks
    private ConditionColumnPlugin plugin;

    public ConditionColumnPluginTest() {
        this.plugin = (ConditionColumnPlugin)Mockito.spy((Object)new ConditionColumnPlugin(this.patternPage, this.calculationTypePage, this.fieldPage, this.operatorPage, this.valueOptionsPage, this.additionalInfoPage, this.changeEvent, this.translationService));
    }

    @Before
    public void setup() {
        GuidedDecisionTable52.TableFormat tableFormat = GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY;
        ((GuidedDecisionTable52)Mockito.doReturn((Object)tableFormat).when((Object)this.model)).getTableFormat();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isNewColumn();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)this.model).when((Object)this.presenter)).getModel();
    }

    @Test
    public void testGetPagesWhenItIsAnExtendedEntryTable() throws Exception {
        ((GuidedDecisionTable52)Mockito.doReturn((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY).when((Object)this.model)).getTableFormat();
        List pages = this.plugin.getPages();
        Assert.assertTrue((boolean)pages.stream().anyMatch(a -> a instanceof CalculationTypePage));
        Assert.assertEquals((long)6L, (long)pages.size());
    }

    @Test
    public void testGetPagesWhenItIsALimitedEntryTable() throws Exception {
        ((GuidedDecisionTable52)Mockito.doReturn((Object)GuidedDecisionTable52.TableFormat.LIMITED_ENTRY).when((Object)this.model)).getTableFormat();
        List pages = this.plugin.getPages();
        Assert.assertFalse((boolean)pages.stream().anyMatch(a -> a instanceof CalculationTypePage));
        Assert.assertEquals((long)5L, (long)pages.size());
    }

    @Test
    public void testPrepareValuesWhenConstraintValueIsPredicate() throws Exception {
        ((ConditionColumnPlugin)Mockito.doReturn((Object)this.editingCol).when((Object)this.plugin)).editingCol();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)5).when((Object)this.plugin)).constraintValue();
        this.plugin.prepareValues();
        ((ConditionCol52)Mockito.verify((Object)this.editingCol)).setOperator(this.plugin.operatorPlaceholder());
    }

    @Test
    public void testPrepareValuesWhenConstraintValueIsNotLiteral() throws Exception {
        ((ConditionColumnPlugin)Mockito.doReturn((Object)0).when((Object)this.plugin)).constraintValue();
        ((GuidedDecisionTable52)Mockito.doReturn((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY).when((Object)this.model)).getTableFormat();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)this.model).when((Object)this.presenter)).getModel();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)this.editingCol).when((Object)this.plugin)).editingCol();
        this.plugin.prepareValues();
        ((ConditionCol52)Mockito.verify((Object)this.editingCol)).setBinding(null);
    }

    @Test
    public void testPrepareValuesWhenConstraintValueIsNotLiteralAndTableFormatIsLimitedEntry() throws Exception {
        ((ConditionColumnPlugin)Mockito.doReturn((Object)0).when((Object)this.plugin)).constraintValue();
        ((GuidedDecisionTable52)Mockito.doReturn((Object)GuidedDecisionTable52.TableFormat.LIMITED_ENTRY).when((Object)this.model)).getTableFormat();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)this.model).when((Object)this.presenter)).getModel();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)this.editingCol).when((Object)this.plugin)).editingCol();
        this.plugin.prepareValues();
        ((ConditionCol52)Mockito.verify((Object)this.editingCol, (VerificationMode)Mockito.never())).setBinding(null);
    }

    @Test
    public void testAppendColumnWhenColumnIsNew() throws Exception {
        PatternWrapper patternWrapper = (PatternWrapper)Mockito.mock(PatternWrapper.class);
        Pattern52 pattern52 = (Pattern52)Mockito.mock(Pattern52.class);
        ((ConditionColumnPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isNewColumn();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)this.editingCol).when((Object)this.plugin)).editingCol();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)patternWrapper).when((Object)this.plugin)).patternWrapper();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)pattern52).when((Object)this.plugin)).editingPattern();
        this.plugin.appendColumn();
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)this.presenter)).appendColumn(pattern52, this.editingCol);
    }

    @Test
    public void testAppendColumnWhenColumnIsNotNew() throws Exception {
        ConditionCol52 originalColumn = (ConditionCol52)Mockito.mock(ConditionCol52.class);
        ConditionCol52 editingColumn = (ConditionCol52)Mockito.mock(ConditionCol52.class);
        Pattern52 originalPattern = (Pattern52)Mockito.mock(Pattern52.class);
        Pattern52 editingPattern = (Pattern52)Mockito.mock(Pattern52.class);
        ((ConditionColumnPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).isNewColumn();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)originalColumn).when((Object)this.plugin)).originalCondition();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)editingColumn).when((Object)this.plugin)).editingCol();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)originalPattern).when((Object)this.plugin)).getOriginalPattern52();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)editingPattern).when((Object)this.plugin)).editingPattern();
        this.plugin.appendColumn();
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)this.presenter)).updateColumn(originalPattern, originalColumn, editingPattern, editingColumn);
    }

    @Test
    public void testGenerateColumn() throws Exception {
        ((ConditionColumnPlugin)Mockito.doReturn((Object)0).when((Object)this.plugin)).constraintValue();
        this.plugin.setupDefaultValues();
        Boolean result = this.plugin.generateColumn();
        Assert.assertTrue((boolean)result);
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).prepareValues();
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).appendColumn();
    }

    @Test
    public void testGenerateColumnWhenColumnIsNotNewAndVetoed() throws Exception {
        ConditionCol52 originalColumn = (ConditionCol52)Mockito.mock(ConditionCol52.class);
        ConditionCol52 editingColumn = (ConditionCol52)Mockito.mock(ConditionCol52.class);
        Pattern52 originalPattern = (Pattern52)Mockito.mock(Pattern52.class);
        Pattern52 editingPattern = (Pattern52)Mockito.mock(Pattern52.class);
        ((ConditionColumnPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).isNewColumn();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)originalColumn).when((Object)this.plugin)).originalCondition();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)editingColumn).when((Object)this.plugin)).editingCol();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)originalPattern).when((Object)this.plugin)).getOriginalPattern52();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)editingPattern).when((Object)this.plugin)).editingPattern();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).isNewColumn();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)this.oracle).when((Object)this.presenter)).getDataModelOracle();
        ((AsyncPackageDataModelOracle)Mockito.doReturn((Object)false).when((Object)this.oracle)).hasEnums((String)Mockito.any(), (String)Mockito.any());
        ((GuidedDecisionTableView.Presenter)Mockito.doThrow(ModelSynchronizer.VetoUpdatePatternInUseException.class).when((Object)this.presenter)).updateColumn((Pattern52)Mockito.any(Pattern52.class), (ConditionCol52)Mockito.any(ConditionCol52.class), (Pattern52)Mockito.any(Pattern52.class), (ConditionCol52)Mockito.any(ConditionCol52.class));
        this.plugin.setupDefaultValues();
        Assert.assertFalse((boolean)this.plugin.generateColumn());
        ((NewGuidedDecisionTableColumnWizard)Mockito.verify((Object)this.wizard)).showPatternInUseError();
    }

    @Test
    public void testGetEditingPattern() throws Exception {
        PatternWrapper patternWrapper = (PatternWrapper)Mockito.mock(PatternWrapper.class);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.plugin});
        this.plugin.setEditingPattern(patternWrapper);
        ((ConditionColumnPlugin)inOrder.verify((Object)this.plugin)).setupDefaultValues();
        ((ConditionColumnPlugin)inOrder.verify((Object)this.plugin)).setPatternWrapper(patternWrapper);
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).setupDefaultValues();
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent(this.patternPage);
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.calculationTypePage);
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.fieldPage);
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.operatorPage);
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.valueOptionsPage);
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent(this.additionalInfoPage);
    }

    @Test
    public void testGetEntryPointNameWheeunEditingPatternIsNotPresent() throws Exception {
        PatternWrapper patternWrapper = new PatternWrapper();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)patternWrapper).when((Object)this.plugin)).patternWrapper();
        String entryPointName = this.plugin.getEntryPointName();
        Assert.assertEquals((Object)"", (Object)entryPointName);
    }

    @Test
    public void testGetEntryPointNameWhenEditingPatternIsNotNull() throws Exception {
        PatternWrapper pattern = (PatternWrapper)Mockito.mock(PatternWrapper.class);
        ((PatternWrapper)Mockito.doReturn((Object)"EntryPointName").when((Object)pattern)).getEntryPointName();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)pattern).when((Object)this.plugin)).patternWrapper();
        String entryPointName = this.plugin.getEntryPointName();
        Assert.assertEquals((Object)"EntryPointName", (Object)entryPointName);
    }

    @Test
    public void testSetEntryPointName() throws Exception {
        PatternWrapper pattern = (PatternWrapper)Mockito.mock(PatternWrapper.class);
        ((ConditionColumnPlugin)Mockito.doReturn((Object)pattern).when((Object)this.plugin)).patternWrapper();
        this.plugin.setEntryPointName("EntryPointName");
        ((PatternWrapper)Mockito.verify((Object)pattern)).setEntryPointName("EntryPointName");
    }

    @Test
    public void testEditingColWhenEditingPatternIsNull() throws Exception {
        PatternWrapper pattern = (PatternWrapper)Mockito.mock(PatternWrapper.class);
        ((PatternWrapper)Mockito.doReturn((Object)"").when((Object)pattern)).getFactType();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)pattern).when((Object)this.plugin)).patternWrapper();
        this.plugin.editingCol();
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).resetFieldAndOperator();
    }

    @Test
    public void testEditingColWhenEditingPatternIsNotNull() throws Exception {
        PatternWrapper pattern = (PatternWrapper)Mockito.mock(PatternWrapper.class);
        ((PatternWrapper)Mockito.doReturn((Object)"factType").when((Object)pattern)).getFactType();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)pattern).when((Object)this.plugin)).patternWrapper();
        this.plugin.editingCol();
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin, (VerificationMode)Mockito.never())).resetFieldAndOperator();
    }

    @Test
    public void testSetHeader() throws Exception {
        String header = "Header";
        ((ConditionColumnPlugin)Mockito.doReturn((Object)this.editingCol).when((Object)this.plugin)).editingCol();
        this.plugin.setHeader("Header");
        ((ConditionCol52)Mockito.verify((Object)this.editingCol)).setHeader("Header");
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent(this.additionalInfoPage);
    }

    @Test
    public void testGetFactType() throws Exception {
        PatternWrapper pattern = (PatternWrapper)Mockito.mock(PatternWrapper.class);
        String expectedFactType = "FactType";
        ((PatternWrapper)Mockito.doReturn((Object)"FactType").when((Object)pattern)).getFactType();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)pattern).when((Object)this.plugin)).patternWrapper();
        String factType = this.plugin.getFactType();
        Assert.assertEquals((Object)"FactType", (Object)factType);
    }

    @Test
    public void testGetFactField() throws Exception {
        String expectedFactField = "FactField";
        ((ConditionCol52)Mockito.doReturn((Object)"FactField").when((Object)this.editingCol)).getFactField();
        String factField = this.plugin.getFactField();
        Assert.assertEquals((Object)"FactField", (Object)factField);
    }

    @Test
    public void testSetFactField() throws Exception {
        PatternWrapper pattern = (PatternWrapper)Mockito.mock(PatternWrapper.class);
        ((ConditionCol52)Mockito.doReturn((Object)"FactField").when((Object)this.editingCol)).getFactField();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)this.editingCol).when((Object)this.plugin)).editingCol();
        ((PatternWrapper)Mockito.doReturn((Object)"FactType").when((Object)pattern)).getFactType();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)pattern).when((Object)this.plugin)).patternWrapper();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)this.oracle).when((Object)this.presenter)).getDataModelOracle();
        this.plugin.setFactField("FactField");
        ((ConditionCol52)Mockito.verify((Object)this.editingCol)).setFactField("FactField");
        ((ConditionCol52)Mockito.verify((Object)this.editingCol)).setFieldType(this.oracle.getFieldType("FactField", "FactType"));
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.fieldPage);
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.operatorPage);
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent(this.additionalInfoPage);
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.valueOptionsPage);
    }

    @Test
    public void testSetOperator() throws Exception {
        ((ConditionColumnPlugin)Mockito.doReturn((Object)this.editingCol).when((Object)this.plugin)).editingCol();
        this.plugin.setOperator("operator");
        ((ConditionCol52)Mockito.verify((Object)this.editingCol)).setOperator("operator");
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.operatorPage);
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent(this.additionalInfoPage);
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.valueOptionsPage);
    }

    @Test
    public void testConstraintValueWhenItHasEnums() throws Exception {
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)this.oracle).when((Object)this.presenter)).getDataModelOracle();
        ((AsyncPackageDataModelOracle)Mockito.doReturn((Object)true).when((Object)this.oracle)).hasEnums((String)Mockito.any(), (String)Mockito.any());
        int constraintValue = this.plugin.constraintValue();
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).setConstraintValueFieldAndUpdateEditingCol(1);
        Assert.assertEquals((long)1L, (long)constraintValue);
    }

    @Test
    public void testConstraintValueWhenItDoesNotHaveEnums() throws Exception {
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)this.oracle).when((Object)this.presenter)).getDataModelOracle();
        ((AsyncPackageDataModelOracle)Mockito.doReturn((Object)false).when((Object)this.oracle)).hasEnums(Mockito.anyString(), Mockito.anyString());
        int constraintValue = this.plugin.constraintValue();
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin, (VerificationMode)Mockito.never())).setConstraintValueFieldAndUpdateEditingCol(1);
        Assert.assertEquals((long)0L, (long)constraintValue);
    }

    @Test
    public void testSetConstraintValue() throws Exception {
        boolean constraintValue = true;
        ((ConditionColumnPlugin)Mockito.doReturn((Object)this.editingCol).when((Object)this.plugin)).editingCol();
        this.plugin.setConstraintValue(1);
        ((ConditionCol52)Mockito.verify((Object)this.editingCol)).setConstraintValueType(1);
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).setConstraintValueFieldAndUpdateEditingCol(1);
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).resetFieldAndOperator();
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.calculationTypePage);
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.fieldPage);
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.operatorPage);
    }

    @Test
    public void testSetValueOptionsPageAsCompletedWhenItIsCompleted() throws Exception {
        ((ConditionColumnPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isValueOptionsPageCompleted();
        this.plugin.setValueOptionsPageAsCompleted();
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin, (VerificationMode)Mockito.never())).setValueOptionsPageCompleted();
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin, (VerificationMode)Mockito.never())).fireChangeEvent((WizardPage)this.valueOptionsPage);
    }

    @Test
    public void testSetValueOptionsPageAsCompletedWhenItIsNotCompleted() throws Exception {
        ((ConditionColumnPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).isValueOptionsPageCompleted();
        this.plugin.setValueOptionsPageAsCompleted();
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).setValueOptionsPageCompleted();
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.valueOptionsPage);
    }

    @Test
    public void testSetValueList() throws Exception {
        String valueList = "valueList";
        DTCellValue52 cellValue52 = (DTCellValue52)Mockito.mock(DTCellValue52.class);
        PatternWrapper pattern = (PatternWrapper)Mockito.mock(PatternWrapper.class);
        DataType.DataTypes dataTypes = DataType.DataTypes.STRING;
        this.plugin.setupDefaultValues();
        ((PatternWrapper)Mockito.doReturn((Object)"FactType").when((Object)pattern)).getFactType();
        ((DTCellValue52)Mockito.doReturn((Object)dataTypes).when((Object)cellValue52)).getDataType();
        ((ConditionCol52)Mockito.doReturn((Object)cellValue52).when((Object)this.editingCol)).getDefaultValue();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)this.editingCol).when((Object)this.plugin)).editingCol();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)pattern).when((Object)this.plugin)).patternWrapper();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)this.oracle).when((Object)this.presenter)).getDataModelOracle();
        this.plugin.setValueList("valueList");
        ((ConditionCol52)Mockito.verify((Object)this.editingCol)).setValueList("valueList");
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).assertDefaultValue();
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.valueOptionsPage);
    }

    @Test
    public void testGetTitle() {
        String errorKey = "ConditionColumnPlugin.AddConditionColumn";
        String errorMessage = "Title";
        Mockito.when((Object)this.translationService.format("ConditionColumnPlugin.AddConditionColumn", new Object[0])).thenReturn((Object)"Title");
        String title = this.plugin.getTitle();
        Assert.assertEquals((Object)"Title", (Object)title);
    }

    @Test
    public void testInit() {
        ((GuidedDecisionTable52)Mockito.doReturn((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY).when((Object)this.model)).getTableFormat();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)this.model).when((Object)this.plugin)).model();
        this.plugin.init(this.wizard);
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).setupDefaultValues();
    }

    @Test
    public void testGetAlreadyUsedColumnNames() throws Exception {
        GuidedDecisionTable52 model = new GuidedDecisionTable52();
        Pattern52 pattern = new Pattern52();
        ConditionCol52 conditionOne = new ConditionCol52(){
            {
                this.setHeader("a");
            }
        };
        ConditionCol52 conditionTwo = new ConditionCol52(){
            {
                this.setHeader("b");
            }
        };
        pattern.getChildColumns().add(conditionOne);
        pattern.getChildColumns().add(conditionTwo);
        model.getConditions().add(pattern);
        Mockito.when((Object)this.presenter.getModel()).thenReturn((Object)model);
        Assert.assertEquals((long)2L, (long)this.plugin.getAlreadyUsedColumnHeaders().size());
        Assert.assertTrue((boolean)this.plugin.getAlreadyUsedColumnHeaders().contains("a"));
        Assert.assertTrue((boolean)this.plugin.getAlreadyUsedColumnHeaders().contains("b"));
    }

    public void testIsBindableWhenTableIsAnExtendedEntry() {
        ((ConditionColumnPlugin)Mockito.doReturn((Object)0).when((Object)this.plugin)).constraintValue();
        ((GuidedDecisionTable52)Mockito.doReturn((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY).when((Object)this.model)).getTableFormat();
        Assert.assertFalse((boolean)this.plugin.isBindable());
    }

    @Test
    public void testIsBindableWhenTableIsAnExtendedEntryAndConstraintValueIsTypeLiteral() {
        ((ConditionColumnPlugin)Mockito.doReturn((Object)1).when((Object)this.plugin)).constraintValue();
        ((GuidedDecisionTable52)Mockito.doReturn((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY).when((Object)this.model)).getTableFormat();
        Assert.assertTrue((boolean)this.plugin.isBindable());
    }

    @Test
    public void testIsBindableWhenTableIsAnExtendedEntryAndConstraintValueIsTypeFormula() {
        ((ConditionColumnPlugin)Mockito.doReturn((Object)3).when((Object)this.plugin)).constraintValue();
        ((GuidedDecisionTable52)Mockito.doReturn((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY).when((Object)this.model)).getTableFormat();
        Assert.assertTrue((boolean)this.plugin.isBindable());
    }

    @Test
    public void testIsBindableWhenTableIsAnExtendedEntryAndConstraintValueIsTypePredicate() {
        ((ConditionColumnPlugin)Mockito.doReturn((Object)5).when((Object)this.plugin)).constraintValue();
        ((GuidedDecisionTable52)Mockito.doReturn((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY).when((Object)this.model)).getTableFormat();
        Assert.assertFalse((boolean)this.plugin.isBindable());
    }

    @Test
    public void testIsBindableWhenTableIsALimitedEntry() {
        ((GuidedDecisionTable52)Mockito.doReturn((Object)GuidedDecisionTable52.TableFormat.LIMITED_ENTRY).when((Object)this.model)).getTableFormat();
        Assert.assertTrue((boolean)this.plugin.isBindable());
    }

    @Test
    public void testSetupDefaultValuesWhenColumnIsNew() {
        Pattern52 pattern52 = (Pattern52)Mockito.mock(Pattern52.class);
        ConditionCol52 conditionCol52 = (ConditionCol52)Mockito.mock(ConditionCol52.class);
        ((ConditionColumnPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isNewColumn();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)pattern52).when((Object)this.plugin)).emptyPattern();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)conditionCol52).when((Object)this.plugin)).newConditionColumn();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)this.oracle).when((Object)this.presenter)).getDataModelOracle();
        ((AsyncPackageDataModelOracle)Mockito.doReturn((Object)false).when((Object)this.oracle)).hasEnums((String)Mockito.any(), (String)Mockito.any());
        this.plugin.setupDefaultValues();
        Assert.assertEquals((Object)pattern52, (Object)this.plugin.editingPattern());
        Assert.assertEquals((Object)conditionCol52, (Object)this.plugin.editingCol());
        Assert.assertEquals((long)0L, (long)this.plugin.constraintValue());
        Assert.assertEquals((Object)Boolean.FALSE, (Object)this.plugin.isValueOptionsPageCompleted());
    }

    @Test
    public void testSetupDefaultValuesWhenColumnIsNotNew() {
        Pattern52 originalPattern52 = (Pattern52)Mockito.mock(Pattern52.class);
        Pattern52 clonedPattern52 = (Pattern52)Mockito.mock(Pattern52.class);
        ConditionCol52 originalConditionCol52 = (ConditionCol52)Mockito.mock(ConditionCol52.class);
        ConditionCol52 clonedConditionCol52 = (ConditionCol52)Mockito.mock(ConditionCol52.class);
        ((ConditionCol52)Mockito.doReturn((Object)1).when((Object)originalConditionCol52)).getConstraintValueType();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)originalConditionCol52).when((Object)this.plugin)).getOriginalColumnConfig52();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)clonedConditionCol52).when((Object)this.plugin)).clone(originalConditionCol52);
        ((ConditionColumnPlugin)Mockito.doReturn((Object)originalPattern52).when((Object)this.plugin)).getOriginalPattern52();
        ((Pattern52)Mockito.doReturn((Object)clonedPattern52).when((Object)originalPattern52)).clonePattern();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)this.oracle).when((Object)this.presenter)).getDataModelOracle();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).isNewColumn();
        ((AsyncPackageDataModelOracle)Mockito.doReturn((Object)false).when((Object)this.oracle)).hasEnums((String)Mockito.any(), (String)Mockito.any());
        this.plugin.setupDefaultValues();
        Assert.assertEquals((Object)clonedPattern52, (Object)this.plugin.editingPattern());
        Assert.assertEquals((long)1L, (long)this.plugin.constraintValue());
        Assert.assertEquals((Object)Boolean.TRUE, (Object)this.plugin.isValueOptionsPageCompleted());
        Assert.assertEquals((Object)clonedConditionCol52, (Object)this.plugin.editingCol());
    }

    @Test
    public void testCloneDTCellValueWhenDTCellValue52IsNull() {
        Assert.assertNull((Object)this.plugin.cloneDTCellValue(null));
    }

    @Test
    public void testCloneDTCellValueWhenDTCellValue52IsNotNull() {
        DTCellValue52 dcv = new DTCellValue52(){
            {
                this.setStringValue("value");
            }
        };
        DTCellValue52 clone = this.plugin.cloneDTCellValue(dcv);
        Assert.assertEquals((Object)dcv, (Object)clone);
        Assert.assertNotSame((Object)dcv, (Object)clone);
    }

    @Test
    public void testCloneWhenColumnIsAConditionCol52() {
        boolean constraintValueType = true;
        String factField = "FactField";
        String fieldType = "FieldType";
        String header = "Header";
        String operator = "Operator";
        String valueList = "ValueList";
        DTCellValue52 defaultValue = null;
        boolean hideColumn = false;
        HashMap<String, String> parameters = new HashMap<String, String>();
        int width = 999;
        String binding = "Binding";
        ConditionCol52 column = this.makeConditionCol52(1, "FactField", "FieldType", "Header", "Operator", "ValueList", defaultValue, false, parameters, 999, "Binding");
        ConditionCol52 clone = this.plugin.clone(column);
        Assert.assertEquals((long)1L, (long)clone.getConstraintValueType());
        Assert.assertEquals((Object)"FactField", (Object)clone.getFactField());
        Assert.assertEquals((Object)"FieldType", (Object)clone.getFieldType());
        Assert.assertEquals((Object)"Header", (Object)clone.getHeader());
        Assert.assertEquals((Object)"Operator", (Object)clone.getOperator());
        Assert.assertEquals((Object)"ValueList", (Object)clone.getValueList());
        Assert.assertEquals(defaultValue, (Object)clone.getDefaultValue());
        Assert.assertEquals((Object)false, (Object)clone.isHideColumn());
        Assert.assertEquals(parameters, (Object)clone.getParameters());
        Assert.assertEquals((long)999L, (long)clone.getWidth());
        Assert.assertEquals((Object)"Binding", (Object)clone.getBinding());
        Assert.assertNotSame((Object)column, (Object)clone);
    }

    @Test
    public void testSetupPatternWrapper() throws Exception {
        Pattern52 pattern52 = new Pattern52(){
            {
                this.setFactType("FactType");
                this.setBoundName("BoundName");
                this.setEntryPointName("EntryPointName");
                this.setNegated(true);
            }
        };
        Mockito.when((Object)this.plugin.getEditingPattern()).thenReturn((Object)pattern52);
        this.plugin.setupPatternWrapper();
        PatternWrapper patternWrapper = this.plugin.patternWrapper();
        Assert.assertEquals((Object)patternWrapper.getFactType(), (Object)"FactType");
        Assert.assertEquals((Object)patternWrapper.getBoundName(), (Object)"BoundName");
        Assert.assertEquals((Object)patternWrapper.getEntryPointName(), (Object)"EntryPointName");
        Assert.assertEquals((Object)patternWrapper.isNegated(), (Object)true);
    }

    @Test
    public void testIsHideColumn() {
        this.plugin.isHideColumn();
        ((ConditionCol52)Mockito.verify((Object)this.editingCol)).isHideColumn();
    }

    @Test
    public void testSetHideColumn() throws Exception {
        boolean hideColumn = false;
        this.plugin.setHideColumn(false);
        ((ConditionCol52)Mockito.verify((Object)this.editingCol)).setHideColumn(false);
    }

    @Test
    public void testGetPatterns() throws Exception {
        Pattern52 pattern = new Pattern52(){
            {
                this.setFactType("FactType");
                this.setBoundName("$fact");
            }
        };
        ((GuidedDecisionTable52)Mockito.doReturn(Collections.singletonList(pattern)).when((Object)this.model)).getConditions();
        ((GuidedDecisionTable52)Mockito.doReturn((Object)pattern).when((Object)this.model)).getConditionPattern((String)Matchers.eq((Object)"$fact"));
        Set patterns = this.plugin.getPatterns();
        Assert.assertEquals((long)1L, (long)patterns.size());
        Assert.assertTrue((boolean)patterns.contains(new PatternWrapper("FactType", "$fact", Boolean.valueOf(false))));
    }

    @Test
    public void testGetPatternsWithBRLCondition() throws Exception {
        Pattern52 pattern = new Pattern52(){
            {
                this.setFactType("FactType");
                this.setBoundName("$fact");
            }
        };
        BRLConditionColumn brlColumn = new BRLConditionColumn();
        FactPattern fp = new FactPattern("AnotherFact"){
            {
                this.setBoundName("$another");
            }
        };
        brlColumn.setDefinition(Collections.singletonList(fp));
        ((GuidedDecisionTable52)Mockito.doReturn(Arrays.asList(pattern, brlColumn)).when((Object)this.model)).getConditions();
        ((GuidedDecisionTable52)Mockito.doReturn((Object)pattern).when((Object)this.model)).getConditionPattern((String)Matchers.eq((Object)"$fact"));
        ((GuidedDecisionTable52)Mockito.doReturn((Object)new FactPatternPattern52Adaptor((IFactPattern)fp)).when((Object)this.model)).getConditionPattern((String)Matchers.eq((Object)"$another"));
        Set patterns = this.plugin.getPatterns();
        Assert.assertEquals((long)1L, (long)patterns.size());
        Assert.assertTrue((boolean)patterns.contains(new PatternWrapper("FactType", "$fact", Boolean.valueOf(false))));
    }

    @Test
    public void testSetBinding() {
        this.plugin.setBinding("$a");
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)Matchers.eq((Object)this.valueOptionsPage));
    }

    @Test
    public void testIsFieldBindingValidWhenNotBindable() {
        ((ConditionColumnPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).isBindable();
        Assert.assertTrue((boolean)this.plugin.isFieldBindingValid());
    }

    @Test
    public void testIsFieldBindingValidWhenBindableNewColumnNoExistingBindings() {
        ((ConditionColumnPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isBindable();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isNewColumn();
        Assert.assertTrue((boolean)this.plugin.isFieldBindingValid());
    }

    @Test
    public void testIsFieldBindingValidWhenBindableNewColumnWithExistingBindingsNoClash() {
        ((ConditionColumnPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isBindable();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isNewColumn();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)"$n").when((Object)this.plugin)).getBinding();
        ((GuidedDecisionTable52)Mockito.doReturn(Collections.singletonList(this.mockFactPattern("$a"))).when((Object)this.model)).getConditions();
        Assert.assertTrue((boolean)this.plugin.isFieldBindingValid());
    }

    @Test
    public void testIsFieldBindingValidWhenBindableNewColumnWithExistingBindingsWithClash() {
        ((ConditionColumnPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isBindable();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isNewColumn();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)"$n").when((Object)this.plugin)).getBinding();
        ((GuidedDecisionTable52)Mockito.doReturn(Collections.singletonList(this.mockFactPattern("$n"))).when((Object)this.model)).getConditions();
        Assert.assertFalse((boolean)this.plugin.isFieldBindingValid());
    }

    @Test
    public void testIsFieldBindingValidWhenBindableEditColumnWithExistingBindingsNoClash() {
        ConditionCol52 originalColumn = (ConditionCol52)Mockito.mock(ConditionCol52.class);
        ((ConditionColumnPlugin)Mockito.doReturn((Object)originalColumn).when((Object)this.plugin)).originalCondition();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isBindable();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).isNewColumn();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)"$n").when((Object)this.plugin)).getBinding();
        ((ConditionCol52)Mockito.doReturn((Object)"$n").when((Object)originalColumn)).getBinding();
        Assert.assertTrue((boolean)this.plugin.isFieldBindingValid());
    }

    @Test
    public void testIsFieldBindingValidWhenBindableEditColumnWithExistingBindingsWithClash() {
        ConditionCol52 originalColumn = (ConditionCol52)Mockito.mock(ConditionCol52.class);
        ((ConditionColumnPlugin)Mockito.doReturn((Object)originalColumn).when((Object)this.plugin)).originalCondition();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isBindable();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).isNewColumn();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)"$a").when((Object)this.plugin)).getBinding();
        ((ConditionCol52)Mockito.doReturn((Object)"$n").when((Object)originalColumn)).getBinding();
        ((GuidedDecisionTable52)Mockito.doReturn(Collections.singletonList(this.mockFactPattern("$a"))).when((Object)this.model)).getConditions();
        Assert.assertFalse((boolean)this.plugin.isFieldBindingValid());
    }

    @Test
    public void testIsFieldBindingValidWhenNullBinding() {
        ((ConditionColumnPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isBindable();
        ((ConditionColumnPlugin)Mockito.doReturn(null).when((Object)this.plugin)).getBinding();
        Assert.assertTrue((boolean)this.plugin.isFieldBindingValid());
    }

    @Test
    public void testIsFieldBindingValidWhenPluginBindingAndFactPatternBoundNameHaveTheSameValue() {
        PatternWrapper patternWrapper = (PatternWrapper)Mockito.mock(PatternWrapper.class);
        FactPattern factPattern = new FactPattern(){
            {
                this.setBoundName("$fact");
            }
        };
        ((ConditionColumnPlugin)Mockito.doReturn((Object)1).when((Object)this.plugin)).constraintValue();
        ((PatternWrapper)Mockito.doReturn((Object)factPattern).when((Object)patternWrapper)).makeFactPattern();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)patternWrapper).when((Object)this.plugin)).patternWrapper();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)"$fact").when((Object)this.plugin)).getBinding();
        Assert.assertFalse((boolean)this.plugin.isFieldBindingValid());
    }

    @Test
    public void testMakeBRLRuleModel() {
        String factType = "FactType";
        String boundName1 = "$fact1";
        String boundName2 = "$fact2";
        Pattern52 pattern = new Pattern52(){
            {
                this.setFactType("FactType");
                this.setBoundName("$fact1");
            }
        };
        FactPattern factPattern = new FactPattern(){
            {
                this.setFactType("FactType");
                this.setBoundName("$fact2");
            }
        };
        PatternWrapper patternWrapper = (PatternWrapper)Mockito.mock(PatternWrapper.class);
        ((PatternWrapper)Mockito.doReturn((Object)factPattern).when((Object)patternWrapper)).makeFactPattern();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)patternWrapper).when((Object)this.plugin)).patternWrapper();
        ((GuidedDecisionTable52)Mockito.doReturn(Collections.singletonList(pattern)).when((Object)this.model)).getConditions();
        ((GuidedDecisionTable52)Mockito.doReturn((Object)pattern).when((Object)this.model)).getConditionPattern("$fact1");
        BRLRuleModel brlRuleModel = this.plugin.makeBRLRuleModel();
        List<String> expectedVariables = Arrays.asList("$fact1", "$fact2");
        List actualVariables = brlRuleModel.getAllVariables();
        Assert.assertEquals(expectedVariables, (Object)actualVariables);
    }

    @Test
    public void testResetFieldAndOperator() {
        this.plugin.resetFieldAndOperator();
        ((ConditionCol52)Mockito.verify((Object)this.editingCol)).setFactField("");
        ((ConditionCol52)Mockito.verify((Object)this.editingCol)).setBinding("");
        ((ConditionCol52)Mockito.verify((Object)this.editingCol)).setFieldType("");
        ((ConditionCol52)Mockito.verify((Object)this.editingCol)).setOperator("pleaseChoose");
    }

    private Pattern52 mockFactPattern(String binding) {
        Pattern52 p = new Pattern52();
        p.setBoundName(binding);
        return p;
    }

    private ConditionCol52 makeConditionCol52(int constraintValueType, String factField, String fieldType, String header, String operator, String valueList, DTCellValue52 defaultValue, boolean hideColumn, HashMap<String, String> parameters, int width, String binding) {
        ConditionCol52 column = new ConditionCol52();
        column.setConstraintValueType(constraintValueType);
        column.setFactField(factField);
        column.setFieldType(fieldType);
        column.setHeader(header);
        column.setOperator(operator);
        column.setValueList(valueList);
        column.setDefaultValue(defaultValue);
        column.setHideColumn(hideColumn);
        column.setParameters(parameters);
        column.setWidth(width);
        column.setBinding(binding);
        return column;
    }
}

