/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.editor.search;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.drools.workbench.screens.guided.dtable.client.editor.search.GuidedDecisionTableGridHighlightHelper;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.commons.util.Maps;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.util.GridHighlightHelper;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.GridLienzoPanel;

@RunWith(value=GwtMockitoTestRunner.class)
public class GuidedDecisionTableGridHighlightHelperTest {
    @Mock
    private GuidedDecisionTableModellerView.Presenter modeller;
    @Mock
    private GuidedDecisionTableModellerView view;
    @Mock
    private GridLayer gridLayer;
    @Mock
    private GridWidget gridWidget1;
    @Mock
    private GridWidget gridWidget2;
    @Mock
    private GridWidget gridWidget3;
    @Mock
    private GridLienzoPanel gridPanel;
    private Double minY = -2400.0;
    private Double minX = -3400.0;
    private GuidedDecisionTableGridHighlightHelper helper;

    @Before
    public void setup() {
        HashSet<GridWidget> gridWidgets = new HashSet<GridWidget>(Arrays.asList(this.gridWidget1, this.gridWidget2, this.gridWidget3));
        ApplicationPreferences.setUp((Map)new Maps.Builder().put((Object)"drools.dateformat", (Object)"dd/mm/yy").build());
        this.helper = (GuidedDecisionTableGridHighlightHelper)Mockito.spy((Object)new GuidedDecisionTableGridHighlightHelper());
        Mockito.when((Object)this.gridWidget1.getY()).thenReturn((Object)0.0);
        Mockito.when((Object)this.gridWidget2.getY()).thenReturn((Object)0.0);
        Mockito.when((Object)this.gridWidget3.getY()).thenReturn((Object)this.minY);
        Mockito.when((Object)this.gridWidget1.getX()).thenReturn((Object)0.0);
        Mockito.when((Object)this.gridWidget2.getX()).thenReturn((Object)0.0);
        Mockito.when((Object)this.gridWidget3.getX()).thenReturn((Object)this.minX);
        Mockito.when((Object)this.gridWidget2.isSelected()).thenReturn((Object)true);
        Mockito.when((Object)this.gridWidget1.isVisible()).thenReturn((Object)true);
        Mockito.when((Object)this.gridWidget2.isVisible()).thenReturn((Object)true);
        Mockito.when((Object)this.gridWidget3.isVisible()).thenReturn((Object)true);
        Mockito.when((Object)this.modeller.getView()).thenReturn((Object)this.view);
        Mockito.when((Object)this.view.getGridLayerView()).thenReturn((Object)this.gridLayer);
        Mockito.when((Object)this.view.getGridPanel()).thenReturn((Object)this.gridPanel);
        Mockito.when((Object)this.view.getGridWidgets()).thenReturn(gridWidgets);
        Mockito.when((Object)this.gridLayer.getGridWidgets()).thenReturn(gridWidgets);
    }

    @Test
    public void testOnFound() {
        GridHighlightHelper highlightHelper = (GridHighlightHelper)Mockito.mock(GridHighlightHelper.class);
        GridData model = (GridData)Mockito.mock(GridData.class);
        GridColumn column1 = (GridColumn)Mockito.mock(GridColumn.class);
        GridColumn column2 = (GridColumn)Mockito.mock(GridColumn.class);
        GridRow gridRow1 = (GridRow)Mockito.mock(GridRow.class);
        GridRow gridRow2 = (GridRow)Mockito.mock(GridRow.class);
        GridRow gridRow3 = (GridRow)Mockito.mock(GridRow.class);
        GridRow gridRow4 = (GridRow)Mockito.mock(GridRow.class);
        double gridRow1Height = 100.0;
        double gridRow2Height = 101.0;
        double gridRow3Height = 102.0;
        double gridRow4Height = 103.0;
        double column1Width = 90.0;
        double column2Width = 110.0;
        int row = 3;
        boolean column = true;
        GuidedDecisionTableView widget = (GuidedDecisionTableView)Mockito.mock(GuidedDecisionTableView.class);
        double paddingX = 310.0;
        double paddingY = 406.0;
        ((GuidedDecisionTableGridHighlightHelper)Mockito.doReturn((Object)highlightHelper).when((Object)this.helper)).highlightHelper(this.modeller, widget);
        Mockito.when((Object)this.gridWidget2.getModel()).thenReturn((Object)model);
        Mockito.when((Object)model.getColumns()).thenReturn(Arrays.asList(column1, column2));
        Mockito.when((Object)model.getRows()).thenReturn(Arrays.asList(gridRow1, gridRow2, gridRow3, gridRow4));
        Mockito.when((Object)gridRow1.getHeight()).thenReturn((Object)100.0);
        Mockito.when((Object)gridRow2.getHeight()).thenReturn((Object)101.0);
        Mockito.when((Object)gridRow3.getHeight()).thenReturn((Object)102.0);
        Mockito.when((Object)gridRow4.getHeight()).thenReturn((Object)103.0);
        Mockito.when((Object)column1.getWidth()).thenReturn((Object)90.0);
        Mockito.when((Object)column2.getWidth()).thenReturn((Object)110.0);
        Mockito.when((Object)highlightHelper.withPaddingX(310.0)).thenReturn((Object)highlightHelper);
        Mockito.when((Object)highlightHelper.withPaddingY(406.0)).thenReturn((Object)highlightHelper);
        ((GuidedDecisionTableGridHighlightHelper)Mockito.doReturn((Object)310.0).when((Object)this.helper)).getPaddingX(Integer.valueOf(1), this.modeller, widget);
        ((GuidedDecisionTableGridHighlightHelper)Mockito.doReturn((Object)406.0).when((Object)this.helper)).getPaddingY(Integer.valueOf(3), this.modeller, widget);
        this.helper.highlight(Integer.valueOf(3), Integer.valueOf(1), widget, this.modeller);
        ((GridHighlightHelper)Mockito.verify((Object)highlightHelper)).highlight(3, 1);
    }

    @Test
    public void testGetWidth() {
        Double expectedWidth = 0.0;
        Double actualWidth = this.helper.getWidth(new ArrayList(), 1);
        Assert.assertEquals((Object)expectedWidth, (Object)actualWidth);
    }

    @Test
    public void testGetHeight() {
        Double expectedHeight = 0.0;
        Double actualHeight = this.helper.getHeight(new ArrayList(), 1);
        Assert.assertEquals((Object)expectedHeight, (Object)actualHeight);
    }

    @Test
    public void testGetGridPanel() {
        Assert.assertEquals((Object)this.gridPanel, (Object)this.helper.getGridPanel(this.modeller));
    }
}

