/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table;

import com.ait.lienzo.client.core.event.INodeXYEvent;
import com.ait.lienzo.client.core.event.NodeDragMoveEvent;
import com.ait.lienzo.client.core.event.NodeDragMoveHandler;
import com.ait.lienzo.client.core.event.NodeMouseDoubleClickEvent;
import com.ait.lienzo.client.core.event.NodeMouseDoubleClickHandler;
import com.ait.lienzo.client.core.shape.Layer;
import com.google.gwt.user.client.Command;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.event.Event;
import org.assertj.core.api.Assertions;
import org.drools.verifier.api.reporting.Issue;
import org.drools.verifier.api.reporting.Severity;
import org.drools.workbench.models.datamodel.rule.ActionFieldValue;
import org.drools.workbench.models.datamodel.rule.ActionInsertFact;
import org.drools.workbench.models.datamodel.rule.Attribute;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.AttributeCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.MetadataCol52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.editor.clipboard.Clipboard;
import org.drools.workbench.screens.guided.dtable.client.editor.search.GuidedDecisionTableSearchableElement;
import org.drools.workbench.screens.guided.dtable.client.type.GuidedDTableResourceType;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.DecisionTableAnalyzerProvider;
import org.drools.workbench.screens.guided.dtable.client.widget.table.BaseGuidedDecisionTablePresenterTest;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerPresenter;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTablePresenter;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.PluginHandler;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.DecisionTableColumnSelectedEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.DecisionTableSelectedEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.DecisionTableSelectionsChangedEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.RefreshActionsPanelEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.RefreshAttributesPanelEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.RefreshConditionsPanelEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.RefreshMenusEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.RefreshMetaDataPanelEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.lockmanager.GuidedDecisionTableLockManager;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.GuidedDecisionTableUiModel;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.converters.cell.GridWidgetCellFactory;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.converters.column.GridWidgetColumnFactory;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.ModelSynchronizer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.themes.GuidedDecisionTableRenderer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.utilities.DependentEnumsUtilities;
import org.drools.workbench.screens.guided.dtable.client.widget.table.utilities.EnumLoaderUtilities;
import org.drools.workbench.screens.guided.dtable.model.GuidedDecisionTableEditorContent;
import org.drools.workbench.screens.guided.dtable.service.GuidedDecisionTableLinkManager;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.project.datamodel.imports.HasImports;
import org.kie.soup.project.datamodel.oracle.DropDownData;
import org.kie.workbench.common.services.datamodel.model.PackageDataModelOracleBaselinePayload;
import org.kie.workbench.common.services.shared.rulename.RuleNamesService;
import org.kie.workbench.common.services.verifier.reporting.client.controller.AnalyzerController;
import org.kie.workbench.common.services.verifier.reporting.client.panel.IssueSelectedEvent;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracleFactory;
import org.kie.workbench.common.widgets.client.search.common.SearchPerformedEvent;
import org.kie.workbench.common.widgets.client.search.common.Searchable;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.client.mvp.UpdatedLockStatusEvent;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.DefaultGridLayer;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=GwtMockitoTestRunner.class)
public class GuidedDecisionTablePresenterTest
extends BaseGuidedDecisionTablePresenterTest {
    private GuidedDecisionTable52 model1;
    private GuidedDecisionTable52 model2;
    private GuidedDecisionTable52 model3;
    private List uiModel1Columns;
    private List uiModel2Columns;
    private List uiModel3Columns;
    private GridColumn uiModel1MockColumn;
    private GridColumn uiModel2MockColumn;
    private GridColumn uiModel3MockColumn;
    @Captor
    private ArgumentCaptor<Map<String, String>> callbackValueCaptor;
    @Captor
    private ArgumentCaptor<List> listArgumentCaptor;
    private int originalHashCode;

    @Override
    @Before
    public void setup() {
        super.setup();
        this.originalHashCode = this.model.hashCode();
        this.dtPresenter.onAppendRow();
        this.dtPresenter.onAppendRow();
        this.dtPresenter.onAppendRow();
        this.model1 = new GuidedDecisionTable52();
        this.model2 = new GuidedDecisionTable52();
        this.model3 = new GuidedDecisionTable52();
        this.uiModel1Columns = (List)Mockito.mock(List.class);
        this.uiModel2Columns = (List)Mockito.mock(List.class);
        this.uiModel3Columns = (List)Mockito.mock(List.class);
        this.uiModel1MockColumn = (GridColumn)Mockito.mock(GridColumn.class);
        this.uiModel2MockColumn = (GridColumn)Mockito.mock(GridColumn.class);
        this.uiModel3MockColumn = (GridColumn)Mockito.mock(GridColumn.class);
    }

    @Test
    public void testOnUpdatedLockStatusEvent_LockedByCurrentUser() {
        UpdatedLockStatusEvent event = (UpdatedLockStatusEvent)Mockito.mock(UpdatedLockStatusEvent.class);
        Mockito.when((Object)event.getFile()).thenReturn((Object)this.dtPath);
        Mockito.when((Object)event.isLockedByCurrentUser()).thenReturn((Object)true);
        Mockito.when((Object)event.isLocked()).thenReturn((Object)true);
        this.dtPresenter.onUpdatedLockStatusEvent(event);
        ((GuidedDecisionTablePresenter)Mockito.verify((Object)this.dtPresenter)).refreshColumnsPage();
        ((GuidedDecisionTablePresenter)Mockito.verify((Object)this.dtPresenter)).refreshMenus();
        Assert.assertEquals((Object)GuidedDecisionTablePresenter.Access.LockedBy.CURRENT_USER, (Object)this.dtPresenter.getAccess().getLock());
    }

    @Test
    public void testOnUpdatedLockStatusEvent_LockedByOtherUser() {
        UpdatedLockStatusEvent event = (UpdatedLockStatusEvent)Mockito.mock(UpdatedLockStatusEvent.class);
        Mockito.when((Object)event.getFile()).thenReturn((Object)this.dtPath);
        Mockito.when((Object)event.isLockedByCurrentUser()).thenReturn((Object)false);
        Mockito.when((Object)event.isLocked()).thenReturn((Object)true);
        this.dtPresenter.onUpdatedLockStatusEvent(event);
        ((GuidedDecisionTablePresenter)Mockito.verify((Object)this.dtPresenter)).refreshColumnsPage();
        ((GuidedDecisionTablePresenter)Mockito.verify((Object)this.dtPresenter)).refreshMenus();
        Assert.assertEquals((Object)GuidedDecisionTablePresenter.Access.LockedBy.OTHER_USER, (Object)this.dtPresenter.getAccess().getLock());
    }

    @Test
    public void testOnUpdatedLockStatusEvent_NotLocked() {
        UpdatedLockStatusEvent event = (UpdatedLockStatusEvent)Mockito.mock(UpdatedLockStatusEvent.class);
        Mockito.when((Object)event.getFile()).thenReturn((Object)this.dtPath);
        this.dtPresenter.onUpdatedLockStatusEvent(event);
        ((GuidedDecisionTablePresenter)Mockito.verify((Object)this.dtPresenter)).refreshColumnsPage();
        ((GuidedDecisionTablePresenter)Mockito.verify((Object)this.dtPresenter)).refreshMenus();
        Assert.assertEquals((Object)GuidedDecisionTablePresenter.Access.LockedBy.NOBODY, (Object)this.dtPresenter.getAccess().getLock());
    }

    @Test
    public void testOnUpdatedLockStatusEvent_NullFile() {
        UpdatedLockStatusEvent event = (UpdatedLockStatusEvent)Mockito.mock(UpdatedLockStatusEvent.class);
        this.dtPresenter.onUpdatedLockStatusEvent(event);
    }

    @Test
    public void testOnIssueSelectedEvent_NullEvent() {
        this.dtPresenter.onIssueSelectedEvent(null);
        ((GuidedDecisionTableRenderer)Mockito.verify((Object)this.renderer, (VerificationMode)Mockito.never())).clearHighlights();
        ((GuidedDecisionTableRenderer)Mockito.verify((Object)this.renderer, (VerificationMode)Mockito.never())).highlightRows((Severity)Mockito.any(Severity.class), (Set)Mockito.any(Set.class));
    }

    @Test
    public void testOnIssueSelectedEvent_ClearHighlightsWithDifferentTable() {
        this.dtPresenter.onIssueSelectedEvent(new IssueSelectedEvent((PlaceRequest)Mockito.mock(PlaceRequest.class), (Issue)Mockito.mock(Issue.class)));
        ((GuidedDecisionTableRenderer)Mockito.verify((Object)this.renderer, (VerificationMode)Mockito.times((int)1))).clearHighlights();
        ((GuidedDecisionTableRenderer)Mockito.verify((Object)this.renderer, (VerificationMode)Mockito.never())).highlightRows((Severity)Mockito.any(Severity.class), (Set)Mockito.any(Set.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).draw();
    }

    @Test
    public void testOnIssueSelectedEvent_HighlightsRows() {
        this.dtPresenter.onIssueSelectedEvent(new IssueSelectedEvent(this.dtPlaceRequest, (Issue)Mockito.mock(Issue.class)));
        ((GuidedDecisionTableRenderer)Mockito.verify((Object)this.renderer, (VerificationMode)Mockito.never())).clearHighlights();
        ((GuidedDecisionTableRenderer)Mockito.verify((Object)this.renderer, (VerificationMode)Mockito.times((int)1))).highlightRows((Severity)Mockito.any(), (Set)Mockito.any(Set.class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).draw();
    }

    @Test
    public void testActivate() {
        this.dtPresenter.activate();
        ((GuidedDecisionTableLockManager)Mockito.verify((Object)this.lockManager, (VerificationMode)Mockito.times((int)1))).fireChangeTitleEvent();
    }

    @Test
    public void setContent() {
        ((GuidedDecisionTablePresenter)Mockito.verify((Object)this.dtPresenter, (VerificationMode)Mockito.times((int)1))).initialiseContent((ObservablePath)Mockito.eq((Object)this.dtPath), (PlaceRequest)Mockito.eq((Object)this.dtPlaceRequest), (GuidedDecisionTableEditorContent)Mockito.eq((Object)this.dtContent), Mockito.eq((boolean)false));
        ((AsyncPackageDataModelOracleFactory)Mockito.verify((Object)this.oracleFactory, (VerificationMode)Mockito.times((int)1))).makeAsyncPackageDataModelOracle((Path)Mockito.eq((Object)this.dtPath), (HasImports)Mockito.any(GuidedDecisionTable52.class), (PackageDataModelOracleBaselinePayload)Mockito.any(PackageDataModelOracleBaselinePayload.class));
        ((GuidedDecisionTablePresenter)Mockito.verify((Object)this.dtPresenter, (VerificationMode)Mockito.times((int)1))).makeUiModel();
        ((GuidedDecisionTablePresenter)Mockito.verify((Object)this.dtPresenter, (VerificationMode)Mockito.times((int)1))).makeView((Set)Mockito.any(Set.class));
        ((GuidedDecisionTablePresenter)Mockito.verify((Object)this.dtPresenter, (VerificationMode)Mockito.times((int)1))).initialiseAccess(false);
        ((GuidedDecisionTablePresenter)Mockito.verify((Object)this.dtPresenter, (VerificationMode)Mockito.times((int)1))).initialiseLockManager();
        ((GuidedDecisionTablePresenter)Mockito.verify((Object)this.dtPresenter, (VerificationMode)Mockito.times((int)1))).initialiseUtilities();
        ((GuidedDecisionTablePresenter)Mockito.verify((Object)this.dtPresenter, (VerificationMode)Mockito.times((int)1))).initialiseModels();
        ((GuidedDecisionTablePresenter)Mockito.verify((Object)this.dtPresenter, (VerificationMode)Mockito.times((int)1))).initialiseValidationAndVerification();
        ((GuidedDecisionTablePresenter)Mockito.verify((Object)this.dtPresenter, (VerificationMode)Mockito.times((int)1))).initialiseEventHandlers();
        ((GuidedDecisionTablePresenter)Mockito.verify((Object)this.dtPresenter, (VerificationMode)Mockito.times((int)1))).initialiseAuditLog();
        Assert.assertEquals((double)24.0, (double)this.dtPresenter.getUiModel().getRow(0).getHeight(), (double)0.0);
        Assert.assertEquals((double)24.0, (double)this.dtPresenter.getUiModel().getRow(1).getHeight(), (double)0.0);
        Assert.assertEquals((double)24.0, (double)this.dtPresenter.getUiModel().getRow(2).getHeight(), (double)0.0);
        Assert.assertEquals((long)this.originalHashCode, (long)this.dtPresenter.getOriginalHashCode().intValue());
        Assert.assertNotEquals((long)this.dtContent.getModel().hashCode(), (long)this.dtPresenter.getOriginalHashCode().intValue());
    }

    @Test
    public void refreshContent() {
        this.dtPresenter.refreshContent(this.dtPath, this.dtPlaceRequest, this.dtContent, false);
        ((GuidedDecisionTablePresenter)Mockito.verify((Object)this.dtPresenter, (VerificationMode)Mockito.times((int)2))).initialiseContent((ObservablePath)Mockito.eq((Object)this.dtPath), (PlaceRequest)Mockito.eq((Object)this.dtPlaceRequest), (GuidedDecisionTableEditorContent)Mockito.eq((Object)this.dtContent), Mockito.eq((boolean)false));
        ((AsyncPackageDataModelOracleFactory)Mockito.verify((Object)this.oracleFactory, (VerificationMode)Mockito.times((int)2))).makeAsyncPackageDataModelOracle((Path)Mockito.eq((Object)this.dtPath), (HasImports)Mockito.any(GuidedDecisionTable52.class), (PackageDataModelOracleBaselinePayload)Mockito.any(PackageDataModelOracleBaselinePayload.class));
        ((GuidedDecisionTablePresenter)Mockito.verify((Object)this.dtPresenter, (VerificationMode)Mockito.times((int)2))).makeUiModel();
        ((GuidedDecisionTablePresenter)Mockito.verify((Object)this.dtPresenter, (VerificationMode)Mockito.times((int)2))).makeView((Set)Mockito.any(Set.class));
        ((GuidedDecisionTablePresenter)Mockito.verify((Object)this.dtPresenter, (VerificationMode)Mockito.times((int)2))).initialiseAccess(false);
        ((GuidedDecisionTablePresenter)Mockito.verify((Object)this.dtPresenter, (VerificationMode)Mockito.times((int)2))).initialiseLockManager();
        ((GuidedDecisionTablePresenter)Mockito.verify((Object)this.dtPresenter, (VerificationMode)Mockito.times((int)2))).initialiseUtilities();
        ((GuidedDecisionTablePresenter)Mockito.verify((Object)this.dtPresenter, (VerificationMode)Mockito.times((int)2))).initialiseModels();
        ((GuidedDecisionTablePresenter)Mockito.verify((Object)this.dtPresenter, (VerificationMode)Mockito.times((int)2))).initialiseValidationAndVerification();
        ((GuidedDecisionTablePresenter)Mockito.verify((Object)this.dtPresenter, (VerificationMode)Mockito.times((int)2))).initialiseAuditLog();
        Assert.assertEquals((long)this.dtContent.getModel().hashCode(), (long)this.dtPresenter.getOriginalHashCode().intValue());
        ((GuidedDecisionTablePresenter)Mockito.verify((Object)this.dtPresenter, (VerificationMode)Mockito.times((int)1))).terminateAnalysis();
        ((GuidedDecisionTableLockManager)Mockito.verify((Object)this.lockManager, (VerificationMode)Mockito.times((int)1))).releaseLock();
        ((AsyncPackageDataModelOracleFactory)Mockito.verify((Object)this.oracleFactory, (VerificationMode)Mockito.times((int)1))).destroy((AsyncPackageDataModelOracle)Mockito.eq((Object)this.oracle));
    }

    @Test
    public void initialiseEventHandler() {
        ArgumentCaptor nodeDragMoveHandlerArgumentCaptor = ArgumentCaptor.forClass(NodeDragMoveHandler.class);
        ArgumentCaptor nodeMouseDoubleClickHandlerArgumentCaptor = ArgumentCaptor.forClass(NodeMouseDoubleClickHandler.class);
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).registerNodeDragMoveHandler((NodeDragMoveHandler)nodeDragMoveHandlerArgumentCaptor.capture());
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).registerNodeMouseDoubleClickHandler((NodeMouseDoubleClickHandler)nodeMouseDoubleClickHandlerArgumentCaptor.capture());
        NodeDragMoveHandler nodeDragMoveHandler = (NodeDragMoveHandler)nodeDragMoveHandlerArgumentCaptor.getValue();
        NodeMouseDoubleClickHandler nodeMouseDoubleClickHandler = (NodeMouseDoubleClickHandler)nodeMouseDoubleClickHandlerArgumentCaptor.getValue();
        Assert.assertNotNull((Object)nodeDragMoveHandler);
        Assert.assertNotNull((Object)nodeMouseDoubleClickHandler);
    }

    @Test
    public void checkRegisteredNodeDragMoveHandler() {
        ArgumentCaptor nodeDragMoveHandlerArgumentCaptor = ArgumentCaptor.forClass(NodeDragMoveHandler.class);
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).registerNodeDragMoveHandler((NodeDragMoveHandler)nodeDragMoveHandlerArgumentCaptor.capture());
        NodeDragMoveHandler nodeDragMoveHandler = (NodeDragMoveHandler)nodeDragMoveHandlerArgumentCaptor.getValue();
        Assert.assertNotNull((Object)nodeDragMoveHandler);
        nodeDragMoveHandler.onNodeDragMove((NodeDragMoveEvent)Mockito.mock(NodeDragMoveEvent.class));
        ((GuidedDecisionTableModellerPresenter)Mockito.verify((Object)this.modellerPresenter, (VerificationMode)Mockito.times((int)1))).updateRadar();
    }

    @Test
    public void checkRegisteredNodeMouseDoubleClickHandlerOverHeader() {
        ArgumentCaptor nodeMouseDoubleClickHandlerArgumentCaptor = ArgumentCaptor.forClass(NodeMouseDoubleClickHandler.class);
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).registerNodeMouseDoubleClickHandler((NodeMouseDoubleClickHandler)nodeMouseDoubleClickHandlerArgumentCaptor.capture());
        NodeMouseDoubleClickHandler nodeMouseDoubleClickHandler = (NodeMouseDoubleClickHandler)nodeMouseDoubleClickHandlerArgumentCaptor.getValue();
        Assert.assertNotNull((Object)nodeMouseDoubleClickHandler);
        NodeMouseDoubleClickEvent event = (NodeMouseDoubleClickEvent)Mockito.mock(NodeMouseDoubleClickEvent.class);
        Mockito.when((Object)this.view.isNodeMouseEventOverCaption((INodeXYEvent)Mockito.eq((Object)event))).thenReturn((Object)true);
        Mockito.when((Object)this.modellerPresenter.isGridPinned()).thenReturn((Object)false);
        nodeMouseDoubleClickHandler.onNodeMouseDoubleClick(event);
        ((GuidedDecisionTablePresenter)Mockito.verify((Object)this.dtPresenter, (VerificationMode)Mockito.times((int)1))).enterPinnedMode((GridWidget)Mockito.eq((Object)this.view), (Command)Mockito.any(Command.class));
        Mockito.when((Object)this.modellerPresenter.isGridPinned()).thenReturn((Object)true);
        nodeMouseDoubleClickHandler.onNodeMouseDoubleClick(event);
        ((GuidedDecisionTablePresenter)Mockito.verify((Object)this.dtPresenter, (VerificationMode)Mockito.times((int)1))).exitPinnedMode((Command)Mockito.any(Command.class));
    }

    @Test
    public void checkRegisteredNodeMouseDoubleClickHandlerNotOverHeader() {
        ArgumentCaptor nodeMouseDoubleClickHandlerArgumentCaptor = ArgumentCaptor.forClass(NodeMouseDoubleClickHandler.class);
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).registerNodeMouseDoubleClickHandler((NodeMouseDoubleClickHandler)nodeMouseDoubleClickHandlerArgumentCaptor.capture());
        NodeMouseDoubleClickHandler nodeMouseDoubleClickHandler = (NodeMouseDoubleClickHandler)nodeMouseDoubleClickHandlerArgumentCaptor.getValue();
        Assert.assertNotNull((Object)nodeMouseDoubleClickHandler);
        NodeMouseDoubleClickEvent event = (NodeMouseDoubleClickEvent)Mockito.mock(NodeMouseDoubleClickEvent.class);
        Mockito.when((Object)this.view.isNodeMouseEventOverCaption((INodeXYEvent)Mockito.eq((Object)event))).thenReturn((Object)false);
        nodeMouseDoubleClickHandler.onNodeMouseDoubleClick(event);
        ((GuidedDecisionTablePresenter)Mockito.verify((Object)this.dtPresenter, (VerificationMode)Mockito.never())).enterPinnedMode((GridWidget)Mockito.any(GridWidget.class), (Command)Mockito.any(Command.class));
        ((GuidedDecisionTablePresenter)Mockito.verify((Object)this.dtPresenter, (VerificationMode)Mockito.never())).enterPinnedMode((GridWidget)Mockito.any(GridWidget.class), (Command)Mockito.any(Command.class));
    }

    @Test
    public void link() {
        final GuidedDecisionTableView.Presenter dtPresenter2 = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        final GuidedDecisionTableView.Presenter dtPresenter3 = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        HashSet<GuidedDecisionTableView.Presenter> dtPresenters = new HashSet<GuidedDecisionTableView.Presenter>(){
            {
                this.add(GuidedDecisionTablePresenterTest.this.dtPresenter);
                this.add(dtPresenter2);
                this.add(dtPresenter3);
            }
        };
        Mockito.when((Object)this.dtPresenter.getModel()).thenReturn((Object)this.model1);
        Mockito.when((Object)dtPresenter2.getModel()).thenReturn((Object)this.model2);
        Mockito.when((Object)dtPresenter3.getModel()).thenReturn((Object)this.model3);
        this.dtPresenter.link((Set)dtPresenters);
        ((GuidedDecisionTableLinkManager)Mockito.verify((Object)this.linkManager, (VerificationMode)Mockito.times((int)1))).link((GuidedDecisionTable52)Mockito.eq((Object)this.model1), (GuidedDecisionTable52)Mockito.eq((Object)this.model2), (GuidedDecisionTableLinkManager.LinkFoundCallback)Mockito.any(GuidedDecisionTableLinkManager.LinkFoundCallback.class));
        ((GuidedDecisionTableLinkManager)Mockito.verify((Object)this.linkManager, (VerificationMode)Mockito.times((int)1))).link((GuidedDecisionTable52)Mockito.eq((Object)this.model1), (GuidedDecisionTable52)Mockito.eq((Object)this.model3), (GuidedDecisionTableLinkManager.LinkFoundCallback)Mockito.any(GuidedDecisionTableLinkManager.LinkFoundCallback.class));
    }

    @Test
    public void linkMultipleRelatedTables() {
        this.addActionInsertFactToModel(this.model1, "Applicant", "name");
        this.addConstraintToModel(this.model2, "Applicant", "name");
        this.addConstraintToModel(this.model3, "Applicant", "name");
        this.linkTables();
        ((List)Mockito.verify((Object)this.uiModel1Columns, (VerificationMode)Mockito.atLeast((int)1))).get(Mockito.eq((int)3));
        ((List)Mockito.verify((Object)this.uiModel2Columns, (VerificationMode)Mockito.atLeast((int)1))).get(Mockito.eq((int)3));
        ((List)Mockito.verify((Object)this.uiModel3Columns, (VerificationMode)Mockito.atLeast((int)1))).get(Mockito.eq((int)3));
        ((GridColumn)Mockito.verify((Object)this.uiModel2MockColumn)).setLink((GridColumn)Mockito.eq((Object)this.uiModel1MockColumn));
        ((GridColumn)Mockito.verify((Object)this.uiModel3MockColumn)).setLink((GridColumn)Mockito.eq((Object)this.uiModel1MockColumn));
    }

    @Test
    public void testLinkOneProducerTwoConsumersOneFact() throws Exception {
        this.addActionInsertFactToModel(this.model1, "Applicant", "name");
        this.addActionInsertFactToModel(this.model1, "Applicant", "age");
        this.addConstraintToModel(this.model2, "Applicant", "name");
        this.addBrlConstraintToModel(this.model3, "Applicant", "age");
        this.linkTables();
        ((GridColumn)Mockito.verify((Object)this.uiModel2MockColumn)).setLink((GridColumn)Mockito.eq((Object)this.uiModel1MockColumn));
        ((GridColumn)Mockito.verify((Object)this.uiModel3MockColumn)).setLink((GridColumn)Mockito.eq((Object)this.uiModel1MockColumn));
    }

    @Test
    public void testLinkOneProducerTwoConsumersTwoFacts() throws Exception {
        this.addActionInsertFactToModel(this.model1, "Applicant", "name");
        this.addActionInsertFactToModel(this.model1, "LoanApplication", "amount");
        this.addConstraintToModel(this.model2, "Applicant", "name");
        this.addBrlConstraintToModel(this.model3, "LoanApplication", "amount");
        this.linkTables();
        ((GridColumn)Mockito.verify((Object)this.uiModel2MockColumn)).setLink((GridColumn)Mockito.eq((Object)this.uiModel1MockColumn));
        ((GridColumn)Mockito.verify((Object)this.uiModel3MockColumn)).setLink((GridColumn)Mockito.eq((Object)this.uiModel1MockColumn));
    }

    @Test
    public void testLinkTwoProducersOneConsumerOneFact() throws Exception {
        this.addBrlInsertActionToModel(this.model1, "Applicant", "name");
        this.addBrlInsertActionToModel(this.model1, "Applicant", "age");
        this.addActionInsertFactToModel(this.model2, "Applicant", "name");
        this.addActionInsertFactToModel(this.model2, "Applicant", "age");
        this.addConstraintToModel(this.model3, "Applicant", "name");
        this.linkTables();
        ((GridColumn)Mockito.verify((Object)this.uiModel3MockColumn)).setLink((GridColumn)Mockito.eq((Object)this.uiModel1MockColumn));
        ((GridColumn)Mockito.verify((Object)this.uiModel3MockColumn)).setLink((GridColumn)Mockito.eq((Object)this.uiModel2MockColumn));
    }

    @Test
    public void testLinkTwoProducersOneConsumerTwoFacts() throws Exception {
        this.addBrlInsertActionToModel(this.model1, "Applicant", "name");
        this.addBrlInsertActionToModel(this.model1, "LoanApplication", "age");
        this.addActionInsertFactToModel(this.model2, "Applicant", "name");
        this.addActionInsertFactToModel(this.model2, "Applicant", "age");
        this.addConstraintToModel(this.model3, "Applicant", "name");
        this.linkTables();
        ((GridColumn)Mockito.verify((Object)this.uiModel3MockColumn)).setLink((GridColumn)Mockito.eq((Object)this.uiModel1MockColumn));
        ((GridColumn)Mockito.verify((Object)this.uiModel3MockColumn)).setLink((GridColumn)Mockito.eq((Object)this.uiModel2MockColumn));
    }

    @Test
    public void testLinkCircle() throws Exception {
        this.addConstraintToModel(this.model1, "Applicant", "name");
        this.addActionInsertFactToModel(this.model1, "Applicant", "age");
        this.addConstraintToModel(this.model2, "Applicant", "age");
        this.addActionInsertFactToModel(this.model2, "LoanApplication", "amount");
        this.addConstraintToModel(this.model3, "LoanApplication", "amount");
        this.addActionInsertFactToModel(this.model3, "Applicant", "name");
        this.linkTables();
        ((GridColumn)Mockito.verify((Object)this.uiModel1MockColumn)).setLink((GridColumn)Mockito.eq((Object)this.uiModel3MockColumn));
        ((GridColumn)Mockito.verify((Object)this.uiModel2MockColumn)).setLink((GridColumn)Mockito.eq((Object)this.uiModel1MockColumn));
        ((GridColumn)Mockito.verify((Object)this.uiModel3MockColumn)).setLink((GridColumn)Mockito.eq((Object)this.uiModel2MockColumn));
    }

    @Test
    public void setRuleNameColumnVisibility() {
        this.dtPresenter.setShowRuleName(true);
        Assert.assertFalse((boolean)this.model.getRuleNameColumn().isHideColumn());
        this.dtPresenter.setShowRuleName(false);
        Assert.assertTrue((boolean)this.model.getRuleNameColumn().isHideColumn());
    }

    @Test
    public void testNoLink() throws Exception {
        this.addActionInsertFactToModel(this.model1, "Applicant", "name");
        this.addConstraintToModel(this.model2, "Applicant", "age");
        this.linkTables();
        ((GridColumn)Mockito.verify((Object)this.uiModel2MockColumn, (VerificationMode)Mockito.never())).setLink((GridColumn)Mockito.eq((Object)this.uiModel1MockColumn));
        ((GridColumn)Mockito.verify((Object)this.uiModel1MockColumn, (VerificationMode)Mockito.never())).setLink((GridColumn)Mockito.eq((Object)this.uiModel2MockColumn));
    }

    private void linkTables() {
        GridData uiModel1 = (GridData)Mockito.spy((Object)new BaseGridData());
        GridData uiModel2 = (GridData)Mockito.spy((Object)new BaseGridData());
        GridData uiModel3 = (GridData)Mockito.spy((Object)new BaseGridData());
        GuidedDecisionTableView dtView2 = (GuidedDecisionTableView)Mockito.mock(GuidedDecisionTableView.class);
        GuidedDecisionTableView dtView3 = (GuidedDecisionTableView)Mockito.mock(GuidedDecisionTableView.class);
        GuidedDecisionTablePresenter dtPresenter2 = this.setupPresenter();
        GuidedDecisionTablePresenter dtPresenter3 = this.setupPresenter();
        HashSet<GuidedDecisionTableView.Presenter> dtPresenters = new HashSet<GuidedDecisionTableView.Presenter>((GuidedDecisionTableView.Presenter)dtPresenter2, (GuidedDecisionTableView.Presenter)dtPresenter3){
            final /* synthetic */ GuidedDecisionTableView.Presenter val$dtPresenter2;
            final /* synthetic */ GuidedDecisionTableView.Presenter val$dtPresenter3;
            {
                this.val$dtPresenter2 = presenter;
                this.val$dtPresenter3 = presenter2;
                this.add(GuidedDecisionTablePresenterTest.this.dtPresenter);
                this.add(this.val$dtPresenter2);
                this.add(this.val$dtPresenter3);
            }
        };
        Mockito.when((Object)this.dtPresenter.getModel()).thenReturn((Object)this.model1);
        Mockito.when((Object)dtPresenter2.getModel()).thenReturn((Object)this.model2);
        Mockito.when((Object)dtPresenter3.getModel()).thenReturn((Object)this.model3);
        Mockito.when((Object)dtPresenter2.getView()).thenReturn((Object)dtView2);
        Mockito.when((Object)dtPresenter3.getView()).thenReturn((Object)dtView3);
        Mockito.when((Object)this.view.getModel()).thenReturn((Object)uiModel1);
        Mockito.when((Object)dtView2.getModel()).thenReturn((Object)uiModel2);
        Mockito.when((Object)dtView3.getModel()).thenReturn((Object)uiModel3);
        Mockito.when((Object)uiModel1.getColumns()).thenReturn((Object)this.uiModel1Columns);
        Mockito.when((Object)uiModel2.getColumns()).thenReturn((Object)this.uiModel2Columns);
        Mockito.when((Object)uiModel3.getColumns()).thenReturn((Object)this.uiModel3Columns);
        Mockito.when(this.uiModel1Columns.get(Mockito.anyInt())).thenReturn((Object)this.uiModel1MockColumn);
        Mockito.when(this.uiModel2Columns.get(Mockito.anyInt())).thenReturn((Object)this.uiModel2MockColumn);
        Mockito.when(this.uiModel3Columns.get(Mockito.anyInt())).thenReturn((Object)this.uiModel3MockColumn);
        this.dtPresenter.link((Set)dtPresenters);
        dtPresenter2.link((Set)dtPresenters);
        dtPresenter3.link((Set)dtPresenters);
    }

    private void addConstraintToModel(GuidedDecisionTable52 model, String factType, String fieldName) {
        Pattern52 p = new Pattern52();
        p.setFactType(factType);
        ConditionCol52 c = new ConditionCol52();
        c.setOperator("==");
        c.setFactField(fieldName);
        c.setFieldType("String");
        p.getChildColumns().add(c);
        model.getConditions().add(p);
    }

    private void addActionInsertFactToModel(GuidedDecisionTable52 model, String factType, String fieldName) {
        ActionInsertFactCol52 aif = new ActionInsertFactCol52();
        aif.setFactType(factType);
        aif.setFactField(fieldName);
        model.getActionCols().add(aif);
    }

    private void addBrlInsertActionToModel(GuidedDecisionTable52 model, String factType, String field) {
        BRLActionColumn brlAction = new BRLActionColumn();
        ActionInsertFact aif = new ActionInsertFact(factType);
        ActionFieldValue afv = new ActionFieldValue(field, "$var", "String");
        afv.setNature(2);
        aif.addFieldValue(afv);
        brlAction.setDefinition(Collections.singletonList(aif));
        BRLActionVariableColumn variableColumn = new BRLActionVariableColumn("$var", "String", factType, field);
        brlAction.getChildColumns().add(variableColumn);
        model.getActionCols().add(brlAction);
    }

    private void addBrlConstraintToModel(GuidedDecisionTable52 model, String factType, String field) {
        Pattern52 p = new Pattern52();
        p.setFactType(factType);
        BRLConditionColumn conditionColumn = new BRLConditionColumn();
        conditionColumn.setFactField(field);
        p.getChildColumns().add(conditionColumn);
        model.getConditions().add(p);
    }

    @Test
    public void onClose() {
        Mockito.reset((Object[])new Object[]{this.dtPresenter, this.lockManager});
        this.dtPresenter.onClose();
        ((GuidedDecisionTablePresenter)Mockito.verify((Object)this.dtPresenter, (VerificationMode)Mockito.times((int)1))).terminateAnalysis();
        ((GuidedDecisionTableLockManager)Mockito.verify((Object)this.lockManager, (VerificationMode)Mockito.times((int)1))).releaseLock();
        ((AsyncPackageDataModelOracleFactory)Mockito.verify((Object)this.oracleFactory, (VerificationMode)Mockito.times((int)1))).destroy((AsyncPackageDataModelOracle)Mockito.eq((Object)this.oracle));
    }

    @Test
    public void select() {
        this.dtPresenter.select((GridWidget)this.dtPresenter.getView());
        ((Event)Mockito.verify((Object)this.decisionTableSelectedEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(DecisionTableSelectedEvent.class));
        ((GuidedDecisionTableLockManager)Mockito.verify((Object)this.lockManager, (VerificationMode)Mockito.times((int)4))).acquireLock();
    }

    @Test
    public void selectLinkedColumn() {
        GridColumn uiColumn = (GridColumn)Mockito.mock(GridColumn.class);
        this.dtPresenter.selectLinkedColumn(uiColumn);
        ((Event)Mockito.verify((Object)this.decisionTableColumnSelectedEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(DecisionTableColumnSelectedEvent.class));
    }

    @Test
    public void getPackageParentRuleNames() {
        HashSet<String> parentRuleNames = new HashSet<String>();
        parentRuleNames.add("parentRule1");
        parentRuleNames.add("parentRule2");
        ParameterizedCommand parentRuleNamesCommand = (ParameterizedCommand)Mockito.mock(ParameterizedCommand.class);
        Mockito.when((Object)this.ruleNameService.getRuleNames((Path)Mockito.any(), (String)Mockito.any())).thenReturn(parentRuleNames);
        this.dtPresenter.getPackageParentRuleNames(parentRuleNamesCommand);
        ((ParameterizedCommand)Mockito.verify((Object)parentRuleNamesCommand, (VerificationMode)Mockito.times((int)1))).execute(Mockito.eq(parentRuleNames));
    }

    @Test
    public void hasColumnDefinitionsEmptyModel() {
        Assert.assertFalse((boolean)this.dtPresenter.hasColumnDefinitions());
    }

    @Test
    public void hasColumnDefinitionsWithAttributeColumn() {
        AttributeCol52 attribute = new AttributeCol52();
        attribute.setAttribute(Attribute.SALIENCE.getAttributeName());
        this.dtPresenter.getModel().getAttributeCols().add(attribute);
        Assert.assertTrue((boolean)this.dtPresenter.hasColumnDefinitions());
    }

    @Test
    public void hasColumnDefinitionsWithConditionColumn() {
        Pattern52 pattern = new Pattern52();
        pattern.setFactType("FactType");
        ConditionCol52 condition = new ConditionCol52();
        condition.setFactField("field");
        pattern.getChildColumns().add(condition);
        this.dtPresenter.getModel().getConditions().add(pattern);
        Assert.assertTrue((boolean)this.dtPresenter.hasColumnDefinitions());
    }

    @Test
    public void hasColumnDefinitionsWithMetadataColumn() {
        MetadataCol52 metadataCol52 = new MetadataCol52();
        this.dtPresenter.getModel().getMetadataCols().add(metadataCol52);
        Assert.assertTrue((boolean)this.dtPresenter.hasColumnDefinitions());
    }

    @Test
    public void hasColumnDefinitionsWithActionColumn() {
        ActionInsertFactCol52 action = new ActionInsertFactCol52();
        action.setFactType("FactType");
        action.setFactField("field");
        this.dtPresenter.getModel().getActionCols().add(action);
        Assert.assertTrue((boolean)this.dtPresenter.hasColumnDefinitions());
    }

    @Test
    public void getBindingsWithSimpleClassName() {
        Pattern52 pattern1 = new Pattern52();
        pattern1.setFactType("FactType1");
        pattern1.setBoundName("$fact1");
        ConditionCol52 condition1 = new ConditionCol52();
        condition1.setFactField("field");
        condition1.setBinding("$field1");
        pattern1.getChildColumns().add(condition1);
        Pattern52 pattern2 = new Pattern52();
        pattern2.setFactType("FactType1");
        ConditionCol52 condition2 = new ConditionCol52();
        condition2.setFactField("field");
        pattern2.getChildColumns().add(condition2);
        Mockito.when((Object)this.oracle.getFieldClassName((String)Mockito.eq((Object)"FactType1"), (String)Mockito.eq((Object)"field"))).thenReturn((Object)"FactType1");
        this.dtPresenter.getModel().getConditions().add(pattern1);
        this.dtPresenter.getModel().getConditions().add(pattern2);
        Set bindings = this.dtPresenter.getBindings("FactType1");
        Assert.assertNotNull((Object)bindings);
        Assert.assertEquals((long)2L, (long)bindings.size());
        Assert.assertTrue((boolean)bindings.contains("$fact1"));
        Assert.assertTrue((boolean)bindings.contains("$field1"));
    }

    @Test
    public void getBindingsWithFullyQualifiedClassName() {
        Pattern52 pattern1 = new Pattern52();
        pattern1.setFactType("FactType1");
        pattern1.setBoundName("$fact1");
        ConditionCol52 condition1 = new ConditionCol52();
        condition1.setFactField("field");
        condition1.setBinding("$field1");
        pattern1.getChildColumns().add(condition1);
        Pattern52 pattern2 = new Pattern52();
        pattern2.setFactType("FactType1");
        ConditionCol52 condition2 = new ConditionCol52();
        condition2.setFactField("field");
        pattern2.getChildColumns().add(condition2);
        Mockito.when((Object)this.oracle.getFieldClassName((String)Mockito.eq((Object)"FactType1"), (String)Mockito.eq((Object)"field"))).thenReturn((Object)"FactType1");
        this.dtPresenter.getModel().getConditions().add(pattern1);
        this.dtPresenter.getModel().getConditions().add(pattern2);
        Set bindings = this.dtPresenter.getBindings("org.drools.workbench.screens.guided.dtable.client.widget.table.FactType1");
        Assert.assertNotNull((Object)bindings);
        Assert.assertEquals((long)1L, (long)bindings.size());
        Assert.assertTrue((boolean)bindings.contains("$fact1"));
    }

    @Test
    public void getValueListLookups() {
        AttributeCol52 attribute = new AttributeCol52();
        attribute.setAttribute(Attribute.ENABLED.getAttributeName());
        Map valueList = this.dtPresenter.getValueListLookups((BaseColumn)attribute);
        Assert.assertNotNull((Object)valueList);
        Assert.assertEquals((long)2L, (long)valueList.size());
        Assert.assertTrue((boolean)valueList.containsKey("true"));
        Assert.assertTrue((boolean)valueList.containsKey("false"));
    }

    @Test
    public void getEnumLookupsWithNoEnumsDefined() {
        DependentEnumsUtilities.Context context = (DependentEnumsUtilities.Context)Mockito.mock(DependentEnumsUtilities.Context.class);
        Callback callback = (Callback)Mockito.mock(Callback.class);
        this.dtPresenter.getEnumLookups("FactType", "field", context, callback);
        ((Callback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).callback(this.callbackValueCaptor.capture());
        Map callbackValue = (Map)this.callbackValueCaptor.getValue();
        Assert.assertNotNull((Object)callbackValue);
        Assert.assertTrue((boolean)callbackValue.isEmpty());
    }

    @Test
    public void getEnumLookupsWithFixedListDefinition() {
        DependentEnumsUtilities.Context context = (DependentEnumsUtilities.Context)Mockito.mock(DependentEnumsUtilities.Context.class);
        Callback callback = (Callback)Mockito.mock(Callback.class);
        DropDownData dd = DropDownData.create((String[])new String[]{"one", "two"});
        Mockito.when((Object)this.oracle.getEnums((String)Mockito.eq((Object)"FactType"), (String)Mockito.eq((Object)"field"), (Map)Mockito.any(Map.class))).thenReturn((Object)dd);
        this.dtPresenter.getEnumLookups("FactType", "field", context, callback);
        ((Callback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).callback(this.callbackValueCaptor.capture());
        Map callbackValue = (Map)this.callbackValueCaptor.getValue();
        Assert.assertNotNull((Object)callbackValue);
        Assert.assertFalse((boolean)callbackValue.isEmpty());
        Assert.assertTrue((boolean)callbackValue.containsKey("one"));
        Assert.assertTrue((boolean)callbackValue.containsKey("two"));
    }

    @Test
    public void getEnumLookupsWithFixedListDefinitionWithSplitter() {
        DependentEnumsUtilities.Context context = (DependentEnumsUtilities.Context)Mockito.mock(DependentEnumsUtilities.Context.class);
        Callback callback = (Callback)Mockito.mock(Callback.class);
        DropDownData dd = DropDownData.create((String[])new String[]{"1=one", "2=two"});
        Mockito.when((Object)this.oracle.getEnums((String)Mockito.eq((Object)"FactType"), (String)Mockito.eq((Object)"field"), (Map)Mockito.any(Map.class))).thenReturn((Object)dd);
        this.dtPresenter.getEnumLookups("FactType", "field", context, callback);
        ((Callback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).callback(this.callbackValueCaptor.capture());
        Map callbackValue = (Map)this.callbackValueCaptor.getValue();
        Assert.assertNotNull((Object)callbackValue);
        Assert.assertFalse((boolean)callbackValue.isEmpty());
        Assert.assertTrue((boolean)callbackValue.containsKey("1"));
        Assert.assertTrue((boolean)callbackValue.containsKey("2"));
        Assert.assertEquals((Object)"one", callbackValue.get("1"));
        Assert.assertEquals((Object)"two", callbackValue.get("2"));
    }

    @Test
    public void getEnumLookupsWithQueryExpressionDefinition() {
        DependentEnumsUtilities.Context context = (DependentEnumsUtilities.Context)Mockito.mock(DependentEnumsUtilities.Context.class);
        Callback callback = (Callback)Mockito.mock(Callback.class);
        DropDownData dd = DropDownData.create((String)"query", (String[])new String[]{"one", "two"});
        Mockito.when((Object)this.oracle.getEnums((String)Mockito.eq((Object)"FactType"), (String)Mockito.eq((Object)"field"), (Map)Mockito.any(Map.class))).thenReturn((Object)dd);
        Mockito.when((Object)this.enumDropdownService.loadDropDownExpression((Path)Mockito.any(Path.class), (String[])Mockito.any(String[].class), (String)Mockito.any(String.class))).thenReturn((Object)new String[]{"three", "four"});
        this.dtPresenter.getEnumLookups("FactType", "field", context, callback);
        ((Callback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).callback(this.callbackValueCaptor.capture());
        Map callbackValue = (Map)this.callbackValueCaptor.getValue();
        Assert.assertNotNull((Object)callbackValue);
        Assert.assertFalse((boolean)callbackValue.isEmpty());
        Assert.assertTrue((boolean)callbackValue.containsKey("three"));
        Assert.assertTrue((boolean)callbackValue.containsKey("four"));
    }

    @Test
    public void editConditionWithPatternAndCondition() {
        this.dtPresenter.editCondition((Pattern52)Mockito.mock(Pattern52.class), (ConditionCol52)Mockito.mock(ConditionCol52.class));
    }

    @Test
    public void appendPatternAndConditionColumn() throws ModelSynchronizer.VetoException {
        Mockito.reset((Object[])new GuidedDecisionTableModellerPresenter[]{this.modellerPresenter});
        Pattern52 pattern = new Pattern52();
        pattern.setFactType("FactType");
        ConditionCol52 condition = new ConditionCol52();
        condition.setFactField("field");
        condition.setHeader("header");
        this.dtPresenter.appendColumn(pattern, condition);
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.times((int)1))).appendColumn((Pattern52)Mockito.eq((Object)pattern), (ConditionCol52)Mockito.eq((Object)condition));
        ((Event)Mockito.verify((Object)this.refreshConditionsPanelEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(RefreshConditionsPanelEvent.class));
        ((GuidedDecisionTableModellerPresenter)Mockito.verify((Object)this.modellerPresenter, (VerificationMode)Mockito.times((int)1))).updateLinks();
    }

    @Test
    public void appendConditionColumn() throws ModelSynchronizer.VetoException {
        Mockito.reset((Object[])new GuidedDecisionTableModellerPresenter[]{this.modellerPresenter});
        ConditionCol52 condition = new ConditionCol52();
        condition.setFactField("field");
        condition.setHeader("header");
        this.dtPresenter.appendColumn(condition);
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.times((int)1))).appendColumn((BaseColumn)Mockito.eq((Object)condition));
        ((Event)Mockito.verify((Object)this.refreshConditionsPanelEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(RefreshConditionsPanelEvent.class));
        ((GuidedDecisionTableModellerPresenter)Mockito.verify((Object)this.modellerPresenter, (VerificationMode)Mockito.times((int)1))).updateLinks();
    }

    @Test
    public void appendActionColumn() throws ModelSynchronizer.VetoException {
        Mockito.reset((Object[])new GuidedDecisionTableModellerPresenter[]{this.modellerPresenter});
        ActionInsertFactCol52 action = new ActionInsertFactCol52();
        action.setFactType("FactType");
        action.setFactField("field");
        action.setHeader("header");
        Mockito.when((Object)this.oracle.getFieldType((String)Mockito.eq((Object)"FactType"), (String)Mockito.eq((Object)"field"))).thenReturn((Object)"String");
        this.dtPresenter.appendColumn((ActionCol52)action);
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.times((int)1))).appendColumn((BaseColumn)Mockito.eq((Object)action));
        ((Event)Mockito.verify((Object)this.refreshActionsPanelEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(RefreshActionsPanelEvent.class));
        ((GuidedDecisionTableModellerPresenter)Mockito.verify((Object)this.modellerPresenter, (VerificationMode)Mockito.times((int)1))).updateLinks();
    }

    @Test
    public void appendRow() throws ModelSynchronizer.VetoException {
        Mockito.reset((Object[])new Object[]{this.synchronizer, this.modellerPresenter});
        this.dtPresenter.onAppendRow();
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.times((int)1))).appendRow();
        ((GuidedDecisionTableModellerPresenter)Mockito.verify((Object)this.modellerPresenter, (VerificationMode)Mockito.times((int)1))).updateLinks();
        ((GuidedDecisionTableLockManager)Mockito.verify((Object)this.lockManager, (VerificationMode)Mockito.times((int)4))).acquireLock();
    }

    @Test
    public void deleteConditionColumn() throws ModelSynchronizer.VetoException {
        Pattern52 pattern = new Pattern52();
        pattern.setFactType("FactType");
        ConditionCol52 condition = new ConditionCol52();
        condition.setFactField("field");
        condition.setHeader("header");
        this.dtPresenter.appendColumn(pattern, condition);
        Mockito.reset((Object[])new GuidedDecisionTableModellerPresenter[]{this.modellerPresenter});
        this.dtPresenter.deleteColumn(condition);
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.times((int)1))).deleteColumn((BaseColumn)Mockito.eq((Object)condition));
        ((GuidedDecisionTableModellerPresenter)Mockito.verify((Object)this.modellerPresenter, (VerificationMode)Mockito.times((int)1))).updateLinks();
        this.checkDTSelectionsChangedEventFired(1);
    }

    @Test
    public void deleteActionColumn() throws ModelSynchronizer.VetoException {
        ActionInsertFactCol52 column = new ActionInsertFactCol52();
        column.setFactType("FactType");
        column.setFactField("field");
        column.setHeader("header");
        Mockito.when((Object)this.oracle.getFieldType((String)Mockito.eq((Object)"FactType"), (String)Mockito.eq((Object)"field"))).thenReturn((Object)"String");
        this.dtPresenter.appendColumn((ActionCol52)column);
        Mockito.reset((Object[])new GuidedDecisionTableModellerPresenter[]{this.modellerPresenter});
        this.dtPresenter.deleteColumn((ActionCol52)column);
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.times((int)1))).deleteColumn((BaseColumn)Mockito.eq((Object)column));
        ((GuidedDecisionTableModellerPresenter)Mockito.verify((Object)this.modellerPresenter, (VerificationMode)Mockito.times((int)1))).updateLinks();
        this.checkDTSelectionsChangedEventFired(1);
    }

    @Test
    public void deleteAttributeColumn() throws Exception {
        AttributeCol52 column = new AttributeCol52();
        column.setAttribute(Attribute.SALIENCE.getAttributeName());
        this.dtPresenter.appendColumn(column);
        Mockito.reset((Object[])new GuidedDecisionTableModellerPresenter[]{this.modellerPresenter});
        this.dtPresenter.deleteColumn(column);
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.times((int)1))).deleteColumn((BaseColumn)Mockito.eq((Object)column));
        ((GuidedDecisionTableModellerPresenter)Mockito.verify((Object)this.modellerPresenter, (VerificationMode)Mockito.times((int)1))).updateLinks();
        ((Event)Mockito.verify((Object)this.refreshAttributesPanelEvent, (VerificationMode)Mockito.times((int)2))).fire(Mockito.any(RefreshAttributesPanelEvent.class));
        this.checkDTSelectionsChangedEventFired(1);
    }

    @Test
    public void updatePatternAndConditionColumn() throws ModelSynchronizer.VetoException {
        Pattern52 pattern = new Pattern52();
        pattern.setFactType("FactType");
        pattern.setBoundName("$f");
        ConditionCol52 condition = new ConditionCol52();
        condition.setFactField("field");
        condition.setHeader("header");
        this.dtPresenter.appendColumn(pattern, condition);
        Mockito.reset((Object[])new GuidedDecisionTableModellerPresenter[]{this.modellerPresenter});
        Pattern52 updatePattern = new Pattern52();
        updatePattern.setFactType("NewType");
        updatePattern.setBoundName("$f");
        ConditionCol52 updateCondition = new ConditionCol52();
        updateCondition.setFactField("newField");
        updateCondition.setHeader("newHeader");
        this.dtPresenter.updateColumn(pattern, condition, updatePattern, updateCondition);
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.times((int)1))).updateColumn((Pattern52)Mockito.eq((Object)pattern), (ConditionCol52)Mockito.eq((Object)condition), (Pattern52)Mockito.eq((Object)updatePattern), (ConditionCol52)Mockito.eq((Object)updateCondition));
        ((GuidedDecisionTableModellerPresenter)Mockito.verify((Object)this.modellerPresenter, (VerificationMode)Mockito.times((int)1))).updateLinks();
    }

    @Test
    public void updateConditionColumn() throws ModelSynchronizer.VetoException {
        Pattern52 pattern = new Pattern52();
        pattern.setFactType("FactType");
        ConditionCol52 condition = new ConditionCol52();
        condition.setFactField("field");
        condition.setHeader("header");
        this.dtPresenter.appendColumn(pattern, condition);
        Mockito.reset((Object[])new GuidedDecisionTableModellerPresenter[]{this.modellerPresenter});
        ConditionCol52 updateCondition = new ConditionCol52();
        updateCondition.setFactField("newField");
        updateCondition.setHeader("newHeader");
        this.dtPresenter.updateColumn(condition, updateCondition);
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.times((int)1))).updateColumn((BaseColumn)Mockito.eq((Object)condition), (BaseColumn)Mockito.eq((Object)updateCondition));
        ((GuidedDecisionTableModellerPresenter)Mockito.verify((Object)this.modellerPresenter, (VerificationMode)Mockito.times((int)1))).updateLinks();
    }

    @Test
    public void updateActionColumn() throws ModelSynchronizer.VetoException {
        ActionInsertFactCol52 column = new ActionInsertFactCol52();
        column.setFactType("FactType");
        column.setFactField("field");
        column.setHeader("header");
        Mockito.when((Object)this.oracle.getFieldType((String)Mockito.eq((Object)"FactType"), (String)Mockito.eq((Object)"field"))).thenReturn((Object)"String");
        this.dtPresenter.appendColumn((ActionCol52)column);
        Mockito.reset((Object[])new GuidedDecisionTableModellerPresenter[]{this.modellerPresenter});
        ActionInsertFactCol52 update = new ActionInsertFactCol52();
        update.setFactType("NewType");
        update.setFactField("newField");
        update.setHeader("newHeader");
        Mockito.when((Object)this.oracle.getFieldType((String)Mockito.eq((Object)"NewType"), (String)Mockito.eq((Object)"newField"))).thenReturn((Object)"String");
        this.dtPresenter.updateColumn((ActionCol52)column, (ActionCol52)update);
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.times((int)1))).updateColumn((BaseColumn)Mockito.eq((Object)column), (BaseColumn)Mockito.eq((Object)update));
        ((GuidedDecisionTableModellerPresenter)Mockito.verify((Object)this.modellerPresenter, (VerificationMode)Mockito.times((int)1))).updateLinks();
    }

    @Test
    public void onCutWithSelection() {
        this.dtPresenter.getUiModel().selectCell(0, 0);
        this.dtPresenter.onCut();
        ((Clipboard)Mockito.verify((Object)this.clipboard, (VerificationMode)Mockito.times((int)1))).setData((Set)Mockito.any(Set.class));
        ((GuidedDecisionTableLockManager)Mockito.verify((Object)this.lockManager, (VerificationMode)Mockito.times((int)4))).acquireLock();
    }

    @Test
    public void onCutWithoutSelection() {
        this.dtPresenter.onCut();
        ((Clipboard)Mockito.verify((Object)this.clipboard, (VerificationMode)Mockito.never())).setData((Set)Mockito.any(Set.class));
    }

    @Test
    public void onCopyWithSelection() {
        this.dtPresenter.getUiModel().selectCell(0, 0);
        this.dtPresenter.onCopy();
        ((Clipboard)Mockito.verify((Object)this.clipboard, (VerificationMode)Mockito.times((int)1))).setData((Set)Mockito.any(Set.class));
        ((GuidedDecisionTableLockManager)Mockito.verify((Object)this.lockManager, (VerificationMode)Mockito.times((int)4))).acquireLock();
    }

    @Test
    public void onCopyWithoutSelection() {
        this.dtPresenter.onCopy();
        ((Clipboard)Mockito.verify((Object)this.clipboard, (VerificationMode)Mockito.never())).setData((Set)Mockito.any(Set.class));
    }

    @Test
    public void onPasteWithClipboardDataWithSelection() {
        this.dtPresenter.getUiModel().selectCell(0, 0);
        this.dtPresenter.onCopy();
        this.dtPresenter.getUiModel().selectCell(1, 0);
        this.dtPresenter.onPaste();
        ((Clipboard)Mockito.verify((Object)this.clipboard, (VerificationMode)Mockito.times((int)1))).getData();
        ((GuidedDecisionTableLockManager)Mockito.verify((Object)this.lockManager, (VerificationMode)Mockito.times((int)5))).acquireLock();
    }

    @Test
    public void onPasteWithClipboardDataWithoutSelection() {
        this.dtPresenter.onPaste();
        ((Clipboard)Mockito.verify((Object)this.clipboard, (VerificationMode)Mockito.never())).getData();
    }

    @Test
    public void onDeleteSelectedCellsWithSelection() {
        GridData uiModel = this.dtPresenter.getUiModel();
        uiModel.selectCell(0, 1);
        ArgumentCaptor columnIndexCaptor = ArgumentCaptor.forClass(Integer.class);
        ArgumentCaptor rowRangeCaptor = ArgumentCaptor.forClass(GridData.Range.class);
        this.dtPresenter.onDeleteSelectedCells();
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.times((int)1))).deleteCell((GridData.Range)rowRangeCaptor.capture(), ((Integer)columnIndexCaptor.capture()).intValue());
        ((GuidedDecisionTableLockManager)Mockito.verify((Object)this.lockManager, (VerificationMode)Mockito.times((int)4))).acquireLock();
        this.checkDTSelectionsChangedEventFired(2);
        Integer columnIndex = (Integer)columnIndexCaptor.getValue();
        GridData.Range rowRange = (GridData.Range)rowRangeCaptor.getValue();
        Assert.assertEquals((long)0L, (long)rowRange.getMinRowIndex());
        Assert.assertEquals((long)0L, (long)rowRange.getMaxRowIndex());
        Assert.assertEquals((long)1L, (long)columnIndex.intValue());
    }

    @Test
    public void onDeleteSelectedCellsWithSelectionWithBooleanColumn() {
        AttributeCol52 column = new AttributeCol52(){
            {
                this.setAttribute(Attribute.ENABLED.getAttributeName());
            }
        };
        this.dtPresenter.appendColumn(column);
        GridData uiModel = this.dtPresenter.getUiModel();
        uiModel.selectCell(0, 3);
        this.dtPresenter.onDeleteSelectedCells();
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.never())).deleteCell((GridData.Range)Mockito.any(GridData.Range.class), ((Integer)Mockito.any(Integer.class)).intValue());
        ((GuidedDecisionTableLockManager)Mockito.verify((Object)this.lockManager, (VerificationMode)Mockito.times((int)4))).acquireLock();
        this.checkDTSelectionsChangedEventFired(1);
    }

    @Test
    public void onDeleteSelectedCellsWithSelectionsWithBooleanColumn() {
        AttributeCol52 column = new AttributeCol52(){
            {
                this.setAttribute(Attribute.ENABLED.getAttributeName());
            }
        };
        this.dtPresenter.appendColumn(column);
        GridData uiModel = this.dtPresenter.getUiModel();
        uiModel.selectCell(0, 2);
        uiModel.selectCell(0, 3);
        ArgumentCaptor columnIndexCaptor = ArgumentCaptor.forClass(Integer.class);
        ArgumentCaptor rowRangeCaptor = ArgumentCaptor.forClass(GridData.Range.class);
        this.dtPresenter.onDeleteSelectedCells();
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.times((int)1))).deleteCell((GridData.Range)rowRangeCaptor.capture(), ((Integer)columnIndexCaptor.capture()).intValue());
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.never())).deleteCell((GridData.Range)Mockito.any(GridData.Range.class), Mockito.eq((int)3));
        ((GuidedDecisionTableLockManager)Mockito.verify((Object)this.lockManager, (VerificationMode)Mockito.times((int)5))).acquireLock();
        this.checkDTSelectionsChangedEventFired(3);
        GridCell booleanCell = uiModel.getCell(0, 3);
        Assert.assertNotNull((Object)booleanCell);
        Assert.assertFalse((boolean)((Boolean)booleanCell.getValue().getValue()));
        Integer columnIndex = (Integer)columnIndexCaptor.getValue();
        GridData.Range rowRange = (GridData.Range)rowRangeCaptor.getValue();
        Assert.assertEquals((long)0L, (long)rowRange.getMinRowIndex());
        Assert.assertEquals((long)0L, (long)rowRange.getMaxRowIndex());
        Assert.assertEquals((long)2L, (long)columnIndex.intValue());
    }

    @Test
    public void onDeleteSelectedCellsWithoutSelections() {
        this.dtPresenter.onDeleteSelectedCells();
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.never())).deleteCell((GridData.Range)Mockito.any(GridData.Range.class), ((Integer)Mockito.any(Integer.class)).intValue());
    }

    @Test
    public void onDeleteSelectedColumnsWithSelections() throws ModelSynchronizer.VetoException {
        AttributeCol52 column = new AttributeCol52(){
            {
                this.setAttribute(Attribute.SALIENCE.getAttributeName());
            }
        };
        this.dtPresenter.appendColumn(column);
        GridData uiModel = this.dtPresenter.getUiModel();
        uiModel.selectCell(0, 3);
        this.dtPresenter.onDeleteSelectedColumns();
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.times((int)1))).deleteColumn((BaseColumn)Mockito.eq((Object)column));
        ((GuidedDecisionTableLockManager)Mockito.verify((Object)this.lockManager, (VerificationMode)Mockito.times((int)4))).acquireLock();
        this.checkDTSelectionsChangedEventFired(2);
    }

    @Test
    public void onDeleteSelectedColumnsWithoutSelections() throws ModelSynchronizer.VetoException {
        this.dtPresenter.onDeleteSelectedColumns();
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.never())).deleteColumn((BaseColumn)Mockito.any(BaseColumn.class));
    }

    @Test
    public void onDeleteSelectedRowsWithSelections() throws ModelSynchronizer.VetoException {
        GridData uiModel = this.dtPresenter.getUiModel();
        uiModel.selectCell(0, 0);
        uiModel.selectCell(2, 0);
        this.dtPresenter.onDeleteSelectedRows();
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.times((int)1))).deleteRow(Mockito.eq((int)0));
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.times((int)1))).deleteRow(Mockito.eq((int)1));
        this.checkDTSelectionsChangedEventFired(4);
        ((GuidedDecisionTableLockManager)Mockito.verify((Object)this.lockManager, (VerificationMode)Mockito.times((int)5))).acquireLock();
    }

    @Test
    public void onDeleteSelectedRowsWithNoSelections() throws ModelSynchronizer.VetoException {
        this.dtPresenter.onDeleteSelectedRows();
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.never())).deleteRow(((Integer)Mockito.any(Integer.class)).intValue());
    }

    @Test
    public void onInsertRowAboveNoRowSelected() throws ModelSynchronizer.VetoException {
        this.dtPresenter.onInsertRowAbove();
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.never())).insertRow(((Integer)Mockito.any(Integer.class)).intValue());
    }

    @Test
    public void onInsertRowAboveSingleRowSelected() throws ModelSynchronizer.VetoException {
        GridData uiModel = this.dtPresenter.getUiModel();
        uiModel.selectCell(0, 0);
        this.dtPresenter.onInsertRowAbove();
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.times((int)1))).insertRow(Mockito.eq((int)0));
        ((GuidedDecisionTableLockManager)Mockito.verify((Object)this.lockManager, (VerificationMode)Mockito.times((int)4))).acquireLock();
    }

    @Test
    public void onInsertRowAboveMultipleRowsSelected() throws ModelSynchronizer.VetoException {
        GridData uiModel = this.dtPresenter.getUiModel();
        uiModel.selectCell(0, 0);
        uiModel.selectCell(1, 0);
        this.dtPresenter.onInsertRowAbove();
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.never())).insertRow(((Integer)Mockito.any(Integer.class)).intValue());
        ((GuidedDecisionTableLockManager)Mockito.verify((Object)this.lockManager, (VerificationMode)Mockito.times((int)5))).acquireLock();
    }

    @Test
    public void onInsertRowBelowNoRowSelected() throws ModelSynchronizer.VetoException {
        this.dtPresenter.onInsertRowBelow();
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.never())).insertRow(((Integer)Mockito.any(Integer.class)).intValue());
    }

    @Test
    public void onInsertRowBelowSingleRowSelected() throws ModelSynchronizer.VetoException {
        GridData uiModel = this.dtPresenter.getUiModel();
        uiModel.selectCell(0, 0);
        this.dtPresenter.onInsertRowBelow();
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.times((int)1))).insertRow(Mockito.eq((int)1));
        ((GuidedDecisionTableLockManager)Mockito.verify((Object)this.lockManager, (VerificationMode)Mockito.times((int)4))).acquireLock();
    }

    @Test
    public void onInsertRowBelowMultipleRowsSelected() throws ModelSynchronizer.VetoException {
        GridData uiModel = this.dtPresenter.getUiModel();
        uiModel.selectCell(0, 0);
        uiModel.selectCell(1, 0);
        this.dtPresenter.onInsertRowBelow();
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.never())).insertRow(((Integer)Mockito.any(Integer.class)).intValue());
        ((GuidedDecisionTableLockManager)Mockito.verify((Object)this.lockManager, (VerificationMode)Mockito.times((int)5))).acquireLock();
    }

    @Test
    public void onOtherwiseCellNoCellSelected() throws ModelSynchronizer.VetoException {
        this.dtPresenter.onOtherwiseCell();
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.never())).setCellOtherwiseState(((Integer)Mockito.any(Integer.class)).intValue(), ((Integer)Mockito.any(Integer.class)).intValue());
    }

    @Test
    public void onOtherwiseCellSingleCellSelected() throws ModelSynchronizer.VetoException {
        GridData uiModel = this.dtPresenter.getUiModel();
        uiModel.selectCell(0, 0);
        this.dtPresenter.onOtherwiseCell();
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.times((int)1))).setCellOtherwiseState(Mockito.eq((int)0), Mockito.eq((int)0));
        ((GuidedDecisionTableLockManager)Mockito.verify((Object)this.lockManager, (VerificationMode)Mockito.times((int)4))).acquireLock();
    }

    @Test
    public void onOtherwiseCellMultipleCellsSelected() throws ModelSynchronizer.VetoException {
        GridData uiModel = this.dtPresenter.getUiModel();
        uiModel.selectCell(0, 0);
        uiModel.selectCell(1, 0);
        this.dtPresenter.onOtherwiseCell();
        ((ModelSynchronizer)Mockito.verify((Object)this.synchronizer, (VerificationMode)Mockito.never())).setCellOtherwiseState(((Integer)Mockito.any(Integer.class)).intValue(), ((Integer)Mockito.any(Integer.class)).intValue());
        ((GuidedDecisionTableLockManager)Mockito.verify((Object)this.lockManager, (VerificationMode)Mockito.times((int)5))).acquireLock();
    }

    @Test
    public void setMergedTrue() {
        Mockito.reset((Object[])new DefaultGridLayer[]{this.gridLayer});
        this.dtPresenter.setMerged(true);
        Assert.assertTrue((boolean)this.dtPresenter.isMerged());
        ((DefaultGridLayer)Mockito.verify((Object)this.gridLayer, (VerificationMode)Mockito.times((int)1))).draw();
    }

    @Test
    public void setMergedFalse() {
        Mockito.reset((Object[])new DefaultGridLayer[]{this.gridLayer});
        this.dtPresenter.setMerged(false);
        Assert.assertFalse((boolean)this.dtPresenter.isMerged());
        ((DefaultGridLayer)Mockito.verify((Object)this.gridLayer, (VerificationMode)Mockito.times((int)1))).draw();
    }

    @Test
    public void testAddOnEnterPinnedModeCommand() {
        GuidedDecisionTableModellerView.Presenter parent = (GuidedDecisionTableModellerView.Presenter)Mockito.mock(GuidedDecisionTableModellerView.Presenter.class);
        Command command = (Command)Mockito.mock(Command.class);
        ((GuidedDecisionTablePresenter)Mockito.doReturn((Object)parent).when((Object)this.dtPresenter)).getParent();
        this.dtPresenter.addOnEnterPinnedModeCommand(command);
        ((GuidedDecisionTableModellerView.Presenter)Mockito.verify((Object)parent)).addOnEnterPinnedModeCommand(command);
    }

    @Test
    public void testAddOnExitPinnedModeCommand() {
        GuidedDecisionTableModellerView.Presenter parent = (GuidedDecisionTableModellerView.Presenter)Mockito.mock(GuidedDecisionTableModellerView.Presenter.class);
        Command command = (Command)Mockito.mock(Command.class);
        ((GuidedDecisionTablePresenter)Mockito.doReturn((Object)parent).when((Object)this.dtPresenter)).getParent();
        this.dtPresenter.addOnExitPinnedModeCommand(command);
        ((GuidedDecisionTableModellerView.Presenter)Mockito.verify((Object)parent)).addOnExitPinnedModeCommand(command);
    }

    @Test
    public void testRefreshView() {
        GuidedDecisionTableModellerView.Presenter parent = (GuidedDecisionTableModellerView.Presenter)Mockito.mock(GuidedDecisionTableModellerView.Presenter.class);
        Layer layer = (Layer)Mockito.mock(Layer.class);
        ((GuidedDecisionTablePresenter)Mockito.doReturn((Object)parent).when((Object)this.dtPresenter)).getParent();
        ((GuidedDecisionTableView)Mockito.doReturn((Object)layer).when((Object)this.view)).getLayer();
        this.dtPresenter.refreshView();
        ((GuidedDecisionTableModellerView.Presenter)Mockito.verify((Object)parent)).updateLinks();
        ((GuidedDecisionTableModellerView.Presenter)Mockito.verify((Object)parent)).refreshScrollPosition();
        ((Layer)Mockito.verify((Object)layer)).draw();
    }

    @Test
    public void testInitialiseAccessReadOnlyTableWithEditableColumns() {
        this.testInitialiseAccess(true, true);
    }

    @Test
    public void testInitialiseAccessReadOnlyTableWithoutEditableColumns() {
        this.testInitialiseAccess(true, false);
    }

    @Test
    public void testInitialiseAccessEditableTableWithEditableColumns() {
        this.testInitialiseAccess(false, true);
    }

    @Test
    public void testInitialiseAccessEditableTableWithoutEditableColumns() {
        this.testInitialiseAccess(false, false);
    }

    @Test
    public void testCanEditColumns() {
        String permission = "guideddecisiontable.edit.columns";
        User user = (User)Mockito.mock(User.class);
        ((SessionInfo)Mockito.doReturn((Object)user).when((Object)this.sessionInfo)).getIdentity();
        this.dtPresenter.canEditColumns();
        ((AuthorizationManager)Mockito.verify((Object)this.authorizationManager)).authorize("guideddecisiontable.edit.columns", user);
    }

    @Test
    public void testHasEditableColumns() {
        GuidedDecisionTablePresenter.Access access = (GuidedDecisionTablePresenter.Access)Mockito.mock(GuidedDecisionTablePresenter.Access.class);
        ((GuidedDecisionTablePresenter)Mockito.doReturn((Object)access).when((Object)this.dtPresenter)).getAccess();
        ((GuidedDecisionTablePresenter.Access)Mockito.doReturn((Object)true).when((Object)access)).hasEditableColumns();
        boolean hasEditableColumns = this.dtPresenter.hasEditableColumns();
        Assert.assertTrue((boolean)hasEditableColumns);
        ((GuidedDecisionTablePresenter.Access)Mockito.verify((Object)access)).hasEditableColumns();
    }

    @Test
    public void testRefreshColumnsPage() {
        this.dtPresenter.refreshColumnsPage();
        ((Event)Mockito.verify((Object)this.refreshAttributesPanelEvent)).fire(Mockito.any(RefreshAttributesPanelEvent.class));
        ((Event)Mockito.verify((Object)this.refreshMetaDataPanelEvent)).fire(Mockito.any(RefreshMetaDataPanelEvent.class));
        ((Event)Mockito.verify((Object)this.refreshConditionsPanelEvent)).fire(Mockito.any(RefreshConditionsPanelEvent.class));
        ((Event)Mockito.verify((Object)this.refreshActionsPanelEvent)).fire(Mockito.any(RefreshActionsPanelEvent.class));
    }

    @Test
    public void testRefreshMenus() {
        this.dtPresenter.refreshMenus();
        ((Event)Mockito.verify((Object)this.refreshMenusEvent)).fire(Mockito.any(RefreshMenusEvent.class));
    }

    @Test
    public void testOnSearchPerformed() {
        GuidedDecisionTableSearchableElement element = (GuidedDecisionTableSearchableElement)Mockito.mock(GuidedDecisionTableSearchableElement.class);
        Mockito.when((Object)element.getModel()).thenReturn((Object)this.model);
        SearchPerformedEvent event = new SearchPerformedEvent((Searchable)element);
        this.dtPresenter.onSearchPerformed(event);
        ((GuidedDecisionTableRenderer)Mockito.verify((Object)this.renderer, (VerificationMode)Mockito.never())).clearCellHighlight();
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view)).draw();
    }

    @Test
    public void testOnSearchPerformedModelNotFromThisTable() {
        GuidedDecisionTableSearchableElement element = (GuidedDecisionTableSearchableElement)Mockito.mock(GuidedDecisionTableSearchableElement.class);
        GuidedDecisionTable52 anotherModel = (GuidedDecisionTable52)Mockito.mock(GuidedDecisionTable52.class);
        Mockito.when((Object)element.getModel()).thenReturn((Object)anotherModel);
        Mockito.when((Object)element.getColumn()).thenReturn((Object)0);
        Mockito.when((Object)element.getRow()).thenReturn((Object)0);
        SearchPerformedEvent event = new SearchPerformedEvent((Searchable)element);
        this.dtPresenter.onSearchPerformed(event);
        ((GuidedDecisionTableRenderer)Mockito.verify((Object)this.renderer)).clearCellHighlight();
    }

    @Test
    public void testSort() throws ModelSynchronizer.VetoException {
        Mockito.reset((Object[])new DefaultGridLayer[]{this.gridLayer});
        this.dtPresenter.onSort(this.uiModel2MockColumn);
        ((GuidedDecisionTableUiModel)Mockito.verify((Object)this.uiModel)).sort(this.uiModel2MockColumn);
        ((DefaultGridLayer)Mockito.verify((Object)this.gridLayer)).draw();
        ((AnalyzerController)Mockito.verify((Object)this.analyzerController)).sort((List)this.listArgumentCaptor.capture());
        List value = (List)this.listArgumentCaptor.getValue();
        Assertions.assertThat((List)value).containsExactly((Object[])new Integer[]{0, 1, 2});
    }

    @Test
    public void testSortReversely() throws ModelSynchronizer.VetoException {
        Mockito.reset((Object[])new DefaultGridLayer[]{this.gridLayer});
        this.dtPresenter.onSort(this.uiModel2MockColumn);
        Mockito.reset((Object[])new GuidedDecisionTableUiModel[]{this.uiModel});
        Mockito.reset((Object[])new DefaultGridLayer[]{this.gridLayer});
        Mockito.reset((Object[])new AnalyzerController[]{this.analyzerController});
        this.dtPresenter.onSort(this.uiModel2MockColumn);
        ((GuidedDecisionTableUiModel)Mockito.verify((Object)this.uiModel)).sort(this.uiModel2MockColumn);
        ((DefaultGridLayer)Mockito.verify((Object)this.gridLayer)).draw();
        ((AnalyzerController)Mockito.verify((Object)this.analyzerController)).sort((List)this.listArgumentCaptor.capture());
        List value = (List)this.listArgumentCaptor.getValue();
        Assertions.assertThat((List)value).containsExactly((Object[])new Integer[]{2, 1, 0});
    }

    private void checkDTSelectionsChangedEventFired(int times) {
        ArgumentCaptor dtSelectionsChangedEventCaptor = ArgumentCaptor.forClass(DecisionTableSelectionsChangedEvent.class);
        ((Event)Mockito.verify((Object)this.decisionTableSelectionsChangedEvent, (VerificationMode)Mockito.times((int)times))).fire(dtSelectionsChangedEventCaptor.capture());
        List dtSelectionsChangedEvents = dtSelectionsChangedEventCaptor.getAllValues();
        Assert.assertNotNull((Object)dtSelectionsChangedEvents);
        Assert.assertEquals((long)dtSelectionsChangedEvents.size(), (long)times);
        dtSelectionsChangedEvents.stream().map(DecisionTableSelectionsChangedEvent::getPresenter).forEach(p -> Assert.assertEquals((String)"Invalid DecisionTableSelectionsChangedEvent detected.", (Object)p, (Object)this.dtPresenter));
    }

    private void testInitialiseAccess(boolean readOnly, boolean canEditColumns) {
        GuidedDecisionTablePresenter.Access access = (GuidedDecisionTablePresenter.Access)Mockito.mock(GuidedDecisionTablePresenter.Access.class);
        ((GuidedDecisionTablePresenter)Mockito.doReturn((Object)access).when((Object)this.dtPresenter)).getAccess();
        ((GuidedDecisionTablePresenter)Mockito.doReturn((Object)canEditColumns).when((Object)this.dtPresenter)).canEditColumns();
        this.dtPresenter.initialiseAccess(readOnly);
        ((GuidedDecisionTablePresenter.Access)Mockito.verify((Object)access)).setReadOnly(readOnly);
        ((GuidedDecisionTablePresenter.Access)Mockito.verify((Object)access)).setHasEditableColumns(canEditColumns);
    }

    @Override
    protected GuidedDecisionTablePresenter makeGuidedDecisionTablePresenterMock() {
        return new GuidedDecisionTablePresenterMock(this.identity, this.resourceType, (Caller<RuleNamesService>)this.ruleNameServiceCaller, (Event<DecisionTableSelectedEvent>)this.decisionTableSelectedEvent, (Event<DecisionTableColumnSelectedEvent>)this.decisionTableColumnSelectedEvent, (Event<DecisionTableSelectionsChangedEvent>)this.decisionTableSelectionsChangedEvent, (Event<RefreshAttributesPanelEvent>)this.refreshAttributesPanelEvent, (Event<RefreshMetaDataPanelEvent>)this.refreshMetaDataPanelEvent, (Event<RefreshConditionsPanelEvent>)this.refreshConditionsPanelEvent, (Event<RefreshActionsPanelEvent>)this.refreshActionsPanelEvent, (Event<RefreshMenusEvent>)this.refreshMenusEvent, (Event<NotificationEvent>)this.notificationEvent, this.gridWidgetCellFactory, this.gridWidgetColumnFactory, this.oracleFactory, this.synchronizer, this.beanManager, this.lockManager, this.linkManager, this.clipboard, this.decisionTableAnalyzerProvider, this.enumLoaderUtilities, this.pluginHandler, this.authorizationManager, this.sessionInfo);
    }

    class GuidedDecisionTablePresenterMock
    extends BaseGuidedDecisionTablePresenterTest.GuidedDecisionTablePresenterBaseMock {
        public GuidedDecisionTablePresenterMock(User identity, GuidedDTableResourceType resourceType, Caller<RuleNamesService> ruleNameService, Event<DecisionTableSelectedEvent> decisionTableSelectedEvent, Event<DecisionTableColumnSelectedEvent> decisionTableColumnSelectedEvent, Event<DecisionTableSelectionsChangedEvent> decisionTableSelectionsChangedEvent, Event<RefreshAttributesPanelEvent> refreshAttributesPanelEvent, Event<RefreshMetaDataPanelEvent> refreshMetaDataPanelEvent, Event<RefreshConditionsPanelEvent> refreshConditionsPanelEvent, Event<RefreshActionsPanelEvent> refreshActionsPanelEvent, Event<RefreshMenusEvent> refreshMenusEvent, Event<NotificationEvent> notificationEvent, GridWidgetCellFactory gridWidgetCellFactory, GridWidgetColumnFactory gridWidgetColumnFactory, AsyncPackageDataModelOracleFactory oracleFactory, ModelSynchronizer synchronizer, SyncBeanManager beanManager, GuidedDecisionTableLockManager lockManager, GuidedDecisionTableLinkManager linkManager, Clipboard clipboard, DecisionTableAnalyzerProvider decisionTableAnalyzerProvider, EnumLoaderUtilities enumLoaderUtilities, PluginHandler pluginHandler, AuthorizationManager authorizationManager, SessionInfo sessionInfo) {
            super(GuidedDecisionTablePresenterTest.this, identity, resourceType, ruleNameService, decisionTableSelectedEvent, decisionTableColumnSelectedEvent, decisionTableSelectionsChangedEvent, refreshAttributesPanelEvent, refreshMetaDataPanelEvent, refreshConditionsPanelEvent, refreshActionsPanelEvent, refreshMenusEvent, notificationEvent, gridWidgetCellFactory, gridWidgetColumnFactory, oracleFactory, synchronizer, beanManager, lockManager, linkManager, clipboard, decisionTableAnalyzerProvider, enumLoaderUtilities, pluginHandler, authorizationManager, sessionInfo);
        }

        @Override
        GuidedDecisionTableUiModel makeUiModel() {
            GuidedDecisionTablePresenterTest.this.uiModel = (GuidedDecisionTableUiModel)Mockito.spy((Object)super.makeUiModel());
            return GuidedDecisionTablePresenterTest.this.uiModel;
        }
    }
}

