/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTablePresenter;
import org.drools.workbench.screens.guided.dtable.client.widget.table.TableSortComparator;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.IntegerUiColumn;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.StringUiColumn;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.dom.textbox.TextBoxIntegerSingletonDOMElementFactory;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.dom.textbox.TextBoxSingletonDOMElementFactory;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.ModelSynchronizer;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCell;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridColumn;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;

@RunWith(value=MockitoJUnitRunner.class)
public class TableSortComparatorTest {
    private BaseGridColumn integerUiColumn = new IntegerUiColumn(Collections.EMPTY_LIST, 100.0, true, true, (GuidedDecisionTablePresenter.Access)Mockito.mock(GuidedDecisionTablePresenter.Access.class), (TextBoxIntegerSingletonDOMElementFactory)Mockito.mock(TextBoxIntegerSingletonDOMElementFactory.class));
    private BaseGridColumn stringUiColumn = new StringUiColumn(Collections.EMPTY_LIST, 100.0, true, true, (GuidedDecisionTablePresenter.Access)Mockito.mock(GuidedDecisionTablePresenter.Access.class), (TextBoxSingletonDOMElementFactory)Mockito.mock(TextBoxSingletonDOMElementFactory.class));
    private TableSortComparator comparator;
    private List<GridRow> rows = new ArrayList<GridRow>();

    @Before
    public void setUp() throws Exception {
        this.integerUiColumn.setIndex(1);
        this.stringUiColumn.setIndex(2);
        this.comparator = new TableSortComparator();
        BaseGridRowMock a = new BaseGridRowMock();
        a.getCells().put(0, (GridCell<?>)new BaseGridCell((GridCellValue)new BaseGridCellValue((Object)1)));
        a.getCells().put(1, (GridCell<?>)new BaseGridCell((GridCellValue)new BaseGridCellValue((Object)3)));
        a.getCells().put(2, (GridCell<?>)new BaseGridCell((GridCellValue)new BaseGridCellValue((Object)"a")));
        this.rows.add((GridRow)a);
        BaseGridRowMock b = new BaseGridRowMock();
        b.getCells().put(0, (GridCell<?>)new BaseGridCell((GridCellValue)new BaseGridCellValue((Object)2)));
        b.getCells().put(1, (GridCell<?>)new BaseGridCell((GridCellValue)new BaseGridCellValue((Object)100)));
        b.getCells().put(2, (GridCell<?>)new BaseGridCell((GridCellValue)new BaseGridCellValue((Object)"c")));
        this.rows.add((GridRow)b);
        BaseGridRowMock c = new BaseGridRowMock();
        c.getCells().put(0, (GridCell<?>)new BaseGridCell((GridCellValue)new BaseGridCellValue((Object)3)));
        c.getCells().put(1, (GridCell<?>)new BaseGridCell((GridCellValue)new BaseGridCellValue((Object)1)));
        c.getCells().put(2, (GridCell<?>)new BaseGridCell((GridCellValue)new BaseGridCellValue((Object)"b")));
        this.rows.add((GridRow)c);
        BaseGridRowMock d = new BaseGridRowMock();
        d.getCells().put(0, (GridCell<?>)new BaseGridCell((GridCellValue)new BaseGridCellValue((Object)4)));
        d.getCells().put(1, (GridCell<?>)new BaseGridCell((GridCellValue)new BaseGridCellValue((Object)100)));
        d.getCells().put(2, (GridCell<?>)new BaseGridCell((GridCellValue)new BaseGridCellValue((Object)"x")));
        this.rows.add((GridRow)d);
    }

    @Test(expected=ModelSynchronizer.VetoException.class)
    public void testInvalidColumn() throws ModelSynchronizer.VetoException {
        BaseGridRowMock badRow = new BaseGridRowMock();
        badRow.getCells().put(0, (GridCell<?>)new BaseGridCell((GridCellValue)new BaseGridCellValue((Object)4)));
        badRow.getCells().put(1, (GridCell<?>)new BaseGridCell((GridCellValue)new BaseGridCellValue((Object)new NotComparable())));
        badRow.getCells().put(2, (GridCell<?>)new BaseGridCell((GridCellValue)new BaseGridCellValue((Object)"x")));
        this.rows.add((GridRow)badRow);
        this.comparator.sort(this.rows, (GridColumn)this.integerUiColumn);
    }

    @Test
    public void testSortIntegerColumn() throws ModelSynchronizer.VetoException {
        List sort = this.comparator.sort(this.rows, (GridColumn)this.integerUiColumn);
        Assertions.assertThat((List)sort).containsExactly((Object[])new Integer[]{2, 0, 1, 3});
        Assertions.assertThat(this.rows).extracting(row -> (Integer)((GridCell)row.getCells().get(1)).getValue().getValue()).containsExactly((Object[])new Integer[]{1, 3, 100, 100});
    }

    @Test
    public void testSortStringColumn() throws ModelSynchronizer.VetoException {
        List sort = this.comparator.sort(this.rows, (GridColumn)this.stringUiColumn);
        Assertions.assertThat((List)sort).containsExactly((Object[])new Integer[]{0, 2, 1, 3});
        Assertions.assertThat(this.rows).extracting(row -> (String)((GridCell)row.getCells().get(2)).getValue().getValue()).containsExactly((Object[])new String[]{"a", "b", "c", "x"});
    }

    @Test
    public void testSecondSortReversesOrder() throws ModelSynchronizer.VetoException {
        this.comparator.sort(this.rows, (GridColumn)this.stringUiColumn);
        List sort = this.comparator.sort(this.rows, (GridColumn)this.stringUiColumn);
        Assertions.assertThat((List)sort).containsExactly((Object[])new Integer[]{3, 1, 2, 0});
        Assertions.assertThat(this.rows).extracting(row -> (String)((GridCell)row.getCells().get(2)).getValue().getValue()).containsExactly((Object[])new String[]{"x", "c", "b", "a"});
    }

    @Test
    public void testThirdSort() throws ModelSynchronizer.VetoException {
        this.comparator.sort(this.rows, (GridColumn)this.integerUiColumn);
        this.comparator.sort(this.rows, (GridColumn)this.integerUiColumn);
        List sort = this.comparator.sort(this.rows, (GridColumn)this.integerUiColumn);
        Assertions.assertThat((List)sort).containsExactly((Object[])new Integer[]{2, 0, 3, 1});
        Assertions.assertThat(this.rows).extracting(row -> (Integer)((GridCell)row.getCells().get(1)).getValue().getValue()).containsExactly((Object[])new Integer[]{1, 3, 100, 100});
    }

    @Test
    public void testSecondSortOnADifferentColumnGivesLowestToHighestOrder() throws ModelSynchronizer.VetoException {
        this.comparator.sort(this.rows, (GridColumn)this.integerUiColumn);
        List sort = this.comparator.sort(this.rows, (GridColumn)this.stringUiColumn);
        Assertions.assertThat((List)sort).containsExactly((Object[])new Integer[]{0, 2, 1, 3});
        Assertions.assertThat(this.rows).extracting(row -> (String)((GridCell)row.getCells().get(2)).getValue().getValue()).containsExactly((Object[])new String[]{"a", "b", "c", "x"});
    }

    class NotComparable {
        NotComparable() {
        }
    }

    class BaseGridRowMock
    extends BaseGridRow {
        BaseGridRowMock() {
        }

        public Map<Integer, GridCell<?>> getCells() {
            return this.cells;
        }
    }
}

