/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.columns.control;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionRetractFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.resources.GuidedDecisionTableResources;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.GuidedDecisionTableConstants;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.control.ColumnLabelWidget;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.control.ColumnManagementView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.control.DeleteColumnManagementAnchorWidget;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.ModelSynchronizer;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class ColumnManagementViewTest {
    @Mock
    private GuidedDecisionTableModellerView modellerView;
    @Mock
    private GuidedDecisionTableModellerView.Presenter modellerPresenter;
    @Mock
    private GuidedDecisionTableView.Presenter decisionTablePresenter;
    @Mock
    private HorizontalPanel horizontalPanel;
    @Mock
    private DeleteColumnManagementAnchorWidget deleteWidget;
    @Mock
    private ManagedInstance<DeleteColumnManagementAnchorWidget> deleteColumnManagementAnchorWidgets;
    @Captor
    private ArgumentCaptor<ClickHandler> clickHandlerCaptor;
    @Captor
    private ArgumentCaptor<Command> deleteCommandCaptor;
    private ColumnManagementView view;

    @Before
    public void setUp() throws Exception {
        ((ManagedInstance)Mockito.doReturn((Object)this.deleteWidget).when(this.deleteColumnManagementAnchorWidgets)).get();
        this.view = (ColumnManagementView)Mockito.spy((Object)new ColumnManagementView(this.deleteColumnManagementAnchorWidgets));
        this.view.init(this.modellerPresenter);
        ((GuidedDecisionTableModellerView.Presenter)Mockito.doReturn((Object)this.modellerView).when((Object)this.modellerPresenter)).getView();
        ((ColumnManagementView)Mockito.doReturn((Object)this.horizontalPanel).when((Object)this.view)).newHorizontalPanel();
        Mockito.when((Object)this.modellerPresenter.getActiveDecisionTable()).thenReturn(Optional.of(this.decisionTablePresenter));
    }

    private ColumnLabelWidget mockColumnLabelWidget() {
        return (ColumnLabelWidget)Mockito.mock(ColumnLabelWidget.class);
    }

    @Test
    public void testRenderColumnsClearTheView() throws Exception {
        this.view.renderColumns(Collections.emptyMap());
        ((ColumnManagementView)Mockito.verify((Object)this.view)).clear();
    }

    @Test
    public void testRenderColumnPatternEditable() throws Exception {
        final Pattern52 pattern = new Pattern52(){
            {
                this.setBoundName("p");
                this.setFactType("Person");
                this.getChildColumns().add(new ConditionCol52(){
                    {
                        this.setHeader("one");
                    }
                });
                this.getChildColumns().add(new ConditionCol52(){
                    {
                        this.setHeader("two");
                    }
                });
                this.getChildColumns().add(new ConditionCol52(){
                    {
                        this.setHeader("three");
                    }
                });
            }
        };
        HashMap<String, List<BaseColumn>> columnGroups = new HashMap<String, List<BaseColumn>>(){
            {
                this.put("Person [p]", Collections.singletonList(pattern));
            }
        };
        ColumnLabelWidget columnLabel = this.mockColumnLabelWidget();
        ((ColumnManagementView)Mockito.doReturn((Object)columnLabel).when((Object)this.view)).newColumnLabelWidget(Matchers.anyString());
        ((GuidedDecisionTableModellerView.Presenter)Mockito.doReturn((Object)true).when((Object)this.modellerPresenter)).isActiveDecisionTableEditable();
        this.view.renderColumns((Map)columnGroups);
        ((ColumnManagementView)Mockito.verify((Object)this.view)).renderColumn(pattern);
        ((HorizontalPanel)Mockito.verify((Object)this.horizontalPanel, (VerificationMode)Mockito.times((int)3))).add((Widget)columnLabel);
        ((ColumnManagementView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)3))).editAnchor((ClickHandler)this.clickHandlerCaptor.capture());
        ((ColumnManagementView)Mockito.verify((Object)this.view)).deleteAnchor((String)Matchers.eq((Object)"one"), (Command)Matchers.any(Command.class));
        ((ColumnManagementView)Mockito.verify((Object)this.view)).deleteAnchor((String)Matchers.eq((Object)"two"), (Command)Matchers.any(Command.class));
        ((ColumnManagementView)Mockito.verify((Object)this.view)).deleteAnchor((String)Matchers.eq((Object)"three"), (Command)Matchers.any(Command.class));
        ((ClickHandler)this.clickHandlerCaptor.getAllValues().get(0)).onClick((ClickEvent)Mockito.mock(ClickEvent.class));
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)this.decisionTablePresenter)).editCondition((Pattern52)Matchers.eq((Object)pattern), (ConditionCol52)Matchers.eq(pattern.getChildColumns().get(0)));
        ((ClickHandler)this.clickHandlerCaptor.getAllValues().get(1)).onClick((ClickEvent)Mockito.mock(ClickEvent.class));
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)this.decisionTablePresenter)).editCondition((Pattern52)Matchers.eq((Object)pattern), (ConditionCol52)Matchers.eq(pattern.getChildColumns().get(1)));
        ((ClickHandler)this.clickHandlerCaptor.getAllValues().get(2)).onClick((ClickEvent)Mockito.mock(ClickEvent.class));
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)this.decisionTablePresenter)).editCondition((Pattern52)Matchers.eq((Object)pattern), (ConditionCol52)Matchers.eq(pattern.getChildColumns().get(2)));
    }

    @Test
    public void testRenderColumnPatternNotEditable() throws Exception {
        final Pattern52 pattern = new Pattern52(){
            {
                this.setBoundName("p");
                this.setFactType("Person");
                this.getChildColumns().add(new ConditionCol52());
                this.getChildColumns().add(new ConditionCol52());
                this.getChildColumns().add(new ConditionCol52());
            }
        };
        HashMap<String, List<BaseColumn>> columnGroups = new HashMap<String, List<BaseColumn>>(){
            {
                this.put("Person [p]", Collections.singletonList(pattern));
            }
        };
        ColumnLabelWidget columnLabel = this.mockColumnLabelWidget();
        ((ColumnManagementView)Mockito.doReturn((Object)columnLabel).when((Object)this.view)).newColumnLabelWidget(Matchers.anyString());
        this.view.renderColumns((Map)columnGroups);
        ((ColumnManagementView)Mockito.verify((Object)this.view)).renderColumn(pattern);
        ((HorizontalPanel)Mockito.verify((Object)this.horizontalPanel, (VerificationMode)Mockito.times((int)3))).add((Widget)columnLabel);
        ((ColumnManagementView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)3))).editAnchor((ClickHandler)Matchers.any(ClickHandler.class));
        ((ColumnManagementView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).deleteAnchor((String)Matchers.eq((Object)"one"), (Command)Matchers.any(Command.class));
        ((ColumnManagementView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).deleteAnchor((String)Matchers.eq((Object)"two"), (Command)Matchers.any(Command.class));
        ((ColumnManagementView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).deleteAnchor((String)Matchers.eq((Object)"three"), (Command)Matchers.any(Command.class));
    }

    @Test
    public void testRenderColumnBrlConditionEditable() throws Exception {
        final BRLConditionColumn conditionColumnOne = (BRLConditionColumn)Mockito.mock(BRLConditionColumn.class);
        final BRLConditionColumn conditionColumnTwo = (BRLConditionColumn)Mockito.mock(BRLConditionColumn.class);
        HashMap<String, List<BaseColumn>> columnGroups = new HashMap<String, List<BaseColumn>>(){
            {
                this.put(GuidedDecisionTableConstants.INSTANCE.BrlConditions(), Arrays.asList(conditionColumnOne, conditionColumnTwo));
            }
        };
        ColumnLabelWidget columnLabel = this.mockColumnLabelWidget();
        ((ColumnManagementView)Mockito.doReturn((Object)columnLabel).when((Object)this.view)).newColumnLabelWidget(Matchers.anyString());
        ((GuidedDecisionTableModellerView.Presenter)Mockito.doReturn((Object)true).when((Object)this.modellerPresenter)).isActiveDecisionTableEditable();
        ((BRLConditionColumn)Mockito.doReturn((Object)"brl one").when((Object)conditionColumnOne)).getHeader();
        ((BRLConditionColumn)Mockito.doReturn((Object)"brl two").when((Object)conditionColumnTwo)).getHeader();
        this.view.renderColumns((Map)columnGroups);
        ((ColumnManagementView)Mockito.verify((Object)this.view)).renderColumn(conditionColumnOne);
        ((ColumnManagementView)Mockito.verify((Object)this.view)).renderColumn(conditionColumnTwo);
        ((HorizontalPanel)Mockito.verify((Object)this.horizontalPanel, (VerificationMode)Mockito.times((int)2))).add((Widget)columnLabel);
        ((ColumnManagementView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).editAnchor((ClickHandler)this.clickHandlerCaptor.capture());
        ((ColumnManagementView)Mockito.verify((Object)this.view)).deleteAnchor((String)Matchers.eq((Object)"brl one"), (Command)Matchers.any(Command.class));
        ((ColumnManagementView)Mockito.verify((Object)this.view)).deleteAnchor((String)Matchers.eq((Object)"brl two"), (Command)Matchers.any(Command.class));
        ((ClickHandler)this.clickHandlerCaptor.getAllValues().get(0)).onClick((ClickEvent)Mockito.mock(ClickEvent.class));
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)this.decisionTablePresenter)).editCondition((BRLConditionColumn)Matchers.eq((Object)conditionColumnOne));
        ((ClickHandler)this.clickHandlerCaptor.getAllValues().get(1)).onClick((ClickEvent)Mockito.mock(ClickEvent.class));
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)this.decisionTablePresenter)).editCondition((BRLConditionColumn)Matchers.eq((Object)conditionColumnTwo));
    }

    @Test
    public void testRenderColumnBrlConditionNotEditable() throws Exception {
        final BRLConditionColumn conditionColumnOne = (BRLConditionColumn)Mockito.mock(BRLConditionColumn.class);
        final BRLConditionColumn conditionColumnTwo = (BRLConditionColumn)Mockito.mock(BRLConditionColumn.class);
        HashMap<String, List<BaseColumn>> columnGroups = new HashMap<String, List<BaseColumn>>(){
            {
                this.put(GuidedDecisionTableConstants.INSTANCE.BrlConditions(), Arrays.asList(conditionColumnOne, conditionColumnTwo));
            }
        };
        ColumnLabelWidget columnLabel = this.mockColumnLabelWidget();
        ((ColumnManagementView)Mockito.doReturn((Object)columnLabel).when((Object)this.view)).newColumnLabelWidget(Matchers.anyString());
        ((BRLConditionColumn)Mockito.doReturn((Object)"brl one").when((Object)conditionColumnOne)).getHeader();
        ((BRLConditionColumn)Mockito.doReturn((Object)"brl two").when((Object)conditionColumnTwo)).getHeader();
        this.view.renderColumns((Map)columnGroups);
        ((ColumnManagementView)Mockito.verify((Object)this.view)).renderColumn(conditionColumnOne);
        ((ColumnManagementView)Mockito.verify((Object)this.view)).renderColumn(conditionColumnTwo);
        ((HorizontalPanel)Mockito.verify((Object)this.horizontalPanel, (VerificationMode)Mockito.times((int)2))).add((Widget)columnLabel);
        ((ColumnManagementView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).editAnchor((ClickHandler)Matchers.any(ClickHandler.class));
        ((ColumnManagementView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).deleteAnchor((String)Matchers.eq((Object)"brl one"), (Command)Matchers.any(Command.class));
        ((ColumnManagementView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).deleteAnchor((String)Matchers.eq((Object)"brl two"), (Command)Matchers.any(Command.class));
    }

    @Test
    public void testRenderColumnActionsEditable() throws Exception {
        final BRLActionColumn brlActionColumn = (BRLActionColumn)Mockito.mock(BRLActionColumn.class);
        final ActionInsertFactCol52 actionInsertFactColumn = (ActionInsertFactCol52)Mockito.mock(ActionInsertFactCol52.class);
        final ActionRetractFactCol52 retractFactColumn = (ActionRetractFactCol52)Mockito.mock(ActionRetractFactCol52.class);
        HashMap<String, List<BaseColumn>> columnGroups = new HashMap<String, List<BaseColumn>>(){
            {
                this.put(GuidedDecisionTableConstants.INSTANCE.BrlConditions(), Arrays.asList(brlActionColumn, actionInsertFactColumn, retractFactColumn));
            }
        };
        ColumnLabelWidget columnLabel = this.mockColumnLabelWidget();
        ((ColumnManagementView)Mockito.doReturn((Object)columnLabel).when((Object)this.view)).newColumnLabelWidget(Matchers.anyString());
        ((GuidedDecisionTableModellerView.Presenter)Mockito.doReturn((Object)true).when((Object)this.modellerPresenter)).isActiveDecisionTableEditable();
        ((BRLActionColumn)Mockito.doReturn((Object)"one").when((Object)brlActionColumn)).getHeader();
        ((ActionInsertFactCol52)Mockito.doReturn((Object)"two").when((Object)actionInsertFactColumn)).getHeader();
        ((ActionRetractFactCol52)Mockito.doReturn((Object)"three").when((Object)retractFactColumn)).getHeader();
        this.view.renderColumns((Map)columnGroups);
        ((ColumnManagementView)Mockito.verify((Object)this.view)).renderColumn((ActionCol52)brlActionColumn);
        ((ColumnManagementView)Mockito.verify((Object)this.view)).renderColumn((ActionCol52)actionInsertFactColumn);
        ((ColumnManagementView)Mockito.verify((Object)this.view)).renderColumn((ActionCol52)retractFactColumn);
        ((HorizontalPanel)Mockito.verify((Object)this.horizontalPanel, (VerificationMode)Mockito.times((int)3))).add((Widget)columnLabel);
        ((ColumnManagementView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)3))).editAnchor((ClickHandler)this.clickHandlerCaptor.capture());
        ((ColumnManagementView)Mockito.verify((Object)this.view)).deleteAnchor((String)Matchers.eq((Object)"one"), (Command)this.deleteCommandCaptor.capture());
        ((ColumnManagementView)Mockito.verify((Object)this.view)).deleteAnchor((String)Matchers.eq((Object)"two"), (Command)this.deleteCommandCaptor.capture());
        ((ColumnManagementView)Mockito.verify((Object)this.view)).deleteAnchor((String)Matchers.eq((Object)"three"), (Command)this.deleteCommandCaptor.capture());
        ((ClickHandler)this.clickHandlerCaptor.getAllValues().get(0)).onClick((ClickEvent)Mockito.mock(ClickEvent.class));
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)this.decisionTablePresenter)).editAction((ActionCol52)Matchers.eq((Object)brlActionColumn));
        ((ClickHandler)this.clickHandlerCaptor.getAllValues().get(1)).onClick((ClickEvent)Mockito.mock(ClickEvent.class));
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)this.decisionTablePresenter)).editAction((ActionCol52)Matchers.eq((Object)actionInsertFactColumn));
        ((ClickHandler)this.clickHandlerCaptor.getAllValues().get(2)).onClick((ClickEvent)Mockito.mock(ClickEvent.class));
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)this.decisionTablePresenter)).editAction((ActionCol52)Matchers.eq((Object)retractFactColumn));
        ((Command)this.deleteCommandCaptor.getAllValues().get(0)).execute();
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)this.decisionTablePresenter)).deleteColumn((ActionCol52)brlActionColumn);
        ((Command)this.deleteCommandCaptor.getAllValues().get(1)).execute();
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)this.decisionTablePresenter)).deleteColumn((ActionCol52)actionInsertFactColumn);
        ((Command)this.deleteCommandCaptor.getAllValues().get(2)).execute();
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)this.decisionTablePresenter)).deleteColumn((ActionCol52)retractFactColumn);
    }

    @Test
    public void testRenderColumnActionsNotEditable() throws Exception {
        final BRLActionColumn brlActionColumn = (BRLActionColumn)Mockito.mock(BRLActionColumn.class);
        final ActionInsertFactCol52 actionInsertFactColumn = (ActionInsertFactCol52)Mockito.mock(ActionInsertFactCol52.class);
        final ActionRetractFactCol52 retractFactColumn = (ActionRetractFactCol52)Mockito.mock(ActionRetractFactCol52.class);
        HashMap<String, List<BaseColumn>> columnGroups = new HashMap<String, List<BaseColumn>>(){
            {
                this.put(GuidedDecisionTableConstants.INSTANCE.BrlConditions(), Arrays.asList(brlActionColumn, actionInsertFactColumn, retractFactColumn));
            }
        };
        ColumnLabelWidget columnLabel = this.mockColumnLabelWidget();
        ((ColumnManagementView)Mockito.doReturn((Object)columnLabel).when((Object)this.view)).newColumnLabelWidget((String)Matchers.any());
        this.view.renderColumns((Map)columnGroups);
        ((ColumnManagementView)Mockito.verify((Object)this.view)).renderColumn((ActionCol52)brlActionColumn);
        ((ColumnManagementView)Mockito.verify((Object)this.view)).renderColumn((ActionCol52)actionInsertFactColumn);
        ((ColumnManagementView)Mockito.verify((Object)this.view)).renderColumn((ActionCol52)retractFactColumn);
        ((HorizontalPanel)Mockito.verify((Object)this.horizontalPanel, (VerificationMode)Mockito.times((int)3))).add((Widget)columnLabel);
        ((ColumnManagementView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)3))).editAnchor((ClickHandler)Matchers.any(ClickHandler.class));
        ((ColumnManagementView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).deleteAnchor((String)Matchers.eq((Object)"one"), (Command)Matchers.any(Command.class));
        ((ColumnManagementView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).deleteAnchor((String)Matchers.eq((Object)"two"), (Command)Matchers.any(Command.class));
        ((ColumnManagementView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).deleteAnchor((String)Matchers.eq((Object)"three"), (Command)Matchers.any(Command.class));
    }

    @Test
    public void testMakeColumnLabelCondition() throws Exception {
        this.testMakeColumnLabelForAllConditionColumns(false, false);
    }

    @Test
    public void testMakeColumnLabelConditionHidden() throws Exception {
        this.testMakeColumnLabelForAllConditionColumns(true, false);
    }

    @Test
    public void testMakeColumnLabelConditionBound() throws Exception {
        this.testMakeColumnLabelForAllConditionColumns(false, true);
    }

    @Test
    public void testMakeColumnLabelConditionHiddenBound() throws Exception {
        this.testMakeColumnLabelForAllConditionColumns(true, true);
    }

    @Test
    public void testMakeColumnLabelAction() throws Exception {
        this.testMakeColumnLabelForAllActionColumns(false);
    }

    @Test
    public void testMakeColumnLabelActionHidden() throws Exception {
        this.testMakeColumnLabelForAllActionColumns(true);
    }

    @Test
    public void testRemoveCondition() throws Exception {
        Stream.of(ConditionCol52.class, BRLConditionColumn.class).map(Mockito::mock).forEach(column -> {
            String columnHeader = "column header";
            ArgumentCaptor commandCaptor = ArgumentCaptor.forClass(Command.class);
            ((GuidedDecisionTableModellerView.Presenter)Mockito.doReturn(Optional.of(this.decisionTablePresenter)).when((Object)this.modellerPresenter)).getActiveDecisionTable();
            ((ConditionCol52)Mockito.doReturn((Object)"column header").when(column)).getHeader();
            this.view.removeCondition(column);
            ((ColumnManagementView)Mockito.verify((Object)this.view)).deleteAnchor((String)Matchers.eq((Object)"column header"), (Command)commandCaptor.capture());
            ((Command)commandCaptor.getValue()).execute();
            try {
                ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)this.decisionTablePresenter)).deleteColumn(column);
            }
            catch (ModelSynchronizer.VetoException veto) {
                Assert.fail((String)"Deletion should have succeeded.");
            }
            Mockito.reset((Object[])new ColumnManagementView[]{this.view});
        });
    }

    @Test
    public void testRemoveConditionCanNotBeDeleted() throws Exception {
        Stream.of(ConditionCol52.class, BRLConditionColumn.class).map(Mockito::mock).forEach(column -> {
            String columnHeader = "column header";
            ArgumentCaptor commandCaptor = ArgumentCaptor.forClass(Command.class);
            ((GuidedDecisionTableModellerView.Presenter)Mockito.doReturn(Optional.of(this.decisionTablePresenter)).when((Object)this.modellerPresenter)).getActiveDecisionTable();
            ((ConditionCol52)Mockito.doReturn((Object)"column header").when(column)).getHeader();
            ((GuidedDecisionTableModellerView)Mockito.doNothing().when((Object)this.modellerView)).showUnableToDeleteColumnMessage(column);
            try {
                ((GuidedDecisionTableView.Presenter)Mockito.doThrow(ModelSynchronizer.VetoDeletePatternInUseException.class).when((Object)this.decisionTablePresenter)).deleteColumn((ConditionCol52)Matchers.eq((Object)column));
                this.view.removeCondition(column);
                ((ColumnManagementView)Mockito.verify((Object)this.view)).deleteAnchor((String)Matchers.eq((Object)"column header"), (Command)commandCaptor.capture());
                ((Command)commandCaptor.getValue()).execute();
                ((GuidedDecisionTableModellerView)Mockito.verify((Object)this.modellerView)).showUnableToDeleteColumnMessage((ConditionCol52)Matchers.eq((Object)column));
            }
            catch (ModelSynchronizer.VetoException vetoException) {
                // empty catch block
            }
            Mockito.reset((Object[])new ColumnManagementView[]{this.view});
        });
    }

    private void testMakeColumnLabelForAllConditionColumns(boolean isColumnHidden, boolean isColumnBound) {
        Stream.of(ConditionCol52.class, BRLConditionColumn.class).map(classToMock -> {
            ConditionCol52 column = (ConditionCol52)Mockito.mock((Class)classToMock);
            ColumnLabelWidget columnLabel = this.mockColumnLabelWidget();
            ((ColumnManagementView)Mockito.doReturn((Object)columnLabel).when((Object)this.view)).newColumnLabelWidget(Matchers.anyString());
            ((ConditionCol52)Mockito.doReturn((Object)column.getClass().toString()).when((Object)column)).getHeader();
            ((ConditionCol52)Mockito.doReturn((Object)isColumnHidden).when((Object)column)).isHideColumn();
            ((ConditionCol52)Mockito.doReturn((Object)isColumnBound).when((Object)column)).isBound();
            ((ConditionCol52)Mockito.doReturn((Object)"binding").when((Object)column)).getBinding();
            return column;
        }).forEach(column -> {
            ColumnLabelWidget label = this.view.makeColumnLabel(column);
            ((ColumnManagementView)Mockito.verify((Object)this.view)).newColumnLabelWidget(isColumnBound ? "binding : " + column.getClass().toString() : column.getClass().toString());
            this.testColumnLabelIsHidden(label, isColumnHidden);
        });
    }

    private void testMakeColumnLabelForAllActionColumns(boolean isColumnHidden) {
        Stream.of(ActionInsertFactCol52.class, ActionSetFieldCol52.class, ActionWorkItemCol52.class, ActionWorkItemInsertFactCol52.class, ActionWorkItemSetFieldCol52.class, ActionRetractFactCol52.class, BRLActionColumn.class).map(classToMock -> {
            ActionCol52 column = (ActionCol52)Mockito.mock((Class)classToMock);
            ColumnLabelWidget columnLabel = this.mockColumnLabelWidget();
            ((ColumnManagementView)Mockito.doReturn((Object)columnLabel).when((Object)this.view)).newColumnLabelWidget(Matchers.anyString());
            ((ActionCol52)Mockito.doReturn((Object)column.getClass().toString()).when((Object)column)).getHeader();
            ((ActionCol52)Mockito.doReturn((Object)isColumnHidden).when((Object)column)).isHideColumn();
            return column;
        }).forEach(column -> {
            ColumnLabelWidget label = this.view.makeColumnLabel(column);
            ((ColumnManagementView)Mockito.verify((Object)this.view)).newColumnLabelWidget(column.getClass().toString());
            this.testColumnLabelIsHidden(label, isColumnHidden);
        });
    }

    private void testColumnLabelIsHidden(ColumnLabelWidget columnLabel, boolean isColumnHidden) {
        if (isColumnHidden) {
            ((ColumnLabelWidget)Mockito.verify((Object)columnLabel)).addStyleName(GuidedDecisionTableResources.INSTANCE.css().columnLabelHidden());
        } else {
            ((ColumnLabelWidget)Mockito.verify((Object)columnLabel)).removeStyleName(GuidedDecisionTableResources.INSTANCE.css().columnLabelHidden());
        }
    }
}

