/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.impl;

import java.util.ArrayList;
import java.util.List;
import org.drools.workbench.models.datamodel.rule.Attribute;
import org.drools.workbench.models.guided.dtable.shared.model.AttributeCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.GuidedDecisionTableUiCell;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.ModelSynchronizer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.impl.BaseSynchronizerTest;
import org.junit.Assert;
import org.junit.Test;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;

public class RowSynchronizerTest
extends BaseSynchronizerTest {
    @Test
    public void testAppend() throws ModelSynchronizer.VetoException {
        this.modelSynchronizer.appendRow();
        Assert.assertEquals((long)1L, (long)this.model.getData().size());
        Assert.assertEquals((long)1L, (long)this.uiModel.getRowCount());
        Assert.assertEquals((double)24.0, (double)this.uiModel.getRow(0).getHeight(), (double)0.0);
    }

    @Test
    public void testInsert() throws ModelSynchronizer.VetoException {
        this.modelSynchronizer.appendRow();
        this.modelSynchronizer.insertRow(0);
        Assert.assertEquals((long)2L, (long)this.model.getData().size());
        Assert.assertEquals((long)2L, (long)this.uiModel.getRowCount());
        Assert.assertEquals((double)24.0, (double)this.uiModel.getRow(0).getHeight(), (double)0.0);
        Assert.assertEquals((double)24.0, (double)this.uiModel.getRow(1).getHeight(), (double)0.0);
    }

    @Test
    public void testDeleteUnmergedData() throws ModelSynchronizer.VetoException {
        this.modelSynchronizer.appendRow();
        this.modelSynchronizer.deleteRow(0);
        Assert.assertEquals((long)0L, (long)this.model.getData().size());
        Assert.assertEquals((long)0L, (long)this.uiModel.getRowCount());
    }

    @Test
    public void testDeleteMergedData_Block() throws ModelSynchronizer.VetoException {
        this.uiModel.setMerged(true);
        this.modelSynchronizer.appendRow();
        this.modelSynchronizer.appendRow();
        this.modelSynchronizer.appendRow();
        this.uiModel.setCellValue(0, 2, (GridCellValue)new GuidedDecisionTableUiCell((Object)"a"));
        this.uiModel.setCellValue(1, 2, (GridCellValue)new GuidedDecisionTableUiCell((Object)"a"));
        this.uiModel.setCellValue(2, 2, (GridCellValue)new GuidedDecisionTableUiCell((Object)"b"));
        this.uiModel.collapseCell(0, 2);
        this.modelSynchronizer.deleteRow(0);
        Assert.assertEquals((long)1L, (long)this.model.getData().size());
        Assert.assertEquals((long)1L, (long)this.uiModel.getRowCount());
    }

    @Test
    public void testDeleteMergedData_WholeBlock() throws ModelSynchronizer.VetoException {
        this.uiModel.setMerged(true);
        this.modelSynchronizer.appendRow();
        this.modelSynchronizer.appendRow();
        this.modelSynchronizer.appendRow();
        this.uiModel.setCellValue(0, 2, (GridCellValue)new GuidedDecisionTableUiCell((Object)"a"));
        this.uiModel.setCellValue(1, 2, (GridCellValue)new GuidedDecisionTableUiCell((Object)"a"));
        this.uiModel.setCellValue(2, 2, (GridCellValue)new GuidedDecisionTableUiCell((Object)"a"));
        this.uiModel.collapseCell(0, 2);
        this.modelSynchronizer.deleteRow(0);
        Assert.assertEquals((long)0L, (long)this.model.getData().size());
        Assert.assertEquals((long)0L, (long)this.uiModel.getRowCount());
    }

    @Test
    public void testMoveRowMoveUpTopBlock() throws ModelSynchronizer.VetoException {
        this.modelSynchronizer.appendRow();
        this.modelSynchronizer.appendRow();
        this.modelSynchronizer.appendRow();
        GridRow uiRow0 = this.uiModel.getRow(0);
        GridRow uiRow1 = this.uiModel.getRow(1);
        final GridRow uiRow2 = this.uiModel.getRow(2);
        List row0 = (List)this.model.getData().get(0);
        List row1 = (List)this.model.getData().get(1);
        List row2 = (List)this.model.getData().get(2);
        this.uiModel.moveRowsTo(0, (List)new ArrayList<GridRow>(){
            {
                this.add(uiRow2);
            }
        });
        Assert.assertEquals((Object)uiRow2, (Object)this.uiModel.getRow(0));
        Assert.assertEquals((Object)uiRow0, (Object)this.uiModel.getRow(1));
        Assert.assertEquals((Object)uiRow1, (Object)this.uiModel.getRow(2));
        Assert.assertEquals((Object)row2, this.model.getData().get(0));
        Assert.assertEquals((Object)row0, this.model.getData().get(1));
        Assert.assertEquals((Object)row1, this.model.getData().get(2));
    }

    @Test
    public void testMoveRowMoveUpMidBlock() throws ModelSynchronizer.VetoException {
        this.modelSynchronizer.appendRow();
        this.modelSynchronizer.appendRow();
        this.modelSynchronizer.appendRow();
        GridRow uiRow0 = this.uiModel.getRow(0);
        GridRow uiRow1 = this.uiModel.getRow(1);
        final GridRow uiRow2 = this.uiModel.getRow(2);
        List row0 = (List)this.model.getData().get(0);
        List row1 = (List)this.model.getData().get(1);
        List row2 = (List)this.model.getData().get(2);
        this.uiModel.moveRowsTo(1, (List)new ArrayList<GridRow>(){
            {
                this.add(uiRow2);
            }
        });
        Assert.assertEquals((Object)uiRow0, (Object)this.uiModel.getRow(0));
        Assert.assertEquals((Object)uiRow2, (Object)this.uiModel.getRow(1));
        Assert.assertEquals((Object)uiRow1, (Object)this.uiModel.getRow(2));
        Assert.assertEquals((Object)row0, this.model.getData().get(0));
        Assert.assertEquals((Object)row2, this.model.getData().get(1));
        Assert.assertEquals((Object)row1, this.model.getData().get(2));
    }

    @Test
    public void testMoveRowsMoveUp() throws ModelSynchronizer.VetoException {
        this.modelSynchronizer.appendRow();
        this.modelSynchronizer.appendRow();
        this.modelSynchronizer.appendRow();
        GridRow uiRow0 = this.uiModel.getRow(0);
        final GridRow uiRow1 = this.uiModel.getRow(1);
        final GridRow uiRow2 = this.uiModel.getRow(2);
        List row0 = (List)this.model.getData().get(0);
        List row1 = (List)this.model.getData().get(1);
        List row2 = (List)this.model.getData().get(2);
        this.uiModel.moveRowsTo(0, (List)new ArrayList<GridRow>(){
            {
                this.add(uiRow1);
                this.add(uiRow2);
            }
        });
        Assert.assertEquals((Object)uiRow1, (Object)this.uiModel.getRow(0));
        Assert.assertEquals((Object)uiRow2, (Object)this.uiModel.getRow(1));
        Assert.assertEquals((Object)uiRow0, (Object)this.uiModel.getRow(2));
        Assert.assertEquals((Object)row1, this.model.getData().get(0));
        Assert.assertEquals((Object)row2, this.model.getData().get(1));
        Assert.assertEquals((Object)row0, this.model.getData().get(2));
    }

    @Test
    public void testMoveRowMoveDownEndBlock() throws ModelSynchronizer.VetoException {
        this.modelSynchronizer.appendRow();
        this.modelSynchronizer.appendRow();
        this.modelSynchronizer.appendRow();
        final GridRow uiRow0 = this.uiModel.getRow(0);
        GridRow uiRow1 = this.uiModel.getRow(1);
        GridRow uiRow2 = this.uiModel.getRow(2);
        List row0 = (List)this.model.getData().get(0);
        List row1 = (List)this.model.getData().get(1);
        List row2 = (List)this.model.getData().get(2);
        this.uiModel.moveRowsTo(2, (List)new ArrayList<GridRow>(){
            {
                this.add(uiRow0);
            }
        });
        Assert.assertEquals((Object)uiRow1, (Object)this.uiModel.getRow(0));
        Assert.assertEquals((Object)uiRow2, (Object)this.uiModel.getRow(1));
        Assert.assertEquals((Object)uiRow0, (Object)this.uiModel.getRow(2));
        Assert.assertEquals((Object)row1, this.model.getData().get(0));
        Assert.assertEquals((Object)row2, this.model.getData().get(1));
        Assert.assertEquals((Object)row0, this.model.getData().get(2));
    }

    @Test
    public void testMoveRowMoveDownMidBlock() throws ModelSynchronizer.VetoException {
        this.modelSynchronizer.appendRow();
        this.modelSynchronizer.appendRow();
        this.modelSynchronizer.appendRow();
        final GridRow uiRow0 = this.uiModel.getRow(0);
        GridRow uiRow1 = this.uiModel.getRow(1);
        GridRow uiRow2 = this.uiModel.getRow(2);
        List row0 = (List)this.model.getData().get(0);
        List row1 = (List)this.model.getData().get(1);
        List row2 = (List)this.model.getData().get(2);
        this.uiModel.moveRowsTo(1, (List)new ArrayList<GridRow>(){
            {
                this.add(uiRow0);
            }
        });
        Assert.assertEquals((Object)uiRow1, (Object)this.uiModel.getRow(0));
        Assert.assertEquals((Object)uiRow0, (Object)this.uiModel.getRow(1));
        Assert.assertEquals((Object)uiRow2, (Object)this.uiModel.getRow(2));
        Assert.assertEquals((Object)row1, this.model.getData().get(0));
        Assert.assertEquals((Object)row0, this.model.getData().get(1));
        Assert.assertEquals((Object)row2, this.model.getData().get(2));
    }

    @Test
    public void testMoveRowsMoveDown() throws ModelSynchronizer.VetoException {
        this.modelSynchronizer.appendRow();
        this.modelSynchronizer.appendRow();
        this.modelSynchronizer.appendRow();
        final GridRow uiRow0 = this.uiModel.getRow(0);
        final GridRow uiRow1 = this.uiModel.getRow(1);
        GridRow uiRow2 = this.uiModel.getRow(2);
        List row0 = (List)this.model.getData().get(0);
        List row1 = (List)this.model.getData().get(1);
        List row2 = (List)this.model.getData().get(2);
        this.uiModel.moveRowsTo(2, (List)new ArrayList<GridRow>(){
            {
                this.add(uiRow0);
                this.add(uiRow1);
            }
        });
        Assert.assertEquals((Object)uiRow2, (Object)this.uiModel.getRow(0));
        Assert.assertEquals((Object)uiRow0, (Object)this.uiModel.getRow(1));
        Assert.assertEquals((Object)uiRow1, (Object)this.uiModel.getRow(2));
        Assert.assertEquals((Object)row2, this.model.getData().get(0));
        Assert.assertEquals((Object)row0, this.model.getData().get(1));
        Assert.assertEquals((Object)row1, this.model.getData().get(2));
    }

    @Test
    public void testAppendRowNumbers() throws ModelSynchronizer.VetoException {
        this.modelSynchronizer.appendRow();
        this.modelSynchronizer.appendRow();
        Assert.assertEquals((Object)1, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(0)).getValue().getValue());
        Assert.assertEquals((Object)2, (Object)((GridCell)this.uiModel.getRow(1).getCells().get(0)).getValue().getValue());
        Assert.assertEquals((Object)1, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(0)).getNumericValue());
        Assert.assertEquals((Object)2, (Object)((DTCellValue52)((List)this.model.getData().get(1)).get(0)).getNumericValue());
    }

    @Test
    public void testInsertRowNumbers() throws ModelSynchronizer.VetoException {
        this.modelSynchronizer.appendRow();
        this.modelSynchronizer.insertRow(0);
        Assert.assertEquals((Object)1, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(0)).getValue().getValue());
        Assert.assertEquals((Object)2, (Object)((GridCell)this.uiModel.getRow(1).getCells().get(0)).getValue().getValue());
        Assert.assertEquals((Object)1, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(0)).getNumericValue());
        Assert.assertEquals((Object)2, (Object)((DTCellValue52)((List)this.model.getData().get(1)).get(0)).getNumericValue());
    }

    @Test
    public void testDeleteRowNumbers() throws ModelSynchronizer.VetoException {
        this.modelSynchronizer.appendRow();
        this.modelSynchronizer.appendRow();
        this.modelSynchronizer.deleteRow(0);
        Assert.assertEquals((Object)1, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(0)).getValue().getValue());
        Assert.assertEquals((Object)1, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(0)).getNumericValue());
    }

    @Test
    public void testMoveRowsMoveDownCheckRowNumbers() throws ModelSynchronizer.VetoException {
        this.modelSynchronizer.appendRow();
        this.modelSynchronizer.appendRow();
        this.modelSynchronizer.appendRow();
        final GridRow uiRow0 = this.uiModel.getRow(0);
        final GridRow uiRow1 = this.uiModel.getRow(1);
        this.uiModel.moveRowsTo(2, (List)new ArrayList<GridRow>(){
            {
                this.add(uiRow0);
                this.add(uiRow1);
            }
        });
        Assert.assertEquals((Object)1, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(0)).getValue().getValue());
        Assert.assertEquals((Object)2, (Object)((GridCell)this.uiModel.getRow(1).getCells().get(0)).getValue().getValue());
        Assert.assertEquals((Object)3, (Object)((GridCell)this.uiModel.getRow(2).getCells().get(0)).getValue().getValue());
        Assert.assertEquals((Object)1, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(0)).getNumericValue());
        Assert.assertEquals((Object)2, (Object)((DTCellValue52)((List)this.model.getData().get(1)).get(0)).getNumericValue());
        Assert.assertEquals((Object)3, (Object)((DTCellValue52)((List)this.model.getData().get(2)).get(0)).getNumericValue());
    }

    @Test
    public void testMoveRowsMoveUpCheckRowNumbers() throws ModelSynchronizer.VetoException {
        this.modelSynchronizer.appendRow();
        this.modelSynchronizer.appendRow();
        this.modelSynchronizer.appendRow();
        final GridRow uiRow1 = this.uiModel.getRow(1);
        final GridRow uiRow2 = this.uiModel.getRow(2);
        this.uiModel.moveRowsTo(0, (List)new ArrayList<GridRow>(){
            {
                this.add(uiRow1);
                this.add(uiRow2);
            }
        });
        Assert.assertEquals((Object)1, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(0)).getValue().getValue());
        Assert.assertEquals((Object)2, (Object)((GridCell)this.uiModel.getRow(1).getCells().get(0)).getValue().getValue());
        Assert.assertEquals((Object)3, (Object)((GridCell)this.uiModel.getRow(2).getCells().get(0)).getValue().getValue());
        Assert.assertEquals((Object)1, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(0)).getNumericValue());
        Assert.assertEquals((Object)2, (Object)((DTCellValue52)((List)this.model.getData().get(1)).get(0)).getNumericValue());
        Assert.assertEquals((Object)3, (Object)((DTCellValue52)((List)this.model.getData().get(2)).get(0)).getNumericValue());
    }

    @Test
    public void checkBooleanDefaultValueTrue() throws ModelSynchronizer.VetoException {
        AttributeCol52 column = new AttributeCol52();
        column.setAttribute(Attribute.ENABLED.getAttributeName());
        column.setDefaultValue(new DTCellValue52(Boolean.valueOf(true)));
        this.modelSynchronizer.appendColumn((BaseColumn)column);
        this.modelSynchronizer.appendRow();
        Assert.assertTrue((boolean)((Boolean)((GridCell)this.uiModel.getRow(0).getCells().get(3)).getValue().getValue()));
        Assert.assertTrue((boolean)((DTCellValue52)((List)this.model.getData().get(0)).get(3)).getBooleanValue());
    }

    @Test
    public void checkBooleanDefaultValueFalse() throws ModelSynchronizer.VetoException {
        AttributeCol52 column = new AttributeCol52();
        column.setAttribute(Attribute.ENABLED.getAttributeName());
        column.setDefaultValue(new DTCellValue52(Boolean.valueOf(false)));
        this.modelSynchronizer.appendColumn((BaseColumn)column);
        this.modelSynchronizer.appendRow();
        Assert.assertFalse((boolean)((Boolean)((GridCell)this.uiModel.getRow(0).getCells().get(3)).getValue().getValue()));
        Assert.assertFalse((boolean)((DTCellValue52)((List)this.model.getData().get(0)).get(3)).getBooleanValue());
    }

    @Test
    public void checkBooleanDefaultValueNotSet() throws ModelSynchronizer.VetoException {
        AttributeCol52 column = new AttributeCol52();
        column.setAttribute(Attribute.ENABLED.getAttributeName());
        this.modelSynchronizer.appendColumn((BaseColumn)column);
        this.modelSynchronizer.appendRow();
        Assert.assertFalse((boolean)((Boolean)((GridCell)this.uiModel.getRow(0).getCells().get(3)).getValue().getValue()));
        Assert.assertFalse((boolean)((DTCellValue52)((List)this.model.getData().get(0)).get(3)).getBooleanValue());
    }

    @Test(expected=ModelSynchronizer.VetoException.class)
    public void testHandlesSortRowCountDoesNotMatchListSize() throws ModelSynchronizer.VetoException {
        this.modelSynchronizer.appendRow();
        this.modelSynchronizer.sort(new ArrayList());
    }

    @Test
    public void testHandlesSort() throws ModelSynchronizer.VetoException {
        this.modelSynchronizer.appendRow();
        this.modelSynchronizer.appendRow();
        this.modelSynchronizer.appendRow();
        Assert.assertEquals((long)1L, (long)((DTCellValue52)((List)this.model.getData().get(0)).get(0)).getNumericValue().intValue());
        Assert.assertEquals((long)2L, (long)((DTCellValue52)((List)this.model.getData().get(1)).get(0)).getNumericValue().intValue());
        Assert.assertEquals((long)3L, (long)((DTCellValue52)((List)this.model.getData().get(2)).get(0)).getNumericValue().intValue());
        ArrayList<Integer> sort = new ArrayList<Integer>();
        sort.add(2);
        sort.add(1);
        sort.add(0);
        this.modelSynchronizer.sort(sort);
        Assert.assertEquals((long)3L, (long)((DTCellValue52)((List)this.model.getData().get(0)).get(0)).getNumericValue().intValue());
        Assert.assertEquals((long)2L, (long)((DTCellValue52)((List)this.model.getData().get(1)).get(0)).getNumericValue().intValue());
        Assert.assertEquals((long)1L, (long)((DTCellValue52)((List)this.model.getData().get(2)).get(0)).getNumericValue().intValue());
    }
}

