/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.impl;

import java.util.Arrays;
import java.util.List;
import org.drools.workbench.models.datamodel.rule.Attribute;
import org.drools.workbench.models.guided.dtable.shared.model.AttributeCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.MetadataCol52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.GuidedDecisionTableUiCell;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.impl.BaseSynchronizerTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;

public class SystemControlledColumnValuesSynchronizerTest
extends BaseSynchronizerTest {
    private MetadataCol52 resolvedHitMetadata;
    private AttributeCol52 salienceAttribute;
    private int rowsCount;

    @Before
    public void setUp() throws Exception {
        this.salienceAttribute = new AttributeCol52();
        this.salienceAttribute.setAttribute(Attribute.SALIENCE.getAttributeName());
        this.resolvedHitMetadata = new MetadataCol52();
        this.resolvedHitMetadata.setMetadata("ResolvedHitPriorityOverRow");
        this.model.setHitPolicy(GuidedDecisionTable52.HitPolicy.RESOLVED_HIT);
        this.modelSynchronizer.appendColumn((BaseColumn)this.salienceAttribute);
        this.modelSynchronizer.appendColumn((BaseColumn)this.resolvedHitMetadata);
        this.rowsCount = 0;
    }

    @Test
    public void testPrioritiesOverSameRowMoveUp() throws Exception {
        this.addRowWithPriorityOver("");
        this.addRowWithPriorityOver("");
        this.addRowWithPriorityOver("2");
        this.addRowWithPriorityOver("2");
        this.uiModel.moveRowsTo(0, Arrays.asList(this.uiModel.getRow(1)));
        this.assertPriorities(Arrays.asList("", "", "1", "1"));
    }

    @Test
    public void testPrioritiesOverSameRowMoveDown() throws Exception {
        this.addRowWithPriorityOver("");
        this.addRowWithPriorityOver("1");
        this.addRowWithPriorityOver("1");
        this.addRowWithPriorityOver("");
        this.uiModel.moveRowsTo(3, Arrays.asList(this.uiModel.getRow(0)));
        this.assertPriorities(Arrays.asList("", "", "", ""));
    }

    @Test
    public void testTransitivePrioritiesMoveUp() throws Exception {
        this.addRowWithPriorityOver("");
        this.addRowWithPriorityOver("1");
        this.addRowWithPriorityOver("2");
        this.addRowWithPriorityOver("3");
        this.addRowWithPriorityOver("");
        this.uiModel.moveRowsTo(0, Arrays.asList(this.uiModel.getRow(4)));
        this.assertPriorities(Arrays.asList("", "", "2", "3", "4"));
    }

    @Test
    public void testTransitivePrioritiesMoveDown() throws Exception {
        this.addRowWithPriorityOver("");
        this.addRowWithPriorityOver("1");
        this.addRowWithPriorityOver("2");
        this.addRowWithPriorityOver("3");
        this.addRowWithPriorityOver("");
        this.uiModel.moveRowsTo(4, Arrays.asList(this.uiModel.getRow(0)));
        this.assertPriorities(Arrays.asList("", "", "", "", ""));
    }

    @Test
    public void testTransitivePrioritiesMoveFirstUp() throws Exception {
        this.addRowWithPriorityOver("");
        this.addRowWithPriorityOver("");
        this.addRowWithPriorityOver("2");
        this.addRowWithPriorityOver("3");
        this.uiModel.moveRowsTo(0, Arrays.asList(this.uiModel.getRow(1)));
        this.assertPriorities(Arrays.asList("", "", "1", "3"));
    }

    @Test
    public void testTransitivePrioritiesMoveFirstDown() throws Exception {
        this.addRowWithPriorityOver("");
        this.addRowWithPriorityOver("");
        this.addRowWithPriorityOver("2");
        this.addRowWithPriorityOver("3");
        this.uiModel.moveRowsTo(2, Arrays.asList(this.uiModel.getRow(1)));
        this.assertPriorities(Arrays.asList("", "", "", "2"));
    }

    @Test
    public void testTransitivePrioritiesMoveMiddleUp() throws Exception {
        this.addRowWithPriorityOver("");
        this.addRowWithPriorityOver("");
        this.addRowWithPriorityOver("2");
        this.addRowWithPriorityOver("3");
        this.uiModel.moveRowsTo(0, Arrays.asList(this.uiModel.getRow(2)));
        this.assertPriorities(Arrays.asList("", "", "", "1"));
    }

    @Test
    public void testTransitivePrioritiesMoveMiddleDown() throws Exception {
        this.addRowWithPriorityOver("");
        this.addRowWithPriorityOver("1");
        this.addRowWithPriorityOver("");
        this.addRowWithPriorityOver("2");
        this.uiModel.moveRowsTo(2, Arrays.asList(this.uiModel.getRow(1)));
        this.assertPriorities(Arrays.asList("", "", "1", "3"));
    }

    @Test
    public void testTransitivePrioritiesMoveLastUp() throws Exception {
        this.addRowWithPriorityOver("");
        this.addRowWithPriorityOver("");
        this.addRowWithPriorityOver("2");
        this.addRowWithPriorityOver("3");
        this.uiModel.moveRowsTo(0, Arrays.asList(this.uiModel.getRow(3)));
        this.assertPriorities(Arrays.asList("", "", "", "3"));
    }

    @Test
    public void testTransitivePrioritiesMoveLastDown() throws Exception {
        this.addRowWithPriorityOver("");
        this.addRowWithPriorityOver("1");
        this.addRowWithPriorityOver("2");
        this.addRowWithPriorityOver("");
        this.uiModel.moveRowsTo(3, Arrays.asList(this.uiModel.getRow(2)));
        this.assertPriorities(Arrays.asList("", "1", "", "2"));
    }

    @Test
    public void testDeletionOfRow() throws Exception {
        this.addRowWithPriorityOver("");
        this.addRowWithPriorityOver("1");
        this.addRowWithPriorityOver("");
        this.addRowWithPriorityOver("2");
        this.addRowWithPriorityOver("4");
        this.modelSynchronizer.deleteRow(2);
        this.assertPriorities(Arrays.asList("", "1", "2", "3"));
    }

    @Test
    public void testDeletionOfExplicitlyUsedRow() throws Exception {
        this.addRowWithPriorityOver("");
        this.addRowWithPriorityOver("1");
        this.addRowWithPriorityOver("1");
        this.addRowWithPriorityOver("2");
        this.addRowWithPriorityOver("4");
        this.modelSynchronizer.deleteRow(0);
        this.assertPriorities(Arrays.asList("0", "0", "1", "3"));
    }

    @Test
    public void testInsertionAtBeginning() throws Exception {
        this.addRowWithPriorityOver("");
        this.addRowWithPriorityOver("1");
        this.addRowWithPriorityOver("1");
        this.addRowWithPriorityOver("2");
        this.addRowWithPriorityOver("4");
        this.modelSynchronizer.insertRow(0);
        this.uiModel.setCellValue(0, 3, (GridCellValue)new GuidedDecisionTableUiCell((Object)""));
        this.assertPriorities(Arrays.asList("", "", "2", "2", "3", "5"));
    }

    @Test
    public void testInsertionIntoMiddle() throws Exception {
        this.addRowWithPriorityOver("");
        this.addRowWithPriorityOver("1");
        this.addRowWithPriorityOver("1");
        this.addRowWithPriorityOver("2");
        this.addRowWithPriorityOver("4");
        this.modelSynchronizer.insertRow(3);
        this.uiModel.setCellValue(3, 3, (GridCellValue)new GuidedDecisionTableUiCell((Object)""));
        this.assertPriorities(Arrays.asList("", "1", "1", "", "2", "5"));
    }

    @Test
    public void testInsertionOnPlaceOfUsedRows() throws Exception {
        this.addRowWithPriorityOver("");
        this.addRowWithPriorityOver("1");
        this.addRowWithPriorityOver("1");
        this.addRowWithPriorityOver("2");
        this.addRowWithPriorityOver("4");
        this.modelSynchronizer.insertRow(4);
        this.uiModel.setCellValue(4, 3, (GridCellValue)new GuidedDecisionTableUiCell((Object)""));
        this.assertPriorities(Arrays.asList("", "1", "1", "2", "", "5"));
    }

    @Test
    public void testMoveIntoGroup() throws Exception {
        this.addRowWithPriorityOver("");
        this.addRowWithPriorityOver("1");
        this.addRowWithPriorityOver("2");
        this.addRowWithPriorityOver("3");
        this.uiModel.moveRowsTo(2, Arrays.asList(this.uiModel.getRow(0)));
        this.assertPriorities(Arrays.asList("", "", "", "2"));
    }

    @Test
    public void testMoveRowWithPriority() throws Exception {
        this.addRowWithPriorityOver("");
        this.addRowWithPriorityOver("");
        this.addRowWithPriorityOver("2");
        this.addRowWithPriorityOver("2");
        this.uiModel.moveRowsTo(0, Arrays.asList(this.uiModel.getRow(2)));
        this.assertPriorities(Arrays.asList("", "", "", "3"));
    }

    @Test
    public void testMoveMultipleRows() throws Exception {
        this.addRowWithPriorityOver("");
        this.addRowWithPriorityOver("1");
        this.addRowWithPriorityOver("2");
        this.addRowWithPriorityOver("");
        this.addRowWithPriorityOver("1");
        this.addRowWithPriorityOver("5");
        this.uiModel.moveRowsTo(3, Arrays.asList(this.uiModel.getRow(0)));
        this.assertPriorities(Arrays.asList("", "", "", "", "4", "5"));
        this.uiModel.moveRowsTo(2, Arrays.asList(this.uiModel.getRow(3)));
        this.assertPriorities(Arrays.asList("", "", "", "", "3", "5"));
        this.uiModel.moveRowsTo(1, Arrays.asList(this.uiModel.getRow(4)));
        this.assertPriorities(Arrays.asList("", "", "", "", "", "2"));
    }

    private void addRowWithPriorityOver(String priorityOverRow) throws Exception {
        this.modelSynchronizer.appendRow();
        this.uiModel.setCellValue(this.rowsCount, 0, (GridCellValue)new GuidedDecisionTableUiCell((Object)(this.rowsCount + 1)));
        this.uiModel.setCellValue(this.rowsCount, 3, (GridCellValue)new GuidedDecisionTableUiCell((Object)priorityOverRow));
        ++this.rowsCount;
    }

    private void assertPriorities(List<String> priorities) {
        for (int rowIndex = 0; rowIndex < priorities.size(); ++rowIndex) {
            Assert.assertEquals((Object)priorities.get(rowIndex), (Object)this.uiModel.getCell(rowIndex, 3).getValue().getValue());
        }
    }
}

