/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.utilities;

import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTablePresenter;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.utilities.EnumLoaderUtilities;
import org.jboss.errai.common.client.api.Caller;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.project.datamodel.oracle.DropDownData;
import org.kie.workbench.common.services.shared.enums.EnumDropdownService;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.class)
public class EnumLoaderUtilitiesTest {
    @Mock
    protected EnumDropdownService enumDropdownService;
    protected Caller<EnumDropdownService> enumDropdownServiceCaller;
    protected EnumLoaderUtilities enumLoaderUtilities;
    @Mock
    private GuidedDecisionTablePresenter presenter;
    @Mock
    private GuidedDecisionTableView view;
    @Mock
    private Command onFetchCommand;
    @Mock
    private Command onFetchCompleteCommand;

    @Before
    public void setup() {
        this.enumDropdownServiceCaller = new CallerMock((Object)this.enumDropdownService);
        this.enumLoaderUtilities = (EnumLoaderUtilities)Mockito.spy((Object)new EnumLoaderUtilities(this.enumDropdownServiceCaller));
        Mockito.when((Object)this.presenter.getView()).thenReturn((Object)this.view);
    }

    @Test
    public void checkNullDefinition() {
        Callback callback = result -> Assert.assertTrue((boolean)result.isEmpty());
        this.enumLoaderUtilities.getEnums(null, callback, this.presenter, this.onFetchCommand, this.onFetchCompleteCommand);
        this.assertNoInteractions();
    }

    @Test
    public void checkEmptyDefinition() {
        Callback callback = result -> Assert.assertTrue((boolean)result.isEmpty());
        this.enumLoaderUtilities.getEnums(new DropDownData(), callback, this.presenter, this.onFetchCommand, this.onFetchCompleteCommand);
        this.assertNoInteractions();
    }

    private void assertNoInteractions() {
        ((EnumDropdownService)Mockito.verify((Object)this.enumDropdownService, (VerificationMode)Mockito.never())).loadDropDownExpression((Path)Mockito.any(Path.class), (String[])Mockito.any(String[].class), (String)Mockito.any(String.class));
        ((Command)Mockito.verify((Object)this.onFetchCommand, (VerificationMode)Mockito.never())).execute();
        ((Command)Mockito.verify((Object)this.onFetchCompleteCommand, (VerificationMode)Mockito.never())).execute();
        ((EnumLoaderUtilities)Mockito.verify((Object)this.enumLoaderUtilities, (VerificationMode)Mockito.never())).convertDropDownData((String[])Mockito.any(String[].class));
    }

    @Test
    public void checkFixedListDefinitionWithCaching() {
        Callback callback = result -> {
            Assert.assertFalse((boolean)result.isEmpty());
            Assert.assertEquals((long)2L, (long)result.size());
            Assert.assertTrue((boolean)result.containsKey("one"));
            Assert.assertTrue((boolean)result.containsKey("two"));
        };
        String[] fixedList = new String[]{"one", "two"};
        DropDownData enumDefinition = DropDownData.create((String[])fixedList);
        this.enumLoaderUtilities.getEnums(enumDefinition, callback, this.presenter, this.onFetchCommand, this.onFetchCompleteCommand);
        this.enumLoaderUtilities.getEnums(enumDefinition, callback, this.presenter, this.onFetchCommand, this.onFetchCompleteCommand);
        ((EnumDropdownService)Mockito.verify((Object)this.enumDropdownService, (VerificationMode)Mockito.never())).loadDropDownExpression((Path)Mockito.any(Path.class), (String[])Mockito.any(String[].class), (String)Mockito.any(String.class));
        ((Command)Mockito.verify((Object)this.onFetchCommand, (VerificationMode)Mockito.never())).execute();
        ((Command)Mockito.verify((Object)this.onFetchCompleteCommand, (VerificationMode)Mockito.never())).execute();
        ((EnumLoaderUtilities)Mockito.verify((Object)this.enumLoaderUtilities, (VerificationMode)Mockito.times((int)1))).convertDropDownData((String[])Mockito.any(String[].class));
    }

    @Test
    public void checkQueryExpressionDefinitionWithCaching() {
        Callback callback = result -> {
            Assert.assertFalse((boolean)result.isEmpty());
            Assert.assertEquals((long)2L, (long)result.size());
            Assert.assertTrue((boolean)result.containsKey("one"));
            Assert.assertTrue((boolean)result.containsKey("two"));
        };
        String[] fixedList = new String[]{"one", "two"};
        String[] valuePairs = new String[]{"param1=a", "param2=b"};
        DropDownData enumDefinition = DropDownData.create((String)"expression", (String[])valuePairs);
        Mockito.when((Object)this.enumDropdownService.loadDropDownExpression((Path)Mockito.any(), (String[])Mockito.any(), (String)Mockito.any())).thenReturn((Object)fixedList);
        this.enumLoaderUtilities.getEnums(enumDefinition, callback, this.presenter, this.onFetchCommand, this.onFetchCompleteCommand);
        this.enumLoaderUtilities.getEnums(enumDefinition, callback, this.presenter, this.onFetchCommand, this.onFetchCompleteCommand);
        ((EnumDropdownService)Mockito.verify((Object)this.enumDropdownService, (VerificationMode)Mockito.times((int)1))).loadDropDownExpression((Path)Mockito.any(), (String[])Mockito.any(String[].class), (String)Mockito.any(String.class));
        ((Command)Mockito.verify((Object)this.onFetchCommand, (VerificationMode)Mockito.times((int)1))).execute();
        ((Command)Mockito.verify((Object)this.onFetchCompleteCommand, (VerificationMode)Mockito.times((int)1))).execute();
        ((EnumLoaderUtilities)Mockito.verify((Object)this.enumLoaderUtilities, (VerificationMode)Mockito.times((int)1))).convertDropDownData((String[])Mockito.any(String[].class));
        ((GuidedDecisionTableView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).batch();
    }
}

