/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import org.drools.workbench.models.datamodel.workitems.PortableFloatParameterDefinition;
import org.drools.workbench.models.datamodel.workitems.PortableParameterDefinition;
import org.drools.workbench.models.datamodel.workitems.PortableStringParameterDefinition;
import org.drools.workbench.models.datamodel.workitems.PortableWorkDefinition;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTColumnConfig52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.ModelSynchronizer;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.NewGuidedDecisionTableColumnWizard;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.AdditionalInfoPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.FieldPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.PatternPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.WorkItemPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.ActionWorkItemSetFieldPlugin;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.ActionWorkItemInsertWrapper;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.ActionWorkItemSetWrapper;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.ActionWorkItemWrapper;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.PatternWrapper;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.project.datamodel.oracle.FieldAccessorsAndMutators;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.widgets.core.client.wizards.WizardPage;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageStatusChangeEvent;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class ActionWorkItemSetFieldPluginTest {
    @Mock
    private NewGuidedDecisionTableColumnWizard wizard;
    @Mock
    private PatternWrapper patternWrapper;
    @Mock
    private BiConsumer<String, String> biConsumer;
    @Mock
    private GuidedDecisionTableView.Presenter presenter;
    @Mock
    private PatternPage patternPage;
    @Mock
    private FieldPage fieldPage;
    @Mock
    private AdditionalInfoPage additionalInfoPage;
    @Mock
    private WorkItemPage workItemPage;
    @Mock
    private ActionWorkItemWrapper editingWrapper;
    @Mock
    private TranslationService translationService;
    @Mock
    private AsyncPackageDataModelOracle oracle;
    @Mock
    private GuidedDecisionTable52 model;
    @Mock
    private EventSourceMock<WizardPageStatusChangeEvent> changeEvent;
    @InjectMocks
    private ActionWorkItemSetFieldPlugin plugin;

    public ActionWorkItemSetFieldPluginTest() {
        this.plugin = (ActionWorkItemSetFieldPlugin)Mockito.spy((Object)new ActionWorkItemSetFieldPlugin(this.patternPage, this.fieldPage, this.additionalInfoPage, this.workItemPage, this.changeEvent, this.translationService));
    }

    @Test
    public void testSetWorkItem() throws Exception {
        String workItemKey = "workItem";
        PortableWorkDefinition workDefinition = (PortableWorkDefinition)Mockito.mock(PortableWorkDefinition.class);
        PortableParameterDefinition parameterDefinition = (PortableParameterDefinition)Mockito.mock(PortableParameterDefinition.class);
        final ActionWorkItemSetFieldPlugin.WorkItemParameter parameter = (ActionWorkItemSetFieldPlugin.WorkItemParameter)Mockito.mock(ActionWorkItemSetFieldPlugin.WorkItemParameter.class);
        HashMap<String, ActionWorkItemSetFieldPlugin.WorkItemParameter> workItems = new HashMap<String, ActionWorkItemSetFieldPlugin.WorkItemParameter>(){
            {
                this.put("workItem", parameter);
            }
        };
        ArrayList<ActionInsertFactCol52> actions = new ArrayList<ActionInsertFactCol52>(){
            {
                this.add(Mockito.mock(ActionInsertFactCol52.class));
            }
        };
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)this.model).when((Object)this.presenter)).getModel();
        ((GuidedDecisionTable52)Mockito.doReturn((Object)actions).when((Object)this.model)).getActionCols();
        ((PortableWorkDefinition)Mockito.doReturn((Object)"workName").when((Object)workDefinition)).getName();
        ((PortableParameterDefinition)Mockito.doReturn((Object)"parameterName").when((Object)parameterDefinition)).getName();
        ((PortableParameterDefinition)Mockito.doReturn((Object)"parameterClassName").when((Object)parameterDefinition)).getClassName();
        ((ActionWorkItemSetFieldPlugin)Mockito.doReturn((Object)workItems).when((Object)this.plugin)).getWorkItems();
        ((ActionWorkItemSetFieldPlugin.WorkItemParameter)Mockito.doReturn((Object)workDefinition).when((Object)parameter)).getWorkDefinition();
        ((ActionWorkItemSetFieldPlugin.WorkItemParameter)Mockito.doReturn((Object)parameterDefinition).when((Object)parameter)).getWorkParameterDefinition();
        this.plugin.setWorkItem("workItem");
        Assert.assertEquals((Object)"workItem", (Object)this.plugin.getWorkItem());
        ((ActionWorkItemWrapper)Mockito.verify((Object)this.editingWrapper)).setWorkItemName("workName");
        ((ActionWorkItemWrapper)Mockito.verify((Object)this.editingWrapper)).setWorkItemResultParameterName("parameterName");
        ((ActionWorkItemWrapper)Mockito.verify((Object)this.editingWrapper)).setParameterClassName("parameterClassName");
        ((ActionWorkItemSetFieldPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.workItemPage);
    }

    @Test
    public void testEditingCol() throws Exception {
        ActionCol52 expectedAction = (ActionCol52)Mockito.mock(ActionCol52.class);
        ((ActionWorkItemWrapper)Mockito.doReturn((Object)expectedAction).when((Object)this.editingWrapper)).getActionCol52();
        ActionCol52 actualAction = this.plugin.editingCol();
        Assert.assertEquals((Object)expectedAction, (Object)actualAction);
    }

    @Test
    public void testIsWorkItemSetWhenItIsSet() throws Exception {
        this.plugin.setWorkItemPageAsCompleted();
        Boolean workItemSet = this.plugin.isWorkItemSet();
        Assert.assertTrue((boolean)workItemSet);
    }

    @Test
    public void testIsWorkItemSetWhenItIsNotSet() throws Exception {
        Boolean workItemSet = this.plugin.isWorkItemSet();
        Assert.assertFalse((boolean)workItemSet);
    }

    @Test
    public void testSetWorkItemPageAsCompletedWhenItIsCompleted() throws Exception {
        ((ActionWorkItemSetFieldPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isWorkItemPageCompleted();
        this.plugin.setWorkItemPageAsCompleted();
        ((ActionWorkItemSetFieldPlugin)Mockito.verify((Object)this.plugin, (VerificationMode)Mockito.never())).setWorkItemPageCompleted();
        ((ActionWorkItemSetFieldPlugin)Mockito.verify((Object)this.plugin, (VerificationMode)Mockito.never())).fireChangeEvent((WizardPage)this.workItemPage);
    }

    @Test
    public void testSetWorkItemPageAsCompletedWhenItIsNotCompleted() throws Exception {
        ((ActionWorkItemSetFieldPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).isWorkItemPageCompleted();
        this.plugin.setWorkItemPageAsCompleted();
        ((ActionWorkItemSetFieldPlugin)Mockito.verify((Object)this.plugin)).setWorkItemPageCompleted();
        ((ActionWorkItemSetFieldPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.workItemPage);
    }

    @Test
    public void testGetHeader() throws Exception {
        String expectedHeader = "header";
        ((ActionWorkItemWrapper)Mockito.doReturn((Object)"header").when((Object)this.editingWrapper)).getHeader();
        String actualHeader = this.plugin.getHeader();
        Assert.assertEquals((Object)"header", (Object)actualHeader);
    }

    @Test
    public void testSetHeader() throws Exception {
        String header = "header";
        this.plugin.setHeader("header");
        ((ActionWorkItemWrapper)Mockito.verify((Object)this.editingWrapper)).setHeader("header");
        ((ActionWorkItemSetFieldPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.additionalInfoPage);
    }

    @Test
    public void testSetInsertLogical() throws Exception {
        boolean isInsertLogical = false;
        this.plugin.setInsertLogical(Boolean.valueOf(false));
        ((ActionWorkItemWrapper)Mockito.verify((Object)this.editingWrapper)).setInsertLogical(false);
    }

    @Test
    public void testSetUpdate() throws Exception {
        boolean isUpdate = false;
        this.plugin.setUpdate(Boolean.valueOf(false));
        ((ActionWorkItemWrapper)Mockito.verify((Object)this.editingWrapper)).setUpdate(false);
    }

    @Test
    public void testGetTitle() {
        String errorKey = "ActionWorkItemSetFieldPlugin.SetValue";
        String errorMessage = "Title";
        Mockito.when((Object)this.translationService.format("ActionWorkItemSetFieldPlugin.SetValue", new Object[0])).thenReturn((Object)"Title");
        String title = this.plugin.getTitle();
        Assert.assertEquals((Object)"Title", (Object)title);
    }

    @Test
    public void testGetPages() throws Exception {
        Assert.assertEquals((long)4L, (long)this.plugin.getPages().size());
    }

    @Test
    public void testGenerateColumnWhenColumnIsNew() throws Exception {
        ActionCol52 actionCol52 = (ActionCol52)Mockito.mock(ActionCol52.class);
        String header = "header";
        ((ActionWorkItemSetFieldPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isNewColumn();
        ((ActionWorkItemWrapper)Mockito.doReturn((Object)"header").when((Object)this.editingWrapper)).getHeader();
        ((ActionWorkItemWrapper)Mockito.doReturn((Object)"factField").when((Object)this.editingWrapper)).getFactField();
        ((ActionWorkItemWrapper)Mockito.doReturn((Object)"factType").when((Object)this.editingWrapper)).getFactType();
        ((ActionWorkItemSetFieldPlugin)Mockito.doReturn((Object)this.editingWrapper).when((Object)this.plugin)).editingWrapper();
        ((ActionWorkItemWrapper)Mockito.doReturn((Object)actionCol52).when((Object)this.editingWrapper)).getActionCol52();
        Boolean success = this.plugin.generateColumn();
        Assert.assertTrue((boolean)success);
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)this.presenter)).appendColumn(actionCol52);
        ((TranslationService)Mockito.verify((Object)this.translationService, (VerificationMode)Mockito.never())).format((String)Mockito.any(), new Object[0]);
    }

    @Test
    public void testGenerateColumnWhenColumnIsNotNew() throws Exception {
        ActionCol52 editingColumn = (ActionCol52)Mockito.mock(ActionCol52.class);
        ActionCol52 originalColumn = (ActionCol52)Mockito.mock(ActionCol52.class);
        String header = "header";
        ((ActionWorkItemSetFieldPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).isNewColumn();
        ((ActionWorkItemWrapper)Mockito.doReturn((Object)"header").when((Object)this.editingWrapper)).getHeader();
        ((ActionWorkItemWrapper)Mockito.doReturn((Object)"factField").when((Object)this.editingWrapper)).getFactField();
        ((ActionWorkItemWrapper)Mockito.doReturn((Object)"factType2").when((Object)this.editingWrapper)).getFactType();
        ((ActionWorkItemSetFieldPlugin)Mockito.doReturn((Object)this.editingWrapper).when((Object)this.plugin)).editingWrapper();
        ((ActionWorkItemWrapper)Mockito.doReturn((Object)editingColumn).when((Object)this.editingWrapper)).getActionCol52();
        ((ActionWorkItemSetFieldPlugin)Mockito.doReturn((Object)originalColumn).when((Object)this.plugin)).getOriginalColumnConfig52();
        Boolean success = this.plugin.generateColumn();
        Assert.assertTrue((boolean)success);
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)this.presenter)).updateColumn(originalColumn, editingColumn);
        ((TranslationService)Mockito.verify((Object)this.translationService, (VerificationMode)Mockito.never())).format((String)Mockito.any(), new Object[0]);
    }

    @Test
    public void testGenerateColumnWhenColumnIsNotNewAndVetoed() throws Exception {
        ((ActionWorkItemSetFieldPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).isNewColumn();
        ((GuidedDecisionTableView.Presenter)Mockito.doThrow(ModelSynchronizer.VetoException.class).when((Object)this.presenter)).updateColumn((ActionCol52)Mockito.any(), (ActionCol52)Mockito.any());
        Assert.assertFalse((boolean)this.plugin.generateColumn());
        ((NewGuidedDecisionTableColumnWizard)Mockito.verify((Object)this.wizard)).showGenericVetoError();
    }

    @Test
    public void testSetEditingPattern() throws Exception {
        PatternWrapper patternWrapper = (PatternWrapper)Mockito.mock(PatternWrapper.class);
        this.plugin.setEditingPattern(patternWrapper);
        ((ActionWorkItemWrapper)Mockito.verify((Object)this.editingWrapper)).setFactField(null);
        ((ActionWorkItemWrapper)Mockito.verify((Object)this.editingWrapper)).setFactType(null);
        ((ActionWorkItemWrapper)Mockito.verify((Object)this.editingWrapper)).setBoundName(null);
        ((ActionWorkItemWrapper)Mockito.verify((Object)this.editingWrapper)).setType(null);
        ((ActionWorkItemSetFieldPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.patternPage);
        ((ActionWorkItemSetFieldPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.fieldPage);
        ((ActionWorkItemSetFieldPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.additionalInfoPage);
        Assert.assertEquals((Object)patternWrapper, (Object)this.plugin.patternWrapper());
    }

    @Test
    public void testGetPatternsWhenColumnIsNew() throws Exception {
        this.mockPatterns();
        ((ActionWorkItemSetFieldPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isNewColumn();
        Set patterns = this.plugin.getPatterns();
        Assert.assertEquals((long)2L, (long)patterns.size());
        Assert.assertTrue((boolean)patterns.contains(new PatternWrapper("factType", "boundName", Boolean.valueOf(true))));
        Assert.assertTrue((boolean)patterns.contains(new PatternWrapper("factType", "boundName")));
    }

    @Test
    public void testGetPatternsWhenColumnIsNotNewButFactPatternIsNew() throws Exception {
        this.mockPatterns();
        ((ActionWorkItemSetFieldPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).isNewColumn();
        ((ActionWorkItemSetFieldPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isNewFactPattern();
        Set patterns = this.plugin.getPatterns();
        Assert.assertEquals((long)1L, (long)patterns.size());
        Assert.assertTrue((boolean)patterns.contains(new PatternWrapper("factType", "boundName")));
    }

    @Test
    public void testGetPatternsWhenColumnAndFactPatternAreNotNew() throws Exception {
        this.mockPatterns();
        ((ActionWorkItemSetFieldPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).isNewColumn();
        ((ActionWorkItemSetFieldPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).isNewFactPattern();
        Set patterns = this.plugin.getPatterns();
        Assert.assertEquals((long)1L, (long)patterns.size());
    }

    @Test
    public void testConstraintValue() throws Exception {
        Assert.assertEquals((long)0L, (long)this.plugin.constraintValue());
    }

    @Test
    public void testGetAccessor() throws Exception {
        Assert.assertEquals((Object)FieldAccessorsAndMutators.ACCESSOR, (Object)this.plugin.getAccessor());
    }

    @Test
    public void testGetFactField() throws Exception {
        String expectedFactField = "factField";
        ((ActionWorkItemWrapper)Mockito.doReturn((Object)"factField").when((Object)this.editingWrapper)).getFactField();
        String actualFactField = this.plugin.getFactField();
        Assert.assertEquals((Object)"factField", (Object)actualFactField);
    }

    @Test
    public void testSetFactFieldWhenFactPattern() throws Exception {
        PatternWrapper patternWrapper = (PatternWrapper)Mockito.mock(PatternWrapper.class);
        String factField = "factField";
        String factType = "factType";
        String boundName = "boundName";
        String type = "type";
        ((PatternWrapper)Mockito.doReturn((Object)"factType").when((Object)patternWrapper)).getFactType();
        ((PatternWrapper)Mockito.doReturn((Object)"boundName").when((Object)patternWrapper)).getBoundName();
        ((GuidedDecisionTable52)Mockito.doReturn((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY).when((Object)this.model)).getTableFormat();
        ((ActionWorkItemSetFieldPlugin)Mockito.doReturn((Object)this.editingWrapper).when((Object)this.plugin)).editingWrapper();
        ((ActionWorkItemSetFieldPlugin)Mockito.doReturn((Object)patternWrapper).when((Object)this.plugin)).patternWrapper();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)this.model).when((Object)this.presenter)).getModel();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)this.oracle).when((Object)this.presenter)).getDataModelOracle();
        ((ActionWorkItemSetFieldPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isNewFactPattern();
        ((AsyncPackageDataModelOracle)Mockito.doReturn((Object)"type").when((Object)this.oracle)).getFieldType((String)Mockito.any(), (String)Mockito.any());
        this.plugin.setFactField("factField");
        ((ActionWorkItemWrapper)Mockito.verify((Object)this.editingWrapper)).setFactField("factField");
        ((ActionWorkItemWrapper)Mockito.verify((Object)this.editingWrapper)).setFactType("factType");
        ((ActionWorkItemWrapper)Mockito.verify((Object)this.editingWrapper)).setBoundName("boundName");
        ((ActionWorkItemWrapper)Mockito.verify((Object)this.editingWrapper)).setType("type");
        ((ActionWorkItemSetFieldPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.fieldPage);
    }

    @Test
    public void testShowUpdateEngineWithChangesWhenFactPatternIsNew() throws Exception {
        ((ActionWorkItemSetFieldPlugin)Mockito.doReturn((Object)Mockito.mock(ActionWorkItemInsertWrapper.class)).when((Object)this.plugin)).editingWrapper();
        boolean updateEngineWithChanges = this.plugin.showUpdateEngineWithChanges();
        Assert.assertFalse((boolean)updateEngineWithChanges);
    }

    @Test
    public void testShowUpdateEngineWithChangesWhenFactPatternIsNotNew() throws Exception {
        ((ActionWorkItemSetFieldPlugin)Mockito.doReturn((Object)Mockito.mock(ActionWorkItemSetWrapper.class)).when((Object)this.plugin)).editingWrapper();
        boolean updateEngineWithChanges = this.plugin.showUpdateEngineWithChanges();
        Assert.assertTrue((boolean)updateEngineWithChanges);
    }

    @Test
    public void testShowLogicallyInsertWhenFactPatternIsNew() throws Exception {
        ((ActionWorkItemSetFieldPlugin)Mockito.doReturn((Object)Mockito.mock(ActionWorkItemInsertWrapper.class)).when((Object)this.plugin)).editingWrapper();
        boolean logicallyInsert = this.plugin.showLogicallyInsert();
        Assert.assertTrue((boolean)logicallyInsert);
    }

    @Test
    public void testShowLogicallyInsertWhenFactPatternIsNotNew() throws Exception {
        ((ActionWorkItemSetFieldPlugin)Mockito.doReturn((Object)Mockito.mock(ActionWorkItemSetWrapper.class)).when((Object)this.plugin)).editingWrapper();
        boolean logicallyInsert = this.plugin.showLogicallyInsert();
        Assert.assertFalse((boolean)logicallyInsert);
    }

    @Test
    public void testInitializedPatternPage() throws Exception {
        this.plugin.initializedPatternPage();
        ((PatternPage)Mockito.verify((Object)this.patternPage)).disableEntryPoint();
        ((PatternPage)Mockito.verify((Object)this.patternPage)).disableNegatedPatterns();
    }

    @Test
    public void testInitializedAdditionalInfoPage() throws Exception {
        this.plugin.initializedAdditionalInfoPage();
        ((AdditionalInfoPage)Mockito.verify((Object)this.additionalInfoPage)).enableHeader();
        ((AdditionalInfoPage)Mockito.verify((Object)this.additionalInfoPage)).enableLogicallyInsert();
        ((AdditionalInfoPage)Mockito.verify((Object)this.additionalInfoPage)).enableUpdateEngineWithChanges();
        ((AdditionalInfoPage)Mockito.verify((Object)this.additionalInfoPage)).enableHideColumn();
    }

    @Test
    public void testGetAlreadyUsedColumnNames() throws Exception {
        GuidedDecisionTable52 model = new GuidedDecisionTable52();
        model.getActionCols().add(new ActionCol52(){
            {
                this.setHeader("a");
            }
        });
        model.getActionCols().add(new ActionCol52(){
            {
                this.setHeader("b");
            }
        });
        Mockito.when((Object)this.presenter.getModel()).thenReturn((Object)model);
        Assert.assertEquals((long)2L, (long)this.plugin.getAlreadyUsedColumnHeaders().size());
        Assert.assertTrue((boolean)this.plugin.getAlreadyUsedColumnHeaders().contains("a"));
        Assert.assertTrue((boolean)this.plugin.getAlreadyUsedColumnHeaders().contains("b"));
    }

    @Test
    @Ignore(value="Reproducer for: GUVNOR-3170")
    public void testForEachWorkItemStringField() throws Exception {
        this.setUpWorkItemDefinitions();
        Mockito.when((Object)this.oracle.getFieldClassName("Person", "factField")).thenReturn((Object)"java.lang.String");
        this.plugin.setupWorkItems();
        this.plugin.forEachWorkItem(this.biConsumer);
        ((BiConsumer)Mockito.verify(this.biConsumer, (VerificationMode)Mockito.times((int)2))).accept(Mockito.anyString(), Mockito.anyString());
        ((BiConsumer)Mockito.verify(this.biConsumer)).accept("StringWorkItemDisplayName - StringResult", "StringWorkItemName:StringResult");
        ((BiConsumer)Mockito.verify(this.biConsumer)).accept("FloatWorkItemDisplayName - FloatResult", "FloatWorkItemName:FloatResult");
    }

    @Test
    public void testForEachWorkItemFloatField() throws Exception {
        this.setUpWorkItemDefinitions();
        Mockito.when((Object)this.oracle.getFieldClassName("Person", "factField")).thenReturn((Object)"java.lang.Float");
        this.plugin.setupWorkItems();
        this.plugin.forEachWorkItem(this.biConsumer);
        ((BiConsumer)Mockito.verify(this.biConsumer, (VerificationMode)Mockito.times((int)1))).accept(Mockito.anyString(), Mockito.anyString());
        ((BiConsumer)Mockito.verify(this.biConsumer)).accept("FloatWorkItemDisplayName - FloatResult", "FloatWorkItemName:FloatResult");
    }

    @Test
    public void testNewActionWrapperWhenColumnIsAnActionWorkItemInsertFactCol52() throws Exception {
        Mockito.when((Object)this.model.getTableFormat()).thenReturn((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY);
        Mockito.when((Object)this.presenter.getModel()).thenReturn((Object)this.model);
        ActionWorkItemWrapper wrapper = this.plugin.newActionWorkItemWrapper((DTColumnConfig52)Mockito.mock(ActionWorkItemInsertFactCol52.class));
        Assert.assertTrue((boolean)(wrapper instanceof ActionWorkItemInsertWrapper));
    }

    @Test
    public void testNewActionWrapperWhenColumnIsAnActionSetFactWrapper() throws Exception {
        Mockito.when((Object)this.model.getTableFormat()).thenReturn((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY);
        Mockito.when((Object)this.presenter.getModel()).thenReturn((Object)this.model);
        ActionWorkItemWrapper wrapper = this.plugin.newActionWorkItemWrapper((DTColumnConfig52)Mockito.mock(ActionWorkItemSetFieldCol52.class));
        Assert.assertTrue((boolean)(wrapper instanceof ActionWorkItemSetWrapper));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testNewActionWrapperWhenColumnIsInvalid() throws Exception {
        Mockito.when((Object)this.model.getTableFormat()).thenReturn((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY);
        Mockito.when((Object)this.presenter.getModel()).thenReturn((Object)this.model);
        this.plugin.newActionWorkItemWrapper((DTColumnConfig52)Mockito.mock(ConditionCol52.class));
    }

    @Test
    public void testNewPatternWrapperWhenPatternIsFound() throws Exception {
        final PatternWrapper expectedWrapper = this.mockPatternWrapper("BoundName");
        HashSet<PatternWrapper> actionWrappers = new HashSet<PatternWrapper>(){
            {
                this.add(expectedWrapper);
            }
        };
        ((ActionWorkItemSetFieldPlugin)Mockito.doReturn((Object)actionWrappers).when((Object)this.plugin)).getPatterns();
        PatternWrapper actualWrapper = this.plugin.newPatternWrapper(this.mockActionWrapper("BoundName", "factType"));
        Assert.assertSame((Object)expectedWrapper, (Object)actualWrapper);
    }

    @Test
    public void testNewPatternWrapperWhenPatternIsNotFound() throws Exception {
        HashSet actionWrappers = new HashSet();
        ActionWorkItemWrapper actionWrapper = this.mockActionWrapper("BoundName", "FactType");
        ((ActionWorkItemSetFieldPlugin)Mockito.doReturn(actionWrappers).when((Object)this.plugin)).getPatterns();
        PatternWrapper patternWrapper = this.plugin.newPatternWrapper(actionWrapper);
        Assert.assertEquals((Object)actionWrapper.getBoundName(), (Object)patternWrapper.getBoundName());
        Assert.assertEquals((Object)actionWrapper.getFactType(), (Object)patternWrapper.getFactType());
    }

    @Test
    public void testSetupValuesWhenColumnIsNew() throws Exception {
        ((ActionWorkItemSetFieldPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isNewColumn();
        this.plugin.setupValues();
        ((ActionWorkItemSetFieldPlugin)Mockito.verify((Object)this.plugin, (VerificationMode)Mockito.never())).setWorkItemPageAsCompleted();
        ((ActionWorkItemSetFieldPlugin)Mockito.verify((Object)this.plugin, (VerificationMode)Mockito.never())).fireChangeEvent((WizardPage)this.patternPage);
        ((ActionWorkItemSetFieldPlugin)Mockito.verify((Object)this.plugin, (VerificationMode)Mockito.never())).fireChangeEvent((WizardPage)this.fieldPage);
        ((ActionWorkItemSetFieldPlugin)Mockito.verify((Object)this.plugin, (VerificationMode)Mockito.never())).fireChangeEvent((WizardPage)this.additionalInfoPage);
    }

    @Test
    public void testSetupValuesWhenColumnIsNotNew() throws Exception {
        DTColumnConfig52 column = (DTColumnConfig52)Mockito.mock(DTColumnConfig52.class);
        ActionWorkItemWrapper actionWrapper = (ActionWorkItemWrapper)Mockito.mock(ActionWorkItemWrapper.class);
        PatternWrapper patternWrapper = (PatternWrapper)Mockito.mock(PatternWrapper.class);
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)this.model).when((Object)this.presenter)).getModel();
        ((ActionWorkItemSetFieldPlugin)Mockito.doReturn((Object)column).when((Object)this.plugin)).getOriginalColumnConfig52();
        ((ActionWorkItemSetFieldPlugin)Mockito.doReturn((Object)actionWrapper).when((Object)this.plugin)).newActionWorkItemWrapper(column);
        ((ActionWorkItemSetFieldPlugin)Mockito.doReturn((Object)patternWrapper).when((Object)this.plugin)).newPatternWrapper(actionWrapper);
        ((ActionWorkItemWrapper)Mockito.doReturn((Object)"WorkItemName").when((Object)actionWrapper)).getWorkItemName();
        ((ActionWorkItemWrapper)Mockito.doReturn((Object)"WorkItemResultParameterName").when((Object)actionWrapper)).getWorkItemResultParameterName();
        ((GuidedDecisionTable52)Mockito.doReturn(new ArrayList()).when((Object)this.model)).getActionCols();
        ((ActionWorkItemSetFieldPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).isNewColumn();
        this.plugin.setupValues();
        ((ActionWorkItemSetFieldPlugin)Mockito.verify((Object)this.plugin)).setupWorkItems();
        ((ActionWorkItemSetFieldPlugin)Mockito.verify((Object)this.plugin)).setWorkItem("WorkItemName:WorkItemResultParameterName");
        ((ActionWorkItemSetFieldPlugin)Mockito.verify((Object)this.plugin)).setWorkItemPageAsCompleted();
        ((ActionWorkItemSetFieldPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.patternPage);
        ((ActionWorkItemSetFieldPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.fieldPage);
        ((ActionWorkItemSetFieldPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.additionalInfoPage);
    }

    @Test
    public void testIsHideColumn() {
        this.plugin.isHideColumn();
        ((ActionWorkItemWrapper)Mockito.verify((Object)this.editingWrapper)).isHideColumn();
    }

    @Test
    public void testSetHideColumn() throws Exception {
        boolean hideColumn = false;
        this.plugin.setHideColumn(false);
        ((ActionWorkItemWrapper)Mockito.verify((Object)this.editingWrapper)).setHideColumn(false);
    }

    @Test
    public void testIsNewFactPatternWhenIsNew() throws Exception {
        this.mockPatterns();
        this.plugin.setEditingPattern(new PatternWrapper("factType", "bananna"));
        Assert.assertTrue((boolean)this.plugin.isNewFactPattern());
    }

    @Test
    public void testIsNewFactPatternWhenIsExisting() throws Exception {
        this.mockPatterns();
        this.plugin.setEditingPattern(new PatternWrapper("factType", "boundName"));
        Assert.assertFalse((boolean)this.plugin.isNewFactPattern());
    }

    @Test
    public void testIsFieldBindingValid() {
        Assert.assertTrue((boolean)this.plugin.isFieldBindingValid());
    }

    @Test
    public void testIsBindable() {
        Assert.assertFalse((boolean)this.plugin.isBindable());
    }

    private ActionWorkItemWrapper mockActionWrapper(String boundName, String factType) {
        ActionWorkItemWrapper wrapper = (ActionWorkItemWrapper)Mockito.mock(ActionWorkItemWrapper.class);
        Mockito.when((Object)wrapper.getBoundName()).thenReturn((Object)boundName);
        Mockito.when((Object)wrapper.getFactType()).thenReturn((Object)factType);
        return wrapper;
    }

    private PatternWrapper mockPatternWrapper(String boundName) {
        PatternWrapper wrapper = (PatternWrapper)Mockito.mock(PatternWrapper.class);
        Mockito.when((Object)wrapper.getBoundName()).thenReturn((Object)boundName);
        return wrapper;
    }

    private void setUpWorkItemDefinitions() {
        Mockito.when((Object)this.patternWrapper.getFactType()).thenReturn((Object)"Person");
        Mockito.when((Object)this.plugin.patternWrapper()).thenReturn((Object)this.patternWrapper);
        Mockito.when((Object)this.editingWrapper.getFactField()).thenReturn((Object)"factField");
        Mockito.when((Object)this.presenter.getDataModelOracle()).thenReturn((Object)this.oracle);
        Mockito.when((Object)this.presenter.getModel()).thenReturn((Object)this.model);
        Mockito.when((Object)this.model.getActionCols()).thenReturn(Arrays.asList(this.firstFakeWorkItem(), this.secondFakeWorkItem()));
    }

    private ActionWorkItemCol52 firstFakeWorkItem() {
        ActionWorkItemCol52 workItemCol52 = new ActionWorkItemCol52();
        PortableWorkDefinition portableWorkDefinition = new PortableWorkDefinition();
        PortableStringParameterDefinition portableStringParameterDefinition = new PortableStringParameterDefinition();
        portableStringParameterDefinition.setName("StringResult");
        portableWorkDefinition.setResults(Collections.singleton(portableStringParameterDefinition));
        portableWorkDefinition.setName("StringWorkItemName");
        portableWorkDefinition.setDisplayName("StringWorkItemDisplayName");
        workItemCol52.setWorkItemDefinition(portableWorkDefinition);
        return workItemCol52;
    }

    private ActionWorkItemCol52 secondFakeWorkItem() {
        ActionWorkItemCol52 workItemCol52 = new ActionWorkItemCol52();
        PortableWorkDefinition portableWorkDefinition = new PortableWorkDefinition();
        PortableFloatParameterDefinition portableFloatParameterDefinition = new PortableFloatParameterDefinition();
        portableFloatParameterDefinition.setName("FloatResult");
        portableWorkDefinition.setResults(Collections.singleton(portableFloatParameterDefinition));
        portableWorkDefinition.setName("FloatWorkItemName");
        portableWorkDefinition.setDisplayName("FloatWorkItemDisplayName");
        workItemCol52.setWorkItemDefinition(portableWorkDefinition);
        return workItemCol52;
    }

    private void mockPatterns() {
        GuidedDecisionTable52 model = (GuidedDecisionTable52)Mockito.mock(GuidedDecisionTable52.class);
        List<Pattern52> patterns = Collections.singletonList(this.fakePattern());
        List<ActionCol52> actions = Arrays.asList(this.fakeActionCol(), this.fakeActionCol());
        Mockito.when((Object)model.getConditions()).thenReturn(patterns);
        Mockito.when((Object)model.getActionCols()).thenReturn(actions);
        Mockito.when((Object)this.presenter.getModel()).thenReturn((Object)model);
    }

    private Pattern52 fakePattern() {
        return new Pattern52(){
            {
                this.setFactType("factType");
                this.setBoundName("boundName");
                this.setNegated(true);
            }
        };
    }

    private ActionInsertFactCol52 fakeActionCol() {
        return new ActionWorkItemInsertFactCol52(){
            {
                this.setFactType("factType");
                this.setBoundName("boundName");
            }
        };
    }
}

