/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins;

import com.google.gwt.event.shared.EventBus;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import java.util.Collections;
import javax.enterprise.event.Event;
import org.drools.workbench.models.datamodel.rule.ActionFieldValue;
import org.drools.workbench.models.datamodel.rule.ActionInsertFact;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLRuleModel;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.DTColumnConfig52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.popovers.MockInstanceImpl;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.NewGuidedDecisionTableColumnWizard;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.AdditionalInfoPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.DefaultValuesPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.RuleModellerPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.SummaryPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.common.DecisionTablePopoverUtils;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.BRLActionColumnPlugin;
import org.drools.workbench.screens.guided.rule.client.editor.plugin.RuleModellerActionPlugin;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.widgets.core.client.wizards.WizardView;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
@WithClassesToStub(value={BRLRuleModel.class})
public class BRLActionColumnPluginChildColumnUpdateTest {
    @Mock
    private GuidedDecisionTableView.Presenter presenter;
    @Mock
    private GuidedDecisionTable52 model;
    @Mock
    private TranslationService translationService;
    private BRLActionColumnPlugin plugin;

    @Before
    public void setUp() throws Exception {
        this.plugin = new BRLActionColumnPlugin((RuleModellerPage)Mockito.mock(RuleModellerPage.class), (DefaultValuesPage)Mockito.mock(DefaultValuesPage.class), new MockInstanceImpl<Object>(Collections.singletonList(Mockito.mock(RuleModellerActionPlugin.class))), (AdditionalInfoPage)Mockito.mock(AdditionalInfoPage.class), (Event)Mockito.mock(EventSourceMock.class), (TranslationService)Mockito.mock(TranslationService.class));
    }

    @Test
    public void testChildColumnDefaultWhenNoTemplateKeys() throws Exception {
        this.initPlugin(this.getBrlActionColumnWithNoTemplateValues());
        Boolean success = this.plugin.generateColumn();
        Assert.assertTrue((boolean)success);
        Assert.assertNotNull((Object)((BRLActionVariableColumn)this.plugin.editingCol().getChildColumns().get(0)).getDefaultValue());
    }

    @Test
    public void testChildColumnDefaultValues() throws Exception {
        this.initPlugin(this.getBrlActionColumnWithTemplateValues());
        Boolean success = this.plugin.generateColumn();
        Assert.assertTrue((boolean)success);
        Assert.assertNull((Object)((BRLActionVariableColumn)this.plugin.editingCol().getChildColumns().get(0)).getDefaultValue());
        Assert.assertNull((Object)((BRLActionVariableColumn)this.plugin.editingCol().getChildColumns().get(1)).getDefaultValue());
    }

    @Test
    public void testChildColumnDefaultValuesValuesAdded() throws Exception {
        this.initPlugin(this.getBrlActionColumnWithTemplateValues());
        ((BRLActionVariableColumn)this.plugin.editingCol().getChildColumns().get(0)).setDefaultValue(new DTCellValue52("Hello"));
        Boolean success = this.plugin.generateColumn();
        Assert.assertTrue((boolean)success);
        Assert.assertEquals((Object)"Hello", (Object)((BRLActionVariableColumn)this.plugin.editingCol().getChildColumns().get(0)).getDefaultValue().getStringValue());
        Assert.assertNull((Object)((BRLActionVariableColumn)this.plugin.editingCol().getChildColumns().get(1)).getDefaultValue());
    }

    private void initPlugin(BRLActionColumn brlActionColumn) {
        this.plugin.setOriginalColumnConfig52((DTColumnConfig52)brlActionColumn);
        NewGuidedDecisionTableColumnWizard wizard = new NewGuidedDecisionTableColumnWizard((WizardView)Mockito.mock(WizardView.class), (SummaryPage)Mockito.mock(SummaryPage.class), this.translationService, (DecisionTablePopoverUtils)Mockito.mock(DecisionTablePopoverUtils.class));
        ((GuidedDecisionTable52)Mockito.doReturn((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY).when((Object)this.model)).getTableFormat();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)this.model).when((Object)this.presenter)).getModel();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)Mockito.mock(EventBus.class)).when((Object)this.presenter)).getEventBus();
        wizard.init(this.presenter);
        this.plugin.init(wizard);
    }

    private BRLActionColumn getBrlActionColumnWithTemplateValues() {
        BRLActionColumn brlActionColumn = new BRLActionColumn();
        ActionInsertFact actionInsertFact = new ActionInsertFact("Person");
        actionInsertFact.setBoundName("$a");
        ActionFieldValue afv1 = new ActionFieldValue("name", "$default", "String");
        afv1.setNature(7);
        actionInsertFact.addFieldValue(afv1);
        ActionFieldValue afv2 = new ActionFieldValue("age", "$default1", "String");
        afv2.setNature(7);
        actionInsertFact.addFieldValue(afv2);
        brlActionColumn.getDefinition().add(actionInsertFact);
        brlActionColumn.getChildColumns().add(new BRLActionVariableColumn("$default", "varName"));
        brlActionColumn.getChildColumns().add(new BRLActionVariableColumn("$default1", "varName"));
        return brlActionColumn;
    }

    private BRLActionColumn getBrlActionColumnWithNoTemplateValues() {
        BRLActionColumn brlActionColumn = new BRLActionColumn();
        ActionInsertFact actionInsertFact = new ActionInsertFact("Person");
        actionInsertFact.setBoundName("$a");
        ActionFieldValue afv1 = new ActionFieldValue("name", "Toni", "String");
        afv1.setNature(1);
        actionInsertFact.addFieldValue(afv1);
        ActionFieldValue afv2 = new ActionFieldValue("age", "12", "String");
        afv2.setNature(1);
        actionInsertFact.addFieldValue(afv2);
        brlActionColumn.getDefinition().add(actionInsertFact);
        BRLActionVariableColumn variableColumn = new BRLActionVariableColumn("", "varName");
        variableColumn.setDefaultValue(new DTCellValue52("test"));
        brlActionColumn.getChildColumns().add(variableColumn);
        return brlActionColumn;
    }
}

