/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import java.util.ArrayList;
import java.util.List;
import org.drools.workbench.models.datamodel.rule.IPattern;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLRuleModel;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTColumnConfig52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.LimitedEntryBRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.ModelSynchronizer;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.NewGuidedDecisionTableColumnWizard;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.AdditionalInfoPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.DefaultValuesPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.RuleModellerPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.BRLConditionColumnPlugin;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.widgets.core.client.wizards.WizardPage;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageStatusChangeEvent;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
@WithClassesToStub(value={BRLRuleModel.class})
public class BRLConditionColumnPluginTest {
    @Mock
    private RuleModellerPage ruleModellerPage;
    @Mock
    private AdditionalInfoPage additionalInfoPage;
    @Mock
    private EventSourceMock<WizardPageStatusChangeEvent> changeEvent;
    @Mock
    private GuidedDecisionTableView.Presenter presenter;
    @Mock
    private GuidedDecisionTable52 model;
    @Mock
    private TranslationService translationService;
    @Mock
    private BRLConditionColumn editingCol;
    @Mock
    private HandlerRegistration registration;
    @Mock
    private NewGuidedDecisionTableColumnWizard wizard;
    @InjectMocks
    private BRLConditionColumnPlugin plugin;

    public BRLConditionColumnPluginTest() {
        this.plugin = (BRLConditionColumnPlugin)Mockito.spy((Object)new BRLConditionColumnPlugin(this.ruleModellerPage, (DefaultValuesPage)Mockito.mock(DefaultValuesPage.class), this.additionalInfoPage, this.changeEvent, this.translationService));
    }

    @Before
    public void setup() {
        ((BRLConditionColumnPlugin)Mockito.doReturn((Object)this.presenter).when((Object)this.plugin)).getPresenter();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)this.model).when((Object)this.presenter)).getModel();
    }

    @Test
    public void testGetTitle() throws Exception {
        String errorKey = "BRLConditionColumnPlugin.AddConditionBRL";
        String errorMessage = "Title";
        Mockito.when((Object)this.translationService.format("BRLConditionColumnPlugin.AddConditionBRL", new Object[0])).thenReturn((Object)"Title");
        String title = this.plugin.getTitle();
        Assert.assertEquals((Object)"Title", (Object)title);
    }

    @Test
    public void testInit() throws Exception {
        ((BRLConditionColumnPlugin)Mockito.doReturn((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY).when((Object)this.plugin)).tableFormat();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)Mockito.mock(EventBus.class)).when((Object)this.presenter)).getEventBus();
        ((NewGuidedDecisionTableColumnWizard)Mockito.doReturn((Object)this.presenter).when((Object)this.wizard)).getPresenter();
        this.plugin.init(this.wizard);
        ((BRLConditionColumnPlugin)Mockito.verify((Object)this.plugin)).setupEditingCol();
        ((BRLConditionColumnPlugin)Mockito.verify((Object)this.plugin)).setupRuleModellerEvents();
    }

    @Test
    public void testGetPages() throws Exception {
        List pages = this.plugin.getPages();
        Assert.assertEquals((long)3L, (long)pages.size());
    }

    @Test
    public void testOnClose() throws Exception {
        this.plugin.onClose();
        ((BRLConditionColumnPlugin)Mockito.verify((Object)this.plugin)).teardownRuleModellerEvents();
    }

    @Test
    public void testGenerateColumnWhenTheColumnIsNew() throws Exception {
        String header = "header";
        ((BRLConditionColumnPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isNewColumn();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)this.model).when((Object)this.presenter)).getModel();
        ((BRLConditionColumn)Mockito.doReturn((Object)"header").when((Object)this.editingCol)).getHeader();
        Boolean success = this.plugin.generateColumn();
        Assert.assertTrue((boolean)success);
        ((BRLConditionColumnPlugin)Mockito.verify((Object)this.plugin)).setupDefinedVariables((RuleModel)Mockito.any());
        ((BRLConditionColumn)Mockito.verify((Object)this.editingCol)).setDefinition((List)Mockito.any());
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)this.presenter)).appendColumn((ConditionCol52)this.editingCol);
        ((TranslationService)Mockito.verify((Object)this.translationService, (VerificationMode)Mockito.never())).format((String)Mockito.any(), new Object[0]);
    }

    @Test
    public void testGenerateColumnVeto() throws Exception {
        ((BRLConditionColumnPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).isNewColumn();
        ((GuidedDecisionTableView.Presenter)Mockito.doThrow((Throwable[])new Throwable[]{new ModelSynchronizer.VetoException()}).when((Object)this.presenter)).updateColumn((ConditionCol52)Mockito.any(ConditionCol52.class), (ConditionCol52)Mockito.any(BRLConditionColumn.class));
        Boolean success = this.plugin.generateColumn();
        Assert.assertFalse((boolean)success);
        ((NewGuidedDecisionTableColumnWizard)Mockito.verify((Object)this.wizard)).showGenericVetoError();
    }

    @Test
    public void testGenerateColumnWhenTheColumnIsNotNew() throws Exception {
        ConditionCol52 col52 = (ConditionCol52)Mockito.mock(ConditionCol52.class);
        String header = "header";
        ((BRLConditionColumnPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).isNewColumn();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)this.model).when((Object)this.presenter)).getModel();
        ((BRLConditionColumn)Mockito.doReturn((Object)"header").when((Object)this.editingCol)).getHeader();
        ((BRLConditionColumnPlugin)Mockito.doReturn((Object)col52).when((Object)this.plugin)).getOriginalColumn();
        Boolean success = this.plugin.generateColumn();
        Assert.assertTrue((boolean)success);
        ((BRLConditionColumnPlugin)Mockito.verify((Object)this.plugin)).setupDefinedVariables((RuleModel)Mockito.any());
        ((BRLConditionColumn)Mockito.verify((Object)this.editingCol)).setDefinition((List)Mockito.any());
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)this.presenter)).updateColumn(col52, (ConditionCol52)this.editingCol);
        ((TranslationService)Mockito.verify((Object)this.translationService, (VerificationMode)Mockito.never())).format((String)Mockito.any(), new Object[0]);
    }

    @Test
    public void testGenerateColumnWhenColumnIsNotNewAndVetoed() throws Exception {
        ((BRLConditionColumnPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).isNewColumn();
        ((GuidedDecisionTableView.Presenter)Mockito.doThrow(ModelSynchronizer.VetoUpdatePatternInUseException.class).when((Object)this.presenter)).updateColumn((ConditionCol52)Mockito.any(BRLConditionColumn.class), (ConditionCol52)Mockito.any(BRLConditionColumn.class));
        Assert.assertFalse((boolean)this.plugin.generateColumn());
        ((NewGuidedDecisionTableColumnWizard)Mockito.verify((Object)this.wizard)).showPatternInUseError();
    }

    @Test
    public void testGetHeader() throws Exception {
        this.plugin.getHeader();
        ((BRLConditionColumn)Mockito.verify((Object)this.editingCol)).getHeader();
    }

    @Test
    public void testSetHeader() throws Exception {
        String header = "header";
        this.plugin.setHeader("header");
        ((BRLConditionColumn)Mockito.verify((Object)this.editingCol)).setHeader("header");
        ((BRLConditionColumnPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.additionalInfoPage);
    }

    @Test
    public void testGetRuleModel() throws Exception {
        Assert.assertNotNull((Object)this.plugin.getRuleModel());
    }

    @Test
    public void testSetRuleModellerPageAsCompletedWhenItIsCompleted() throws Exception {
        ((BRLConditionColumnPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isRuleModellerPageCompleted();
        this.plugin.setRuleModellerPageAsCompleted();
        ((BRLConditionColumnPlugin)Mockito.verify((Object)this.plugin, (VerificationMode)Mockito.never())).setRuleModellerPageCompleted();
        ((BRLConditionColumnPlugin)Mockito.verify((Object)this.plugin, (VerificationMode)Mockito.never())).fireChangeEvent((WizardPage)this.ruleModellerPage);
    }

    @Test
    public void testSetRuleModellerPageAsCompletedWhenItIsNotCompleted() throws Exception {
        ((BRLConditionColumnPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).isRuleModellerPageCompleted();
        this.plugin.setRuleModellerPageAsCompleted();
        ((BRLConditionColumnPlugin)Mockito.verify((Object)this.plugin)).setRuleModellerPageCompleted();
        ((BRLConditionColumnPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.ruleModellerPage);
    }

    @Test
    public void testTableFormat() throws Exception {
        GuidedDecisionTable52.TableFormat expectedTableFormat = GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY;
        ((GuidedDecisionTable52)Mockito.doReturn((Object)expectedTableFormat).when((Object)this.model)).getTableFormat();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)this.model).when((Object)this.presenter)).getModel();
        GuidedDecisionTable52.TableFormat actualTableFormat = this.plugin.tableFormat();
        Assert.assertEquals((Object)expectedTableFormat, (Object)actualTableFormat);
    }

    @Test
    public void testGetAlreadyUsedColumnNames() throws Exception {
        GuidedDecisionTable52 model = new GuidedDecisionTable52();
        Pattern52 pattern = new Pattern52();
        ConditionCol52 conditionOne = new ConditionCol52(){
            {
                this.setHeader("a");
            }
        };
        ConditionCol52 conditionTwo = new ConditionCol52(){
            {
                this.setHeader("b");
            }
        };
        pattern.getChildColumns().add(conditionOne);
        pattern.getChildColumns().add(conditionTwo);
        model.getConditions().add(pattern);
        Mockito.when((Object)this.presenter.getModel()).thenReturn((Object)model);
        Assert.assertEquals((long)2L, (long)this.plugin.getAlreadyUsedColumnHeaders().size());
        Assert.assertTrue((boolean)this.plugin.getAlreadyUsedColumnHeaders().contains("a"));
        Assert.assertTrue((boolean)this.plugin.getAlreadyUsedColumnHeaders().contains("b"));
    }

    @Test
    public void testGetRuleModellerDescription() throws Exception {
        this.plugin.getRuleModellerDescription();
        ((TranslationService)Mockito.verify((Object)this.translationService, (VerificationMode)Mockito.never())).format("RuleModellerPage.InsertAnActionBRLFragment", new Object[0]);
        ((TranslationService)Mockito.verify((Object)this.translationService)).format("RuleModellerPage.InsertAConditionBRLFragment", new Object[0]);
    }

    @Test
    public void testCloneWhenColumnIsALimitedEntryBRLConditionColumn() throws Exception {
        ArrayList<IPattern> definition = new ArrayList<IPattern>();
        boolean hideColumn = false;
        LimitedEntryBRLConditionColumn column = this.makeLimitedEntryBRLConditionColumn("header", false, definition);
        BRLConditionColumn clone = this.plugin.clone((DTColumnConfig52)column);
        Assert.assertEquals((Object)column.getHeader(), (Object)clone.getHeader());
        Assert.assertEquals((Object)column.isHideColumn(), (Object)clone.isHideColumn());
        Assert.assertEquals((Object)column.getDefinition(), (Object)clone.getDefinition());
        Assert.assertNotSame((Object)column, (Object)clone);
        Assert.assertTrue((boolean)clone.getChildColumns().isEmpty());
    }

    @Test
    public void testCloneWhenColumnIsABRLConditionColumn() throws Exception {
        ((GuidedDecisionTable52)Mockito.doReturn((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY).when((Object)this.model)).getTableFormat();
        ArrayList<IPattern> definition = new ArrayList<IPattern>();
        Boolean hideColumn = false;
        ArrayList<BRLConditionVariableColumn> childColumns = new ArrayList<BRLConditionVariableColumn>(){
            {
                this.add(Mockito.mock(BRLConditionVariableColumn.class));
            }
        };
        BRLConditionColumn column = this.makeBRLConditionColumn("header", hideColumn, definition, (List<BRLConditionVariableColumn>)childColumns);
        BRLConditionColumn clone = this.plugin.clone((DTColumnConfig52)column);
        Assert.assertEquals((Object)column.getHeader(), (Object)clone.getHeader());
        Assert.assertEquals((Object)column.isHideColumn(), (Object)clone.isHideColumn());
        Assert.assertEquals((Object)column.getDefinition(), (Object)clone.getDefinition());
        Assert.assertNotSame((Object)column, (Object)clone);
        Assert.assertFalse((boolean)clone.getChildColumns().isEmpty());
    }

    @Test
    public void testCloneVariables() throws Exception {
        ((GuidedDecisionTable52)Mockito.doReturn((Object)GuidedDecisionTable52.TableFormat.LIMITED_ENTRY).when((Object)this.model)).getTableFormat();
        ArrayList<BRLConditionVariableColumn> variables = new ArrayList<BRLConditionVariableColumn>(){
            {
                this.add(Mockito.mock(BRLConditionVariableColumn.class));
                this.add(Mockito.mock(BRLConditionVariableColumn.class));
                this.add(Mockito.mock(BRLConditionVariableColumn.class));
            }
        };
        List clones = this.plugin.cloneVariables((List)variables);
        Assert.assertEquals((long)3L, (long)clones.size());
        ((BRLConditionColumnPlugin)Mockito.verify((Object)this.plugin, (VerificationMode)Mockito.times((int)3))).cloneVariable((BRLConditionVariableColumn)Mockito.any(BRLConditionVariableColumn.class));
    }

    @Test
    public void testCloneVariable() throws Exception {
        BRLConditionVariableColumn variable = this.makeVariable("variableName", "variableFieldType", "variableFactType", "variableFactField", "variableHeader", false, 999);
        BRLConditionVariableColumn clone = this.plugin.cloneVariable(variable);
        Assert.assertEquals((Object)variable.getVarName(), (Object)clone.getVarName());
        Assert.assertEquals((Object)variable.getFieldType(), (Object)clone.getFieldType());
        Assert.assertEquals((Object)variable.getFactType(), (Object)clone.getFactType());
        Assert.assertEquals((Object)variable.getFactField(), (Object)clone.getFactField());
        Assert.assertEquals((Object)variable.getHeader(), (Object)clone.getHeader());
        Assert.assertEquals((Object)variable.isHideColumn(), (Object)clone.isHideColumn());
        Assert.assertEquals((long)variable.getWidth(), (long)clone.getWidth());
        Assert.assertNotSame((Object)variable, (Object)clone);
    }

    @Test
    public void testIsHideColumn() {
        this.plugin.isHideColumn();
        ((BRLConditionColumn)Mockito.verify((Object)this.editingCol)).isHideColumn();
    }

    @Test
    public void testSetHideColumn() throws Exception {
        boolean hideColumn = false;
        this.plugin.setHideColumn(false);
        ((BRLConditionColumn)Mockito.verify((Object)this.editingCol)).setHideColumn(false);
    }

    private LimitedEntryBRLConditionColumn makeLimitedEntryBRLConditionColumn(String header, boolean hideColumn, List<IPattern> definition) {
        LimitedEntryBRLConditionColumn column = new LimitedEntryBRLConditionColumn();
        column.setHeader(header);
        column.setHideColumn(hideColumn);
        column.setDefinition(definition);
        return column;
    }

    private BRLConditionColumn makeBRLConditionColumn(String header, boolean hideColumn, List<IPattern> definition, List<BRLConditionVariableColumn> childColumns) {
        BRLConditionColumn column = new BRLConditionColumn();
        column.setHeader(header);
        column.setHideColumn(hideColumn);
        column.setDefinition(definition);
        column.setChildColumns(childColumns);
        return column;
    }

    private BRLConditionVariableColumn makeVariable(String variableName, String variableFieldType, String variableFactType, String variableFactField, String variableHeader, boolean hideColumn, int width) {
        BRLConditionVariableColumn clone = new BRLConditionVariableColumn(variableName, variableFieldType, variableFactType, variableFactField);
        clone.setHeader(variableHeader);
        clone.setHideColumn(hideColumn);
        clone.setWidth(width);
        return clone;
    }
}

