/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis;

import java.util.ArrayList;
import java.util.List;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.DTableUpdateManager;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.services.verifier.reporting.client.analysis.VerifierWebWorkerConnection;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.data.Coordinate;

public class DecisionTableAnalyzer
implements org.kie.workbench.common.services.verifier.reporting.client.analysis.DecisionTableAnalyzer<BaseColumn> {
    private final DTableUpdateManager updateManager;
    private final VerifierWebWorkerConnection analyzer;
    private final GuidedDecisionTable52 model;
    private final EventManager eventManager = new EventManager();

    public DecisionTableAnalyzer(GuidedDecisionTable52 model, DTableUpdateManager updateManager, VerifierWebWorkerConnection connection) {
        this.model = (GuidedDecisionTable52)PortablePreconditions.checkNotNull((String)"model", (Object)model);
        this.updateManager = (DTableUpdateManager)PortablePreconditions.checkNotNull((String)"updateManager", (Object)updateManager);
        this.analyzer = (VerifierWebWorkerConnection)PortablePreconditions.checkNotNull((String)"connection", (Object)connection);
    }

    public void analyze(List<Coordinate> updates) {
        this.updateManager.update(this.model, this.convert(updates));
    }

    private List<org.drools.workbench.services.verifier.plugin.client.Coordinate> convert(List<Coordinate> updates) {
        ArrayList<org.drools.workbench.services.verifier.plugin.client.Coordinate> result = new ArrayList<org.drools.workbench.services.verifier.plugin.client.Coordinate>();
        for (Coordinate coordinate : updates) {
            result.add(new org.drools.workbench.services.verifier.plugin.client.Coordinate(coordinate.getRow(), coordinate.getCol()));
        }
        return result;
    }

    public void deleteColumns(int firstColumnIndex, int numberOfColumns) {
        this.updateManager.deleteColumns(firstColumnIndex, numberOfColumns);
    }

    public void insertColumn(BaseColumn baseColumn) {
        this.updateManager.newColumn(this.model, this.getColumnIndex(baseColumn));
    }

    private int getColumnIndex(BaseColumn baseColumn) {
        List cols = this.model.getExpandedColumns();
        int indexOf = cols.indexOf(baseColumn);
        if (indexOf < 0) {
            if (baseColumn instanceof BRLConditionColumn) {
                for (BaseColumn column : this.model.getExpandedColumns()) {
                    if (!(column instanceof BRLConditionVariableColumn) || !((BRLConditionColumn)baseColumn).getChildColumns().contains(column)) continue;
                    return this.model.getExpandedColumns().indexOf(column);
                }
                throw new IllegalArgumentException("Could not find BRLConditionColumn: " + baseColumn.toString());
            }
            if (baseColumn instanceof BRLActionColumn) {
                for (BaseColumn column : this.model.getExpandedColumns()) {
                    if (!(column instanceof BRLActionVariableColumn) || !((BRLActionColumn)baseColumn).getChildColumns().contains(column)) continue;
                    return this.model.getExpandedColumns().indexOf(column);
                }
                throw new IllegalArgumentException("Could not find BRLActionColumn: " + baseColumn.toString());
            }
            if (baseColumn instanceof BRLVariableColumn) {
                return this.model.getExpandedColumns().indexOf(this.model.getBRLColumn((BRLVariableColumn)baseColumn));
            }
            throw new IllegalArgumentException("Could not find baseColumn: " + baseColumn.toString());
        }
        return indexOf;
    }

    public void updateColumns(int amountOfRows) {
        if (this.eventManager.rowDeleted != null) {
            this.updateManager.removeRule(this.eventManager.rowDeleted);
        } else {
            this.updateManager.makeRule(this.model, this.eventManager.getNewIndex());
        }
        this.eventManager.clear();
    }

    public void sort(List<Integer> rowOrder) {
        this.updateManager.sort(rowOrder);
    }

    public void deleteRow(int index) {
        this.eventManager.rowDeleted = index;
    }

    public void appendRow() {
        this.eventManager.rowAppended = true;
    }

    public void insertRow(int index) {
        this.eventManager.rowInserted = index;
    }

    public void activate() {
        this.analyzer.activate();
    }

    public void terminate() {
        this.analyzer.terminate();
    }

    class EventManager {
        boolean rowAppended = false;
        Integer rowInserted = null;
        Integer rowDeleted = null;

        EventManager() {
        }

        public void clear() {
            this.rowAppended = false;
            this.rowInserted = null;
            this.rowDeleted = null;
        }

        int getNewIndex() {
            if (((DecisionTableAnalyzer)DecisionTableAnalyzer.this).eventManager.rowAppended) {
                return DecisionTableAnalyzer.this.model.getData().size() - 1;
            }
            if (((DecisionTableAnalyzer)DecisionTableAnalyzer.this).eventManager.rowInserted != null) {
                return ((DecisionTableAnalyzer)DecisionTableAnalyzer.this).eventManager.rowInserted;
            }
            throw new IllegalStateException("There are no active updates");
        }
    }
}

