/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GridRowComparator;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.ModelSynchronizer;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;

public class TableSortComparator {
    private Optional<Integer> lastSorted = Optional.empty();

    public List<Integer> sort(List<GridRow> rows, GridColumn gridColumn) throws ModelSynchronizer.VetoException {
        if (this.lastSorted.isPresent() && this.lastSorted.get().intValue() == gridColumn.hashCode()) {
            Collections.reverse(rows);
            this.lastSorted = Optional.empty();
        } else {
            try {
                Collections.sort(rows, new GridRowComparator(gridColumn));
                this.lastSorted = Optional.of(gridColumn.hashCode());
            }
            catch (IllegalArgumentException e) {
                throw new ModelSynchronizer.VetoException();
            }
        }
        return this.listRowNumbersByNewOrder(rows);
    }

    private ArrayList<Integer> listRowNumbersByNewOrder(List<GridRow> rows) {
        ArrayList<Integer> rowNumbers = new ArrayList<Integer>();
        for (GridRow row : rows) {
            rowNumbers.add((Integer)((GridCell)row.getCells().get(0)).getValue().getValue() - 1);
        }
        return rowNumbers;
    }
}

