/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.editor.menu;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.BaseMenu;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.DecisionTableSelectedEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.DecisionTableSelectionsChangedEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.RefreshMenusEvent;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.NewGuidedDecisionTableColumnWizard;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.uberfire.ext.widgets.common.client.menu.MenuItemFactory;
import org.uberfire.ext.widgets.common.client.menu.MenuItemWithIconView;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;

@Dependent
public class InsertMenuBuilder
extends BaseMenu
implements MenuFactory.CustomMenuBuilder {
    MenuItemFactory.MenuItemViewHolder<MenuItemWithIconView> miAppendRow;
    MenuItemFactory.MenuItemViewHolder<MenuItemWithIconView> miInsertRowAbove;
    MenuItemFactory.MenuItemViewHolder<MenuItemWithIconView> miInsertRowBelow;
    MenuItemFactory.MenuItemViewHolder<MenuItemWithIconView> miInsertColumn;
    private TranslationService ts;
    private MenuItemFactory menuItemFactory;
    private ManagedInstance<NewGuidedDecisionTableColumnWizard> wizardManagedInstance;
    private GuidedDecisionTableModellerView.Presenter modeller;

    @Inject
    public InsertMenuBuilder(TranslationService ts, MenuItemFactory menuItemFactory, ManagedInstance<NewGuidedDecisionTableColumnWizard> wizardManagedInstance) {
        this.ts = ts;
        this.menuItemFactory = menuItemFactory;
        this.wizardManagedInstance = wizardManagedInstance;
    }

    @PostConstruct
    public void setup() {
        this.miAppendRow = this.menuItemFactory.makeMenuItemWithIcon(this.ts.getTranslation("InsertMenu.appendRow"), this::onAppendRow);
        this.miInsertRowAbove = this.menuItemFactory.makeMenuItemWithIcon(this.ts.getTranslation("InsertMenu.insertRowAbove"), this::onInsertRowAbove);
        this.miInsertRowBelow = this.menuItemFactory.makeMenuItemWithIcon(this.ts.getTranslation("InsertMenu.insertRowBelow"), this::onInsertRowBelow);
        this.miInsertColumn = this.menuItemFactory.makeMenuItemWithIcon(this.ts.getTranslation("InsertMenu.insertColumn"), this::onAppendColumn);
    }

    public void push(MenuFactory.CustomMenuBuilder element) {
    }

    public MenuItem build() {
        return (MenuItem)((MenuFactory.TopLevelMenusBuilder)MenuFactory.newTopLevelMenu((String)this.ts.getTranslation("InsertMenu.title")).withItems(this.getEditMenuItems()).endMenu()).build().getItems().get(0);
    }

    List<MenuItem> getEditMenuItems() {
        ArrayList<MenuItem> menuItems = new ArrayList<MenuItem>();
        menuItems.add(this.miAppendRow.getMenuItem());
        menuItems.add(this.miInsertRowAbove.getMenuItem());
        menuItems.add(this.miInsertRowBelow.getMenuItem());
        menuItems.add(this.miInsertColumn.getMenuItem());
        return menuItems;
    }

    @Override
    public void onDecisionTableSelectedEvent(@Observes DecisionTableSelectedEvent event) {
        super.onDecisionTableSelectedEvent(event);
    }

    @Override
    public void onDecisionTableSelectionsChangedEvent(@Observes DecisionTableSelectionsChangedEvent event) {
        super.onDecisionTableSelectionsChangedEvent(event);
    }

    @Override
    public void onRefreshMenusEvent(@Observes RefreshMenusEvent event) {
        super.onRefreshMenusEvent(event);
    }

    @Override
    public void initialise() {
        if (this.activeDecisionTable == null || !this.activeDecisionTable.getAccess().isEditable()) {
            this.enableMenuItemsForAppendingRows(false);
            this.enableMenuItemsForAppendingColumns(false);
            this.enableMenuItemsForInsertingRows(false);
            return;
        }
        List selections = this.activeDecisionTable.getView().getModel().getSelectedCells();
        if (selections == null || selections.isEmpty()) {
            this.enableMenuItemsForAppendingRows(true);
            this.enableMenuItemsForInsertingRows(false);
            this.enableMenuItemsForAppendingColumns(this.activeDecisionTable.hasEditableColumns());
            return;
        }
        HashMap<Integer, Boolean> rowUsage = new HashMap<Integer, Boolean>();
        for (GridData.SelectedCell sc : selections) {
            rowUsage.put(sc.getRowIndex(), true);
        }
        this.enableMenuItemsForAppendingRows(true);
        this.enableMenuItemsForAppendingColumns(this.activeDecisionTable.hasEditableColumns());
        this.enableMenuItemsForInsertingRows(rowUsage.keySet().size() == 1);
    }

    void onAppendRow() {
        if (this.activeDecisionTable != null) {
            this.activeDecisionTable.onAppendRow();
        }
    }

    void onInsertRowAbove() {
        if (this.activeDecisionTable != null) {
            this.activeDecisionTable.onInsertRowAbove();
        }
    }

    void onInsertRowBelow() {
        if (this.activeDecisionTable != null) {
            this.activeDecisionTable.onInsertRowBelow();
        }
    }

    void onAppendColumn() {
        Optional<GuidedDecisionTableModellerView.Presenter> modeller = Optional.ofNullable(this.getModeller());
        if (modeller.isPresent()) {
            this.openNewGuidedDecisionTableColumnWizard(modeller.get());
        }
    }

    GuidedDecisionTableModellerView.Presenter getModeller() {
        return this.modeller;
    }

    public void setModeller(GuidedDecisionTableModellerView.Presenter modeller) {
        this.modeller = modeller;
    }

    void openNewGuidedDecisionTableColumnWizard(GuidedDecisionTableModellerView.Presenter modeller) {
        NewGuidedDecisionTableColumnWizard wizard = (NewGuidedDecisionTableColumnWizard)((Object)this.wizardManagedInstance.get());
        Optional<GuidedDecisionTableView.Presenter> activeDecisionTable = modeller.getActiveDecisionTable();
        activeDecisionTable.ifPresent(dt -> {
            wizard.init((GuidedDecisionTableView.Presenter)dt);
            wizard.start();
        });
    }

    private void enableMenuItemsForAppendingRows(boolean enabled) {
        this.miAppendRow.getMenuItem().setEnabled(enabled);
    }

    private void enableMenuItemsForAppendingColumns(boolean enabled) {
        this.miInsertColumn.getMenuItem().setEnabled(enabled);
    }

    private void enableMenuItemsForInsertingRows(boolean enabled) {
        this.miInsertRowAbove.getMenuItem().setEnabled(enabled);
        this.miInsertRowBelow.getMenuItem().setEnabled(enabled);
    }

    public static interface SupportsInsertRowBelow {
        public void onInsertRowBelow();
    }

    public static interface SupportsInsertRowAbove {
        public void onInsertRowAbove();
    }

    public static interface SupportsAppendRow {
        public void onAppendRow();
    }
}

