/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.auditlog;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.HasKeyboardPagingPolicy;
import com.google.gwt.user.cellview.client.HasKeyboardSelectionPolicy;
import com.google.gwt.user.cellview.client.SimplePager;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ListDataProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.drools.workbench.models.datamodel.auditlog.AuditLog;
import org.drools.workbench.models.datamodel.auditlog.AuditLogEntry;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.GuidedDecisionTableConstants;
import org.drools.workbench.screens.guided.dtable.client.widget.auditlog.AuditLogEntryCellHelper;
import org.drools.workbench.screens.guided.dtable.client.widget.auditlog.AuditLogEntryCommentColumn;
import org.drools.workbench.screens.guided.dtable.client.widget.auditlog.AuditLogEntryDeleteCommentColumn;
import org.drools.workbench.screens.guided.dtable.client.widget.auditlog.AuditLogEntrySummaryColumn;
import org.drools.workbench.screens.guided.dtable.client.widget.auditlog.AuditLogView;
import org.guvnor.common.services.shared.security.AppRoles;
import org.gwtbootstrap3.client.ui.CheckBox;
import org.gwtbootstrap3.client.ui.Label;
import org.gwtbootstrap3.client.ui.Pagination;
import org.gwtbootstrap3.client.ui.Row;
import org.gwtbootstrap3.client.ui.constants.ColumnSize;
import org.gwtbootstrap3.client.ui.constants.ModalBackdrop;
import org.gwtbootstrap3.client.ui.gwt.CellTable;
import org.jboss.errai.security.shared.api.RoleImpl;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.footers.ModalFooterOKButton;

public class AuditLogViewImpl
extends BaseModal
implements AuditLogView {
    private final AuditLog auditLog;
    private static final int PAGE_SIZE = 4;
    @UiField
    Row eventTypes;
    @UiField
    Row eventsContainer;
    @UiField
    Pagination cellTablePagination;
    private SimplePager pager = new SimplePager();
    private CellTable<AuditLogEntry> events;
    private ListDataProvider<AuditLogEntry> dlp;
    @UiField
    AuditLogStyle style;
    private final User identity;
    private static AuditLogViewImplBinder uiBinder = (AuditLogViewImplBinder)GWT.create(AuditLogViewImplBinder.class);

    public AuditLogViewImpl(AuditLog auditLog, User identity) {
        this.auditLog = auditLog;
        this.identity = identity;
        this.setTitle(GuidedDecisionTableConstants.INSTANCE.DecisionTableAuditLog());
        this.setDataBackdrop(ModalBackdrop.STATIC);
        this.setDataKeyboard(true);
        this.setFade(true);
        this.setRemoveOnHide(true);
        this.setWidth("1000px");
        this.setBody((Widget)uiBinder.createAndBindUi(this));
        this.add((Widget)new ModalFooterOKButton(() -> ((AuditLogViewImpl)this).hide()));
        this.setup();
    }

    @Override
    public void show() {
        this.refreshDataProvider();
        super.show();
    }

    void refreshDataProvider() {
        this.dlp.setList(this.filterDeletedEntries((List<AuditLogEntry>)this.auditLog));
    }

    public void setup() {
        this.eventTypes.setStyleName("row");
        for (Map.Entry e : this.auditLog.getAuditLogFilter().getAcceptedTypes().entrySet()) {
            this.eventTypes.add(this.makeEventTypeCheckBox((String)e.getKey(), (Boolean)e.getValue()));
        }
        this.events = new CellTable();
        this.events.setWidth("100%");
        this.events.addStyleName("table");
        this.dlp = new ListDataProvider<AuditLogEntry>(){

            public void setList(List<AuditLogEntry> listToWrap) {
                super.setList(listToWrap);
                AuditLogViewImpl.this.cellTablePagination.rebuild(AuditLogViewImpl.this.pager);
            }
        };
        this.dlp.addDataDisplay(this.events);
        AuditLogEntrySummaryColumn summaryColumn = new AuditLogEntrySummaryColumn(this.style.auditLogDetailLabel(), this.style.auditLogDetailValue());
        AuditLogEntryCommentColumn commentColumn = new AuditLogEntryCommentColumn();
        this.events.addColumn((Column)summaryColumn);
        this.events.addColumn((Column)commentColumn);
        this.events.setColumnWidth((Column)summaryColumn, 60.0, Style.Unit.PCT);
        this.events.setColumnWidth((Column)commentColumn, 40.0, Style.Unit.PCT);
        if (this.identity.getRoles().contains(new RoleImpl(AppRoles.ADMIN.getName()))) {
            AuditLogEntryDeleteCommentColumn deleteCommentColumn = new AuditLogEntryDeleteCommentColumn();
            deleteCommentColumn.setFieldUpdater((index, row, value) -> {
                row.setDeleted(true);
                this.dlp.setList(this.filterDeletedEntries((List<AuditLogEntry>)this.auditLog));
                this.dlp.refresh();
            });
            this.events.addColumn((Column)deleteCommentColumn);
            this.events.setColumnWidth((Column)commentColumn, 35.0, Style.Unit.PCT);
            this.events.setColumnWidth((Column)deleteCommentColumn, 5.0, Style.Unit.PCT);
        }
        this.events.setEmptyTableWidget((Widget)new Label(GuidedDecisionTableConstants.INSTANCE.DecisionTableAuditLogNoEntries()));
        this.events.setKeyboardPagingPolicy(HasKeyboardPagingPolicy.KeyboardPagingPolicy.CHANGE_PAGE);
        this.events.setKeyboardSelectionPolicy(HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.DISABLED);
        this.events.setPageSize(4);
        this.pager.setDisplay(this.events);
        this.pager.setPageSize(4);
        this.eventsContainer.add(this.events);
    }

    private Widget makeEventTypeCheckBox(String eventType, Boolean isEnabled) {
        final CheckBox chkEventType = new CheckBox(AuditLogEntryCellHelper.getEventTypeDisplayText(eventType));
        chkEventType.setValue(Boolean.valueOf(Boolean.TRUE.equals(isEnabled)));
        chkEventType.addValueChangeHandler(event -> this.auditLog.getAuditLogFilter().getAcceptedTypes().put(eventType, (Boolean)event.getValue()));
        chkEventType.setWordWrap(false);
        return new org.gwtbootstrap3.client.ui.Column(ColumnSize.MD_2, new ColumnSize[0]){
            {
                super(firstSize, otherSizes);
                this.add((Widget)chkEventType);
            }
        };
    }

    private List<AuditLogEntry> filterDeletedEntries(List<AuditLogEntry> entries) {
        if (!this.identity.getRoles().contains(new RoleImpl(AppRoles.ADMIN.getName()))) {
            return entries;
        }
        ArrayList<AuditLogEntry> filteredEntries = new ArrayList<AuditLogEntry>();
        for (AuditLogEntry entry : entries) {
            if (entry.isDeleted()) continue;
            filteredEntries.add(entry);
        }
        return filteredEntries;
    }

    static interface AuditLogViewImplBinder
    extends UiBinder<Widget, AuditLogViewImpl> {
    }

    public static interface AuditLogStyle
    extends CssResource {
        public String eventTypesTitle();

        public String eventsContainerInline();

        public String auditLogDetailLabel();

        public String auditLogDetailValue();
    }
}

