/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.impl;

import java.util.Collections;
import java.util.List;
import java.util.OptionalInt;
import javax.enterprise.context.Dependent;
import org.drools.workbench.models.guided.dtable.shared.model.ActionSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumnFieldDiff;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumnFieldDiffImpl;
import org.drools.workbench.models.guided.dtable.shared.model.LimitedEntryCol;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.ModelSynchronizer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.Synchronizer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.impl.ActionColumnSynchronizer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.impl.BaseColumnSynchronizer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.impl.BaseSynchronizer;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;

@Dependent
public class ActionSetFieldColumnSynchronizer
extends ActionColumnSynchronizer {
    @Override
    public int priority() {
        return 1;
    }

    @Override
    public boolean handlesAppend(Synchronizer.MetaData metaData) throws ModelSynchronizer.VetoException {
        return this.handlesUpdate(metaData);
    }

    @Override
    public void append(BaseColumnSynchronizer.ColumnMetaData metaData) throws ModelSynchronizer.VetoException {
        if (!this.handlesAppend(metaData)) {
            return;
        }
        ActionSetFieldCol52 column = (ActionSetFieldCol52)metaData.getColumn();
        OptionalInt targetIndex = this.findLastIndexOfActionSetFieldColumn(column);
        if (targetIndex.isPresent()) {
            this.model.getActionCols().add(targetIndex.getAsInt() + 1, column);
            this.synchroniseAppendColumn((BaseColumn)column);
        } else {
            this.model.getActionCols().add(column);
            this.synchroniseAppendColumn((BaseColumn)column);
        }
    }

    @Override
    public boolean handlesUpdate(Synchronizer.MetaData metaData) throws ModelSynchronizer.VetoException {
        if (!(metaData instanceof BaseColumnSynchronizer.ColumnMetaData)) {
            return false;
        }
        return ((BaseColumnSynchronizer.ColumnMetaData)metaData).getColumn() instanceof ActionSetFieldCol52;
    }

    @Override
    public List<BaseColumnFieldDiff> update(BaseColumnSynchronizer.ColumnMetaData originalMetaData, BaseColumnSynchronizer.ColumnMetaData editedMetaData) throws ModelSynchronizer.VetoException {
        if (!this.handlesUpdate(originalMetaData) || !this.handlesUpdate(editedMetaData)) {
            return Collections.emptyList();
        }
        ActionSetFieldCol52 originalColumn = (ActionSetFieldCol52)originalMetaData.getColumn();
        ActionSetFieldCol52 editedColumn = (ActionSetFieldCol52)editedMetaData.getColumn();
        List diffs = originalColumn.diff((BaseColumn)editedColumn);
        this.update(originalColumn, editedColumn);
        boolean isHideUpdated = BaseColumnFieldDiffImpl.hasChanged((String)"hideColumn", (List)diffs);
        boolean isHeaderUpdated = BaseColumnFieldDiffImpl.hasChanged((String)"header", (List)diffs);
        boolean isBoundNameUpdated = BaseColumnFieldDiffImpl.hasChanged((String)"boundName", (List)diffs);
        boolean isFactFieldUpdated = BaseColumnFieldDiffImpl.hasChanged((String)"factField", (List)diffs);
        if (isBoundNameUpdated || isFactFieldUpdated) {
            this.clearColumnData((BaseColumn)originalColumn);
        } else {
            this.cleanColumnData(originalColumn, editedColumn, diffs);
        }
        this.synchroniseUpdateColumn((BaseColumn)originalColumn);
        if (isHideUpdated) {
            this.setColumnVisibility((BaseColumn)originalColumn, originalColumn.isHideColumn());
        }
        if (isHeaderUpdated) {
            this.setColumnHeader((BaseColumn)originalColumn, originalColumn.getHeader());
        }
        return diffs;
    }

    private void cleanColumnData(ActionSetFieldCol52 originalColumn, ActionSetFieldCol52 editedColumn, List<BaseColumnFieldDiff> diffs) {
        boolean isValueListUpdated = BaseColumnFieldDiffImpl.hasChanged((String)"valueList", diffs);
        if (isValueListUpdated) {
            this.updateCellsForOptionValueList((BaseColumn)originalColumn, (BaseColumn)editedColumn);
        }
    }

    private void update(ActionSetFieldCol52 originalColumn, ActionSetFieldCol52 editedColumn) {
        originalColumn.setBoundName(editedColumn.getBoundName());
        originalColumn.setType(editedColumn.getType());
        originalColumn.setFactField(editedColumn.getFactField());
        originalColumn.setHeader(editedColumn.getHeader());
        originalColumn.setValueList(editedColumn.getValueList());
        originalColumn.setDefaultValue(editedColumn.getDefaultValue());
        originalColumn.setHideColumn(editedColumn.isHideColumn());
        originalColumn.setUpdate(editedColumn.isUpdate());
        if (originalColumn instanceof LimitedEntryCol && editedColumn instanceof LimitedEntryCol) {
            ((LimitedEntryCol)originalColumn).setValue(((LimitedEntryCol)editedColumn).getValue());
        }
    }

    @Override
    public boolean handlesMoveColumnsTo(List<? extends Synchronizer.MetaData> metaData) throws ModelSynchronizer.VetoException {
        return this.isActionSetFieldFragment(metaData);
    }

    private boolean isActionSetFieldFragment(List<? extends Synchronizer.MetaData> metaData) {
        if (!metaData.stream().allMatch(c -> c instanceof BaseSynchronizer.MoveColumnToMetaData)) {
            return false;
        }
        if (!metaData.stream().map(c -> (BaseSynchronizer.MoveColumnToMetaData)c).allMatch(c -> c.getColumn() instanceof ActionSetFieldCol52)) {
            return false;
        }
        Object firstColumnInFragment = ((BaseSynchronizer.MoveColumnToMetaData)metaData.get(0)).getColumn();
        Object lastColumnInFragment = ((BaseSynchronizer.MoveColumnToMetaData)metaData.get(metaData.size() - 1)).getColumn();
        int firstColumnIndex = this.model.getExpandedColumns().indexOf(firstColumnInFragment);
        int lastColumnIndex = this.model.getExpandedColumns().indexOf(lastColumnInFragment);
        return lastColumnIndex - firstColumnIndex == metaData.size() - 1;
    }

    @Override
    protected void setColumnHeader(BaseColumn modelColumn, String header) {
        modelColumn.setHeader(header);
        int iModelColumn = this.model.getExpandedColumns().indexOf(modelColumn);
        ((GridColumn.HeaderMetaData)((GridColumn)this.uiModel.getColumns().get(iModelColumn)).getHeaderMetaData().get(1)).setTitle(header);
    }
}

