/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.pages;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.commons.HasPatternPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.common.BaseDecisionTableColumnPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.common.DecisionTableColumnViewUtils;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.modals.HasList;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.modals.NewPatternPresenter;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.DecisionTableColumnPlugin;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.PatternWrapper;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.client.mvp.UberElement;

@Dependent
public class PatternPage<T extends HasPatternPage & DecisionTableColumnPlugin>
extends BaseDecisionTableColumnPage<T> {
    private View view;
    private NewPatternPresenter newPatternPresenter;
    private boolean negatedPatternEnabled = true;
    private boolean patternCreationEnabled = true;

    @Inject
    public PatternPage(View view, NewPatternPresenter newPatternPresenter, TranslationService translationService) {
        super(translationService);
        this.view = view;
        this.newPatternPresenter = newPatternPresenter;
    }

    @Override
    public void initialise() {
        super.initialise();
        this.newPatternPresenter.init(this);
    }

    @Override
    protected UberElement<?> getView() {
        return this.view;
    }

    public String getTitle() {
        return this.translate("PatternPage.Pattern", new Object[0]);
    }

    public void isComplete(Callback<Boolean> callback) {
        boolean isPatternSet = this.isPatternSet();
        if (!isPatternSet) {
            this.view.showPatternWarning();
        } else {
            this.view.hidePatternWarning();
        }
        callback.callback((Object)isPatternSet);
    }

    private boolean isPatternSet() {
        return !DecisionTableColumnViewUtils.nil(this.currentPattern().getFactType());
    }

    public void prepareView() {
        this.view.init(this);
        this.setupPattern();
        this.setupEntryPoint();
        this.setPatternPageDescription();
    }

    private void setupEntryPoint() {
        this.view.setupEntryPointName(this.getEntryPointName());
    }

    private void setPatternPageDescription() {
        this.view.setPatternPageDescription(this.getPatternPageDescription());
    }

    void setupPattern() {
        this.view.clearPatternList();
        this.setUpPatternList();
        if (!this.isPatternCreationEnabled()) {
            this.view.disablePatternCreation();
        }
        this.view.selectPattern(this.currentPatternValue());
        this.view.hidePatternListWhenItIsEmpty();
    }

    private void setUpPatternList() {
        this.forEachPattern((name, key) -> this.view.addItem((String)name, (String)key));
    }

    public GuidedDecisionTableView.Presenter presenter() {
        return this.presenter;
    }

    public void setEditingPattern(PatternWrapper wrapper) {
        wrapper.setEntryPointName(this.view.getEntryPointName());
        ((HasPatternPage)this.plugin()).setEditingPattern(wrapper);
    }

    public void disableEntryPoint() {
        this.view.disableEntryPoint();
    }

    public boolean isNegatedPatternEnabled() {
        return this.negatedPatternEnabled;
    }

    public void disableNegatedPatterns() {
        this.negatedPatternEnabled = false;
    }

    public boolean isPatternCreationEnabled() {
        return this.patternCreationEnabled;
    }

    public void disablePatternCreation() {
        this.patternCreationEnabled = false;
    }

    void setSelectedEditingPattern() {
        String selectedValue = this.view.getSelectedValue();
        PatternWrapper patternWrapper = this.findPatternWrapperByKey(selectedValue);
        this.setEditingPattern(patternWrapper);
    }

    void forEachPattern(BiConsumer<String, String> biConsumer) {
        HashSet addedBounds = new HashSet();
        this.getPatterns().forEach(pattern -> {
            if (!addedBounds.contains(pattern.key())) {
                biConsumer.accept(pattern.name(), pattern.key());
                addedBounds.add(pattern.key());
            }
        });
    }

    void showNewPatternModal() {
        this.newPatternPresenter.show();
    }

    String currentPatternName() {
        return this.currentPattern().name();
    }

    String currentPatternValue() {
        return this.currentPattern().key();
    }

    Set<PatternWrapper> getPatterns() {
        Set<PatternWrapper> patterns = ((HasPatternPage)this.plugin()).getPatterns();
        if (this.isPatternSet()) {
            patterns.add(this.currentPattern());
        }
        if (this.isNegatedPatternEnabled()) {
            return patterns;
        }
        return patterns.stream().filter(pattern -> !pattern.isNegated()).collect(Collectors.toSet());
    }

    private PatternWrapper currentPattern() {
        return Optional.ofNullable(((HasPatternPage)this.plugin()).patternWrapper()).orElse(new PatternWrapper());
    }

    String getEntryPointName() {
        return ((HasPatternPage)this.plugin()).getEntryPointName();
    }

    String getPatternPageDescription() {
        return ((HasPatternPage)this.plugin()).getPatternPageDescription();
    }

    void setEntryPoint() {
        ((HasPatternPage)this.plugin()).setEntryPointName(this.view.getEntryPointName());
    }

    PatternWrapper findPatternWrapperByKey(String key) {
        return this.getPatterns().stream().filter(p -> p.key().equals(key)).findAny().orElse(PatternWrapper.DEFAULT);
    }

    public static interface View
    extends HasList,
    UberElement<PatternPage> {
        public void setupEntryPointName(String var1);

        public String getSelectedValue();

        public String getEntryPointName();

        public void disableEntryPoint();

        public void clearPatternList();

        public void hidePatternListWhenItIsEmpty();

        public void selectPattern(String var1);

        public void setPatternPageDescription(String var1);

        public void showPatternWarning();

        public void hidePatternWarning();

        public void disablePatternCreation();
    }
}

