/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.editor;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.enterprise.event.Event;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.editor.BaseGuidedDecisionTableEditorPresenter;
import org.drools.workbench.screens.guided.dtable.client.editor.BaseGuidedDecisionTablePresenterTest;
import org.drools.workbench.screens.guided.dtable.client.editor.GuidedDecisionTableEditorPresenter;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.InsertMenuBuilder;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.RadarMenuBuilder;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.ViewMenuBuilder;
import org.drools.workbench.screens.guided.dtable.client.editor.page.ColumnsPage;
import org.drools.workbench.screens.guided.dtable.client.type.GuidedDTableResourceType;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTablePresenter;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.DecisionTableSelectedEvent;
import org.drools.workbench.screens.guided.dtable.model.GuidedDecisionTableEditorContent;
import org.drools.workbench.screens.guided.dtable.service.GuidedDecisionTableEditorService;
import org.guvnor.common.services.project.categories.Decision;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.project.datamodel.imports.Imports;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.metadata.client.KieDocument;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UpdatedLockStatusEvent;
import org.uberfire.client.workbench.widgets.multipage.MultiPageEditor;
import org.uberfire.client.workbench.widgets.multipage.Page;
import org.uberfire.ext.editor.commons.client.menu.MenuItems;
import org.uberfire.ext.editor.commons.client.menu.common.SaveAndRenameCommandBuilder;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.Menus;

@RunWith(value=GwtMockitoTestRunner.class)
public class BaseGuidedDecisionTableEditorPresenterTest
extends BaseGuidedDecisionTablePresenterTest<BaseGuidedDecisionTableEditorPresenter> {
    private GuidedDTableResourceType resourceType = new GuidedDTableResourceType(new Decision());
    @Mock
    private SaveAndRenameCommandBuilder<GuidedDecisionTable52, Metadata> saveAndRenameCommandBuilder;

    @Override
    protected GuidedDecisionTableEditorPresenter getPresenter() {
        return new GuidedDecisionTableEditorPresenter(this.view, this.dtServiceCaller, this.notification, this.decisionTableSelectedEvent, this.validationPopup, this.resourceType, this.editMenuBuilder, this.viewMenuBuilder, this.insertMenuBuilder, this.radarMenuBuilder, this.modeller, this.beanManager, this.placeManager, this.columnsPage, this.saveAndRenameCommandBuilder, this.alertsButtonMenuItemBuilder, this.downloadMenuItem){

            protected Command getSaveAndRenameCommand() {
                return (Command)Mockito.mock(Command.class);
            }
        };
    }

    @Test
    public void checkInit() {
        ((ViewMenuBuilder)Mockito.verify((Object)this.viewMenuBuilder, (VerificationMode)Mockito.times((int)1))).setModeller((GuidedDecisionTableModellerView.Presenter)Mockito.eq((Object)this.modeller));
        ((InsertMenuBuilder)Mockito.verify((Object)this.insertMenuBuilder, (VerificationMode)Mockito.times((int)1))).setModeller((GuidedDecisionTableModellerView.Presenter)Mockito.eq((Object)this.modeller));
        ((RadarMenuBuilder)Mockito.verify((Object)this.radarMenuBuilder, (VerificationMode)Mockito.times((int)1))).setModeller((GuidedDecisionTableModellerView.Presenter)Mockito.eq((Object)this.modeller));
        ((BaseGuidedDecisionTableEditorPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setModellerView((GuidedDecisionTableModellerView)Mockito.eq((Object)this.modellerView));
    }

    @Test
    public void checkOnStartup() {
        ObservablePath path = (ObservablePath)Mockito.mock(ObservablePath.class);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        GuidedDecisionTableEditorContent content = this.makeDecisionTableContent();
        GuidedDecisionTableView.Presenter dtPresenter = this.makeDecisionTable((Path)path, path, placeRequest, content);
        this.presenter.onStartup(path, placeRequest);
        Assert.assertEquals((Object)path, (Object)this.presenter.editorPath);
        Assert.assertEquals((Object)placeRequest, (Object)this.presenter.editorPlaceRequest);
        ((BaseGuidedDecisionTableEditorPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showLoading();
        ((BaseGuidedDecisionTableEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).loadDocument((ObservablePath)Mockito.eq((Object)path), (PlaceRequest)Mockito.eq((Object)placeRequest));
        ((GuidedDecisionTableEditorService)Mockito.verify((Object)this.dtService, (VerificationMode)Mockito.times((int)1))).loadContent((Path)Mockito.eq((Object)path));
        ((GuidedDecisionTableModellerView.Presenter)Mockito.verify((Object)this.modeller, (VerificationMode)Mockito.times((int)1))).addDecisionTable((ObservablePath)Mockito.eq((Object)path), (PlaceRequest)Mockito.eq((Object)placeRequest), (GuidedDecisionTableEditorContent)Mockito.eq((Object)content), ((Boolean)Matchers.any(Boolean.class)).booleanValue(), (Double)Mockito.eq(null), (Double)Mockito.eq(null));
        ((BaseGuidedDecisionTableEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).registerDocument((KieDocument)Mockito.eq((Object)dtPresenter));
        ((Event)Mockito.verify((Object)this.decisionTableSelectedEvent, (VerificationMode)Mockito.times((int)1))).fire(this.dtSelectedEventCaptor.capture());
        ((BaseGuidedDecisionTableEditorPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).hideBusyIndicator();
        DecisionTableSelectedEvent dtSelectedEvent = (DecisionTableSelectedEvent)this.dtSelectedEventCaptor.getValue();
        Assert.assertNotNull((Object)dtSelectedEvent);
        Assert.assertTrue((boolean)dtSelectedEvent.getPresenter().isPresent());
        Assert.assertEquals((Object)dtPresenter, dtSelectedEvent.getPresenter().get());
    }

    @Test
    public void checkDecisionTableSelectedEventFiredWhenEditorReceivesFocusWithActiveDecisionTable() {
        GuidedDecisionTableView.Presenter activeDtable = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        Mockito.when((Object)this.modeller.getActiveDecisionTable()).thenReturn(Optional.of(activeDtable));
        this.presenter.onFocus();
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)activeDtable, (VerificationMode)Mockito.times((int)1))).initialiseAnalysis();
        ((Event)Mockito.verify((Object)this.decisionTableSelectedEvent, (VerificationMode)Mockito.times((int)1))).fire(this.dtSelectedEventCaptor.capture());
        DecisionTableSelectedEvent event = (DecisionTableSelectedEvent)this.dtSelectedEventCaptor.getValue();
        Assert.assertNotNull((Object)event);
        Assert.assertTrue((boolean)event.getPresenter().isPresent());
        Assert.assertEquals((Object)activeDtable, event.getPresenter().get());
    }

    @Test
    public void checkDecisionTableSelectedEventNotFiredWhenEditorReceivesFocusWithoutActiveDecisionTable() {
        Mockito.when((Object)this.modeller.getActiveDecisionTable()).thenReturn(Optional.empty());
        this.presenter.onFocus();
        ((Event)Mockito.verify((Object)this.decisionTableSelectedEvent, (VerificationMode)Mockito.never())).fire(Matchers.any(DecisionTableSelectedEvent.class));
    }

    @Test
    public void checkMayCloseWithNoDecisionTable() {
        Assert.assertTrue((boolean)this.presenter.mayClose());
    }

    @Test
    public void checkMayCloseWithCleanDecisionTable() {
        ObservablePath path = (ObservablePath)Mockito.mock(ObservablePath.class);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        GuidedDecisionTableEditorContent content = this.makeDecisionTableContent();
        final GuidedDecisionTableView.Presenter dtPresenter = this.makeDecisionTable((Path)path, path, placeRequest, content);
        Mockito.when((Object)dtPresenter.getOriginalHashCode()).thenReturn((Object)0);
        Mockito.when((Object)this.modeller.getAvailableDecisionTables()).thenReturn((Object)new HashSet<GuidedDecisionTableView.Presenter>(){
            {
                this.add(dtPresenter);
            }
        });
        Assert.assertTrue((boolean)this.presenter.mayClose());
    }

    @Test
    public void checkMayCloseWithDirtyDecisionTable() {
        ObservablePath path = (ObservablePath)Mockito.mock(ObservablePath.class);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        GuidedDecisionTableEditorContent content = this.makeDecisionTableContent();
        final GuidedDecisionTableView.Presenter dtPresenter = this.makeDecisionTable((Path)path, path, placeRequest, content);
        Mockito.when((Object)dtPresenter.getOriginalHashCode()).thenReturn((Object)10);
        Mockito.when((Object)this.modeller.getAvailableDecisionTables()).thenReturn((Object)new HashSet<GuidedDecisionTableView.Presenter>(){
            {
                this.add(dtPresenter);
            }
        });
        Assert.assertFalse((boolean)this.presenter.mayClose());
    }

    @Test
    public void checkOnClose() {
        this.presenter.onClose();
        ((GuidedDecisionTableModellerView.Presenter)Mockito.verify((Object)this.modeller, (VerificationMode)Mockito.times((int)1))).onClose();
    }

    @Test
    public void checkOnDecisionTableSelectedWhenAvailableSelected() {
        ObservablePath path = (ObservablePath)Mockito.mock(ObservablePath.class);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        GuidedDecisionTableEditorContent content = this.makeDecisionTableContent();
        GuidedDecisionTableView.Presenter dtPresenter = this.makeDecisionTable((Path)path, path, placeRequest, content);
        DecisionTableSelectedEvent event = new DecisionTableSelectedEvent(dtPresenter);
        Mockito.when((Object)this.modeller.isDecisionTableAvailable((GuidedDecisionTableView.Presenter)Matchers.any(GuidedDecisionTableView.Presenter.class))).thenReturn((Object)true);
        Mockito.when((Object)this.presenter.getActiveDocument()).thenReturn((Object)dtPresenter);
        this.presenter.onDecisionTableSelected(event);
        ((BaseGuidedDecisionTableEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).activateDocument((GuidedDecisionTableView.Presenter)Matchers.any(GuidedDecisionTableView.Presenter.class));
        Assert.assertTrue((boolean)this.getMenuState(this.presenter.getMenus(), MenuItems.VALIDATE));
    }

    private boolean getMenuState(Menus menus, MenuItems menuItem) {
        return menus.getItems().stream().filter(m -> m.getIdentifier() != null).filter(m -> m.getCaption().toLowerCase().equals(menuItem.name().toLowerCase())).findFirst().get().isEnabled();
    }

    @Test
    public void checkOnDecisionTableSelectedWhenAvailableNotSelected() {
        ObservablePath path = (ObservablePath)Mockito.mock(ObservablePath.class);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        GuidedDecisionTableEditorContent content = this.makeDecisionTableContent();
        GuidedDecisionTableView.Presenter dtPresenter = this.makeDecisionTable((Path)path, path, placeRequest, content);
        DecisionTableSelectedEvent event = new DecisionTableSelectedEvent(dtPresenter);
        MultiPageEditor pageEditor = (MultiPageEditor)Mockito.mock(MultiPageEditor.class);
        Mockito.when((Object)this.modeller.isDecisionTableAvailable((GuidedDecisionTableView.Presenter)Matchers.any(GuidedDecisionTableView.Presenter.class))).thenReturn((Object)true);
        Mockito.when((Object)this.presenter.getActiveDocument()).thenReturn(null);
        Mockito.when((Object)this.presenter.getKieEditorWrapperMultiPage()).thenReturn((Object)pageEditor);
        this.presenter.onStartup(path, placeRequest);
        this.presenter.onDecisionTableSelected(event);
        ((BaseGuidedDecisionTableEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).activateDocument((GuidedDecisionTableView.Presenter)Matchers.any(GuidedDecisionTableView.Presenter.class));
        ((MenuItem)Mockito.verify((Object)this.radarMenuItem, (VerificationMode)Mockito.atLeast((int)1))).setEnabled(Mockito.eq((boolean)true));
        Assert.assertTrue((boolean)this.getMenuState(this.presenter.getMenus(), MenuItems.VALIDATE));
    }

    @Test
    public void checkOnDecisionTableSelectedWhenNotAvailable() {
        ObservablePath path = (ObservablePath)Mockito.mock(ObservablePath.class);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        GuidedDecisionTableEditorContent content = this.makeDecisionTableContent();
        GuidedDecisionTableView.Presenter dtPresenter = this.makeDecisionTable((Path)path, path, placeRequest, content);
        DecisionTableSelectedEvent event = new DecisionTableSelectedEvent(dtPresenter);
        Mockito.when((Object)this.modeller.isDecisionTableAvailable((GuidedDecisionTableView.Presenter)Matchers.any(GuidedDecisionTableView.Presenter.class))).thenReturn((Object)false);
        this.presenter.onDecisionTableSelected(event);
        ((BaseGuidedDecisionTableEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).activateDocument((GuidedDecisionTableView.Presenter)Matchers.any(GuidedDecisionTableView.Presenter.class));
        Assert.assertTrue((boolean)this.getMenuState(this.presenter.getMenus(), MenuItems.VALIDATE));
    }

    @Test
    public void checkOnDecisionTableSelectedEventNoTableSelected() {
        DecisionTableSelectedEvent event = DecisionTableSelectedEvent.NONE;
        this.presenter.onDecisionTableSelected(event);
        ((BaseGuidedDecisionTableEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).activateDocument((GuidedDecisionTableView.Presenter)Matchers.any(GuidedDecisionTableView.Presenter.class));
        Assert.assertFalse((boolean)this.getMenuState(this.presenter.getMenus(), MenuItems.VALIDATE));
    }

    @Test
    public void checkOnDecisionTableSelectedEventReselection() {
        ObservablePath path = (ObservablePath)Mockito.mock(ObservablePath.class);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        GuidedDecisionTableEditorContent content = this.makeDecisionTableContent();
        GuidedDecisionTableView.Presenter dtPresenter = this.makeDecisionTable((Path)path, path, placeRequest, content);
        DecisionTableSelectedEvent eventSelect = new DecisionTableSelectedEvent(dtPresenter);
        ((GuidedDecisionTableModellerView.Presenter)Mockito.doReturn((Object)true).when((Object)this.modeller)).isDecisionTableAvailable(dtPresenter);
        this.presenter.onStartup(path, placeRequest);
        this.presenter.onDecisionTableSelected(eventSelect);
        Assert.assertEquals((Object)dtPresenter, (Object)this.presenter.getActiveDocument());
        DecisionTableSelectedEvent eventDeselect = DecisionTableSelectedEvent.NONE;
        this.presenter.onDecisionTableSelected(eventDeselect);
        Assert.assertNull((Object)this.presenter.getActiveDocument());
        this.presenter.onDecisionTableSelected(eventSelect);
        Assert.assertEquals((Object)dtPresenter, (Object)this.presenter.getActiveDocument());
    }

    @Test
    public void checkRefreshDocument() {
        ObservablePath path = (ObservablePath)Mockito.mock(ObservablePath.class);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        GuidedDecisionTableEditorContent content = this.makeDecisionTableContent();
        MultiPageEditor pageEditor = (MultiPageEditor)Mockito.mock(MultiPageEditor.class);
        GuidedDecisionTableView.Presenter dtPresenter = this.makeDecisionTable((Path)path, path, placeRequest, content);
        this.presenter.onStartup(path, placeRequest);
        ((BaseGuidedDecisionTableEditorPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showLoading();
        ((GuidedDecisionTableEditorService)Mockito.verify((Object)this.dtService, (VerificationMode)Mockito.times((int)1))).loadContent((Path)Mockito.eq((Object)path));
        ((Event)Mockito.verify((Object)this.decisionTableSelectedEvent, (VerificationMode)Mockito.times((int)1))).fire(this.dtSelectedEventCaptor.capture());
        ((BaseGuidedDecisionTableEditorPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).hideBusyIndicator();
        DecisionTableSelectedEvent dtSelectedEvent = (DecisionTableSelectedEvent)this.dtSelectedEventCaptor.getValue();
        Assert.assertNotNull((Object)dtSelectedEvent);
        Assert.assertTrue((boolean)dtSelectedEvent.getPresenter().isPresent());
        Assert.assertEquals((Object)dtPresenter, dtSelectedEvent.getPresenter().get());
        Mockito.when((Object)dtPresenter.getCurrentPath()).thenReturn((Object)path);
        Mockito.when((Object)this.presenter.getKieEditorWrapperMultiPage()).thenReturn((Object)pageEditor);
        this.presenter.refreshDocument(dtPresenter);
        ((BaseGuidedDecisionTableEditorPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).showLoading();
        ((GuidedDecisionTableEditorService)Mockito.verify((Object)this.dtService, (VerificationMode)Mockito.times((int)2))).loadContent((Path)Mockito.eq((Object)path));
        ((GuidedDecisionTableModellerView.Presenter)Mockito.verify((Object)this.modeller, (VerificationMode)Mockito.times((int)1))).refreshDecisionTable((GuidedDecisionTableView.Presenter)Mockito.eq((Object)dtPresenter), (ObservablePath)Mockito.eq((Object)path), (PlaceRequest)Mockito.eq((Object)placeRequest), (GuidedDecisionTableEditorContent)Mockito.eq((Object)content), ((Boolean)Matchers.any(Boolean.class)).booleanValue());
        ((BaseGuidedDecisionTableEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).activateDocument((GuidedDecisionTableView.Presenter)Mockito.eq((Object)dtPresenter));
        ((BaseGuidedDecisionTableEditorPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).hideBusyIndicator();
    }

    @Test
    public void checkRemoveDocument() {
        ObservablePath path = (ObservablePath)Mockito.mock(ObservablePath.class);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        GuidedDecisionTableEditorContent content = this.makeDecisionTableContent();
        GuidedDecisionTableView.Presenter dtPresenter = this.makeDecisionTable((Path)path, path, placeRequest, content);
        this.presenter.onStartup(path, placeRequest);
        this.presenter.removeDocument(dtPresenter);
        ((GuidedDecisionTableModellerView.Presenter)Mockito.verify((Object)this.modeller, (VerificationMode)Mockito.times((int)1))).removeDecisionTable((GuidedDecisionTableView.Presenter)Mockito.eq((Object)dtPresenter));
        ((BaseGuidedDecisionTableEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).deregisterDocument((KieDocument)Mockito.eq((Object)dtPresenter));
        ((BaseGuidedDecisionTableEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).openOtherDecisionTable();
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)dtPresenter, (VerificationMode)Mockito.times((int)1))).onClose();
    }

    @Test
    public void checkOpenOtherDecisionTableIsLastDecisionTable() {
        Mockito.when((Object)this.modeller.getAvailableDecisionTables()).thenReturn(Collections.emptySet());
        this.presenter.openOtherDecisionTable();
        ((BaseGuidedDecisionTableEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).activateDocument((GuidedDecisionTableView.Presenter)Matchers.any(GuidedDecisionTableView.Presenter.class));
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.never())).forceClosePlace((String)Matchers.any(String.class));
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.never())).forceClosePlace((PlaceRequest)Matchers.any(PlaceRequest.class));
        ((Event)Mockito.verify((Object)this.decisionTableSelectedEvent, (VerificationMode)Mockito.times((int)1))).fire(this.dtSelectedEventCaptor.capture());
        DecisionTableSelectedEvent dtSelectedEvent = (DecisionTableSelectedEvent)this.dtSelectedEventCaptor.getValue();
        Assert.assertNotNull((Object)dtSelectedEvent);
        Assert.assertFalse((boolean)dtSelectedEvent.getPresenter().isPresent());
    }

    @Test
    public void checkOpenOtherDecisionTableIsNotLastDecisionTable() {
        final GuidedDecisionTableView.Presenter remainingDtPresenter = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        Mockito.when((Object)this.modeller.getAvailableDecisionTables()).thenReturn((Object)new HashSet<GuidedDecisionTableView.Presenter>(){
            {
                this.add(remainingDtPresenter);
            }
        });
        ((BaseGuidedDecisionTableEditorPresenter)Mockito.doNothing().when((Object)this.presenter)).activateDocument((GuidedDecisionTableView.Presenter)Matchers.any(GuidedDecisionTableView.Presenter.class));
        this.presenter.openOtherDecisionTable();
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.never())).forceClosePlace((String)Matchers.any(String.class));
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.never())).forceClosePlace((PlaceRequest)Matchers.any(PlaceRequest.class));
        ((Event)Mockito.verify((Object)this.decisionTableSelectedEvent, (VerificationMode)Mockito.times((int)2))).fire(this.dtSelectedEventCaptor.capture());
        List dtSelectedEvents = this.dtSelectedEventCaptor.getAllValues();
        Assert.assertNotNull((Object)dtSelectedEvents);
        Assert.assertEquals((long)2L, (long)dtSelectedEvents.size());
        Assert.assertFalse((boolean)((DecisionTableSelectedEvent)dtSelectedEvents.get(0)).getPresenter().isPresent());
        Assert.assertTrue((boolean)((DecisionTableSelectedEvent)dtSelectedEvents.get(1)).getPresenter().isPresent());
        Assert.assertEquals(((DecisionTableSelectedEvent)dtSelectedEvents.get(1)).getPresenter().get(), (Object)remainingDtPresenter);
    }

    @Test
    public void checkOnValidateWithErrors() {
        ObservablePath path = (ObservablePath)Mockito.mock(ObservablePath.class);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        GuidedDecisionTableEditorContent content = this.makeDecisionTableContent();
        GuidedDecisionTableView.Presenter dtPresenter = this.makeDecisionTable((Path)path, path, placeRequest, content);
        ArrayList<ValidationMessage> validationMessages = new ArrayList<ValidationMessage>(){
            {
                this.add(new ValidationMessage());
            }
        };
        Mockito.when((Object)this.dtService.validate((Path)Matchers.any(Path.class), Matchers.any(GuidedDecisionTable52.class))).thenReturn((Object)validationMessages);
        ((BaseGuidedDecisionTableEditorPresenter)Mockito.doNothing().when((Object)this.presenter)).showValidationPopup((List)Matchers.any(List.class));
        this.presenter.onValidate(dtPresenter);
        ArgumentCaptor modelCaptor = ArgumentCaptor.forClass(GuidedDecisionTable52.class);
        ((GuidedDecisionTableEditorService)Mockito.verify((Object)this.dtService, (VerificationMode)Mockito.times((int)1))).validate((Path)Mockito.eq((Object)path), modelCaptor.capture());
        Assert.assertNotNull((Object)modelCaptor.getValue());
        Assert.assertEquals((Object)dtPresenter.getModel(), (Object)modelCaptor.getValue());
        ((Event)Mockito.verify((Object)this.notification, (VerificationMode)Mockito.never())).fire(Matchers.any(NotificationEvent.class));
        ((BaseGuidedDecisionTableEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).showValidationPopup((List)Mockito.eq((Object)validationMessages));
    }

    @Test
    public void checkOnValidateWithoutErrors() {
        ObservablePath path = (ObservablePath)Mockito.mock(ObservablePath.class);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        GuidedDecisionTableEditorContent content = this.makeDecisionTableContent();
        GuidedDecisionTableView.Presenter dtPresenter = this.makeDecisionTable((Path)path, path, placeRequest, content);
        Mockito.when((Object)this.dtService.validate((Path)Matchers.any(Path.class), Matchers.any(GuidedDecisionTable52.class))).thenReturn(Collections.emptyList());
        this.presenter.onValidate(dtPresenter);
        ArgumentCaptor modelCaptor = ArgumentCaptor.forClass(GuidedDecisionTable52.class);
        ((GuidedDecisionTableEditorService)Mockito.verify((Object)this.dtService, (VerificationMode)Mockito.times((int)1))).validate((Path)Mockito.eq((Object)path), modelCaptor.capture());
        Assert.assertNotNull((Object)modelCaptor.getValue());
        Assert.assertEquals((Object)dtPresenter.getModel(), (Object)modelCaptor.getValue());
        ((Event)Mockito.verify((Object)this.notification, (VerificationMode)Mockito.times((int)1))).fire(Matchers.any(NotificationEvent.class));
    }

    @Test
    public void checkOnSave() {
        String commitMessage = "message";
        ObservablePath path = (ObservablePath)Mockito.mock(ObservablePath.class);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        GuidedDecisionTableEditorContent content = this.makeDecisionTableContent();
        GuidedDecisionTableView.Presenter dtPresenter = this.makeDecisionTable((Path)path, path, placeRequest, content);
        this.presenter.onSave(dtPresenter, "message");
        ArgumentCaptor modelCaptor = ArgumentCaptor.forClass(GuidedDecisionTable52.class);
        ArgumentCaptor metadataCaptor = ArgumentCaptor.forClass(Metadata.class);
        ((GuidedDecisionTableEditorService)Mockito.verify((Object)this.dtService, (VerificationMode)Mockito.times((int)1))).saveAndUpdateGraphEntries((Path)Mockito.eq((Object)path), (GuidedDecisionTable52)modelCaptor.capture(), (Metadata)metadataCaptor.capture(), (String)Mockito.eq((Object)"message"));
        Assert.assertNotNull((Object)modelCaptor.getValue());
        Assert.assertEquals((Object)dtPresenter.getModel(), (Object)modelCaptor.getValue());
        Assert.assertNotNull((Object)metadataCaptor.getValue());
        Assert.assertEquals((Object)dtPresenter.getOverview().getMetadata(), (Object)metadataCaptor.getValue());
    }

    @Test
    public void checkOnSourceTabSelected() {
        String source = "source";
        ObservablePath path = (ObservablePath)Mockito.mock(ObservablePath.class);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        GuidedDecisionTableEditorContent content = this.makeDecisionTableContent();
        GuidedDecisionTableView.Presenter dtPresenter = this.makeDecisionTable((Path)path, path, placeRequest, content);
        Mockito.when((Object)this.dtService.toSource((Path)Mockito.eq((Object)path), Matchers.any(GuidedDecisionTable52.class))).thenReturn((Object)"source");
        this.presenter.onSourceTabSelected(dtPresenter);
        ArgumentCaptor modelCaptor = ArgumentCaptor.forClass(GuidedDecisionTable52.class);
        ((GuidedDecisionTableEditorService)Mockito.verify((Object)this.dtService, (VerificationMode)Mockito.times((int)1))).toSource((Path)Mockito.eq((Object)path), modelCaptor.capture());
        Assert.assertNotNull((Object)modelCaptor.getValue());
        Assert.assertEquals((Object)dtPresenter.getModel(), (Object)modelCaptor.getValue());
        ((BaseGuidedDecisionTableEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).updateSource((String)Mockito.eq((Object)"source"));
    }

    @Test
    public void testActivateDocument() {
        GuidedDecisionTableView.Presenter dtPresenter = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        Overview overview = (Overview)Mockito.mock(Overview.class);
        AsyncPackageDataModelOracle oracle = (AsyncPackageDataModelOracle)Mockito.mock(AsyncPackageDataModelOracle.class);
        GuidedDecisionTable52 model = (GuidedDecisionTable52)Mockito.mock(GuidedDecisionTable52.class);
        Imports imports = (Imports)Mockito.mock(Imports.class);
        GuidedDecisionTablePresenter.Access access = (GuidedDecisionTablePresenter.Access)Mockito.mock(GuidedDecisionTablePresenter.Access.class);
        MultiPageEditor pageEditor = (MultiPageEditor)Mockito.mock(MultiPageEditor.class);
        boolean isEditable = true;
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)overview).when((Object)dtPresenter)).getOverview();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)oracle).when((Object)dtPresenter)).getDataModelOracle();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)model).when((Object)dtPresenter)).getModel();
        ((GuidedDecisionTable52)Mockito.doReturn((Object)imports).when((Object)model)).getImports();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)access).when((Object)dtPresenter)).getAccess();
        ((GuidedDecisionTablePresenter.Access)Mockito.doReturn((Object)true).when((Object)access)).isEditable();
        ((BaseGuidedDecisionTableEditorPresenter)Mockito.doReturn((Object)pageEditor).when((Object)this.presenter)).getKieEditorWrapperMultiPage();
        ((BaseGuidedDecisionTableEditorPresenter)Mockito.doNothing().when((Object)this.presenter)).activateDocument((KieDocument)Matchers.any(), (Overview)Matchers.any(), (AsyncPackageDataModelOracle)Matchers.any(), (Imports)Matchers.any(), Matchers.anyBoolean());
        this.presenter.activateDocument(dtPresenter);
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)dtPresenter)).activate();
        ((BaseGuidedDecisionTableEditorPresenter)Mockito.verify((Object)this.presenter)).enableMenus(true);
        ((BaseGuidedDecisionTableEditorPresenter)Mockito.verify((Object)this.presenter)).addColumnsTab();
        ((BaseGuidedDecisionTableEditorPresenter)Mockito.verify((Object)this.presenter)).enableColumnsTab(dtPresenter);
        ((BaseGuidedDecisionTableEditorPresenter)Mockito.verify((Object)this.presenter)).activateDocument((KieDocument)dtPresenter, overview, oracle, imports, false);
    }

    @Test
    public void testEnableColumnsTab() {
        GuidedDecisionTableView.Presenter dtPresenter = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        boolean isGuidedDecisionTableEditable = true;
        ((BaseGuidedDecisionTableEditorPresenter)Mockito.doReturn((Object)true).when((Object)this.presenter)).isGuidedDecisionTableEditable((GuidedDecisionTableView.Presenter)Matchers.any());
        this.presenter.enableColumnsTab(dtPresenter);
        ((BaseGuidedDecisionTableEditorPresenter)Mockito.verify((Object)this.presenter)).enableColumnsTab(Mockito.eq((boolean)true));
    }

    @Test
    public void testIsGuidedDecisionTableEditableWhenDecisionTableDoesNotHaveEditableColumns() {
        GuidedDecisionTableView.Presenter dtPresenter = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        GuidedDecisionTablePresenter.Access access = (GuidedDecisionTablePresenter.Access)Mockito.mock(GuidedDecisionTablePresenter.Access.class);
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)access).when((Object)dtPresenter)).getAccess();
        ((GuidedDecisionTablePresenter.Access)Mockito.doReturn((Object)false).when((Object)access)).isReadOnly();
        ((GuidedDecisionTablePresenter.Access)Mockito.doReturn((Object)false).when((Object)access)).hasEditableColumns();
        boolean isGuidedDecisionTableEditable = this.presenter.isGuidedDecisionTableEditable(dtPresenter);
        Assert.assertFalse((boolean)isGuidedDecisionTableEditable);
    }

    @Test
    public void testIsGuidedDecisionTableEditableWhenDecisionTableIsNotEditable() {
        GuidedDecisionTableView.Presenter dtPresenter = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        GuidedDecisionTablePresenter.Access access = (GuidedDecisionTablePresenter.Access)Mockito.mock(GuidedDecisionTablePresenter.Access.class);
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)access).when((Object)dtPresenter)).getAccess();
        ((GuidedDecisionTablePresenter.Access)Mockito.doReturn((Object)true).when((Object)access)).isReadOnly();
        ((GuidedDecisionTablePresenter.Access)Mockito.doReturn((Object)true).when((Object)access)).hasEditableColumns();
        boolean isGuidedDecisionTableEditable = this.presenter.isGuidedDecisionTableEditable(dtPresenter);
        Assert.assertFalse((boolean)isGuidedDecisionTableEditable);
    }

    @Test
    public void testIsGuidedDecisionTableEditableWhenDecisionTableIsEditable() {
        GuidedDecisionTableView.Presenter dtPresenter = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        GuidedDecisionTablePresenter.Access access = (GuidedDecisionTablePresenter.Access)Mockito.mock(GuidedDecisionTablePresenter.Access.class);
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)access).when((Object)dtPresenter)).getAccess();
        ((GuidedDecisionTablePresenter.Access)Mockito.doReturn((Object)false).when((Object)access)).isReadOnly();
        ((GuidedDecisionTablePresenter.Access)Mockito.doReturn((Object)true).when((Object)access)).hasEditableColumns();
        boolean isGuidedDecisionTableEditable = this.presenter.isGuidedDecisionTableEditable(dtPresenter);
        Assert.assertTrue((boolean)isGuidedDecisionTableEditable);
    }

    @Test
    public void testAddColumnsTab() {
        MultiPageEditor pageEditor = (MultiPageEditor)Mockito.mock(MultiPageEditor.class);
        ((BaseGuidedDecisionTableEditorPresenter)Mockito.doReturn((Object)pageEditor).when((Object)this.presenter)).getKieEditorWrapperMultiPage();
        this.presenter.addColumnsTab();
        ((ColumnsPage)Mockito.verify((Object)this.columnsPage)).init(this.modeller);
        ((BaseGuidedDecisionTableEditorPresenter)Mockito.verify((Object)this.presenter)).addEditorPage(1, (Page)this.columnsPage);
    }

    @Test
    public void testAddEditorPage() {
        MultiPageEditor multiPage = (MultiPageEditor)Mockito.mock(MultiPageEditor.class);
        Page page = (Page)Mockito.mock(Page.class);
        boolean index = true;
        ((BaseGuidedDecisionTableEditorPresenter)Mockito.doReturn((Object)multiPage).when((Object)this.presenter)).getKieEditorWrapperMultiPage();
        this.presenter.addEditorPage(1, page);
        ((MultiPageEditor)Mockito.verify((Object)multiPage)).addPage(1, page);
    }

    @Test
    public void testDisableColumnsPage() {
        MultiPageEditor multiPage = (MultiPageEditor)Mockito.mock(MultiPageEditor.class);
        ((BaseGuidedDecisionTableEditorPresenter)Mockito.doReturn((Object)multiPage).when((Object)this.presenter)).getKieEditorWrapperMultiPage();
        this.presenter.disableColumnsPage();
        ((MultiPageEditor)Mockito.verify((Object)multiPage)).disablePage(1);
    }

    @Test
    public void testEnableColumnsPage() {
        MultiPageEditor multiPage = (MultiPageEditor)Mockito.mock(MultiPageEditor.class);
        ((BaseGuidedDecisionTableEditorPresenter)Mockito.doReturn((Object)multiPage).when((Object)this.presenter)).getKieEditorWrapperMultiPage();
        this.presenter.enableColumnsPage();
        ((MultiPageEditor)Mockito.verify((Object)multiPage)).enablePage(1);
    }

    @Test
    public void testOnUpdatedLockStatusEventWhenTableIsNotLockedAndIsEditable() {
        UpdatedLockStatusEvent event = (UpdatedLockStatusEvent)Mockito.mock(UpdatedLockStatusEvent.class);
        GuidedDecisionTableView.Presenter activeDecisionTable = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        ((UpdatedLockStatusEvent)Mockito.doReturn((Object)false).when((Object)event)).isLocked();
        ((UpdatedLockStatusEvent)Mockito.doReturn((Object)false).when((Object)event)).isLockedByCurrentUser();
        ((BaseGuidedDecisionTableEditorPresenter)Mockito.doReturn((Object)true).when((Object)this.presenter)).isGuidedDecisionTableEditable(activeDecisionTable);
        ((GuidedDecisionTableModellerView.Presenter)Mockito.doReturn(Optional.of(activeDecisionTable)).when((Object)this.modeller)).getActiveDecisionTable();
        ((BaseGuidedDecisionTableEditorPresenter)Mockito.doNothing().when((Object)this.presenter)).enableColumnsTab(Matchers.anyBoolean());
        this.presenter.onUpdatedLockStatusEvent(event);
        ((BaseGuidedDecisionTableEditorPresenter)Mockito.verify((Object)this.presenter)).enableColumnsTab(Mockito.eq((boolean)true));
    }

    @Test
    public void testOnUpdatedLockStatusEventWhenTableIsNotLockedAndIsNotEditable() {
        UpdatedLockStatusEvent event = (UpdatedLockStatusEvent)Mockito.mock(UpdatedLockStatusEvent.class);
        GuidedDecisionTableView.Presenter activeDecisionTable = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        ((UpdatedLockStatusEvent)Mockito.doReturn((Object)false).when((Object)event)).isLocked();
        ((UpdatedLockStatusEvent)Mockito.doReturn((Object)false).when((Object)event)).isLockedByCurrentUser();
        ((BaseGuidedDecisionTableEditorPresenter)Mockito.doReturn((Object)false).when((Object)this.presenter)).isGuidedDecisionTableEditable(activeDecisionTable);
        ((GuidedDecisionTableModellerView.Presenter)Mockito.doReturn(Optional.of(activeDecisionTable)).when((Object)this.modeller)).getActiveDecisionTable();
        ((BaseGuidedDecisionTableEditorPresenter)Mockito.doNothing().when((Object)this.presenter)).enableColumnsTab(Matchers.anyBoolean());
        this.presenter.onUpdatedLockStatusEvent(event);
        ((BaseGuidedDecisionTableEditorPresenter)Mockito.verify((Object)this.presenter)).enableColumnsTab(Mockito.eq((boolean)false));
    }

    @Test
    public void testOnUpdatedLockStatusEventWhenIsLockedByTheCurrentUser() {
        UpdatedLockStatusEvent event = (UpdatedLockStatusEvent)Mockito.mock(UpdatedLockStatusEvent.class);
        GuidedDecisionTableView.Presenter activeDecisionTable = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        ((UpdatedLockStatusEvent)Mockito.doReturn((Object)true).when((Object)event)).isLocked();
        ((UpdatedLockStatusEvent)Mockito.doReturn((Object)true).when((Object)event)).isLockedByCurrentUser();
        ((BaseGuidedDecisionTableEditorPresenter)Mockito.doReturn((Object)true).when((Object)this.presenter)).isGuidedDecisionTableEditable(activeDecisionTable);
        ((GuidedDecisionTableModellerView.Presenter)Mockito.doReturn(Optional.of(activeDecisionTable)).when((Object)this.modeller)).getActiveDecisionTable();
        ((BaseGuidedDecisionTableEditorPresenter)Mockito.doNothing().when((Object)this.presenter)).enableColumnsTab(Matchers.anyBoolean());
        this.presenter.onUpdatedLockStatusEvent(event);
        ((BaseGuidedDecisionTableEditorPresenter)Mockito.verify((Object)this.presenter)).enableColumnsTab(Mockito.eq((boolean)true));
    }

    @Test
    public void testOnUpdatedLockStatusEventWhenIsLockedByAnotherUser() {
        UpdatedLockStatusEvent event = (UpdatedLockStatusEvent)Mockito.mock(UpdatedLockStatusEvent.class);
        GuidedDecisionTableView.Presenter activeDecisionTable = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        ((UpdatedLockStatusEvent)Mockito.doReturn((Object)true).when((Object)event)).isLocked();
        ((UpdatedLockStatusEvent)Mockito.doReturn((Object)false).when((Object)event)).isLockedByCurrentUser();
        ((BaseGuidedDecisionTableEditorPresenter)Mockito.doReturn((Object)true).when((Object)this.presenter)).isGuidedDecisionTableEditable(activeDecisionTable);
        ((GuidedDecisionTableModellerView.Presenter)Mockito.doReturn(Optional.of(activeDecisionTable)).when((Object)this.modeller)).getActiveDecisionTable();
        ((BaseGuidedDecisionTableEditorPresenter)Mockito.doNothing().when((Object)this.presenter)).enableColumnsTab(Matchers.anyBoolean());
        this.presenter.onUpdatedLockStatusEvent(event);
        ((BaseGuidedDecisionTableEditorPresenter)Mockito.verify((Object)this.presenter)).enableColumnsTab(Mockito.eq((boolean)false));
    }

    @Test
    public void testOnUpdatedLockStatusEventWhenActiveDecisionTableIsNull() {
        UpdatedLockStatusEvent event = (UpdatedLockStatusEvent)Mockito.mock(UpdatedLockStatusEvent.class);
        ((GuidedDecisionTableModellerView.Presenter)Mockito.doReturn(Optional.empty()).when((Object)this.modeller)).getActiveDecisionTable();
        this.presenter.onUpdatedLockStatusEvent(event);
        ((BaseGuidedDecisionTableEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).enableColumnsTab((GuidedDecisionTableView.Presenter)Matchers.any());
    }
}

