/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.editor;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.enterprise.event.Event;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.editor.BaseGuidedDecisionTableEditorPresenter;
import org.drools.workbench.screens.guided.dtable.client.editor.GuidedDecisionTableEditorPresenter;
import org.drools.workbench.screens.guided.dtable.client.editor.clipboard.Clipboard;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.EditMenuBuilder;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.InsertMenuBuilder;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.RadarMenuBuilder;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.RadarMenuView;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.ViewMenuBuilder;
import org.drools.workbench.screens.guided.dtable.client.editor.page.ColumnsPage;
import org.drools.workbench.screens.guided.dtable.client.type.GuidedDTableResourceType;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.DecisionTableSelectedEvent;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.NewGuidedDecisionTableColumnWizard;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.common.DecisionTablePopoverUtils;
import org.drools.workbench.screens.guided.dtable.service.GuidedDecisionTableEditorService;
import org.guvnor.common.services.project.categories.Decision;
import org.guvnor.common.services.project.client.context.WorkspaceProjectContext;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.messageconsole.client.console.widget.button.AlertsButtonMenuItemBuilder;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.client.menu.FileMenuBuilder;
import org.kie.workbench.common.widgets.client.menu.FileMenuBuilderImpl;
import org.kie.workbench.common.widgets.client.popups.validation.ValidationPopup;
import org.kie.workbench.common.widgets.configresource.client.widget.bound.ImportsWidgetPresenter;
import org.kie.workbench.common.widgets.metadata.client.KieMultipleDocumentEditorWrapperView;
import org.kie.workbench.common.widgets.metadata.client.menu.RegisteredDocumentsMenuBuilder;
import org.kie.workbench.common.widgets.metadata.client.menu.RegisteredDocumentsMenuView;
import org.kie.workbench.common.widgets.metadata.client.widget.OverviewWidgetPresenter;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.ext.editor.commons.client.file.popups.CopyPopUpPresenter;
import org.uberfire.ext.editor.commons.client.file.popups.DeletePopUpPresenter;
import org.uberfire.ext.editor.commons.client.file.popups.RenamePopUpPresenter;
import org.uberfire.ext.editor.commons.client.file.popups.SavePopUpPresenter;
import org.uberfire.ext.editor.commons.client.history.VersionRecordManager;
import org.uberfire.ext.editor.commons.client.menu.BasicFileMenuBuilder;
import org.uberfire.ext.editor.commons.client.menu.BasicFileMenuBuilderImpl;
import org.uberfire.ext.editor.commons.client.menu.DownloadMenuItem;
import org.uberfire.ext.editor.commons.client.menu.RestoreVersionCommandProvider;
import org.uberfire.ext.editor.commons.client.menu.common.SaveAndRenameCommandBuilder;
import org.uberfire.ext.editor.commons.client.validation.DefaultFileNameValidator;
import org.uberfire.ext.editor.commons.version.VersionService;
import org.uberfire.ext.editor.commons.version.events.RestoreEvent;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.ext.widgets.common.client.menu.MenuItemDivider;
import org.uberfire.ext.widgets.common.client.menu.MenuItemDividerView;
import org.uberfire.ext.widgets.common.client.menu.MenuItemFactory;
import org.uberfire.ext.widgets.common.client.menu.MenuItemHeader;
import org.uberfire.ext.widgets.common.client.menu.MenuItemHeaderView;
import org.uberfire.ext.widgets.common.client.menu.MenuItemView;
import org.uberfire.ext.widgets.common.client.menu.MenuItemWithIcon;
import org.uberfire.ext.widgets.common.client.menu.MenuItemWithIconView;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.MenuCustom;
import org.uberfire.workbench.model.menu.MenuGroup;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.MenuItemCommand;
import org.uberfire.workbench.model.menu.MenuItemPerspective;
import org.uberfire.workbench.model.menu.MenuItemPlain;
import org.uberfire.workbench.model.menu.MenuVisitor;
import org.uberfire.workbench.model.menu.Menus;

@RunWith(value=GwtMockitoTestRunner.class)
public class GuidedDecisionTableEditorMenusTest {
    @Mock
    protected BaseGuidedDecisionTableEditorPresenter.View view;
    @Mock
    protected GuidedDecisionTableEditorService dtService;
    protected Caller<GuidedDecisionTableEditorService> dtServiceCaller;
    @Mock
    protected EventSourceMock<NotificationEvent> notification;
    @Mock
    protected EventSourceMock<DecisionTableSelectedEvent> decisionTableSelectedEvent;
    @Mock
    protected ValidationPopup validationPopup;
    @Mock
    protected Clipboard clipboard;
    @Mock
    protected TranslationService ts;
    @Mock
    private ManagedInstance<MenuItemView> menuItemViewProducer;
    @Mock
    private ManagedInstance<MenuItemView> menuItemViewHeaderProducer;
    @Mock
    private ManagedInstance<MenuItemView> menuItemViewWithIconProducer;
    @Mock
    private ManagedInstance<MenuItemView> menuItemViewDividerProducer;
    @Mock
    private ManagedInstance<NewGuidedDecisionTableColumnWizard> wizardManagedInstance;
    private MenuItemFactory menuItemFactory;
    protected EditMenuBuilder editMenuBuilder;
    protected InsertMenuBuilder insertMenuBuilder;
    protected ViewMenuBuilder viewMenuBuilder;
    @Mock
    protected RadarMenuView radarMenuView;
    protected RadarMenuBuilder radarMenuBuilder;
    @Mock
    protected RegisteredDocumentsMenuView registeredDocumentsMenuView;
    @Mock
    protected ManagedInstance<RegisteredDocumentsMenuView.DocumentMenuItem> documentMenuItems;
    protected RegisteredDocumentsMenuBuilder registeredDocumentsMenuBuilder;
    @Mock
    protected MenuItem saveMenuItem;
    @Mock
    protected MenuItem versionManagerMenuItem;
    @Mock
    protected GuidedDecisionTableModellerView.Presenter modeller;
    @Mock
    protected GuidedDecisionTableModellerView modellerView;
    @Mock
    protected KieMultipleDocumentEditorWrapperView kieEditorWrapperView;
    @Mock
    protected OverviewWidgetPresenter overviewWidget;
    @Mock
    protected SavePopUpPresenter savePopUpPresenter;
    @Mock
    protected ImportsWidgetPresenter importsWidget;
    @Mock
    protected EventSourceMock<NotificationEvent> notificationEvent;
    @Mock
    protected EventSourceMock<ChangeTitleWidgetEvent> changeTitleEvent;
    @Mock
    protected WorkspaceProjectContext workbenchContext;
    @Mock
    protected VersionRecordManager versionRecordManager;
    @Mock
    protected VersionService versionService;
    protected CallerMock<VersionService> versionServiceCaller;
    @Mock
    protected EventSourceMock<RestoreEvent> restoreEvent;
    @Mock
    protected DeletePopUpPresenter deletePopUpPresenter;
    @Mock
    protected CopyPopUpPresenter copyPopUpPresenter;
    @Mock
    protected RenamePopUpPresenter renamePopUpPresenter;
    @Mock
    protected BusyIndicatorView busyIndicatorView;
    @Spy
    protected RestoreVersionCommandProvider restoreVersionCommandProvider;
    @Spy
    protected BasicFileMenuBuilder basicFileMenuBuilder;
    @Spy
    protected FileMenuBuilder fileMenuBuilder;
    @Mock
    protected DefaultFileNameValidator fileNameValidator;
    @Mock
    protected SyncBeanManager beanManager;
    @Mock
    protected PlaceManager placeManager;
    @Mock
    protected ColumnsPage columnsPage;
    @Mock
    protected SaveAndRenameCommandBuilder<GuidedDecisionTable52, Metadata> saveAndRenameCommandBuilder;
    @Mock
    protected MenuItemWithIconView menuItemWithIconView;
    @Mock
    private DecisionTablePopoverUtils popoverUtils;
    @Mock
    protected AlertsButtonMenuItemBuilder alertsButtonMenuItemBuilder;
    @Mock
    protected DownloadMenuItem downloadMenuItem;
    @Mock
    protected MenuItem downloadMenuItemButton;
    @Mock
    protected MenuItem alertsButtonMenuItem;
    private GuidedDecisionTableEditorPresenter presenter;
    private GuidedDTableResourceType resourceType;
    private String[] menuItemIdentifiers;

    public GuidedDecisionTableEditorMenusTest() {
        this.registeredDocumentsMenuBuilder = new RegisteredDocumentsMenuBuilder(this.registeredDocumentsMenuView, this.documentMenuItems);
        this.restoreVersionCommandProvider = this.getRestoreVersionCommandProvider();
        this.basicFileMenuBuilder = this.getBasicFileMenuBuilder();
        this.fileMenuBuilder = this.getFileMenuBuilder();
        this.resourceType = new GuidedDTableResourceType(new Decision());
        this.menuItemIdentifiers = new String[]{"org.uberfire.workbench.model.menu.impl.MenuBuilderImpl$CurrentContext$1#Delete", "org.uberfire.workbench.model.menu.impl.MenuBuilderImpl$CurrentContext$1#Rename", "org.uberfire.workbench.model.menu.impl.MenuBuilderImpl$CurrentContext$1#Copy", "org.uberfire.workbench.model.menu.impl.MenuBuilderImpl$CurrentContext$1#Validate", "org.uberfire.workbench.model.menu.impl.DefaultMenuGroup#EditMenu.title", "org.uberfire.ext.widgets.common.client.menu.MenuItemFactory$2$1#EditMenu.cut", "org.uberfire.ext.widgets.common.client.menu.MenuItemFactory$2$1#EditMenu.copy", "org.uberfire.ext.widgets.common.client.menu.MenuItemFactory$2$1#EditMenu.paste", "org.uberfire.ext.widgets.common.client.menu.MenuItemFactory$2$1#EditMenu.deleteCells", "org.uberfire.ext.widgets.common.client.menu.MenuItemFactory$2$1#EditMenu.deleteColumns", "org.uberfire.ext.widgets.common.client.menu.MenuItemFactory$2$1#EditMenu.deleteRows", "org.uberfire.ext.widgets.common.client.menu.MenuItemFactory$2$1#EditMenu.otherwise", "org.uberfire.workbench.model.menu.impl.DefaultMenuGroup#ViewMenu.title", "org.uberfire.ext.widgets.common.client.menu.MenuItemFactory$4$1#ViewMenu.zoom", "org.uberfire.ext.widgets.common.client.menu.MenuItemFactory$2$1#125%", "org.uberfire.ext.widgets.common.client.menu.MenuItemFactory$2$1#100%", "org.uberfire.ext.widgets.common.client.menu.MenuItemFactory$2$1#75%", "org.uberfire.ext.widgets.common.client.menu.MenuItemFactory$2$1#50%", "org.uberfire.ext.widgets.common.client.menu.MenuItemFactory$6$1#null", "org.uberfire.ext.widgets.common.client.menu.MenuItemFactory$2$1#ViewMenu.merged", "org.uberfire.ext.widgets.common.client.menu.MenuItemFactory$2$1#ViewMenu.auditLog", "org.uberfire.workbench.model.menu.impl.DefaultMenuGroup#InsertMenu.title", "org.uberfire.ext.widgets.common.client.menu.MenuItemFactory$2$1#InsertMenu.appendRow", "org.uberfire.ext.widgets.common.client.menu.MenuItemFactory$2$1#InsertMenu.insertRowAbove", "org.uberfire.ext.widgets.common.client.menu.MenuItemFactory$2$1#InsertMenu.insertRowBelow", "org.uberfire.ext.widgets.common.client.menu.MenuItemFactory$2$1#InsertMenu.insertColumn", "org.drools.workbench.screens.guided.dtable.client.editor.menu.RadarMenuBuilder$1#null"};
    }

    @Before
    public void setup() {
        Mockito.when((Object)this.downloadMenuItem.build((Supplier)Matchers.any())).thenReturn((Object)this.downloadMenuItemButton);
        Mockito.when((Object)this.alertsButtonMenuItemBuilder.build()).thenReturn((Object)this.alertsButtonMenuItem);
        Mockito.when((Object)this.modeller.getView()).thenReturn((Object)this.modellerView);
        Mockito.when((Object)this.versionRecordManager.newSaveMenuItem((Command)Matchers.any(Command.class))).thenReturn((Object)this.saveMenuItem);
        Mockito.when((Object)this.versionRecordManager.buildMenu()).thenReturn((Object)this.versionManagerMenuItem);
        Mockito.when((Object)this.ts.getTranslation((String)Matchers.any(String.class))).thenAnswer(invocation -> invocation.getArguments()[0]);
        Mockito.when((Object)this.menuItemViewProducer.select(new Annotation[]{(Annotation)Matchers.any(Annotation.class)})).thenAnswer(o -> {
            Annotation a = (Annotation)o.getArguments()[0];
            if (a.annotationType().equals(MenuItemHeader.class)) {
                return this.menuItemViewHeaderProducer;
            }
            if (a.annotationType().equals(MenuItemWithIcon.class)) {
                return this.menuItemViewWithIconProducer;
            }
            if (a.annotationType().equals(MenuItemDivider.class)) {
                return this.menuItemViewDividerProducer;
            }
            throw new IllegalArgumentException("Unexpected MenuItemView");
        });
        Mockito.when((Object)this.menuItemViewHeaderProducer.get()).thenReturn(Mockito.mock(MenuItemHeaderView.class));
        Mockito.when((Object)this.menuItemViewDividerProducer.get()).thenReturn(Mockito.mock(MenuItemDividerView.class));
        Mockito.when((Object)this.menuItemViewWithIconProducer.get()).thenReturn((Object)this.menuItemWithIconView);
        Mockito.when((Object)this.menuItemWithIconView.getElement()).thenReturn(Mockito.mock(HTMLElement.class));
        this.dtServiceCaller = new CallerMock((Object)this.dtService);
        this.versionServiceCaller = new CallerMock((Object)this.versionService);
        this.menuItemFactory = new MenuItemFactory(this.menuItemViewProducer);
        this.editMenuBuilder = new EditMenuBuilder(this.clipboard, this.ts, this.menuItemFactory, this.popoverUtils);
        this.editMenuBuilder.setup();
        this.insertMenuBuilder = new InsertMenuBuilder(this.ts, this.menuItemFactory, this.wizardManagedInstance);
        this.insertMenuBuilder.setup();
        this.insertMenuBuilder.setModeller(this.modeller);
        this.viewMenuBuilder = new ViewMenuBuilder(this.ts, this.menuItemFactory);
        this.viewMenuBuilder.setup();
        this.viewMenuBuilder.setModeller(this.modeller);
        this.radarMenuBuilder = new RadarMenuBuilder(this.radarMenuView);
        this.radarMenuBuilder.setup();
        GuidedDecisionTableEditorPresenter wrapped = new GuidedDecisionTableEditorPresenter(this.view, (Caller)this.dtServiceCaller, (Event)this.notification, (Event)this.decisionTableSelectedEvent, this.validationPopup, this.resourceType, this.editMenuBuilder, this.viewMenuBuilder, this.insertMenuBuilder, this.radarMenuBuilder, this.modeller, this.beanManager, this.placeManager, this.columnsPage, (SaveAndRenameCommandBuilder)this.saveAndRenameCommandBuilder, this.alertsButtonMenuItemBuilder, this.downloadMenuItem){

            protected Command getSaveAndRenameCommand() {
                return (Command)Mockito.mock(Command.class);
            }
        };
        wrapped.setKieEditorWrapperView(this.kieEditorWrapperView);
        wrapped.setOverviewWidget(this.overviewWidget);
        wrapped.setSavePopUpPresenter(this.savePopUpPresenter);
        wrapped.setImportsWidget(this.importsWidget);
        wrapped.setNotificationEvent(this.notificationEvent);
        wrapped.setChangeTitleEvent(this.changeTitleEvent);
        wrapped.setWorkbenchContext(this.workbenchContext);
        wrapped.setVersionRecordManager(this.versionRecordManager);
        wrapped.setRegisteredDocumentsMenuBuilder(this.registeredDocumentsMenuBuilder);
        wrapped.setFileMenuBuilder(this.fileMenuBuilder);
        wrapped.setFileNameValidator(this.fileNameValidator);
        this.presenter = (GuidedDecisionTableEditorPresenter)Mockito.spy((Object)wrapped);
        Mockito.when((Object)this.workbenchContext.getActiveOrganizationalUnit()).thenReturn(Optional.empty());
        Mockito.when((Object)this.workbenchContext.getActiveWorkspaceProject()).thenReturn(Optional.empty());
        this.presenter.init();
        this.presenter.setupMenuBar();
    }

    @Test
    public void checkMenuStructure() {
        final AtomicInteger i = new AtomicInteger(0);
        Menus menus = this.presenter.getMenus();
        MenuVisitor visitor = new MenuVisitor(){

            public boolean visitEnter(Menus menus) {
                return true;
            }

            public void visitLeave(Menus menus) {
            }

            public boolean visitEnter(MenuGroup menuGroup) {
                Assert.assertEquals((Object)GuidedDecisionTableEditorMenusTest.this.menuItemIdentifiers[i.getAndIncrement()], (Object)menuGroup.getIdentifier());
                return true;
            }

            public void visitLeave(MenuGroup menuGroup) {
            }

            public void visit(MenuItemPlain menuItemPlain) {
                Assert.assertEquals((Object)GuidedDecisionTableEditorMenusTest.this.menuItemIdentifiers[i.getAndIncrement()], (Object)menuItemPlain.getIdentifier());
            }

            public void visit(MenuItemCommand menuItemCommand) {
                Assert.assertEquals((Object)GuidedDecisionTableEditorMenusTest.this.menuItemIdentifiers[i.getAndIncrement()], (Object)menuItemCommand.getIdentifier());
            }

            public void visit(MenuItemPerspective menuItemPerspective) {
                Assert.assertEquals((Object)GuidedDecisionTableEditorMenusTest.this.menuItemIdentifiers[i.getAndIncrement()], (Object)menuItemPerspective.getIdentifier());
            }

            public void visit(MenuCustom<?> menuCustom) {
                Assert.assertEquals((Object)GuidedDecisionTableEditorMenusTest.this.menuItemIdentifiers[i.getAndIncrement()], (Object)menuCustom.getIdentifier());
            }
        };
        menus.accept(visitor);
    }

    private RestoreVersionCommandProvider getRestoreVersionCommandProvider() {
        RestoreVersionCommandProvider restoreVersionCommandProvider = new RestoreVersionCommandProvider();
        this.setField(restoreVersionCommandProvider, "versionService", this.versionServiceCaller);
        this.setField(restoreVersionCommandProvider, "restoreEvent", this.restoreEvent);
        this.setField(restoreVersionCommandProvider, "busyIndicatorView", this.view);
        return restoreVersionCommandProvider;
    }

    private BasicFileMenuBuilder getBasicFileMenuBuilder() {
        BasicFileMenuBuilderImpl basicFileMenuBuilder = new BasicFileMenuBuilderImpl(this.deletePopUpPresenter, this.copyPopUpPresenter, this.renamePopUpPresenter, this.busyIndicatorView, this.notification, this.restoreVersionCommandProvider);
        this.setField(basicFileMenuBuilder, "restoreVersionCommandProvider", this.restoreVersionCommandProvider);
        this.setField(basicFileMenuBuilder, "notification", this.notificationEvent);
        this.setField(this.restoreVersionCommandProvider, "busyIndicatorView", this.view);
        return basicFileMenuBuilder;
    }

    private FileMenuBuilder getFileMenuBuilder() {
        FileMenuBuilderImpl fileMenuBuilder = new FileMenuBuilderImpl();
        this.setField(fileMenuBuilder, "menuBuilder", this.basicFileMenuBuilder);
        return fileMenuBuilder;
    }

    private void setField(Object o, String fieldName, Object value) {
        try {
            Field field = o.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(o, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

