/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.editor;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Collections;
import java.util.Optional;
import javax.enterprise.event.Event;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.editor.BaseGuidedDecisionTablePresenterTest;
import org.drools.workbench.screens.guided.dtable.client.editor.GuidedDecisionTableEditorPresenter;
import org.drools.workbench.screens.guided.dtable.client.type.GuidedDTableResourceType;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.DecisionTableSelectedEvent;
import org.drools.workbench.screens.guided.dtable.model.GuidedDecisionTableEditorContent;
import org.guvnor.common.services.project.categories.Decision;
import org.guvnor.common.services.project.client.context.WorkspaceProjectContext;
import org.guvnor.common.services.project.client.security.ProjectController;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.project.datamodel.imports.Imports;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.menu.FileMenuBuilder;
import org.kie.workbench.common.widgets.configresource.client.widget.bound.ImportsWidgetPresenter;
import org.kie.workbench.common.widgets.metadata.client.KieDocument;
import org.kie.workbench.common.widgets.metadata.client.KieMultipleDocumentEditorWrapperView;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.editor.commons.client.menu.BasicFileMenuBuilder;
import org.uberfire.ext.editor.commons.client.menu.common.SaveAndRenameCommandBuilder;
import org.uberfire.ext.editor.commons.client.validation.Validator;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.GridLienzoPanel;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.model.menu.MenuItem;

@RunWith(value=GwtMockitoTestRunner.class)
public class GuidedDecisionTableEditorPresenterTest
extends BaseGuidedDecisionTablePresenterTest<GuidedDecisionTableEditorPresenter> {
    private GuidedDTableResourceType resourceType = new GuidedDTableResourceType(new Decision());
    @Mock
    private SaveAndRenameCommandBuilder<GuidedDecisionTable52, Metadata> saveAndRenameCommandBuilder;

    @Override
    protected GuidedDecisionTableEditorPresenter getPresenter() {
        return new GuidedDecisionTableEditorPresenter(this.view, this.dtServiceCaller, this.notification, this.decisionTableSelectedEvent, this.validationPopup, this.resourceType, this.editMenuBuilder, this.viewMenuBuilder, this.insertMenuBuilder, this.radarMenuBuilder, this.modeller, this.beanManager, this.placeManager, this.columnsPage, this.saveAndRenameCommandBuilder, this.alertsButtonMenuItemBuilder, this.downloadMenuItem){
            {
                this.workbenchContext = GuidedDecisionTableEditorPresenterTest.this.workbenchContext;
                this.projectController = GuidedDecisionTableEditorPresenterTest.this.projectController;
            }

            protected Command getSaveAndRenameCommand() {
                return (Command)Mockito.mock(Command.class);
            }
        };
    }

    @Test
    public void testSetupMenuBar() {
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilder, (VerificationMode)Mockito.times((int)1))).addSave((MenuItem)Mockito.any(MenuItem.class));
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilder, (VerificationMode)Mockito.times((int)1))).addCopy((BasicFileMenuBuilder.PathProvider)Mockito.any(BasicFileMenuBuilder.PathProvider.class), (Validator)Mockito.eq((Object)this.assetUpdateValidator));
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilder, (VerificationMode)Mockito.times((int)1))).addRename((Command)Mockito.any(Command.class));
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilder, (VerificationMode)Mockito.times((int)1))).addDelete((BasicFileMenuBuilder.PathProvider)Mockito.any(BasicFileMenuBuilder.PathProvider.class), (Validator)Mockito.eq((Object)this.assetUpdateValidator));
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilder, (VerificationMode)Mockito.times((int)1))).addValidate((Command)Mockito.any(Command.class));
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilder, (VerificationMode)Mockito.times((int)1))).addNewTopLevelMenu((MenuItem)Mockito.eq((Object)this.editMenuItem));
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilder, (VerificationMode)Mockito.times((int)1))).addNewTopLevelMenu((MenuItem)Mockito.eq((Object)this.viewMenuItem));
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilder, (VerificationMode)Mockito.times((int)1))).addNewTopLevelMenu((MenuItem)Mockito.eq((Object)this.insertMenuItem));
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilder, (VerificationMode)Mockito.times((int)1))).addNewTopLevelMenu((MenuItem)Mockito.eq((Object)this.radarMenuItem));
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilder, (VerificationMode)Mockito.times((int)1))).addNewTopLevelMenu((MenuItem)Mockito.eq((Object)this.versionManagerMenuItem));
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilder)).addNewTopLevelMenu(this.alertsButtonMenuItem);
    }

    @Test
    public void testMakeMenuBarWithoutUpdateProjectPermission() {
        Mockito.reset((Object[])new FileMenuBuilder[]{this.fileMenuBuilder});
        ((WorkspaceProjectContext)Mockito.doReturn(Optional.of(Mockito.mock(WorkspaceProject.class))).when((Object)this.workbenchContext)).getActiveWorkspaceProject();
        ((ProjectController)Mockito.doReturn((Object)false).when((Object)this.projectController)).canUpdateProject((WorkspaceProject)Mockito.any());
        ((GuidedDecisionTableEditorPresenter)this.presenter).makeMenuBar();
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilder, (VerificationMode)Mockito.never())).addSave((MenuItem)Mockito.any(MenuItem.class));
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilder, (VerificationMode)Mockito.never())).addCopy((BasicFileMenuBuilder.PathProvider)Mockito.any(BasicFileMenuBuilder.PathProvider.class), (Validator)Mockito.eq((Object)this.assetUpdateValidator));
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilder, (VerificationMode)Mockito.never())).addRename((BasicFileMenuBuilder.PathProvider)Mockito.any(BasicFileMenuBuilder.PathProvider.class), (Validator)Mockito.eq((Object)this.assetUpdateValidator));
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilder, (VerificationMode)Mockito.never())).addDelete((BasicFileMenuBuilder.PathProvider)Mockito.any(BasicFileMenuBuilder.PathProvider.class), (Validator)Mockito.eq((Object)this.assetUpdateValidator));
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilder)).addNewTopLevelMenu(this.alertsButtonMenuItem);
    }

    @Test
    public void startUpSelectsDecisionTable() {
        ObservablePath path = (ObservablePath)Mockito.mock(ObservablePath.class);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        GuidedDecisionTableEditorContent content = this.makeDecisionTableContent();
        GuidedDecisionTableView.Presenter dtPresenter = this.makeDecisionTable((Path)path, path, placeRequest, content);
        ((GuidedDecisionTableEditorPresenter)this.presenter).onStartup(path, placeRequest);
        ((Event)Mockito.verify((Object)this.decisionTableSelectedEvent, (VerificationMode)Mockito.times((int)1))).fire(this.dtSelectedEventCaptor.capture());
        DecisionTableSelectedEvent dtSelectedEvent = (DecisionTableSelectedEvent)this.dtSelectedEventCaptor.getValue();
        Assert.assertNotNull((Object)dtSelectedEvent);
        Assert.assertTrue((boolean)dtSelectedEvent.getPresenter().isPresent());
        Assert.assertEquals((Object)dtPresenter, dtSelectedEvent.getPresenter().get());
        ((GridLienzoPanel)Mockito.verify((Object)this.modellerGridPanel)).setFocus(Mockito.eq((boolean)true));
    }

    @Test
    public void checkGetAvailableDocumentPaths() {
        ((GuidedDecisionTableEditorPresenter)this.presenter).getAvailableDocumentPaths(result -> Assert.assertTrue((boolean)result.isEmpty()));
    }

    @Test
    public void checkOnOpenDocumentsInEditor() {
        this.exception.expect(UnsupportedOperationException.class);
        ((GuidedDecisionTableEditorPresenter)this.presenter).onOpenDocumentsInEditor(Collections.emptyList());
    }

    @Test
    public void checkRemoveDocumentClosesEditor() {
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        GuidedDecisionTableView.Presenter dtPresenter = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        ((GuidedDecisionTableEditorPresenter)this.presenter).editorPlaceRequest = placeRequest;
        ((GuidedDecisionTableEditorPresenter)this.presenter).removeDocument(dtPresenter);
        ArgumentCaptor commandCaptor = ArgumentCaptor.forClass(Scheduler.ScheduledCommand.class);
        ((GuidedDecisionTableEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).scheduleClosure((Scheduler.ScheduledCommand)commandCaptor.capture());
        Scheduler.ScheduledCommand command = (Scheduler.ScheduledCommand)commandCaptor.getValue();
        Assert.assertNotNull((Object)command);
        command.execute();
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.times((int)1))).forceClosePlace((PlaceRequest)Mockito.eq((Object)placeRequest));
    }

    @Test
    public void testGetMetadataSupplier() {
        GuidedDecisionTableView.Presenter document = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        Overview overview = (Overview)Mockito.mock(Overview.class);
        Metadata expectedMetadata = (Metadata)Mockito.mock(Metadata.class);
        ((GuidedDecisionTableEditorPresenter)Mockito.doReturn((Object)document).when((Object)this.presenter)).getActiveDocument();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)overview).when((Object)document)).getOverview();
        ((Overview)Mockito.doReturn((Object)expectedMetadata).when((Object)overview)).getMetadata();
        Metadata actualMetadata = (Metadata)((GuidedDecisionTableEditorPresenter)this.presenter).getMetadataSupplier().get();
        Assert.assertEquals((Object)expectedMetadata, (Object)actualMetadata);
    }

    @Test
    public void testGetContentSupplier() {
        GuidedDecisionTableView.Presenter presenter = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        GuidedDecisionTable52 expected = (GuidedDecisionTable52)Mockito.mock(GuidedDecisionTable52.class);
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)expected).when((Object)presenter)).getModel();
        ((GuidedDecisionTableEditorPresenter)Mockito.doReturn((Object)presenter).when((Object)this.presenter)).getActiveDocument();
        GuidedDecisionTable52 actual = (GuidedDecisionTable52)((GuidedDecisionTableEditorPresenter)this.presenter).getContentSupplier().get();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testGetIsDirtySupplierWhenItIsDirty() {
        GuidedDecisionTableView.Presenter presenter = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        GuidedDecisionTable52 model = (GuidedDecisionTable52)Mockito.mock(GuidedDecisionTable52.class);
        int currentHash = 456;
        int originalHash = 123;
        ((GuidedDecisionTableEditorPresenter)Mockito.doReturn((Object)456).when((Object)this.presenter)).currentHashCode(presenter);
        ((GuidedDecisionTableEditorPresenter)Mockito.doReturn((Object)123).when((Object)this.presenter)).originalHashCode(presenter);
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)model).when((Object)presenter)).getModel();
        ((GuidedDecisionTableEditorPresenter)Mockito.doReturn((Object)presenter).when((Object)this.presenter)).getActiveDocument();
        boolean isDirty = (Boolean)((GuidedDecisionTableEditorPresenter)this.presenter).getIsDirtySupplier().get();
        Assert.assertTrue((boolean)isDirty);
    }

    @Test
    public void testGetIsDirtySupplierWhenItIsNotDirty() {
        GuidedDecisionTableView.Presenter presenter = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        GuidedDecisionTable52 model = (GuidedDecisionTable52)Mockito.mock(GuidedDecisionTable52.class);
        int currentHash = 123;
        int originalHash = 123;
        ((GuidedDecisionTableEditorPresenter)Mockito.doReturn((Object)123).when((Object)this.presenter)).currentHashCode(presenter);
        ((GuidedDecisionTableEditorPresenter)Mockito.doReturn((Object)123).when((Object)this.presenter)).originalHashCode(presenter);
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)model).when((Object)presenter)).getModel();
        ((GuidedDecisionTableEditorPresenter)Mockito.doReturn((Object)presenter).when((Object)this.presenter)).getActiveDocument();
        boolean isDirty = (Boolean)((GuidedDecisionTableEditorPresenter)this.presenter).getIsDirtySupplier().get();
        Assert.assertFalse((boolean)isDirty);
    }

    @Test
    public void testImportsTabIsAdded() {
        ObservablePath path = (ObservablePath)Mockito.mock(ObservablePath.class);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        GuidedDecisionTableEditorContent content = this.makeDecisionTableContent();
        GuidedDecisionTableView.Presenter dtDocument = this.makeDecisionTable((Path)path, path, placeRequest, content);
        ((GuidedDecisionTableEditorPresenter)this.presenter).registerDocument((KieDocument)dtDocument);
        ((GuidedDecisionTableEditorPresenter)this.presenter).refreshDocument(dtDocument);
        ((KieMultipleDocumentEditorWrapperView)Mockito.verify((Object)this.kieEditorWrapperView)).addImportsTab((IsWidget)Mockito.eq((Object)this.importsWidget));
        AsyncPackageDataModelOracle oracle = dtDocument.getDataModelOracle();
        Imports imports = dtDocument.getModel().getImports();
        ((ImportsWidgetPresenter)Mockito.verify((Object)this.importsWidget)).setContent((AsyncPackageDataModelOracle)Matchers.same((Object)oracle), (Imports)Matchers.same((Object)imports), Mockito.eq((boolean)false));
    }
}

