/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.editor.page;

import com.google.gwt.dev.util.collect.HashMap;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.AttributeCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.CompositeColumn;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.MetadataCol52;
import org.drools.workbench.screens.guided.dtable.client.editor.page.ColumnsPagePresenter;
import org.drools.workbench.screens.guided.dtable.client.editor.page.accordion.GuidedDecisionTableAccordion;
import org.drools.workbench.screens.guided.dtable.client.editor.page.accordion.GuidedDecisionTableAccordionItem;
import org.drools.workbench.screens.guided.dtable.client.resources.GuidedDecisionTableResources;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.control.AttributeColumnConfigRow;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.control.ColumnLabelWidget;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.control.ColumnManagementView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.control.DeleteColumnManagementAnchorWidget;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.DecisionTableSelectedEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.RefreshActionsPanelEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.RefreshAttributesPanelEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.RefreshConditionsPanelEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.RefreshMetaDataPanelEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.ModelSynchronizer;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.NewGuidedDecisionTableColumnWizard;
import org.gwtbootstrap3.client.ui.CheckBox;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.client.ruleselector.RuleSelector;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.client.mvp.UpdatedLockStatusEvent;
import org.uberfire.mvp.ParameterizedCommand;

@RunWith(value=GwtMockitoTestRunner.class)
public class ColumnsPagePresenterTest {
    @Mock
    private ColumnsPagePresenter.View view;
    @Mock
    private GuidedDecisionTableAccordion accordion;
    @Mock
    private ManagedInstance<NewGuidedDecisionTableColumnWizard> wizardManagedInstance;
    @Mock
    private TranslationService translationService;
    @Mock
    private ManagedInstance<DeleteColumnManagementAnchorWidget> deleteColumnManagementAnchorWidgets;
    @Mock
    private ManagedInstance<AttributeColumnConfigRow> attributeColumnConfigRow;
    @Mock
    private ColumnManagementView conditionsPanel;
    @Mock
    private ColumnManagementView actionsPanel;
    @Mock
    private VerticalPanel verticalPanel;
    @Mock
    private GuidedDecisionTableModellerView.Presenter modeller;
    @Mock
    private MetadataCol52 metadataColumn;
    @Mock
    private CompositeColumn<? extends BaseColumn> compositeColumn1;
    @Mock
    private CompositeColumn<? extends BaseColumn> compositeColumn2;
    @Mock
    private CompositeColumn<? extends BaseColumn> compositeColumn3;
    private ColumnsPagePresenter presenter;

    @Before
    public void setUp() {
        this.presenter = (ColumnsPagePresenter)Mockito.spy((Object)new ColumnsPagePresenter(this.view, this.accordion, this.wizardManagedInstance, this.translationService, this.deleteColumnManagementAnchorWidgets, this.attributeColumnConfigRow, this.conditionsPanel, this.actionsPanel));
        ((ColumnsPagePresenter)Mockito.doReturn((Object)this.modeller).when((Object)this.presenter)).getModeller();
    }

    @Test
    public void testSetup() {
        this.presenter.setup();
        ((ColumnsPagePresenter.View)Mockito.verify((Object)this.view)).init((Object)this.presenter);
    }

    @Test
    public void testInit() {
        GuidedDecisionTableModellerView.Presenter modeller = (GuidedDecisionTableModellerView.Presenter)Mockito.mock(GuidedDecisionTableModellerView.Presenter.class);
        ((ColumnsPagePresenter)Mockito.doNothing().when((Object)this.presenter)).setupAccordion();
        ((ColumnsPagePresenter)Mockito.doNothing().when((Object)this.presenter)).setupRuleInheritance();
        ((ColumnsPagePresenter)Mockito.doNothing().when((Object)this.presenter)).setupColumnsNoteInfo(modeller);
        ((ColumnsPagePresenter)Mockito.doNothing().when((Object)this.presenter)).setupConditionsPanel(modeller);
        ((ColumnsPagePresenter)Mockito.doNothing().when((Object)this.presenter)).setupActionsPanel(modeller);
        ((ColumnsPagePresenter)Mockito.doCallRealMethod().when((Object)this.presenter)).getModeller();
        this.presenter.init(modeller);
        ((ColumnsPagePresenter)Mockito.verify((Object)this.presenter)).setupAccordion();
        ((ColumnsPagePresenter)Mockito.verify((Object)this.presenter)).setupRuleInheritance();
        ((ColumnsPagePresenter)Mockito.verify((Object)this.presenter)).setupColumnsNoteInfo(modeller);
        ((ColumnsPagePresenter)Mockito.verify((Object)this.presenter)).setupConditionsPanel(modeller);
        ((ColumnsPagePresenter)Mockito.verify((Object)this.presenter)).setupActionsPanel(modeller);
        Assert.assertEquals((Object)modeller, (Object)this.presenter.getModeller());
    }

    @Test
    public void testSetupConditionsPanel() {
        this.presenter.setupConditionsPanel(this.modeller);
        ((ColumnManagementView)Mockito.verify((Object)this.conditionsPanel)).init(this.modeller);
    }

    @Test
    public void testSetupActionsPanel() {
        this.presenter.setupActionsPanel(this.modeller);
        ((ColumnManagementView)Mockito.verify((Object)this.actionsPanel)).init(this.modeller);
    }

    @Test
    public void testSetupAccordionWidgets() {
        VerticalPanel verticalPanel = (VerticalPanel)Mockito.mock(VerticalPanel.class);
        ((ColumnsPagePresenter)Mockito.doReturn((Object)verticalPanel).when((Object)this.presenter)).makeDefaultPanel();
        this.presenter.setupAccordionWidgets();
        ((ColumnsPagePresenter)Mockito.verify((Object)this.presenter)).setupAccordionWidget((GuidedDecisionTableAccordionItem.Type)Matchers.eq((Object)GuidedDecisionTableAccordionItem.Type.ATTRIBUTE), (Consumer)Matchers.any());
        ((ColumnsPagePresenter)Mockito.verify((Object)this.presenter)).setupAccordionWidget((GuidedDecisionTableAccordionItem.Type)Matchers.eq((Object)GuidedDecisionTableAccordionItem.Type.METADATA), (Consumer)Matchers.any());
        ((ColumnsPagePresenter)Mockito.verify((Object)this.presenter)).setupAccordionWidget((GuidedDecisionTableAccordionItem.Type)Matchers.eq((Object)GuidedDecisionTableAccordionItem.Type.CONDITION), (Consumer)Matchers.any());
        ((ColumnsPagePresenter)Mockito.verify((Object)this.presenter)).setupAccordionWidget((GuidedDecisionTableAccordionItem.Type)Matchers.eq((Object)GuidedDecisionTableAccordionItem.Type.ACTION), (Consumer)Matchers.any());
        Assert.assertEquals((Object)verticalPanel, (Object)this.presenter.getAttributeWidget());
        Assert.assertEquals((Object)verticalPanel, (Object)this.presenter.getMetaDataWidget());
        Assert.assertEquals((Object)verticalPanel, (Object)this.presenter.getConditionsWidget());
        Assert.assertEquals((Object)verticalPanel, (Object)this.presenter.getActionsWidget());
    }

    @Test
    public void testSetupAccordionWidget() {
        VerticalPanel defaultPanel = (VerticalPanel)Mockito.mock(VerticalPanel.class);
        GuidedDecisionTableAccordionItem.Type accordionType = GuidedDecisionTableAccordionItem.Type.METADATA;
        Consumer<VerticalPanel> setWidget = panel -> Assert.assertEquals((Object)panel, (Object)defaultPanel);
        ((ColumnsPagePresenter)Mockito.doReturn((Object)defaultPanel).when((Object)this.presenter)).makeDefaultPanel();
        this.presenter.setupAccordionWidget(accordionType, setWidget);
        ((GuidedDecisionTableAccordion)Mockito.verify((Object)this.accordion)).addItem(accordionType, (Widget)defaultPanel);
    }

    @Test
    public void testRefreshAttributeWidgetWhenAttributeColumnsIsEmpty() {
        ArrayList attributeColumns = new ArrayList();
        AttributeColumnConfigRow attributeColumnConfigRow = (AttributeColumnConfigRow)Mockito.mock(AttributeColumnConfigRow.class);
        Label blankSlate = (Label)Mockito.mock(Label.class);
        ((ColumnsPagePresenter)Mockito.doReturn((Object)this.verticalPanel).when((Object)this.presenter)).getAttributeWidget();
        ((ManagedInstance)Mockito.doReturn((Object)attributeColumnConfigRow).when(this.attributeColumnConfigRow)).get();
        ((ColumnsPagePresenter)Mockito.doReturn((Object)blankSlate).when((Object)this.presenter)).blankSlate();
        this.presenter.refreshAttributeWidget(attributeColumns);
        ((VerticalPanel)Mockito.verify((Object)this.verticalPanel)).add((Widget)blankSlate);
        ((AttributeColumnConfigRow)Mockito.verify((Object)attributeColumnConfigRow, (VerificationMode)Mockito.never())).init((AttributeCol52)Matchers.any(), (GuidedDecisionTableModellerView.Presenter)Matchers.any());
    }

    @Test
    public void testRefreshAttributeWidgetWhenAttributeColumnsIsNotEmpty() {
        AttributeColumnConfigRow attributeColumnConfigRow = (AttributeColumnConfigRow)Mockito.mock(AttributeColumnConfigRow.class);
        Label blankSlate = (Label)Mockito.mock(Label.class);
        final AttributeCol52 attributeCol52 = (AttributeCol52)Mockito.mock(AttributeCol52.class);
        Widget widget = (Widget)Mockito.mock(Widget.class);
        ArrayList<AttributeCol52> attributeColumns = new ArrayList<AttributeCol52>(){
            {
                this.add(attributeCol52);
            }
        };
        ((ColumnsPagePresenter)Mockito.doReturn((Object)this.verticalPanel).when((Object)this.presenter)).getAttributeWidget();
        ((ManagedInstance)Mockito.doReturn((Object)attributeColumnConfigRow).when(this.attributeColumnConfigRow)).get();
        ((AttributeColumnConfigRow)Mockito.doReturn((Object)widget).when((Object)attributeColumnConfigRow)).getView();
        ((ColumnsPagePresenter)Mockito.doReturn((Object)blankSlate).when((Object)this.presenter)).blankSlate();
        this.presenter.refreshAttributeWidget((List)attributeColumns);
        ((AttributeColumnConfigRow)Mockito.verify((Object)attributeColumnConfigRow)).init(attributeCol52, this.modeller);
        ((VerticalPanel)Mockito.verify((Object)this.verticalPanel, (VerificationMode)Mockito.never())).add((Widget)blankSlate);
        ((VerticalPanel)Mockito.verify((Object)this.verticalPanel)).add(widget);
    }

    @Test
    public void testRefreshMetaDataWidgetWhenModellerIsNull() {
        ArrayList metaDataColumns = new ArrayList();
        ((ColumnsPagePresenter)Mockito.doReturn(null).when((Object)this.presenter)).getModeller();
        ((ColumnsPagePresenter)Mockito.doReturn((Object)this.verticalPanel).when((Object)this.presenter)).getMetaDataWidget();
        this.presenter.refreshMetaDataWidget(metaDataColumns);
        ((VerticalPanel)Mockito.verify((Object)this.verticalPanel, (VerificationMode)Mockito.never())).clear();
        ((VerticalPanel)Mockito.verify((Object)this.verticalPanel, (VerificationMode)Mockito.never())).add((Widget)Matchers.any());
    }

    @Test
    public void testRefreshMetaDataWidgetWhenModellerIsNotNullAndMetaDataColumnsIsEmpty() {
        ArrayList metaDataColumns = new ArrayList();
        Label blankSlate = (Label)Mockito.mock(Label.class);
        ((ColumnsPagePresenter)Mockito.doReturn((Object)this.verticalPanel).when((Object)this.presenter)).getMetaDataWidget();
        ((ColumnsPagePresenter)Mockito.doReturn((Object)blankSlate).when((Object)this.presenter)).blankSlate();
        this.presenter.refreshMetaDataWidget(metaDataColumns);
        ((VerticalPanel)Mockito.verify((Object)this.verticalPanel)).clear();
        ((VerticalPanel)Mockito.verify((Object)this.verticalPanel)).add((Widget)blankSlate);
    }

    @Test
    public void testRefreshMetaDataWidgetWhenModellerIsNotNullAndMetaDataColumnsIsNotEmpty() {
        final MetadataCol52 metadataColumn1 = (MetadataCol52)Mockito.mock(MetadataCol52.class);
        final MetadataCol52 metadataColumn2 = (MetadataCol52)Mockito.mock(MetadataCol52.class);
        HorizontalPanel metaDataWidget1 = (HorizontalPanel)Mockito.mock(HorizontalPanel.class);
        HorizontalPanel metaDataWidget2 = (HorizontalPanel)Mockito.mock(HorizontalPanel.class);
        ArrayList<MetadataCol52> metaDataColumns = new ArrayList<MetadataCol52>(){
            {
                this.add(metadataColumn1);
                this.add(metadataColumn2);
            }
        };
        ((ColumnsPagePresenter)Mockito.doReturn((Object)this.verticalPanel).when((Object)this.presenter)).getMetaDataWidget();
        ((ColumnsPagePresenter)Mockito.doReturn((Object)metaDataWidget1).when((Object)this.presenter)).makeMetaDataWidget(this.modeller, metadataColumn1);
        ((ColumnsPagePresenter)Mockito.doReturn((Object)metaDataWidget2).when((Object)this.presenter)).makeMetaDataWidget(this.modeller, metadataColumn2);
        this.presenter.refreshMetaDataWidget((List)metaDataColumns);
        ((VerticalPanel)Mockito.verify((Object)this.verticalPanel)).clear();
        ((VerticalPanel)Mockito.verify((Object)this.verticalPanel)).add((Widget)metaDataWidget1);
        ((VerticalPanel)Mockito.verify((Object)this.verticalPanel)).add((Widget)metaDataWidget2);
    }

    @Test
    public void testMakeMetaDataWidgetWhenDecisionTableIsEditable() {
        HorizontalPanel expectedHorizontalPanel = (HorizontalPanel)Mockito.mock(HorizontalPanel.class);
        ColumnLabelWidget columnLabelWidget = (ColumnLabelWidget)Mockito.mock(ColumnLabelWidget.class);
        CheckBox hideColumnCheckBox = (CheckBox)Mockito.mock(CheckBox.class);
        DeleteColumnManagementAnchorWidget deleteColumnManagementAnchorWidget = (DeleteColumnManagementAnchorWidget)Mockito.mock(DeleteColumnManagementAnchorWidget.class);
        boolean isEditable = true;
        ((ColumnsPagePresenter)Mockito.doReturn((Object)expectedHorizontalPanel).when((Object)this.presenter)).makeHorizontalPanel();
        ((ColumnsPagePresenter)Mockito.doReturn((Object)columnLabelWidget).when((Object)this.presenter)).makeColumnLabel(this.metadataColumn);
        ((ColumnsPagePresenter)Mockito.doReturn((Object)hideColumnCheckBox).when((Object)this.presenter)).hideColumnCheckBox(this.modeller, this.metadataColumn);
        ((ColumnsPagePresenter)Mockito.doReturn((Object)deleteColumnManagementAnchorWidget).when((Object)this.presenter)).deleteMetaDataColumnAnchor(this.modeller, this.metadataColumn);
        ((GuidedDecisionTableModellerView.Presenter)Mockito.doReturn((Object)true).when((Object)this.modeller)).isActiveDecisionTableEditable();
        HorizontalPanel actualHorizontalPanel = this.presenter.makeMetaDataWidget(this.modeller, this.metadataColumn);
        ((HorizontalPanel)Mockito.verify((Object)actualHorizontalPanel)).setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        ((HorizontalPanel)Mockito.verify((Object)actualHorizontalPanel)).add((Widget)columnLabelWidget);
        ((HorizontalPanel)Mockito.verify((Object)actualHorizontalPanel)).add((Widget)hideColumnCheckBox);
        ((HorizontalPanel)Mockito.verify((Object)actualHorizontalPanel)).add((Widget)deleteColumnManagementAnchorWidget);
        Assert.assertEquals((Object)expectedHorizontalPanel, (Object)actualHorizontalPanel);
    }

    @Test
    public void testMakeMetaDataWidgetWhenDecisionTableIsNotEditable() {
        HorizontalPanel expectedHorizontalPanel = (HorizontalPanel)Mockito.mock(HorizontalPanel.class);
        ColumnLabelWidget columnLabelWidget = (ColumnLabelWidget)Mockito.mock(ColumnLabelWidget.class);
        CheckBox hideColumnCheckBox = (CheckBox)Mockito.mock(CheckBox.class);
        DeleteColumnManagementAnchorWidget deleteColumnManagementAnchorWidget = (DeleteColumnManagementAnchorWidget)Mockito.mock(DeleteColumnManagementAnchorWidget.class);
        boolean isEditable = false;
        ((ColumnsPagePresenter)Mockito.doReturn((Object)expectedHorizontalPanel).when((Object)this.presenter)).makeHorizontalPanel();
        ((ColumnsPagePresenter)Mockito.doReturn((Object)columnLabelWidget).when((Object)this.presenter)).makeColumnLabel(this.metadataColumn);
        ((ColumnsPagePresenter)Mockito.doReturn((Object)hideColumnCheckBox).when((Object)this.presenter)).hideColumnCheckBox(this.modeller, this.metadataColumn);
        ((ColumnsPagePresenter)Mockito.doReturn((Object)deleteColumnManagementAnchorWidget).when((Object)this.presenter)).deleteMetaDataColumnAnchor(this.modeller, this.metadataColumn);
        ((GuidedDecisionTableModellerView.Presenter)Mockito.doReturn((Object)false).when((Object)this.modeller)).isActiveDecisionTableEditable();
        HorizontalPanel actualHorizontalPanel = this.presenter.makeMetaDataWidget(this.modeller, this.metadataColumn);
        ((HorizontalPanel)Mockito.verify((Object)actualHorizontalPanel)).setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        ((HorizontalPanel)Mockito.verify((Object)actualHorizontalPanel)).add((Widget)columnLabelWidget);
        ((HorizontalPanel)Mockito.verify((Object)actualHorizontalPanel)).add((Widget)hideColumnCheckBox);
        ((HorizontalPanel)Mockito.verify((Object)actualHorizontalPanel, (VerificationMode)Mockito.never())).add((Widget)deleteColumnManagementAnchorWidget);
        Assert.assertEquals((Object)expectedHorizontalPanel, (Object)actualHorizontalPanel);
    }

    @Test
    public void testDeleteMetaDataColumnAnchor() {
        DeleteColumnManagementAnchorWidget expectedWidget = (DeleteColumnManagementAnchorWidget)Mockito.mock(DeleteColumnManagementAnchorWidget.class);
        String columnHeader = "columnHeader";
        Command command = (Command)Mockito.mock(Command.class);
        ((MetadataCol52)Mockito.doReturn((Object)"columnHeader").when((Object)this.metadataColumn)).getMetadata();
        ((ManagedInstance)Mockito.doReturn((Object)expectedWidget).when(this.deleteColumnManagementAnchorWidgets)).get();
        ((ColumnsPagePresenter)Mockito.doReturn((Object)command).when((Object)this.presenter)).deleteMetadataCommand(this.modeller, this.metadataColumn);
        DeleteColumnManagementAnchorWidget actualWidget = this.presenter.deleteMetaDataColumnAnchor(this.modeller, this.metadataColumn);
        ((DeleteColumnManagementAnchorWidget)Mockito.verify((Object)actualWidget)).init("columnHeader", command);
        Assert.assertEquals((Object)expectedWidget, (Object)actualWidget);
    }

    @Test
    public void testDeleteMetadataCommandWhenVetoExceptionIsNotRaised() throws Exception {
        GuidedDecisionTableView.Presenter activeDecisionTable = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        ((GuidedDecisionTableModellerView.Presenter)Mockito.doReturn(Optional.of(activeDecisionTable)).when((Object)this.modeller)).getActiveDecisionTable();
        this.presenter.deleteMetadataCommand(this.modeller, this.metadataColumn).execute();
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)activeDecisionTable)).deleteColumn(this.metadataColumn);
        ((ColumnsPagePresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).showGenericVetoMessage();
    }

    @Test
    public void testDeleteMetadataCommandWhenVetoExceptionIsRaised() throws Exception {
        GuidedDecisionTableView.Presenter activeDecisionTable = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        ((GuidedDecisionTableModellerView.Presenter)Mockito.doReturn(Optional.of(activeDecisionTable)).when((Object)this.modeller)).getActiveDecisionTable();
        ((GuidedDecisionTableView.Presenter)Mockito.doThrow(ModelSynchronizer.VetoException.class).when((Object)activeDecisionTable)).deleteColumn(this.metadataColumn);
        ((ColumnsPagePresenter)Mockito.doNothing().when((Object)this.presenter)).showGenericVetoMessage();
        this.presenter.deleteMetadataCommand(this.modeller, this.metadataColumn).execute();
        ((ColumnsPagePresenter)Mockito.verify((Object)this.presenter)).showGenericVetoMessage();
    }

    @Test
    public void testHideColumnCheckBox() {
        CheckBox expectedCheckBox = (CheckBox)Mockito.mock(CheckBox.class);
        ClickHandler clickHandler = (ClickHandler)Mockito.mock(ClickHandler.class);
        boolean isHideColumn = true;
        ((MetadataCol52)Mockito.doReturn((Object)true).when((Object)this.metadataColumn)).isHideColumn();
        ((ColumnsPagePresenter)Mockito.doReturn((Object)expectedCheckBox).when((Object)this.presenter)).makeCheckBox((String)Matchers.eq((Object)"HideThisColumn:"));
        ((ColumnsPagePresenter)Mockito.doReturn((Object)clickHandler).when((Object)this.presenter)).hideMetadataClickHandler(this.modeller, expectedCheckBox, this.metadataColumn);
        CheckBox actualCheckBox = this.presenter.hideColumnCheckBox(this.modeller, this.metadataColumn);
        ((CheckBox)Mockito.verify((Object)expectedCheckBox)).setValue(Boolean.valueOf(true));
        ((CheckBox)Mockito.verify((Object)expectedCheckBox)).addClickHandler(clickHandler);
        Assert.assertEquals((Object)expectedCheckBox, (Object)actualCheckBox);
    }

    @Test
    public void testHideMetadataClickHandlerWhenVetoExceptionIsNotRaised() throws Exception {
        MetadataCol52 clone = (MetadataCol52)Mockito.mock(MetadataCol52.class);
        CheckBox checkBox = (CheckBox)Mockito.mock(CheckBox.class);
        ClickEvent clickEvent = (ClickEvent)Mockito.mock(ClickEvent.class);
        GuidedDecisionTableView.Presenter activeDecisionTable = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        ((GuidedDecisionTableModellerView.Presenter)Mockito.doReturn(Optional.of(activeDecisionTable)).when((Object)this.modeller)).getActiveDecisionTable();
        ((MetadataCol52)Mockito.doReturn((Object)clone).when((Object)this.metadataColumn)).cloneColumn();
        ClickHandler clickHandler = this.presenter.hideMetadataClickHandler(this.modeller, checkBox, this.metadataColumn);
        clickHandler.onClick(clickEvent);
        ((MetadataCol52)Mockito.verify((Object)clone)).setHideColumn(checkBox.getValue().booleanValue());
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)activeDecisionTable)).updateColumn(this.metadataColumn, clone);
    }

    @Test
    public void testHideMetadataClickHandlerWhenVetoExceptionIsRaised() throws Exception {
        MetadataCol52 clone = (MetadataCol52)Mockito.mock(MetadataCol52.class);
        CheckBox checkBox = (CheckBox)Mockito.mock(CheckBox.class);
        ClickEvent clickEvent = (ClickEvent)Mockito.mock(ClickEvent.class);
        GuidedDecisionTableView.Presenter activeDecisionTable = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        ((GuidedDecisionTableModellerView.Presenter)Mockito.doReturn(Optional.of(activeDecisionTable)).when((Object)this.modeller)).getActiveDecisionTable();
        ((MetadataCol52)Mockito.doReturn((Object)clone).when((Object)this.metadataColumn)).cloneColumn();
        ((GuidedDecisionTableView.Presenter)Mockito.doThrow(ModelSynchronizer.VetoException.class).when((Object)activeDecisionTable)).updateColumn(this.metadataColumn, clone);
        ((ColumnsPagePresenter)Mockito.doNothing().when((Object)this.presenter)).showGenericVetoMessage();
        ClickHandler clickHandler = this.presenter.hideMetadataClickHandler(this.modeller, checkBox, this.metadataColumn);
        clickHandler.onClick(clickEvent);
        ((MetadataCol52)Mockito.verify((Object)clone)).setHideColumn(checkBox.getValue().booleanValue());
        ((ColumnsPagePresenter)Mockito.verify((Object)this.presenter)).showGenericVetoMessage();
    }

    @Test
    public void testRefreshConditionsWidgetWhenConditionColumnsIsEmpty() {
        ArrayList conditions = new ArrayList();
        ColumnManagementView columnManagementView = (ColumnManagementView)Mockito.mock(ColumnManagementView.class);
        GuidedDecisionTableAccordionItem item = (GuidedDecisionTableAccordionItem)Mockito.mock(GuidedDecisionTableAccordionItem.class);
        Label blankSlate = (Label)Mockito.mock(Label.class);
        ((ColumnsPagePresenter)Mockito.doReturn((Object)this.verticalPanel).when((Object)this.presenter)).getConditionsWidget();
        ((ColumnsPagePresenter)Mockito.doReturn((Object)columnManagementView).when((Object)this.presenter)).getConditionsPanel();
        ((ColumnsPagePresenter)Mockito.doReturn((Object)blankSlate).when((Object)this.presenter)).blankSlate();
        ((GuidedDecisionTableAccordion)Mockito.doReturn((Object)item).when((Object)this.accordion)).getItem(GuidedDecisionTableAccordionItem.Type.CONDITION);
        this.presenter.refreshConditionsWidget(conditions);
        ((GuidedDecisionTableAccordionItem)Mockito.verify((Object)item)).setOpen(false);
        ((VerticalPanel)Mockito.verify((Object)this.verticalPanel)).add((Widget)blankSlate);
        ((VerticalPanel)Mockito.verify((Object)this.verticalPanel, (VerificationMode)Mockito.never())).add((Widget)columnManagementView);
        ((ColumnManagementView)Mockito.verify((Object)columnManagementView, (VerificationMode)Mockito.never())).renderColumns((Map)Matchers.any());
    }

    @Test
    public void testRefreshConditionsWidgetWhenConditionColumnsIsNotEmpty() {
        ColumnManagementView columnManagementView = (ColumnManagementView)Mockito.mock(ColumnManagementView.class);
        GuidedDecisionTableAccordionItem item = (GuidedDecisionTableAccordionItem)Mockito.mock(GuidedDecisionTableAccordionItem.class);
        Label blankSlate = (Label)Mockito.mock(Label.class);
        ArrayList<CompositeColumn<? extends BaseColumn>> conditions1 = new ArrayList<CompositeColumn<? extends BaseColumn>>(){
            {
                this.add(ColumnsPagePresenterTest.this.compositeColumn1);
            }
        };
        HashMap<String, List<BaseColumn>> conditions2 = new HashMap<String, List<BaseColumn>>(){
            {
                this.put("title", new ArrayList());
            }
        };
        ((ColumnsPagePresenter)Mockito.doReturn((Object)this.verticalPanel).when((Object)this.presenter)).getConditionsWidget();
        ((ColumnsPagePresenter)Mockito.doReturn((Object)columnManagementView).when((Object)this.presenter)).getConditionsPanel();
        ((ColumnsPagePresenter)Mockito.doReturn((Object)blankSlate).when((Object)this.presenter)).blankSlate();
        ((GuidedDecisionTableAccordion)Mockito.doReturn((Object)item).when((Object)this.accordion)).getItem(GuidedDecisionTableAccordionItem.Type.CONDITION);
        ((ColumnsPagePresenter)Mockito.doReturn((Object)conditions2).when((Object)this.presenter)).groupByTitle((List)conditions1);
        this.presenter.refreshConditionsWidget((List)conditions1);
        ((GuidedDecisionTableAccordionItem)Mockito.verify((Object)item, (VerificationMode)Mockito.never())).setOpen(false);
        ((VerticalPanel)Mockito.verify((Object)this.verticalPanel, (VerificationMode)Mockito.never())).add((Widget)blankSlate);
        ((VerticalPanel)Mockito.verify((Object)this.verticalPanel)).add((Widget)columnManagementView);
        ((ColumnManagementView)Mockito.verify((Object)columnManagementView)).renderColumns((Map)conditions2);
    }

    @Test
    public void testGroupByTitle() {
        ArrayList<CompositeColumn<? extends BaseColumn>> conditions = new ArrayList<CompositeColumn<? extends BaseColumn>>(){
            {
                this.add(ColumnsPagePresenterTest.this.compositeColumn1);
                this.add(ColumnsPagePresenterTest.this.compositeColumn2);
                this.add(ColumnsPagePresenterTest.this.compositeColumn3);
            }
        };
        String title1 = "title1";
        String title2 = "title2";
        ((CompositeColumn)Mockito.doReturn((Object)"title1").when(this.compositeColumn1)).getHeader();
        ((CompositeColumn)Mockito.doReturn((Object)"title2").when(this.compositeColumn2)).getHeader();
        ((CompositeColumn)Mockito.doReturn((Object)"title1").when(this.compositeColumn3)).getHeader();
        Map columnGroups = this.presenter.groupByTitle((List)conditions);
        List actualTitle1List = (List)columnGroups.get("title1");
        List actualTitle2List = (List)columnGroups.get("title2");
        ArrayList<CompositeColumn<? extends BaseColumn>> expectedTitle1List = new ArrayList<CompositeColumn<? extends BaseColumn>>(){
            {
                this.add(ColumnsPagePresenterTest.this.compositeColumn1);
                this.add(ColumnsPagePresenterTest.this.compositeColumn3);
            }
        };
        ArrayList<CompositeColumn<? extends BaseColumn>> expectedTitle2List = new ArrayList<CompositeColumn<? extends BaseColumn>>(){
            {
                this.add(ColumnsPagePresenterTest.this.compositeColumn2);
            }
        };
        Assert.assertEquals((long)2L, (long)columnGroups.size());
        Assert.assertEquals((Object)actualTitle1List, (Object)expectedTitle1List);
        Assert.assertEquals((Object)actualTitle2List, (Object)expectedTitle2List);
    }

    @Test
    public void testRefreshActionsWidgetWhenActionColumnsIsEmpty() {
        ArrayList actionColumns = new ArrayList();
        ColumnManagementView columnManagementView = (ColumnManagementView)Mockito.mock(ColumnManagementView.class);
        GuidedDecisionTableAccordionItem item = (GuidedDecisionTableAccordionItem)Mockito.mock(GuidedDecisionTableAccordionItem.class);
        Label blankSlate = (Label)Mockito.mock(Label.class);
        ((ColumnsPagePresenter)Mockito.doReturn((Object)this.verticalPanel).when((Object)this.presenter)).getActionsWidget();
        ((ColumnsPagePresenter)Mockito.doReturn((Object)columnManagementView).when((Object)this.presenter)).getActionsPanel();
        ((ColumnsPagePresenter)Mockito.doReturn((Object)blankSlate).when((Object)this.presenter)).blankSlate();
        ((GuidedDecisionTableAccordion)Mockito.doReturn((Object)item).when((Object)this.accordion)).getItem(GuidedDecisionTableAccordionItem.Type.ACTION);
        this.presenter.refreshActionsWidget(actionColumns);
        ((GuidedDecisionTableAccordionItem)Mockito.verify((Object)item)).setOpen(false);
        ((VerticalPanel)Mockito.verify((Object)this.verticalPanel)).add((Widget)blankSlate);
        ((VerticalPanel)Mockito.verify((Object)this.verticalPanel, (VerificationMode)Mockito.never())).add((Widget)columnManagementView);
        ((ColumnManagementView)Mockito.verify((Object)columnManagementView, (VerificationMode)Mockito.never())).renderColumns((Map)Matchers.any());
    }

    @Test
    public void testRefreshActionsWidgetWhenActionColumnsIsNotEmpty() {
        ColumnManagementView columnManagementView = (ColumnManagementView)Mockito.mock(ColumnManagementView.class);
        GuidedDecisionTableAccordionItem item = (GuidedDecisionTableAccordionItem)Mockito.mock(GuidedDecisionTableAccordionItem.class);
        Label blankSlate = (Label)Mockito.mock(Label.class);
        final ActionCol52 actionCol52 = (ActionCol52)Mockito.mock(ActionCol52.class);
        ArrayList<ActionCol52> actionColumns1 = new ArrayList<ActionCol52>(){
            {
                this.add(actionCol52);
            }
        };
        HashMap<String, List<BaseColumn>> actionColumns2 = new HashMap<String, List<BaseColumn>>(){
            {
                this.put("title", new ArrayList());
            }
        };
        ((ColumnsPagePresenter)Mockito.doReturn((Object)this.verticalPanel).when((Object)this.presenter)).getActionsWidget();
        ((ColumnsPagePresenter)Mockito.doReturn((Object)columnManagementView).when((Object)this.presenter)).getActionsPanel();
        ((ColumnsPagePresenter)Mockito.doReturn((Object)blankSlate).when((Object)this.presenter)).blankSlate();
        ((GuidedDecisionTableAccordion)Mockito.doReturn((Object)item).when((Object)this.accordion)).getItem(GuidedDecisionTableAccordionItem.Type.ACTION);
        ((ColumnsPagePresenter)Mockito.doReturn((Object)actionColumns2).when((Object)this.presenter)).groupByTitle((List)actionColumns1);
        this.presenter.refreshActionsWidget((List)actionColumns1);
        ((GuidedDecisionTableAccordionItem)Mockito.verify((Object)item, (VerificationMode)Mockito.never())).setOpen(false);
        ((VerticalPanel)Mockito.verify((Object)this.verticalPanel, (VerificationMode)Mockito.never())).add((Widget)blankSlate);
        ((VerticalPanel)Mockito.verify((Object)this.verticalPanel)).add((Widget)columnManagementView);
        ((ColumnManagementView)Mockito.verify((Object)columnManagementView)).renderColumns((Map)actionColumns2);
    }

    @Test
    public void testOnUpdatedLockStatusEventWhenActiveDecisionTableHasAValidPath() {
        UpdatedLockStatusEvent event = (UpdatedLockStatusEvent)Mockito.mock(UpdatedLockStatusEvent.class);
        GuidedDecisionTableView.Presenter activeDecisionTable = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        ObservablePath path = (ObservablePath)Mockito.mock(ObservablePath.class);
        ((ColumnsPagePresenter)Mockito.doReturn((Object)true).when((Object)this.presenter)).hasActiveDecisionTable();
        ((GuidedDecisionTableModellerView.Presenter)Mockito.doReturn(Optional.of(activeDecisionTable)).when((Object)this.modeller)).getActiveDecisionTable();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)path).when((Object)activeDecisionTable)).getCurrentPath();
        ((UpdatedLockStatusEvent)Mockito.doReturn((Object)path).when((Object)event)).getFile();
        ((ColumnsPagePresenter)Mockito.doNothing().when((Object)this.presenter)).refresh();
        this.presenter.onUpdatedLockStatusEvent(event);
        ((ColumnsPagePresenter)Mockito.verify((Object)this.presenter)).refresh();
    }

    @Test
    public void testOnUpdatedLockStatusEventWhenActiveDecisionTableHasAnInvalidPath() {
        UpdatedLockStatusEvent event = (UpdatedLockStatusEvent)Mockito.mock(UpdatedLockStatusEvent.class);
        GuidedDecisionTableView.Presenter activeDecisionTable = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        ObservablePath path = (ObservablePath)Mockito.mock(ObservablePath.class);
        ((ColumnsPagePresenter)Mockito.doReturn((Object)true).when((Object)this.presenter)).hasActiveDecisionTable();
        ((GuidedDecisionTableModellerView.Presenter)Mockito.doReturn(Optional.of(activeDecisionTable)).when((Object)this.modeller)).getActiveDecisionTable();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)path).when((Object)activeDecisionTable)).getCurrentPath();
        ((UpdatedLockStatusEvent)Mockito.doReturn(null).when((Object)event)).getFile();
        this.presenter.onUpdatedLockStatusEvent(event);
        ((ColumnsPagePresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).refresh();
    }

    @Test
    public void testOnUpdatedLockStatusEventWhenDoesNotHaveActiveDecisionTable() {
        UpdatedLockStatusEvent event = (UpdatedLockStatusEvent)Mockito.mock(UpdatedLockStatusEvent.class);
        ((ColumnsPagePresenter)Mockito.doReturn((Object)false).when((Object)this.presenter)).hasActiveDecisionTable();
        this.presenter.onUpdatedLockStatusEvent(event);
        ((ColumnsPagePresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).refresh();
    }

    @Test
    public void testHasActiveDecisionTableWhenModellerIsNull() {
        ((ColumnsPagePresenter)Mockito.doReturn(null).when((Object)this.presenter)).getModeller();
        boolean hasActiveDecisionTable = this.presenter.hasActiveDecisionTable();
        Assert.assertFalse((boolean)hasActiveDecisionTable);
    }

    @Test
    public void testHasActiveDecisionTableWhenActiveDecisionTableIsNull() {
        ((GuidedDecisionTableModellerView.Presenter)Mockito.doReturn(null).when((Object)this.modeller)).getActiveDecisionTable();
        boolean hasActiveDecisionTable = this.presenter.hasActiveDecisionTable();
        Assert.assertFalse((boolean)hasActiveDecisionTable);
    }

    @Test
    public void testHasActiveDecisionTableWhenActiveDecisionTableIsNotNull() {
        ((GuidedDecisionTableModellerView.Presenter)Mockito.doReturn(Optional.of(Mockito.mock(GuidedDecisionTableView.Presenter.class))).when((Object)this.modeller)).getActiveDecisionTable();
        boolean hasActiveDecisionTable = this.presenter.hasActiveDecisionTable();
        Assert.assertTrue((boolean)hasActiveDecisionTable);
    }

    @Test
    public void testOnRefreshAttributesPanelEvent() {
        RefreshAttributesPanelEvent event = (RefreshAttributesPanelEvent)Mockito.mock(RefreshAttributesPanelEvent.class);
        GuidedDecisionTableView.Presenter eventPresenter = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        ArrayList columns = new ArrayList();
        ((RefreshAttributesPanelEvent)Mockito.doReturn((Object)eventPresenter).when((Object)event)).getPresenter();
        ((RefreshAttributesPanelEvent)Mockito.doReturn(columns).when((Object)event)).getColumns();
        ((ColumnsPagePresenter)Mockito.doNothing().when((Object)this.presenter)).refreshAttributeWidget((List)Matchers.any());
        ((ColumnsPagePresenter)Mockito.doNothing().when((Object)this.presenter)).refreshColumnsNoteInfo((GuidedDecisionTableView.Presenter)Matchers.any());
        this.presenter.onRefreshAttributesPanelEvent(event);
        ((ColumnsPagePresenter)Mockito.verify((Object)this.presenter)).refreshAttributeWidget(columns);
        ((ColumnsPagePresenter)Mockito.verify((Object)this.presenter)).refreshColumnsNoteInfo(eventPresenter);
    }

    @Test
    public void testOnRefreshMetaDataPanelEvent() {
        RefreshMetaDataPanelEvent event = (RefreshMetaDataPanelEvent)Mockito.mock(RefreshMetaDataPanelEvent.class);
        GuidedDecisionTableView.Presenter eventPresenter = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        ArrayList columns = new ArrayList();
        ((RefreshMetaDataPanelEvent)Mockito.doReturn((Object)eventPresenter).when((Object)event)).getPresenter();
        ((RefreshMetaDataPanelEvent)Mockito.doReturn(columns).when((Object)event)).getColumns();
        ((ColumnsPagePresenter)Mockito.doNothing().when((Object)this.presenter)).refreshMetaDataWidget((List)Matchers.any());
        ((ColumnsPagePresenter)Mockito.doNothing().when((Object)this.presenter)).refreshColumnsNoteInfo((GuidedDecisionTableView.Presenter)Matchers.any());
        this.presenter.onRefreshMetaDataPanelEvent(event);
        ((ColumnsPagePresenter)Mockito.verify((Object)this.presenter)).refreshMetaDataWidget(columns);
        ((ColumnsPagePresenter)Mockito.verify((Object)this.presenter)).refreshColumnsNoteInfo(eventPresenter);
    }

    @Test
    public void testOnRefreshConditionsPanelEvent() {
        RefreshConditionsPanelEvent event = (RefreshConditionsPanelEvent)Mockito.mock(RefreshConditionsPanelEvent.class);
        GuidedDecisionTableView.Presenter eventPresenter = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        ArrayList columns = new ArrayList();
        ((RefreshConditionsPanelEvent)Mockito.doReturn((Object)eventPresenter).when((Object)event)).getPresenter();
        ((RefreshConditionsPanelEvent)Mockito.doReturn(columns).when((Object)event)).getColumns();
        ((ColumnsPagePresenter)Mockito.doNothing().when((Object)this.presenter)).refreshConditionsWidget((List)Matchers.any());
        ((ColumnsPagePresenter)Mockito.doNothing().when((Object)this.presenter)).refreshColumnsNoteInfo((GuidedDecisionTableView.Presenter)Matchers.any());
        this.presenter.onRefreshConditionsPanelEvent(event);
        ((ColumnsPagePresenter)Mockito.verify((Object)this.presenter)).refreshConditionsWidget(columns);
        ((ColumnsPagePresenter)Mockito.verify((Object)this.presenter)).refreshColumnsNoteInfo(eventPresenter);
    }

    @Test
    public void testOnRefreshActionsPanelEvent() {
        RefreshActionsPanelEvent event = (RefreshActionsPanelEvent)Mockito.mock(RefreshActionsPanelEvent.class);
        GuidedDecisionTableView.Presenter eventPresenter = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        ArrayList columns = new ArrayList();
        ((RefreshActionsPanelEvent)Mockito.doReturn((Object)eventPresenter).when((Object)event)).getPresenter();
        ((RefreshActionsPanelEvent)Mockito.doReturn(columns).when((Object)event)).getColumns();
        ((ColumnsPagePresenter)Mockito.doNothing().when((Object)this.presenter)).refreshActionsWidget((List)Matchers.any());
        ((ColumnsPagePresenter)Mockito.doNothing().when((Object)this.presenter)).refreshColumnsNoteInfo((GuidedDecisionTableView.Presenter)Matchers.any());
        this.presenter.onRefreshActionsPanelEvent(event);
        ((ColumnsPagePresenter)Mockito.verify((Object)this.presenter)).refreshActionsWidget(columns);
        ((ColumnsPagePresenter)Mockito.verify((Object)this.presenter)).refreshColumnsNoteInfo(eventPresenter);
    }

    @Test
    public void testSetupColumnsNoteInfoWhenActiveDecisionTableHasColumnDefinitions() {
        GuidedDecisionTableView.Presenter activeDecisionTable = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        ((GuidedDecisionTableModellerView.Presenter)Mockito.doReturn(Optional.of(activeDecisionTable)).when((Object)this.modeller)).getActiveDecisionTable();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)true).when((Object)activeDecisionTable)).hasColumnDefinitions();
        this.presenter.setupColumnsNoteInfo(this.modeller);
        ((ColumnsPagePresenter.View)Mockito.verify((Object)this.view)).setColumnsNoteInfoAsHidden();
    }

    @Test
    public void testSetupColumnsNoteInfoWhenActiveDecisionTableDoesNotHaveColumnDefinitions() {
        GuidedDecisionTableView.Presenter activeDecisionTable = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        ((GuidedDecisionTableModellerView.Presenter)Mockito.doReturn(Optional.of(activeDecisionTable)).when((Object)this.modeller)).getActiveDecisionTable();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)false).when((Object)activeDecisionTable)).hasColumnDefinitions();
        this.presenter.setupColumnsNoteInfo(this.modeller);
        ((ColumnsPagePresenter.View)Mockito.verify((Object)this.view)).setColumnsNoteInfoAsVisible();
    }

    @Test
    public void testSetupAccordion() {
        this.presenter.setupAccordion();
        ((GuidedDecisionTableAccordion)Mockito.verify((Object)this.accordion)).clear();
        ((ColumnsPagePresenter)Mockito.verify((Object)this.presenter)).setupAccordionWidgets();
        ((ColumnsPagePresenter.View)Mockito.verify((Object)this.view)).setAccordion(this.accordion);
    }

    @Test
    public void testRuleInheritanceWidget() {
        FlowPanel expectedPanel = (FlowPanel)Mockito.mock(FlowPanel.class);
        Label label = (Label)Mockito.mock(Label.class);
        Widget widget = (Widget)Mockito.mock(Widget.class);
        ((ColumnsPagePresenter)Mockito.doReturn((Object)expectedPanel).when((Object)this.presenter)).makeFlowPanel();
        ((ColumnsPagePresenter)Mockito.doReturn((Object)label).when((Object)this.presenter)).ruleInheritanceLabel();
        ((ColumnsPagePresenter)Mockito.doReturn((Object)widget).when((Object)this.presenter)).ruleSelector();
        Widget actualPanel = this.presenter.ruleInheritanceWidget();
        ((FlowPanel)Mockito.verify((Object)expectedPanel)).setStyleName(GuidedDecisionTableResources.INSTANCE.css().ruleInheritance());
        ((FlowPanel)Mockito.verify((Object)expectedPanel)).add((Widget)label);
        ((FlowPanel)Mockito.verify((Object)expectedPanel)).add(widget);
        Assert.assertEquals((Object)expectedPanel, (Object)actualPanel);
    }

    @Test
    public void testRuleSelectorWidget() {
        RuleSelector ruleSelector = (RuleSelector)Mockito.mock(RuleSelector.class);
        GuidedDecisionTableView.Presenter dtPresenter = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        GuidedDecisionTable52 model = new GuidedDecisionTable52();
        List<String> ruleNames = Collections.singletonList("rule");
        model.setParentName("parent");
        ((ColumnsPagePresenter)Mockito.doReturn((Object)ruleSelector).when((Object)this.presenter)).makeRuleSelector();
        Mockito.when((Object)this.modeller.getActiveDecisionTable()).thenReturn(Optional.of(dtPresenter));
        Mockito.when((Object)dtPresenter.getModel()).thenReturn((Object)model);
        ArgumentCaptor valueChangeHandlerCaptor = ArgumentCaptor.forClass(ValueChangeHandler.class);
        ArgumentCaptor commandCaptor = ArgumentCaptor.forClass(ParameterizedCommand.class);
        this.presenter.ruleSelector();
        ((RuleSelector)Mockito.verify((Object)ruleSelector)).addValueChangeHandler((ValueChangeHandler)valueChangeHandlerCaptor.capture());
        ((ValueChangeHandler)valueChangeHandlerCaptor.getValue()).onValueChange((ValueChangeEvent)Mockito.mock(ValueChangeEvent.class));
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)dtPresenter)).setParentRuleName(Matchers.anyString());
        ((ColumnsPagePresenter)Mockito.verify((Object)this.presenter)).setupRuleSelector((GuidedDecisionTableView.Presenter)Matchers.eq((Object)dtPresenter));
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)dtPresenter)).getPackageParentRuleNames((ParameterizedCommand)commandCaptor.capture());
        ((ParameterizedCommand)commandCaptor.getValue()).execute(ruleNames);
        ((RuleSelector)Mockito.verify((Object)ruleSelector)).setRuleName((String)Matchers.eq((Object)"parent"));
        ((RuleSelector)Mockito.verify((Object)ruleSelector)).setRuleNames((Collection)Matchers.eq(ruleNames));
    }

    @Test
    public void testRuleSelectorWidgetWitNoActiveDecisionTable() {
        RuleSelector ruleSelector = (RuleSelector)Mockito.mock(RuleSelector.class);
        Mockito.when((Object)this.modeller.getActiveDecisionTable()).thenReturn(Optional.empty());
        ((ColumnsPagePresenter)Mockito.doReturn((Object)ruleSelector).when((Object)this.presenter)).makeRuleSelector();
        this.presenter.ruleSelector();
        ((ColumnsPagePresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).setupRuleSelector((GuidedDecisionTableView.Presenter)Matchers.any(GuidedDecisionTableView.Presenter.class));
    }

    @Test
    public void testOpenNewGuidedDecisionTableColumnWizardWhenColumnCreatingIsNotEnabled() {
        NewGuidedDecisionTableColumnWizard wizard = (NewGuidedDecisionTableColumnWizard)Mockito.mock(NewGuidedDecisionTableColumnWizard.class);
        ((ColumnsPagePresenter)Mockito.doReturn((Object)false).when((Object)this.presenter)).isColumnCreationEnabledToActiveDecisionTable();
        ((ManagedInstance)Mockito.doReturn((Object)wizard).when(this.wizardManagedInstance)).get();
        this.presenter.openNewGuidedDecisionTableColumnWizard();
        ((NewGuidedDecisionTableColumnWizard)Mockito.verify((Object)wizard, (VerificationMode)Mockito.never())).init((GuidedDecisionTableView.Presenter)Matchers.any());
        ((NewGuidedDecisionTableColumnWizard)Mockito.verify((Object)wizard, (VerificationMode)Mockito.never())).start();
    }

    @Test
    public void testOpenNewGuidedDecisionTableColumnWizardWhenColumnCreatingIsEnabled() {
        NewGuidedDecisionTableColumnWizard wizard = (NewGuidedDecisionTableColumnWizard)Mockito.mock(NewGuidedDecisionTableColumnWizard.class);
        GuidedDecisionTableView.Presenter activeDecisionTable = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        ((ColumnsPagePresenter)Mockito.doReturn((Object)true).when((Object)this.presenter)).isColumnCreationEnabledToActiveDecisionTable();
        ((GuidedDecisionTableModellerView.Presenter)Mockito.doReturn(Optional.of(activeDecisionTable)).when((Object)this.modeller)).getActiveDecisionTable();
        ((ManagedInstance)Mockito.doReturn((Object)wizard).when(this.wizardManagedInstance)).get();
        this.presenter.openNewGuidedDecisionTableColumnWizard();
        ((NewGuidedDecisionTableColumnWizard)Mockito.verify((Object)wizard)).init(activeDecisionTable);
        ((NewGuidedDecisionTableColumnWizard)Mockito.verify((Object)wizard)).start();
    }

    @Test
    public void testIsColumnCreationEnabledToActiveDecisionTableWhenPresenterDoesNotHaveActiveDecisionTable() {
        ((ColumnsPagePresenter)Mockito.doReturn((Object)false).when((Object)this.presenter)).hasActiveDecisionTable();
        boolean isColumnCreationEnabled = this.presenter.isColumnCreationEnabledToActiveDecisionTable();
        Assert.assertFalse((boolean)isColumnCreationEnabled);
    }

    @Test
    public void testIsColumnCreationEnabledToActiveDecisionTableWhenPresenterHasActiveDecisionTable() {
        ((ColumnsPagePresenter)Mockito.doReturn((Object)true).when((Object)this.presenter)).hasActiveDecisionTable();
        ((ColumnsPagePresenter)Mockito.doReturn((Object)true).when((Object)this.presenter)).isColumnCreationEnabled((Optional)Matchers.any());
        boolean isColumnCreationEnabled = this.presenter.isColumnCreationEnabledToActiveDecisionTable();
        Assert.assertTrue((boolean)isColumnCreationEnabled);
    }

    @Test
    public void testIsColumnCreationEnabledWhenActiveDecisionTableIsReadOnly() {
        GuidedDecisionTableView.Presenter dtPresenter = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)true).when((Object)dtPresenter)).isReadOnly();
        boolean isColumnCreationEnabled = this.presenter.isColumnCreationEnabled(Optional.of(dtPresenter));
        Assert.assertFalse((boolean)isColumnCreationEnabled);
    }

    @Test
    public void testIsColumnCreationEnabledWhenActiveDecisionTableDoesNotHaveEditableColumns() {
        GuidedDecisionTableView.Presenter dtPresenter = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)false).when((Object)dtPresenter)).isReadOnly();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)false).when((Object)dtPresenter)).hasEditableColumns();
        boolean isColumnCreationEnabled = this.presenter.isColumnCreationEnabled(Optional.of(dtPresenter));
        Assert.assertFalse((boolean)isColumnCreationEnabled);
    }

    @Test
    public void testIsColumnCreationEnabledWhenActiveDecisionTableHasEditableColumns() {
        GuidedDecisionTableView.Presenter dtPresenter = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)false).when((Object)dtPresenter)).isReadOnly();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)true).when((Object)dtPresenter)).hasEditableColumns();
        boolean isColumnCreationEnabled = this.presenter.isColumnCreationEnabled(Optional.of(dtPresenter));
        Assert.assertTrue((boolean)isColumnCreationEnabled);
    }

    @Test
    public void testOnDecisionTableSelectedWhenPresenterDoesNotHaveActiveDecisionTable() {
        DecisionTableSelectedEvent event = (DecisionTableSelectedEvent)Mockito.mock(DecisionTableSelectedEvent.class);
        ((ColumnsPagePresenter)Mockito.doReturn((Object)false).when((Object)this.presenter)).hasActiveDecisionTable();
        this.presenter.onDecisionTableSelected(event);
        ((ColumnsPagePresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).setupRuleSelector((GuidedDecisionTableView.Presenter)Matchers.any());
    }

    @Test
    public void testOnDecisionTableSelectedWhenEventDoesNotHaveActiveDecisionTable() {
        DecisionTableSelectedEvent event = (DecisionTableSelectedEvent)Mockito.mock(DecisionTableSelectedEvent.class);
        ((ColumnsPagePresenter)Mockito.doReturn((Object)true).when((Object)this.presenter)).hasActiveDecisionTable();
        ((DecisionTableSelectedEvent)Mockito.doReturn(Optional.empty()).when((Object)event)).getPresenter();
        this.presenter.onDecisionTableSelected(event);
        ((ColumnsPagePresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).setupRuleSelector((GuidedDecisionTableView.Presenter)Matchers.any());
    }

    @Test
    public void testOnDecisionTableSelectedWhenEventAndActiveDecisionTableAreEqual() {
        DecisionTableSelectedEvent event = (DecisionTableSelectedEvent)Mockito.mock(DecisionTableSelectedEvent.class);
        GuidedDecisionTableView.Presenter presenterDecisionTable = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        ((ColumnsPagePresenter)Mockito.doReturn((Object)true).when((Object)this.presenter)).hasActiveDecisionTable();
        ((GuidedDecisionTableModellerView.Presenter)Mockito.doReturn(Optional.of(presenterDecisionTable)).when((Object)this.modeller)).getActiveDecisionTable();
        ((DecisionTableSelectedEvent)Mockito.doReturn(Optional.of(presenterDecisionTable)).when((Object)event)).getPresenter();
        this.presenter.onDecisionTableSelected(event);
        ((ColumnsPagePresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).setupRuleSelector((GuidedDecisionTableView.Presenter)Matchers.any());
    }

    @Test
    public void testOnDecisionTableSelectedWhenEventAndActiveDecisionTableAreDifferent() {
        DecisionTableSelectedEvent event = (DecisionTableSelectedEvent)Mockito.mock(DecisionTableSelectedEvent.class);
        GuidedDecisionTableView.Presenter presenterDecisionTable = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        GuidedDecisionTableView.Presenter eventDecisionTable = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        Optional<GuidedDecisionTableView.Presenter> presenterOptional = Optional.ofNullable(eventDecisionTable);
        ((ColumnsPagePresenter)Mockito.doReturn((Object)true).when((Object)this.presenter)).hasActiveDecisionTable();
        ((GuidedDecisionTableModellerView.Presenter)Mockito.doReturn(Optional.of(presenterDecisionTable)).when((Object)this.modeller)).getActiveDecisionTable();
        ((DecisionTableSelectedEvent)Mockito.doReturn(presenterOptional).when((Object)event)).getPresenter();
        ((ColumnsPagePresenter)Mockito.doNothing().when((Object)this.presenter)).setupRuleSelector((GuidedDecisionTableView.Presenter)Matchers.any());
        this.presenter.onDecisionTableSelected(event);
        ((ColumnsPagePresenter)Mockito.verify((Object)this.presenter)).setupRuleSelector(eventDecisionTable);
    }

    @Test
    public void testRefresh() {
        GuidedDecisionTable52 guidedDecisionTable52 = (GuidedDecisionTable52)Mockito.mock(GuidedDecisionTable52.class);
        ((ColumnsPagePresenter)Mockito.doReturn(Optional.of(guidedDecisionTable52)).when((Object)this.presenter)).getGuidedDecisionTable52();
        ((ColumnsPagePresenter)Mockito.doNothing().when((Object)this.presenter)).refreshAttributeWidget((List)Matchers.any());
        ((ColumnsPagePresenter)Mockito.doNothing().when((Object)this.presenter)).refreshMetaDataWidget((List)Matchers.any());
        ((ColumnsPagePresenter)Mockito.doNothing().when((Object)this.presenter)).refreshConditionsWidget((List)Matchers.any());
        ((ColumnsPagePresenter)Mockito.doNothing().when((Object)this.presenter)).refreshActionsWidget((List)Matchers.any());
        ArrayList attributeCol52s = new ArrayList();
        ArrayList metadataCol52s = new ArrayList();
        ArrayList compositeColumns = new ArrayList();
        ArrayList actionCol52s = new ArrayList();
        ((GuidedDecisionTable52)Mockito.doReturn(attributeCol52s).when((Object)guidedDecisionTable52)).getAttributeCols();
        ((GuidedDecisionTable52)Mockito.doReturn(metadataCol52s).when((Object)guidedDecisionTable52)).getAttributeCols();
        ((GuidedDecisionTable52)Mockito.doReturn(compositeColumns).when((Object)guidedDecisionTable52)).getAttributeCols();
        ((GuidedDecisionTable52)Mockito.doReturn(actionCol52s).when((Object)guidedDecisionTable52)).getAttributeCols();
        this.presenter.refresh();
        ((ColumnsPagePresenter)Mockito.verify((Object)this.presenter)).refreshAttributeWidget(attributeCol52s);
        ((ColumnsPagePresenter)Mockito.verify((Object)this.presenter)).refreshMetaDataWidget(metadataCol52s);
        ((ColumnsPagePresenter)Mockito.verify((Object)this.presenter)).refreshConditionsWidget(compositeColumns);
        ((ColumnsPagePresenter)Mockito.verify((Object)this.presenter)).refreshActionsWidget(actionCol52s);
    }

    @Test
    public void testRefreshColumnsNoteInfo() {
        GuidedDecisionTableView.Presenter viewPresenter = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        GuidedDecisionTableModellerView.Presenter modeller = (GuidedDecisionTableModellerView.Presenter)Mockito.mock(GuidedDecisionTableModellerView.Presenter.class);
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)modeller).when((Object)viewPresenter)).getModellerPresenter();
        ((ColumnsPagePresenter)Mockito.doNothing().when((Object)this.presenter)).setupColumnsNoteInfo((GuidedDecisionTableModellerView.Presenter)Matchers.any());
        this.presenter.refreshColumnsNoteInfo(viewPresenter);
        ((ColumnsPagePresenter)Mockito.verify((Object)this.presenter)).setupColumnsNoteInfo(modeller);
    }
}

