/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget;

import java.util.ArrayList;
import java.util.List;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.CompositeColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.screens.guided.dtable.client.widget.Validator;
import org.junit.Assert;
import org.junit.Test;

public class ValidatorTest {
    @Test
    public void testIsConditionValidWhenHeaderIsBlank() throws Exception {
        Validator validator = new Validator();
        Assert.assertFalse((boolean)validator.isConditionValid(this.fakeConditionCol52("")));
    }

    @Test
    public void testIsConditionValidWhenHeaderIsNotUnique() throws Exception {
        ConditionCol52 conditionCol1 = this.fakeConditionCol52("header");
        ConditionCol52 conditionCol2 = this.fakeConditionCol52("header");
        Validator validator = new Validator(this.fakeCompositeColumn(conditionCol1, conditionCol2));
        Assert.assertFalse((boolean)validator.isConditionValid(conditionCol2));
    }

    @Test
    public void testIsConditionValidWhenHeaderIsValid() throws Exception {
        ConditionCol52 conditionCol1 = this.fakeConditionCol52("header1");
        ConditionCol52 conditionCol2 = this.fakeConditionCol52("header2");
        Validator validator = new Validator(this.fakeCompositeColumn(conditionCol1, conditionCol2));
        Assert.assertTrue((boolean)validator.isConditionValid(conditionCol2));
    }

    @Test
    public void testIsConditionHeaderNotBlankWhenHeaderIsNull() throws Exception {
        Validator validator = new Validator();
        ConditionCol52 col52 = this.fakeConditionCol52(null);
        Assert.assertFalse((boolean)validator.isConditionHeaderNotBlank(col52));
    }

    @Test
    public void testIsConditionHeaderNotBlankWhenHeaderIsEmpty() throws Exception {
        Validator validator = new Validator();
        ConditionCol52 col52 = this.fakeConditionCol52("");
        Assert.assertFalse((boolean)validator.isConditionHeaderNotBlank(col52));
    }

    @Test
    public void testIsConditionHeaderNotBlankWhenHeaderIsValid() throws Exception {
        Validator validator = new Validator();
        ConditionCol52 col52 = this.fakeConditionCol52("my header");
        Assert.assertTrue((boolean)validator.isConditionHeaderNotBlank(col52));
    }

    @Test
    public void testIsConditionHeaderUniqueWhenHeaderIsInvalid() throws Exception {
        ConditionCol52 conditionCol1 = this.fakeConditionCol52("header");
        ConditionCol52 conditionCol2 = this.fakeConditionCol52("header");
        Validator validator = new Validator(this.fakeCompositeColumn(conditionCol1, conditionCol2));
        Assert.assertFalse((boolean)validator.isConditionHeaderUnique(conditionCol2));
    }

    @Test
    public void testIsConditionHeaderUniqueWhenHeaderIsValid() throws Exception {
        ConditionCol52 conditionCol1 = this.fakeConditionCol52("header1");
        ConditionCol52 conditionCol2 = this.fakeConditionCol52("header2");
        Validator validator = new Validator(this.fakeCompositeColumn(conditionCol1, conditionCol2));
        Assert.assertTrue((boolean)validator.isConditionHeaderUnique(conditionCol2));
    }

    private ConditionCol52 fakeConditionCol52(String header) {
        ConditionCol52 conditionCol52 = new ConditionCol52();
        conditionCol52.setHeader(header);
        conditionCol52.setConstraintValueType(5);
        return conditionCol52;
    }

    private List<CompositeColumn<? extends BaseColumn>> fakeCompositeColumn(final ConditionCol52 ... columns) {
        ArrayList<CompositeColumn<? extends BaseColumn>> compositeColumns = new ArrayList<CompositeColumn<? extends BaseColumn>>();
        compositeColumns.add(this.fakeCompositeColumn(new ArrayList<ConditionCol52>(){
            {
                for (ConditionCol52 column : columns) {
                    this.add(column);
                }
            }
        }));
        return compositeColumns;
    }

    private CompositeColumn<?> fakeCompositeColumn(final ArrayList<?> objects) {
        return new CompositeColumn(){

            public String getHeader() {
                return null;
            }

            public void setHeader(String header) {
            }

            public boolean isHideColumn() {
                return false;
            }

            public void setHideColumn(boolean hideColumn) {
            }

            public int getWidth() {
                return 0;
            }

            public void setWidth(int width) {
            }

            public DTCellValue52 getDefaultValue() {
                return null;
            }

            public void setDefaultValue(DTCellValue52 defaultValue) {
            }

            public List<?> getChildColumns() {
                return objects;
            }

            public void setChildColumns(List columns) {
            }
        };
    }
}

