/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.panel;

import com.google.gwt.view.client.ListDataProvider;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.panel.AnalysisReport;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.panel.AnalysisReportScreen;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.panel.AnalysisReportScreenView;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.panel.IssueSelectedEvent;
import org.drools.workbench.services.verifier.api.client.Status;
import org.drools.workbench.services.verifier.api.client.reporting.CheckType;
import org.drools.workbench.services.verifier.api.client.reporting.Issue;
import org.drools.workbench.services.verifier.api.client.reporting.Severity;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.PlaceRequest;

@RunWith(value=GwtMockitoTestRunner.class)
public class AnalysisReportScreenTest {
    private AnalysisReportScreen screen;
    @Mock
    private AnalysisReportScreenView view;
    @Mock
    private PlaceManager placeManager;
    @Mock
    private EventSourceMock<IssueSelectedEvent> issueSelectedEvent;
    @Captor
    private ArgumentCaptor<ListDataProvider<Issue>> listDataProviderArgumentCaptor;
    @Captor
    private ArgumentCaptor<IssueSelectedEvent> issueSelectedEventCaptor;
    private ListDataProvider dataProvider;
    @Mock
    private PlaceRequest place;

    @Before
    public void setUp() throws Exception {
        this.screen = new AnalysisReportScreen(this.view, this.placeManager, this.issueSelectedEvent);
        this.screen.setCurrentPlace(this.place);
        ((AnalysisReportScreenView)Mockito.verify((Object)this.view)).setPresenter(this.screen);
        ((AnalysisReportScreenView)Mockito.verify((Object)this.view)).setUpDataProvider((ListDataProvider)this.listDataProviderArgumentCaptor.capture());
        this.dataProvider = (ListDataProvider)this.listDataProviderArgumentCaptor.getValue();
    }

    @Test
    public void testShowReport() throws Exception {
        Issue issue1 = new Issue(Severity.WARNING, CheckType.DEFICIENT_ROW, Collections.emptySet());
        this.screen.showReport(this.getAnalysis(issue1));
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo((String)Mockito.eq((Object)"org.drools.workbench.AnalysisReportScreen"));
        Assert.assertEquals((long)1L, (long)this.dataProvider.getList().size());
        Assert.assertTrue((boolean)this.dataProvider.getList().contains(issue1));
        Issue issue2 = new Issue(Severity.ERROR, CheckType.CONFLICTING_ROWS, Collections.emptySet());
        Issue issue3 = new Issue(Severity.WARNING, CheckType.SINGLE_HIT_LOST, Collections.emptySet());
        this.screen.showReport(this.getAnalysis(issue2, issue3));
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.times((int)2))).goTo((String)Mockito.eq((Object)"org.drools.workbench.AnalysisReportScreen"));
        ((AnalysisReportScreenView)Mockito.verify((Object)this.view)).showIssue(issue1);
        Assert.assertEquals((long)2L, (long)this.dataProvider.getList().size());
        Assert.assertFalse((boolean)this.dataProvider.getList().contains(issue1));
        Assert.assertTrue((boolean)this.dataProvider.getList().contains(issue2));
        Assert.assertTrue((boolean)this.dataProvider.getList().contains(issue3));
    }

    @Test
    public void testMergeEmptyRules() throws Exception {
        this.testMerge(CheckType.EMPTY_RULE);
    }

    @Test
    public void testMergeMissingAction() throws Exception {
        this.testMerge(CheckType.MISSING_ACTION);
    }

    @Test
    public void testMergeMissingRestriction() throws Exception {
        this.testMerge(CheckType.MISSING_RESTRICTION);
    }

    private void testMerge(CheckType type) {
        Issue issue1 = new Issue(Severity.WARNING, type, new HashSet<Integer>(Arrays.asList(1)));
        Issue issue2 = new Issue(Severity.WARNING, type, new HashSet<Integer>(Arrays.asList(2)));
        Issue issue3 = new Issue(Severity.WARNING, type, new HashSet<Integer>(Arrays.asList(3)));
        this.screen.showReport(this.getAnalysis(issue1, issue2, issue3));
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo((String)Mockito.eq((Object)"org.drools.workbench.AnalysisReportScreen"));
        Assert.assertEquals((long)1L, (long)this.dataProvider.getList().size());
        Issue issue = (Issue)this.dataProvider.getList().get(0);
        Assert.assertEquals((Object)Severity.WARNING, (Object)issue.getSeverity());
        Assert.assertEquals((Object)type, (Object)issue.getCheckType());
        Iterator rowNumbers = issue.getRowNumbers().iterator();
        for (Integer rowNumber : Arrays.asList(1, 2, 3)) {
            Assert.assertEquals((Object)rowNumber, rowNumbers.next());
        }
        ((AnalysisReportScreenView)Mockito.verify((Object)this.view)).showIssue(issue);
    }

    @Test
    public void testDoNotShowIfThereAreNoIssues() throws Exception {
        this.screen.showReport(this.getAnalysis(new Issue[0]));
        Assert.assertEquals((long)0L, (long)this.dataProvider.getList().size());
        ((AnalysisReportScreenView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showIssue((Issue)Mockito.any(Issue.class));
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.never())).goTo((String)Mockito.eq((Object)"org.drools.workbench.AnalysisReportScreen"));
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).closePlace((String)Mockito.eq((Object)"org.drools.workbench.AnalysisReportScreen"));
    }

    @Test
    public void testShowEverythingOnce() throws Exception {
        Issue issue2 = new Issue(Severity.WARNING, CheckType.REDUNDANT_ROWS, Collections.emptySet());
        Issue issue3 = new Issue(Severity.WARNING, CheckType.REDUNDANT_ROWS, Collections.emptySet());
        Issue issue4 = new Issue(Severity.WARNING, CheckType.REDUNDANT_ROWS, new HashSet<Integer>(Arrays.asList(1, 2, 3)));
        Issue issue5 = new Issue(Severity.WARNING, CheckType.REDUNDANT_ROWS, new HashSet<Integer>(Arrays.asList(1, 2, 3)));
        this.screen.showReport(this.getAnalysis(issue2, issue3, issue4, issue5));
        Assert.assertEquals((long)2L, (long)this.dataProvider.getList().size());
    }

    @Test
    public void testOnSelect() throws Exception {
        Issue issue1 = new Issue(Severity.WARNING, CheckType.REDUNDANT_ROWS, Collections.emptySet());
        Issue issue2 = new Issue(Severity.WARNING, CheckType.SINGLE_HIT_LOST, Collections.emptySet());
        this.screen.showReport(this.getAnalysis(issue1, issue2));
        ((EventSourceMock)Mockito.verify(this.issueSelectedEvent, (VerificationMode)Mockito.times((int)1))).fire(this.issueSelectedEventCaptor.capture());
        Assert.assertEquals((Object)issue1, (Object)((IssueSelectedEvent)this.issueSelectedEventCaptor.getValue()).getIssue());
        this.screen.onSelect(issue2);
        ((AnalysisReportScreenView)Mockito.verify((Object)this.view)).showIssue(issue2);
        ((EventSourceMock)Mockito.verify(this.issueSelectedEvent, (VerificationMode)Mockito.times((int)2))).fire(this.issueSelectedEventCaptor.capture());
        Assert.assertEquals((Object)issue2, (Object)((IssueSelectedEvent)this.issueSelectedEventCaptor.getValue()).getIssue());
    }

    @Test
    public void testShowStatus() throws Exception {
        this.screen.showStatus(new Status("UUID", 1, 2, 3));
        ((AnalysisReportScreenView)Mockito.verify((Object)this.view)).showStatusTitle(1, 2, 3);
    }

    @Test
    public void testThePlaceInReportIsNotActive() throws Exception {
        this.screen.showReport(this.getAnalysis(PlaceRequest.NOWHERE, new Issue[0]));
        ((AnalysisReportScreenView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showStatusComplete();
    }

    @Test
    public void testNoIssuesShowNothing() throws Exception {
        this.screen.showReport(this.getAnalysis(new Issue[0]));
        ((AnalysisReportScreenView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showIssue((Issue)Mockito.any(Issue.class));
        ((AnalysisReportScreenView)Mockito.verify((Object)this.view)).clearIssue();
        ((EventSourceMock)Mockito.verify(this.issueSelectedEvent, (VerificationMode)Mockito.times((int)1))).fire(this.issueSelectedEventCaptor.capture());
        Assert.assertEquals((Object)Issue.EMPTY, (Object)((IssueSelectedEvent)this.issueSelectedEventCaptor.getValue()).getIssue());
    }

    private AnalysisReport getAnalysis(Issue ... issues) {
        return this.getAnalysis(this.place, issues);
    }

    private AnalysisReport getAnalysis(PlaceRequest place, Issue ... issues) {
        AnalysisReport report = new AnalysisReport(place);
        HashSet<Issue> unorderedIssues = new HashSet<Issue>();
        for (Issue issue : issues) {
            unorderedIssues.add(issue);
        }
        report.setIssues(unorderedIssues);
        return report;
    }
}

