/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.auditlog;

import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.drools.workbench.models.datamodel.auditlog.AuditLogEntry;
import org.drools.workbench.models.datamodel.rule.ActionRetractFact;
import org.drools.workbench.models.datamodel.rule.FactPattern;
import org.drools.workbench.models.datamodel.workitems.PortableParameterDefinition;
import org.drools.workbench.models.datamodel.workitems.PortableStringParameterDefinition;
import org.drools.workbench.models.datamodel.workitems.PortableWorkDefinition;
import org.drools.workbench.models.guided.dtable.shared.auditlog.UpdateColumnAuditLogEntry;
import org.drools.workbench.models.guided.dtable.shared.model.ActionInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionRetractFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.AttributeCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumnFieldDiff;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.MetadataCol52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.models.guided.dtable.shared.model.WorkItemColumnParameterValueDiffImpl;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.GuidedDecisionTableConstants;
import org.drools.workbench.screens.guided.dtable.client.widget.auditlog.AuditLogEntryCellHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class AuditLogEntryCellHelperTest {
    @Mock
    private DateTimeFormat format;
    private String labelClass = "mockCssClassForLabel";
    private AuditLogEntryCellHelper helper;

    @Before
    public void setUp() throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Mockito.when((Object)this.format.format((Date)Matchers.any(Date.class))).thenReturn((Object)"mockDateString");
        this.helper = new AuditLogEntryCellHelper(this.format, this.labelClass, "mockCssClassForValue");
    }

    @Test
    public void convertValueToString() {
        Assert.assertEquals(null, (Object)this.helper.convertValueToString(null));
        Assert.assertEquals((Object)"true", (Object)this.helper.convertValueToString((Object)true));
        Assert.assertEquals((Object)"false", (Object)this.helper.convertValueToString((Object)false));
        Date date = new Date();
        Assert.assertEquals((Object)this.format.format(date), (Object)this.helper.convertValueToString((Object)date));
        Assert.assertEquals((Object)BigDecimal.ONE.toPlainString(), (Object)this.helper.convertValueToString((Object)BigDecimal.ONE));
        Assert.assertEquals((Object)BigInteger.ONE.toString(), (Object)this.helper.convertValueToString((Object)BigInteger.ONE));
        Byte b = 127;
        Assert.assertEquals((Object)b.toString(), (Object)this.helper.convertValueToString((Object)b));
        Double d = 123.456;
        Assert.assertEquals((Object)d.toString(), (Object)this.helper.convertValueToString((Object)d));
        Float f = new Float(123.456);
        Assert.assertEquals((Object)f.toString(), (Object)this.helper.convertValueToString((Object)f));
        Integer i = 123;
        Assert.assertEquals((Object)i.toString(), (Object)this.helper.convertValueToString((Object)i));
        Long l = new Long(123L);
        Assert.assertEquals((Object)l.toString(), (Object)this.helper.convertValueToString((Object)l));
        Short s = 123;
        Assert.assertEquals((Object)s.toString(), (Object)this.helper.convertValueToString((Object)s));
        Assert.assertEquals((Object)"surprise!", (Object)this.helper.convertValueToString((Object)"surprise!"));
    }

    @Test
    public void getSafeHtml_Metadata() {
        MetadataCol52 originalColumn = new MetadataCol52();
        originalColumn.setHideColumn(true);
        originalColumn.setDefaultValue(new DTCellValue52("def1"));
        originalColumn.setMetadata("meta");
        originalColumn.setHeader("meta");
        MetadataCol52 newColumn = new MetadataCol52();
        newColumn.setHideColumn(false);
        newColumn.setDefaultValue(new DTCellValue52("def2"));
        newColumn.setMetadata("meta");
        newColumn.setHeader("meta");
        List diffs = originalColumn.diff((BaseColumn)newColumn);
        SafeHtml result = this.helper.getSafeHtml((AuditLogEntry)new UpdateColumnAuditLogEntry("mock user", (BaseColumn)originalColumn, (BaseColumn)newColumn, diffs));
        Assert.assertEquals((Object)(this.getHeaderRepre(newColumn.getHeader()) + this.getDiffRepre(diffs)), (Object)result.asString());
    }

    @Test
    public void getSafeHtml_Attribute() {
        AttributeCol52 originalColumn = new AttributeCol52();
        originalColumn.setReverseOrder(false);
        originalColumn.setUseRowNumber(false);
        originalColumn.setHideColumn(false);
        originalColumn.setDefaultValue(new DTCellValue52("def1"));
        originalColumn.setAttribute("attr");
        originalColumn.setHeader("attr");
        AttributeCol52 newColumn = new AttributeCol52();
        newColumn.setReverseOrder(true);
        newColumn.setUseRowNumber(true);
        newColumn.setHideColumn(true);
        newColumn.setDefaultValue(new DTCellValue52("def2"));
        newColumn.setAttribute("attr");
        newColumn.setHeader("attr");
        List diffs = originalColumn.diff((BaseColumn)newColumn);
        SafeHtml result = this.helper.getSafeHtml((AuditLogEntry)new UpdateColumnAuditLogEntry("mock user", (BaseColumn)originalColumn, (BaseColumn)newColumn, diffs));
        Assert.assertEquals((Object)(this.getAttributeHeaderRepre(newColumn.getAttribute()) + this.getDiffRepre(diffs)), (Object)result.asString());
    }

    @Test
    public void getSafeHtml_Condition() {
        ConditionCol52 originalColumn = new ConditionCol52();
        originalColumn.setBinding("bind1");
        originalColumn.setConstraintValueType(1);
        originalColumn.setFactField("field1");
        originalColumn.setFieldType("FieldType1");
        originalColumn.setOperator("==");
        originalColumn.setValueList("a,b,c");
        originalColumn.setHeader("condition1");
        originalColumn.setHideColumn(false);
        originalColumn.setDefaultValue(new DTCellValue52("def1"));
        ConditionCol52 newColumn = new ConditionCol52();
        newColumn.setBinding("bind2");
        newColumn.setConstraintValueType(5);
        newColumn.setFactField("field2");
        newColumn.setFieldType("FieldType2");
        newColumn.setOperator("!=");
        newColumn.setValueList("x,y,z");
        newColumn.setHeader("condition2");
        newColumn.setHideColumn(true);
        newColumn.setDefaultValue(new DTCellValue52("def2"));
        Pattern52 originalPattern = new Pattern52();
        originalPattern.setBoundName("patBind1");
        originalPattern.setFactType("FactType1");
        originalPattern.setEntryPointName("ep1");
        Pattern52 newPattern = new Pattern52();
        newPattern.setBoundName("patBind2");
        newPattern.setFactType("FactType2");
        newPattern.setEntryPointName("ep2");
        List diffs = originalColumn.diff((BaseColumn)newColumn);
        diffs.addAll(originalPattern.diff((BaseColumn)newPattern));
        SafeHtml result = this.helper.getSafeHtml((AuditLogEntry)new UpdateColumnAuditLogEntry("mock user", (BaseColumn)originalColumn, (BaseColumn)newColumn, diffs));
        Assert.assertEquals((Object)(this.getConditionHeaderRepre(newColumn.getHeader()) + this.getDiffRepre(diffs)), (Object)result.asString());
    }

    @Test
    public void getSafeHtml_ActionInsert() {
        ActionInsertFactCol52 originalColumn = new ActionInsertFactCol52();
        originalColumn.setFactField("field1");
        originalColumn.setInsertLogical(false);
        originalColumn.setValueList("q,w,e");
        originalColumn.setHeader("action1");
        originalColumn.setHideColumn(false);
        originalColumn.setDefaultValue(new DTCellValue52("def1"));
        ActionInsertFactCol52 newColumn = new ActionInsertFactCol52();
        newColumn.setFactField("field2");
        newColumn.setInsertLogical(true);
        newColumn.setValueList("a,s,d");
        newColumn.setHeader("action2");
        newColumn.setHideColumn(true);
        newColumn.setDefaultValue(new DTCellValue52("def2"));
        List diffs = originalColumn.diff((BaseColumn)newColumn);
        SafeHtml result = this.helper.getSafeHtml((AuditLogEntry)new UpdateColumnAuditLogEntry("mock user", (BaseColumn)originalColumn, (BaseColumn)newColumn, diffs));
        Assert.assertEquals((Object)(this.getActionHeaderRepre(newColumn.getHeader()) + this.getDiffRepre(diffs)), (Object)result.asString());
    }

    @Test
    public void getSafeHtml_ActionSetField() {
        ActionSetFieldCol52 originalColumn = new ActionSetFieldCol52();
        originalColumn.setBoundName("bind1");
        originalColumn.setFactField("field1");
        originalColumn.setUpdate(false);
        originalColumn.setValueList("q,w,e");
        originalColumn.setHeader("action1");
        originalColumn.setHideColumn(false);
        originalColumn.setDefaultValue(new DTCellValue52("def1"));
        ActionSetFieldCol52 newColumn = new ActionSetFieldCol52();
        newColumn.setBoundName("bind2");
        newColumn.setFactField("field2");
        newColumn.setUpdate(true);
        newColumn.setValueList("a,s,d");
        newColumn.setHeader("action2");
        newColumn.setHideColumn(true);
        newColumn.setDefaultValue(new DTCellValue52("def2"));
        List diffs = originalColumn.diff((BaseColumn)newColumn);
        SafeHtml result = this.helper.getSafeHtml((AuditLogEntry)new UpdateColumnAuditLogEntry("mock user", (BaseColumn)originalColumn, (BaseColumn)newColumn, diffs));
        Assert.assertEquals((Object)(this.getActionHeaderRepre(newColumn.getHeader()) + this.getDiffRepre(diffs)), (Object)result.asString());
    }

    @Test
    public void getSafeHtml_ActionRetract() {
        ActionRetractFactCol52 originalColumn = new ActionRetractFactCol52();
        originalColumn.setHeader("action1");
        originalColumn.setHideColumn(false);
        originalColumn.setDefaultValue(new DTCellValue52("def1"));
        ActionRetractFactCol52 newColumn = new ActionRetractFactCol52();
        newColumn.setHeader("action2");
        newColumn.setHideColumn(true);
        newColumn.setDefaultValue(new DTCellValue52("def2"));
        List diffs = originalColumn.diff((BaseColumn)newColumn);
        SafeHtml result = this.helper.getSafeHtml((AuditLogEntry)new UpdateColumnAuditLogEntry("mock user", (BaseColumn)originalColumn, (BaseColumn)newColumn, diffs));
        Assert.assertEquals((Object)(this.getHeaderRepre(newColumn.getHeader()) + this.getDiffRepre(diffs)), (Object)result.asString());
    }

    @Test
    public void getSafeHtml_ActionWorkItemExecute_Simple() {
        ActionWorkItemCol52 originalColumn = new ActionWorkItemCol52();
        originalColumn.setHeader("action1");
        originalColumn.setHideColumn(false);
        ActionWorkItemCol52 newColumn = new ActionWorkItemCol52();
        newColumn.setHeader("action2");
        newColumn.setHideColumn(true);
        PortableStringParameterDefinition param1 = new PortableStringParameterDefinition();
        param1.setName("param1");
        param1.setValue("value1");
        PortableWorkDefinition def1 = new PortableWorkDefinition();
        def1.setName("def1name");
        def1.addParameter((PortableParameterDefinition)param1);
        PortableStringParameterDefinition param3 = new PortableStringParameterDefinition();
        param3.setName("param3");
        param3.setValue("value3");
        PortableWorkDefinition def2 = new PortableWorkDefinition();
        def2.setName("def2name");
        def2.addParameter((PortableParameterDefinition)param3);
        originalColumn.setWorkItemDefinition(def1);
        newColumn.setWorkItemDefinition(def2);
        List diffs = originalColumn.diff((BaseColumn)newColumn);
        SafeHtml result = this.helper.getSafeHtml((AuditLogEntry)new UpdateColumnAuditLogEntry("mock user", (BaseColumn)originalColumn, (BaseColumn)newColumn, diffs));
        Assert.assertEquals((Object)(this.getActionHeaderRepre(newColumn.getHeader()) + this.getDiffRepre(diffs)), (Object)result.asString());
    }

    @Test
    public void getSafeHtml_ActionWorkItemExecute_Complex() {
        ActionWorkItemCol52 originalColumn = new ActionWorkItemCol52();
        originalColumn.setHeader("action1");
        originalColumn.setHideColumn(false);
        ActionWorkItemCol52 newColumn = new ActionWorkItemCol52();
        newColumn.setHeader("action2");
        newColumn.setHideColumn(true);
        PortableStringParameterDefinition param1 = new PortableStringParameterDefinition();
        param1.setName("param1");
        param1.setValue("value1");
        PortableStringParameterDefinition param2 = new PortableStringParameterDefinition();
        param2.setName("param2");
        param2.setValue("value2");
        PortableWorkDefinition def1 = new PortableWorkDefinition();
        def1.setName("def1name");
        def1.addParameter((PortableParameterDefinition)param1);
        def1.addParameter((PortableParameterDefinition)param2);
        PortableStringParameterDefinition param3 = new PortableStringParameterDefinition();
        param3.setName("param3");
        param3.setValue("value3");
        PortableStringParameterDefinition param4 = new PortableStringParameterDefinition();
        param4.setName("param1");
        param4.setValue("value1");
        PortableStringParameterDefinition param5 = new PortableStringParameterDefinition();
        param5.setName("param5");
        param5.setBinding("binding5");
        PortableStringParameterDefinition param6 = new PortableStringParameterDefinition();
        param6.setName("param2");
        param6.setValue("value6");
        PortableWorkDefinition def2 = new PortableWorkDefinition();
        def2.setName("def2name");
        def2.addParameter((PortableParameterDefinition)param3);
        def2.addParameter((PortableParameterDefinition)param4);
        def2.addParameter((PortableParameterDefinition)param5);
        def2.addParameter((PortableParameterDefinition)param6);
        originalColumn.setWorkItemDefinition(def1);
        newColumn.setWorkItemDefinition(def2);
        List diffs = originalColumn.diff((BaseColumn)newColumn);
        SafeHtml result = this.helper.getSafeHtml((AuditLogEntry)new UpdateColumnAuditLogEntry("mock user", (BaseColumn)originalColumn, (BaseColumn)newColumn, diffs));
        Assert.assertEquals((Object)(this.getActionHeaderRepre(newColumn.getHeader()) + this.getDiffRepre(diffs)), (Object)result.asString());
    }

    @Test
    public void getSafeHtml_ActionWorkItemInsert() {
        ActionWorkItemInsertFactCol52 originalColumn = new ActionWorkItemInsertFactCol52();
        originalColumn.setParameterClassName("ParamClass1");
        originalColumn.setWorkItemName("WI1");
        originalColumn.setWorkItemResultParameterName("param1");
        originalColumn.setBoundName("b1");
        originalColumn.setFactField("field1");
        originalColumn.setInsertLogical(false);
        originalColumn.setHeader("action1");
        originalColumn.setHideColumn(false);
        ActionWorkItemInsertFactCol52 newColumn = new ActionWorkItemInsertFactCol52();
        newColumn.setParameterClassName("ParamClass2");
        newColumn.setWorkItemName("WI2");
        newColumn.setWorkItemResultParameterName("param2");
        newColumn.setBoundName("b2");
        newColumn.setFactField("field2");
        newColumn.setInsertLogical(true);
        newColumn.setHeader("action2");
        newColumn.setHideColumn(true);
        List diffs = originalColumn.diff((BaseColumn)newColumn);
        SafeHtml result = this.helper.getSafeHtml((AuditLogEntry)new UpdateColumnAuditLogEntry("mock user", (BaseColumn)originalColumn, (BaseColumn)newColumn, diffs));
        Assert.assertEquals((Object)(this.getActionHeaderRepre(newColumn.getHeader()) + this.getDiffRepre(diffs)), (Object)result.asString());
    }

    @Test
    public void getSafeHtml_ActionWorkItemSetField() {
        ActionWorkItemSetFieldCol52 originalColumn = new ActionWorkItemSetFieldCol52();
        originalColumn.setParameterClassName("ParamClass1");
        originalColumn.setWorkItemName("WI1");
        originalColumn.setWorkItemResultParameterName("param1");
        originalColumn.setBoundName("bind1");
        originalColumn.setFactField("field1");
        originalColumn.setUpdate(false);
        originalColumn.setHeader("action1");
        originalColumn.setHideColumn(false);
        ActionWorkItemSetFieldCol52 newColumn = new ActionWorkItemSetFieldCol52();
        newColumn.setParameterClassName("ParamClass2");
        newColumn.setWorkItemName("WI2");
        newColumn.setWorkItemResultParameterName("param2");
        newColumn.setBoundName("bind2");
        newColumn.setFactField("field2");
        newColumn.setUpdate(true);
        newColumn.setHeader("action2");
        newColumn.setHideColumn(true);
        List diffs = originalColumn.diff((BaseColumn)newColumn);
        SafeHtml result = this.helper.getSafeHtml((AuditLogEntry)new UpdateColumnAuditLogEntry("mock user", (BaseColumn)originalColumn, (BaseColumn)newColumn, diffs));
        Assert.assertEquals((Object)(this.getActionHeaderRepre(newColumn.getHeader()) + this.getDiffRepre(diffs)), (Object)result.asString());
    }

    @Test
    public void getSafeHtml_BrlCondition() {
        BRLConditionColumn originalColumn = new BRLConditionColumn();
        originalColumn.setHeader("condition1");
        originalColumn.setHideColumn(false);
        BRLConditionColumn newColumn = new BRLConditionColumn();
        newColumn.setHeader("condition2");
        newColumn.setHideColumn(true);
        List diffs = originalColumn.diff((BaseColumn)newColumn);
        SafeHtml result = this.helper.getSafeHtml((AuditLogEntry)new UpdateColumnAuditLogEntry("mock user", (BaseColumn)originalColumn, (BaseColumn)newColumn, diffs));
        Assert.assertEquals((Object)(this.getHeaderRepre(newColumn.getHeader()) + this.getDiffRepre(diffs)), (Object)result.asString());
    }

    @Test
    public void getSafeHtml_BrlCondition_DefinitionOnly() {
        BRLConditionColumn originalColumn = new BRLConditionColumn();
        originalColumn.setDefinition(Arrays.asList(new FactPattern("FactType1")));
        originalColumn.setHeader("condition");
        originalColumn.setHideColumn(false);
        BRLConditionColumn newColumn = new BRLConditionColumn();
        originalColumn.setDefinition(Arrays.asList(new FactPattern("FactType2"), new FactPattern("FactType3")));
        newColumn.setHeader("condition");
        newColumn.setHideColumn(false);
        List diffs = originalColumn.diff((BaseColumn)newColumn);
        SafeHtml result = this.helper.getSafeHtml((AuditLogEntry)new UpdateColumnAuditLogEntry("mock user", (BaseColumn)originalColumn, (BaseColumn)newColumn, diffs));
        Assert.assertEquals((Object)(this.getHeaderRepre(newColumn.getHeader()) + this.getDiffRepre(new ArrayList<BaseColumnFieldDiff>())), (Object)result.asString());
    }

    @Test
    public void getSafeHtml_BrlAction() {
        BRLActionColumn originalColumn = new BRLActionColumn();
        originalColumn.setHeader("action1");
        originalColumn.setHideColumn(false);
        BRLActionColumn newColumn = new BRLActionColumn();
        newColumn.setHeader("action2");
        newColumn.setHideColumn(true);
        List diffs = originalColumn.diff((BaseColumn)newColumn);
        SafeHtml result = this.helper.getSafeHtml((AuditLogEntry)new UpdateColumnAuditLogEntry("mock user", (BaseColumn)originalColumn, (BaseColumn)newColumn, diffs));
        Assert.assertEquals((Object)(this.getHeaderRepre(newColumn.getHeader()) + this.getDiffRepre(diffs)), (Object)result.asString());
    }

    @Test
    public void getSafeHtml_BrlAction_DefinitionOnly() {
        BRLActionColumn originalColumn = new BRLActionColumn();
        originalColumn.setDefinition(Arrays.asList(new ActionRetractFact("fact1")));
        originalColumn.setHeader("action");
        originalColumn.setHideColumn(false);
        BRLActionColumn newColumn = new BRLActionColumn();
        newColumn.setDefinition(Arrays.asList(new ActionRetractFact("fact2"), new ActionRetractFact("fact3")));
        newColumn.setHeader("action");
        newColumn.setHideColumn(false);
        List diffs = originalColumn.diff((BaseColumn)newColumn);
        SafeHtml result = this.helper.getSafeHtml((AuditLogEntry)new UpdateColumnAuditLogEntry("mock user", (BaseColumn)originalColumn, (BaseColumn)newColumn, diffs));
        Assert.assertEquals((Object)(this.getHeaderRepre(newColumn.getHeader()) + this.getDiffRepre(new ArrayList<BaseColumnFieldDiff>())), (Object)result.asString());
    }

    private String getHeaderRepre(String header) {
        return String.format("commentHeader(DecisionTableAuditLogUpdateColumn(%s))", header);
    }

    private String getAttributeHeaderRepre(String header) {
        return String.format("commentHeader(DecisionTableAuditLogUpdateAttribute(%s))", header);
    }

    private String getConditionHeaderRepre(String header) {
        return String.format("commentHeader(DecisionTableAuditLogUpdateCondition(%s))", header);
    }

    private String getActionHeaderRepre(String header) {
        return String.format("commentHeader(DecisionTableAuditLogUpdateAction(%s))", header);
    }

    private String getDiffRepre(List<BaseColumnFieldDiff> diffs) {
        String diffsRepre = "";
        for (BaseColumnFieldDiff diff : diffs) {
            diffsRepre = diffsRepre + this.getDiffRepre(diff);
        }
        return String.format("updatedFields(%s, %s)", diffsRepre, this.labelClass);
    }

    private String getDiffRepre(BaseColumnFieldDiff diff) {
        boolean constraintValueType = diff.getFieldName().equals("constraintValueType");
        boolean WIParamValueOnly = diff instanceof WorkItemColumnParameterValueDiffImpl;
        String paramName = WIParamValueOnly ? ((WorkItemColumnParameterValueDiffImpl)diff).getParameterName() : "";
        return String.format("updatedField(%s, '%s', '%s')", this.getDisplayableFieldValue(diff.getFieldName(), paramName, WIParamValueOnly), this.getNonNullValue(diff.getOldValue(), constraintValueType), this.getNonNullValue(diff.getValue(), constraintValueType));
    }

    private String getNonNullValue(Object diffValue, boolean constraintValueType) {
        String value = "";
        if (diffValue != null) {
            value = constraintValueType ? this.helper.getLiteralForCalculationType((Integer)diffValue) : diffValue.toString();
        }
        return value;
    }

    private String getDisplayableFieldValue(String field, String optionalParameter, boolean WIParamValueOnly) {
        switch (field) {
            case "header": {
                return GuidedDecisionTableConstants.INSTANCE.ColumnHeader();
            }
            case "hideColumn": {
                return GuidedDecisionTableConstants.INSTANCE.HideThisColumn();
            }
            case "defaultValue": {
                return GuidedDecisionTableConstants.INSTANCE.DefaultValue();
            }
            case "metadata": {
                return GuidedDecisionTableConstants.INSTANCE.Metadata1();
            }
            case "reverseOrder": {
                return GuidedDecisionTableConstants.INSTANCE.ReverseOrder();
            }
            case "useRowNumber": {
                return GuidedDecisionTableConstants.INSTANCE.UseRowNumber();
            }
            case "entryPointName": {
                return GuidedDecisionTableConstants.INSTANCE.DTLabelFromEntryPoint();
            }
            case "binding": {
                return GuidedDecisionTableConstants.INSTANCE.Binding();
            }
            case "constraintValueType": {
                return GuidedDecisionTableConstants.INSTANCE.CalculationType();
            }
            case "operator": {
                return GuidedDecisionTableConstants.INSTANCE.Operator();
            }
            case "fieldType": 
            case "type": {
                return GuidedDecisionTableConstants.INSTANCE.FieldType();
            }
            case "update": {
                return GuidedDecisionTableConstants.INSTANCE.UpdateEngineWithChanges();
            }
            case "isInsertLogical": {
                return GuidedDecisionTableConstants.INSTANCE.LogicallyInsert();
            }
            case "workItemDefinitionName": {
                return GuidedDecisionTableConstants.INSTANCE.DecisionTableAuditLogWorkItemName();
            }
            case "workItemDefinitionParameterName": {
                return GuidedDecisionTableConstants.INSTANCE.DecisionTableAuditLogWorkItemParameterName();
            }
            case "workItemDefinitionParameterValue": {
                if (WIParamValueOnly) {
                    return GuidedDecisionTableConstants.INSTANCE.DecisionTableAuditLogWorkItemParameterValueOnly0(optionalParameter);
                }
                return GuidedDecisionTableConstants.INSTANCE.DecisionTableAuditLogWorkItemParameterValue();
            }
        }
        if (Arrays.asList("factType", "factType").contains(field)) {
            return GuidedDecisionTableConstants.INSTANCE.FactType();
        }
        if (Arrays.asList("boundName", "boundName", "boundName").contains(field)) {
            return GuidedDecisionTableConstants.INSTANCE.Binding();
        }
        if (Arrays.asList("factField", "factField", "factField").contains(field)) {
            return GuidedDecisionTableConstants.INSTANCE.Field();
        }
        if (Arrays.asList("valueList", "valueList", "valueList").contains(field)) {
            return GuidedDecisionTableConstants.INSTANCE.ValueList();
        }
        if (Arrays.asList("parameterClassName", "parameterClassName").contains(field)) {
            return GuidedDecisionTableConstants.INSTANCE.DecisionTableAuditLogWorkItemParameterClassName();
        }
        if (Arrays.asList("workItemName", "workItemName").contains(field)) {
            return GuidedDecisionTableConstants.INSTANCE.DecisionTableAuditLogWorkItemName();
        }
        if (Arrays.asList("workItemResultParameterName", "workItemResultParameterName").contains(field)) {
            return GuidedDecisionTableConstants.INSTANCE.DecisionTableAuditLogWorkItemParameterName();
        }
        if (Arrays.asList("value", "value", "value").contains(field)) {
            return GuidedDecisionTableConstants.INSTANCE.Value();
        }
        return "";
    }
}

