/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerBoundsHelper;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.ext.wires.core.grids.client.model.Bounds;

@RunWith(value=MockitoJUnitRunner.class)
public class GuidedDecisionTableModellerBoundsHelperTest {
    private GuidedDecisionTableModellerBoundsHelper helper = new GuidedDecisionTableModellerBoundsHelper();

    @Test(expected=NullPointerException.class)
    public void nullCollection() {
        this.helper.getBounds(null);
    }

    @Test
    public void emptyCollection() {
        Bounds b = this.helper.getBounds(Collections.emptySet());
        Assert.assertEquals((double)-2000.0, (double)b.getX(), (double)0.0);
        Assert.assertEquals((double)-2000.0, (double)b.getY(), (double)0.0);
        Assert.assertEquals((double)4000.0, (double)b.getWidth(), (double)0.0);
        Assert.assertEquals((double)4000.0, (double)b.getHeight(), (double)0.0);
    }

    @Test
    public void emptyOneDecisionTableWithinMinimumBounds() {
        Bounds b = this.helper.getBounds((Set)new HashSet<GuidedDecisionTableView.Presenter>(){
            {
                this.add(GuidedDecisionTableModellerBoundsHelperTest.this.makeTable(0.0, 0.0, 400.0, 400.0));
            }
        });
        Assert.assertEquals((double)-2000.0, (double)b.getX(), (double)0.0);
        Assert.assertEquals((double)-2000.0, (double)b.getY(), (double)0.0);
        Assert.assertEquals((double)4000.0, (double)b.getWidth(), (double)0.0);
        Assert.assertEquals((double)4000.0, (double)b.getHeight(), (double)0.0);
    }

    @Test
    public void multipleDecisionTablesCheckLeftBounds() {
        Bounds b = this.helper.getBounds((Set)new HashSet<GuidedDecisionTableView.Presenter>(){
            {
                this.add(GuidedDecisionTableModellerBoundsHelperTest.this.makeTable(0.0, 0.0, 400.0, 400.0));
                this.add(GuidedDecisionTableModellerBoundsHelperTest.this.makeTable(-2200.0, 0.0, 400.0, 400.0));
            }
        });
        double expectedMinX = -2220.0;
        Assert.assertEquals((double)-2220.0, (double)b.getX(), (double)0.0);
        Assert.assertEquals((double)-2000.0, (double)b.getY(), (double)0.0);
        Assert.assertEquals((double)4220.0, (double)b.getWidth(), (double)0.0);
        Assert.assertEquals((double)4000.0, (double)b.getHeight(), (double)0.0);
    }

    @Test
    public void multipleDecisionTablesCheckRightBounds() {
        Bounds b = this.helper.getBounds((Set)new HashSet<GuidedDecisionTableView.Presenter>(){
            {
                this.add(GuidedDecisionTableModellerBoundsHelperTest.this.makeTable(0.0, 0.0, 400.0, 400.0));
                this.add(GuidedDecisionTableModellerBoundsHelperTest.this.makeTable(1800.0, 0.0, 400.0, 400.0));
            }
        });
        double expectedMaxX = 2220.0;
        Assert.assertEquals((double)-2000.0, (double)b.getX(), (double)0.0);
        Assert.assertEquals((double)-2000.0, (double)b.getY(), (double)0.0);
        Assert.assertEquals((double)4220.0, (double)b.getWidth(), (double)0.0);
        Assert.assertEquals((double)4000.0, (double)b.getHeight(), (double)0.0);
    }

    @Test
    public void multipleDecisionTablesCheckTopBounds() {
        Bounds b = this.helper.getBounds((Set)new HashSet<GuidedDecisionTableView.Presenter>(){
            {
                this.add(GuidedDecisionTableModellerBoundsHelperTest.this.makeTable(0.0, 0.0, 400.0, 400.0));
                this.add(GuidedDecisionTableModellerBoundsHelperTest.this.makeTable(0.0, -2200.0, 400.0, 400.0));
            }
        });
        double expectedMinY = -2220.0;
        Assert.assertEquals((double)-2000.0, (double)b.getX(), (double)0.0);
        Assert.assertEquals((double)-2220.0, (double)b.getY(), (double)0.0);
        Assert.assertEquals((double)4000.0, (double)b.getWidth(), (double)0.0);
        Assert.assertEquals((double)4220.0, (double)b.getHeight(), (double)0.0);
    }

    @Test
    public void multipleDecisionTablesCheckBottomBounds() {
        Bounds b = this.helper.getBounds((Set)new HashSet<GuidedDecisionTableView.Presenter>(){
            {
                this.add(GuidedDecisionTableModellerBoundsHelperTest.this.makeTable(0.0, 0.0, 400.0, 400.0));
                this.add(GuidedDecisionTableModellerBoundsHelperTest.this.makeTable(0.0, 1800.0, 400.0, 400.0));
            }
        });
        double expectedMaxY = 2220.0;
        Assert.assertEquals((double)-2000.0, (double)b.getX(), (double)0.0);
        Assert.assertEquals((double)-2000.0, (double)b.getY(), (double)0.0);
        Assert.assertEquals((double)4000.0, (double)b.getWidth(), (double)0.0);
        Assert.assertEquals((double)4220.0, (double)b.getHeight(), (double)0.0);
    }

    private GuidedDecisionTableView.Presenter makeTable(double x, double y, double width, double height) {
        GuidedDecisionTableView.Presenter dtPresenter = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        GuidedDecisionTableView dtView = (GuidedDecisionTableView)Mockito.mock(GuidedDecisionTableView.class);
        Mockito.when((Object)dtPresenter.getView()).thenReturn((Object)dtView);
        Mockito.when((Object)dtView.getX()).thenReturn((Object)x);
        Mockito.when((Object)dtView.getY()).thenReturn((Object)y);
        Mockito.when((Object)dtView.getWidth()).thenReturn((Object)width);
        Mockito.when((Object)dtView.getHeight()).thenReturn((Object)height);
        return dtPresenter;
    }
}

