/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.columns;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.ArrayList;
import java.util.List;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTablePresenter;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.BooleanUiColumn;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCell;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.dom.multiple.impl.CheckBoxDOMElementFactory;

@RunWith(value=LienzoMockitoTestRunner.class)
public class BooleanUiColumnTest {
    @Mock
    private GridColumn.HeaderMetaData headerMetaData;
    @Mock
    private GuidedDecisionTablePresenter.Access access;
    @Mock
    private CheckBoxDOMElementFactory factory;
    @Mock
    private GridBodyCellRenderContext context;
    @Mock
    private Callback<GridCellValue<Boolean>> callback;
    @Captor
    private ArgumentCaptor<BaseGridCellValue<Boolean>> callbackArgumentCaptor;
    private BooleanUiColumn column;

    @Before
    public void setup() {
        ArrayList<GridColumn.HeaderMetaData> metaDataList = new ArrayList<GridColumn.HeaderMetaData>(){
            {
                this.add(BooleanUiColumnTest.this.headerMetaData);
            }
        };
        this.column = new BooleanUiColumn((List)metaDataList, 100.0, true, true, this.access, this.factory);
    }

    @Test
    public void editTrueToFalse() {
        Mockito.when((Object)this.access.isEditable()).thenReturn((Object)true);
        BaseGridCell cell = new BaseGridCell((GridCellValue)new BaseGridCellValue((Object)true));
        this.column.edit((GridCell)cell, this.context, this.callback);
        ((Callback)Mockito.verify(this.callback, (VerificationMode)Mockito.times((int)1))).callback(this.callbackArgumentCaptor.capture());
        BaseGridCellValue callbackArgument = (BaseGridCellValue)this.callbackArgumentCaptor.getValue();
        Assert.assertFalse((boolean)((Boolean)callbackArgument.getValue()));
    }

    @Test
    public void editFalseToTrue() {
        Mockito.when((Object)this.access.isEditable()).thenReturn((Object)true);
        BaseGridCell cell = new BaseGridCell((GridCellValue)new BaseGridCellValue((Object)false));
        this.column.edit((GridCell)cell, this.context, this.callback);
        ((Callback)Mockito.verify(this.callback, (VerificationMode)Mockito.times((int)1))).callback(this.callbackArgumentCaptor.capture());
        BaseGridCellValue callbackArgument = (BaseGridCellValue)this.callbackArgumentCaptor.getValue();
        Assert.assertTrue((boolean)((Boolean)callbackArgument.getValue()));
    }

    @Test
    public void editReadOnly() {
        Mockito.when((Object)this.access.isEditable()).thenReturn((Object)false);
        BaseGridCell cell = new BaseGridCell((GridCellValue)new BaseGridCellValue((Object)true));
        this.column.edit((GridCell)cell, this.context, this.callback);
        ((Callback)Mockito.verify(this.callback, (VerificationMode)Mockito.never())).callback(Mockito.any(BaseGridCellValue.class));
    }
}

