/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.columns;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.CallbackFactory;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.dom.listbox.MultiValueDOMElement;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.dom.listbox.MultiValueSingletonDOMElementFactory;
import org.gwtbootstrap3.client.ui.ListBox;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;

@RunWith(value=GwtMockitoTestRunner.class)
public class CallbackFactoryTest {
    private static final String KEY = "key";
    private static final String VALUE = "value";
    @Mock
    private MultiValueSingletonDOMElementFactory factory;
    @Mock
    private MultiValueDOMElement multiValueDOMElement;
    @Mock
    private ListBox multiValueWidget;
    @Mock
    private GridCell cell;
    private Map<String, String> enumLookups;

    @Before
    public void setup() {
        this.enumLookups = new HashMap<String, String>();
        Mockito.when((Object)this.multiValueDOMElement.getWidget()).thenReturn((Object)this.multiValueWidget);
    }

    @Test
    public void makeOnCreationCallbackListBoxSingleSelect() {
        this.setupMultipleSelectTest(10, false);
        Callback callback = CallbackFactory.makeOnCreationCallback((MultiValueSingletonDOMElementFactory)this.factory, (GridCell)this.cell, this.enumLookups);
        callback.callback((Object)this.multiValueDOMElement);
        this.verifyMultipleSelectTest(10);
        ((ListBox)Mockito.verify((Object)this.multiValueWidget, (VerificationMode)Mockito.never())).setVisibleItemCount(Mockito.anyInt());
    }

    @Test
    public void makeOnCreationCallbackListBoxMultipleSelect() {
        this.setupMultipleSelectTest(10, true);
        Callback callback = CallbackFactory.makeOnCreationCallback((MultiValueSingletonDOMElementFactory)this.factory, (GridCell)this.cell, this.enumLookups);
        callback.callback((Object)this.multiValueDOMElement);
        this.verifyMultipleSelectTest(10);
        ((ListBox)Mockito.verify((Object)this.multiValueWidget)).setVisibleItemCount(Mockito.eq((int)10));
    }

    @Test
    public void makeOnCreationCallbackListBoxMultipleSelectMoreThanMaximum() {
        this.setupMultipleSelectTest(11, true);
        Callback callback = CallbackFactory.makeOnCreationCallback((MultiValueSingletonDOMElementFactory)this.factory, (GridCell)this.cell, this.enumLookups);
        callback.callback((Object)this.multiValueDOMElement);
        ((ListBox)Mockito.verify((Object)this.multiValueWidget)).setVisibleItemCount(Mockito.eq((int)10));
        this.verifyMultipleSelectTest(11);
    }

    private void setupMultipleSelectTest(int enumLookupSize, boolean isMultipleSelect) {
        IntStream.rangeClosed(1, enumLookupSize).forEach(i -> this.enumLookups.put(KEY + i, VALUE + i));
        Mockito.when((Object)this.multiValueWidget.isMultipleSelect()).thenReturn((Object)isMultipleSelect);
    }

    private void verifyMultipleSelectTest(int enumLookupSize) {
        IntStream.range(1, enumLookupSize).forEach(i -> ((ListBox)Mockito.verify((Object)this.multiValueWidget)).addItem((String)Mockito.eq((Object)(VALUE + i)), (String)Mockito.eq((Object)(KEY + i))));
        ((MultiValueSingletonDOMElementFactory)Mockito.verify((Object)this.factory)).toWidget((GridCell)Mockito.eq((Object)this.cell), (ListBox)Mockito.eq((Object)this.multiValueWidget));
    }
}

