/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.model.converters.column.impl;

import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTablePresenter;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.converters.column.BaseColumnConverter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;

public abstract class BaseActionWorkItemConverterTest {
    protected static final int WIDTH = 200;
    protected static final String HEADER = "header";
    protected static final String WID_NAME = "WID";
    @Mock
    protected GuidedDecisionTableView gridWidget;
    protected GuidedDecisionTablePresenter.Access access = new GuidedDecisionTablePresenter.Access();
    protected BaseColumnConverter converter;

    @Before
    public void setup() {
        this.converter = this.getConverter();
    }

    protected abstract BaseColumnConverter getConverter();

    protected abstract BaseColumn getColumn();

    protected abstract int getExpectedPriority();

    protected abstract String getExpectedColumnGroup();

    @Test
    public void checkPriority() {
        Assert.assertEquals((long)this.getExpectedPriority(), (long)this.converter.priority());
    }

    @Test
    public void checkHandlesSupportedColumn() {
        Assert.assertTrue((boolean)this.converter.handles(this.getColumn()));
    }

    @Test
    public void checkDoesNotHandleUnsupportedColumn() {
        Assert.assertFalse((boolean)this.converter.handles((BaseColumn)Mockito.mock(ConditionCol52.class)));
    }

    @Test
    public void checkConvertColumn() {
        BaseColumn column = this.getColumn();
        GridColumn uiColumn = this.converter.convertColumn(column, this.access, this.gridWidget);
        Assert.assertTrue((boolean)uiColumn.isResizable());
        Assert.assertTrue((boolean)uiColumn.isVisible());
        Assert.assertEquals((double)200.0, (double)uiColumn.getWidth(), (double)0.0);
        Assert.assertEquals((long)2L, (long)uiColumn.getHeaderMetaData().size());
        GridColumn.HeaderMetaData row0 = (GridColumn.HeaderMetaData)uiColumn.getHeaderMetaData().get(0);
        Assert.assertEquals((Object)WID_NAME, (Object)row0.getTitle());
        Assert.assertEquals((Object)ActionCol52.class.getName(), (Object)row0.getColumnGroup());
        GridColumn.HeaderMetaData row1 = (GridColumn.HeaderMetaData)uiColumn.getHeaderMetaData().get(1);
        Assert.assertEquals((Object)HEADER, (Object)row1.getTitle());
        Assert.assertEquals((Object)this.getExpectedColumnGroup(), (Object)row1.getColumnGroup());
    }
}

