/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.model.converters.column.impl;

import java.util.ArrayList;
import java.util.List;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.converters.column.BaseColumnConverter;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.converters.column.impl.ActionInsertFactColumnConverter;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.converters.column.impl.ActionRetractFactColumnConverter;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.converters.column.impl.ActionSetFieldColumnConverter;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.converters.column.impl.ActionWorkItemExecuteColumnConverter;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.converters.column.impl.ActionWorkItemInsertFactColumnConverter;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.converters.column.impl.ActionWorkItemSetFieldColumnConverter;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.converters.column.impl.AttributeColumnConverter;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.converters.column.impl.BRLActionVariableColumnConverter;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.converters.column.impl.BRLConditionVariableColumnConverter;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.converters.column.impl.ConditionColumnConverter;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.converters.column.impl.DescriptionColumnConverter;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.converters.column.impl.LimitedEntryColumnConverter;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.converters.column.impl.MetaDataColumnConverter;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.converters.column.impl.RowNumberColumnConverter;
import org.drools.workbench.screens.guided.dtable.client.widget.table.utilities.ColumnUtilities;
import org.junit.Before;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.mockito.Mock;

public abstract class BaseConverterTest {
    @Mock
    protected GuidedDecisionTableView gridWidget;
    protected GuidedDecisionTableView.Presenter presenter;
    protected GuidedDecisionTable52 model;
    protected AsyncPackageDataModelOracle oracle;
    protected ColumnUtilities columnUtilities;
    private final List<BaseColumnConverter> converters = new ArrayList<BaseColumnConverter>();

    @Before
    public void setup() {
        this.model = this.getModel();
        this.oracle = this.getOracle();
        this.presenter = this.getPresenter();
        this.columnUtilities = new ColumnUtilities(this.model, this.oracle);
        for (BaseColumnConverter bcc : this.getConverters()) {
            bcc.initialise(this.model, this.oracle, this.columnUtilities, this.presenter);
        }
    }

    protected abstract GuidedDecisionTable52 getModel();

    protected abstract AsyncPackageDataModelOracle getOracle();

    protected abstract GuidedDecisionTableView.Presenter getPresenter();

    protected List<BaseColumnConverter> getConverters() {
        if (!this.converters.isEmpty()) {
            return this.converters;
        }
        this.converters.add((BaseColumnConverter)new ActionInsertFactColumnConverter());
        this.converters.add((BaseColumnConverter)new ActionRetractFactColumnConverter());
        this.converters.add((BaseColumnConverter)new ActionSetFieldColumnConverter());
        this.converters.add((BaseColumnConverter)new ActionWorkItemExecuteColumnConverter());
        this.converters.add((BaseColumnConverter)new ActionWorkItemInsertFactColumnConverter());
        this.converters.add((BaseColumnConverter)new ActionWorkItemSetFieldColumnConverter());
        this.converters.add((BaseColumnConverter)new AttributeColumnConverter());
        this.converters.add((BaseColumnConverter)new BRLActionVariableColumnConverter());
        this.converters.add((BaseColumnConverter)new BRLConditionVariableColumnConverter());
        this.converters.add((BaseColumnConverter)new ConditionColumnConverter());
        this.converters.add((BaseColumnConverter)new DescriptionColumnConverter());
        this.converters.add((BaseColumnConverter)new LimitedEntryColumnConverter());
        this.converters.add((BaseColumnConverter)new MetaDataColumnConverter());
        this.converters.add((BaseColumnConverter)new RowNumberColumnConverter());
        return this.converters;
    }
}

