/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.impl;

import java.util.ArrayList;
import java.util.List;
import org.drools.workbench.models.datamodel.workitems.PortableWorkDefinition;
import org.drools.workbench.models.guided.dtable.shared.model.ActionInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.BaseMultipleDOMElementUiColumn;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.BooleanUiColumn;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.StringUiColumn;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.ModelSynchronizer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.impl.BaseSynchronizerTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;

public class ActionWorkItemInsertFactColumnSynchronizerTest
extends BaseSynchronizerTest {
    private static final String WORK_ITEM_NAME = "WorkItemDefinition";

    @Before
    public void setupWorkItemExecution() throws ModelSynchronizer.VetoException {
        ActionWorkItemCol52 column = new ActionWorkItemCol52();
        PortableWorkDefinition pwd = new PortableWorkDefinition();
        pwd.setName(WORK_ITEM_NAME);
        column.setWorkItemDefinition(pwd);
        column.setHeader("wid");
        this.modelSynchronizer.appendColumn((BaseColumn)column);
    }

    @Test
    public void testAppend() throws ModelSynchronizer.VetoException {
        ActionWorkItemInsertFactCol52 column = new ActionWorkItemInsertFactCol52();
        column.setWorkItemName(WORK_ITEM_NAME);
        column.setHeader("col1");
        this.modelSynchronizer.appendColumn((BaseColumn)column);
        Assert.assertEquals((long)2L, (long)this.model.getActionCols().size());
        Assert.assertEquals((long)4L, (long)this.uiModel.getColumns().size());
        Assert.assertTrue((boolean)(this.uiModel.getColumns().get(3) instanceof BooleanUiColumn));
        Assert.assertEquals((Object)true, (Object)((BaseMultipleDOMElementUiColumn)this.uiModel.getColumns().get(3)).isEditable());
    }

    @Test
    public void testAppendMultipleColumns() throws ModelSynchronizer.VetoException {
        ActionWorkItemInsertFactCol52 column1 = new ActionWorkItemInsertFactCol52();
        column1.setWorkItemName(WORK_ITEM_NAME);
        column1.setHeader("col1");
        ActionWorkItemInsertFactCol52 column2 = new ActionWorkItemInsertFactCol52();
        column2.setWorkItemName(WORK_ITEM_NAME);
        column2.setHeader("col2");
        this.modelSynchronizer.appendColumn((BaseColumn)column1);
        this.modelSynchronizer.appendColumn((BaseColumn)column2);
        Assert.assertEquals((long)3L, (long)this.model.getActionCols().size());
        Assert.assertEquals((long)5L, (long)this.uiModel.getColumns().size());
        Assert.assertTrue((boolean)(this.uiModel.getColumns().get(3) instanceof BooleanUiColumn));
        Assert.assertTrue((boolean)(this.uiModel.getColumns().get(4) instanceof BooleanUiColumn));
        Assert.assertEquals((Object)true, (Object)((BaseMultipleDOMElementUiColumn)this.uiModel.getColumns().get(3)).isEditable());
        Assert.assertEquals((Object)true, (Object)((BaseMultipleDOMElementUiColumn)this.uiModel.getColumns().get(4)).isEditable());
        Assert.assertEquals((Object)column1.getHeader(), (Object)((GridColumn.HeaderMetaData)((GridColumn)this.uiModel.getColumns().get(3)).getHeaderMetaData().get(1)).getTitle());
        Assert.assertEquals((Object)column2.getHeader(), (Object)((GridColumn.HeaderMetaData)((GridColumn)this.uiModel.getColumns().get(4)).getHeaderMetaData().get(1)).getTitle());
    }

    @Test
    public void testUpdate() throws ModelSynchronizer.VetoException {
        ActionWorkItemInsertFactCol52 column = (ActionWorkItemInsertFactCol52)Mockito.spy((Object)new ActionWorkItemInsertFactCol52());
        column.setWorkItemName(WORK_ITEM_NAME);
        column.setHeader("col1");
        this.modelSynchronizer.appendColumn((BaseColumn)column);
        ActionWorkItemInsertFactCol52 edited = new ActionWorkItemInsertFactCol52();
        edited.setWorkItemName(WORK_ITEM_NAME);
        edited.setWidth(column.getWidth());
        edited.setHideColumn(true);
        edited.setHeader("updated");
        List diffs = this.modelSynchronizer.updateColumn((BaseColumn)column, (BaseColumn)edited);
        Assert.assertEquals((long)2L, (long)diffs.size());
        ((ActionWorkItemInsertFactCol52)Mockito.verify((Object)column)).diff((BaseColumn)edited);
        Assert.assertEquals((long)2L, (long)this.model.getActionCols().size());
        Assert.assertEquals((long)4L, (long)this.uiModel.getColumns().size());
        Assert.assertTrue((boolean)(this.uiModel.getColumns().get(3) instanceof BooleanUiColumn));
        Assert.assertEquals((Object)"updated", (Object)((GridColumn.HeaderMetaData)((GridColumn)this.uiModel.getColumns().get(3)).getHeaderMetaData().get(1)).getTitle());
        Assert.assertEquals((Object)false, (Object)((GridColumn)this.uiModel.getColumns().get(3)).isVisible());
    }

    @Test
    public void testDelete() throws ModelSynchronizer.VetoException {
        ActionWorkItemInsertFactCol52 column = new ActionWorkItemInsertFactCol52();
        column.setWorkItemName(WORK_ITEM_NAME);
        column.setHeader("col1");
        this.modelSynchronizer.appendColumn((BaseColumn)column);
        Assert.assertEquals((long)2L, (long)this.model.getActionCols().size());
        Assert.assertEquals((long)4L, (long)this.uiModel.getColumns().size());
        this.modelSynchronizer.deleteColumn((BaseColumn)column);
        Assert.assertEquals((long)1L, (long)this.model.getActionCols().size());
        Assert.assertEquals((long)3L, (long)this.uiModel.getColumns().size());
    }

    @Test
    public void testMoveColumnTo_MoveLeft() throws ModelSynchronizer.VetoException {
        ActionWorkItemInsertFactCol52 column1 = new ActionWorkItemInsertFactCol52();
        column1.setWorkItemName(WORK_ITEM_NAME);
        column1.setBoundName("$a");
        column1.setFactType("Applicant");
        column1.setFactField("age");
        column1.setHeader("wid1");
        ActionWorkItemInsertFactCol52 column2 = new ActionWorkItemInsertFactCol52();
        column2.setWorkItemName(WORK_ITEM_NAME);
        column2.setBoundName("$a");
        column2.setFactType("Applicant");
        column2.setFactField("name");
        column2.setHeader("wid2");
        this.modelSynchronizer.appendColumn((BaseColumn)column1);
        this.modelSynchronizer.appendColumn((BaseColumn)column2);
        this.modelSynchronizer.appendRow();
        this.uiModel.setCellValue(0, 3, (GridCellValue)new BaseGridCellValue((Object)true));
        this.uiModel.setCellValue(0, 4, (GridCellValue)new BaseGridCellValue((Object)false));
        Assert.assertEquals((long)3L, (long)this.model.getActionCols().size());
        Assert.assertEquals((Object)column1, this.model.getActionCols().get(1));
        Assert.assertEquals((Object)column2, this.model.getActionCols().get(2));
        Assert.assertEquals((Object)true, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(3)).getBooleanValue());
        Assert.assertEquals((Object)false, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(4)).getBooleanValue());
        Assert.assertEquals((long)5L, (long)this.uiModel.getColumns().size());
        GridColumn uiModelColumn1_1 = (GridColumn)this.uiModel.getColumns().get(3);
        GridColumn uiModelColumn2_1 = (GridColumn)this.uiModel.getColumns().get(4);
        Assert.assertEquals((Object)"wid1", (Object)((GridColumn.HeaderMetaData)uiModelColumn1_1.getHeaderMetaData().get(1)).getTitle());
        Assert.assertEquals((Object)"wid2", (Object)((GridColumn.HeaderMetaData)uiModelColumn2_1.getHeaderMetaData().get(1)).getTitle());
        Assert.assertTrue((boolean)(uiModelColumn1_1 instanceof BooleanUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn2_1 instanceof BooleanUiColumn));
        Assert.assertEquals((long)3L, (long)uiModelColumn1_1.getIndex());
        Assert.assertEquals((long)4L, (long)uiModelColumn2_1.getIndex());
        Assert.assertEquals((Object)true, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn1_1.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)false, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn2_1.getIndex())).getValue().getValue());
        this.uiModel.moveColumnTo(3, uiModelColumn2_1);
        Assert.assertEquals((long)3L, (long)this.model.getActionCols().size());
        Assert.assertEquals((Object)column2, this.model.getActionCols().get(1));
        Assert.assertEquals((Object)column1, this.model.getActionCols().get(2));
        Assert.assertEquals((Object)false, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(3)).getBooleanValue());
        Assert.assertEquals((Object)true, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(4)).getBooleanValue());
        Assert.assertEquals((long)5L, (long)this.uiModel.getColumns().size());
        GridColumn uiModelColumn1_2 = (GridColumn)this.uiModel.getColumns().get(3);
        GridColumn uiModelColumn2_2 = (GridColumn)this.uiModel.getColumns().get(4);
        Assert.assertEquals((Object)"wid2", (Object)((GridColumn.HeaderMetaData)uiModelColumn1_2.getHeaderMetaData().get(1)).getTitle());
        Assert.assertEquals((Object)"wid1", (Object)((GridColumn.HeaderMetaData)uiModelColumn2_2.getHeaderMetaData().get(1)).getTitle());
        Assert.assertTrue((boolean)(uiModelColumn1_2 instanceof BooleanUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn2_2 instanceof BooleanUiColumn));
        Assert.assertEquals((long)4L, (long)uiModelColumn1_2.getIndex());
        Assert.assertEquals((long)3L, (long)uiModelColumn2_2.getIndex());
        Assert.assertEquals((Object)false, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn1_2.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)true, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn2_2.getIndex())).getValue().getValue());
    }

    @Test
    public void testMoveColumnTo_MoveRight() throws ModelSynchronizer.VetoException {
        ActionWorkItemInsertFactCol52 column1 = new ActionWorkItemInsertFactCol52();
        column1.setWorkItemName(WORK_ITEM_NAME);
        column1.setBoundName("$a");
        column1.setFactType("Applicant");
        column1.setFactField("age");
        column1.setHeader("wid1");
        ActionWorkItemInsertFactCol52 column2 = new ActionWorkItemInsertFactCol52();
        column2.setWorkItemName(WORK_ITEM_NAME);
        column2.setBoundName("$a");
        column2.setFactType("Applicant");
        column2.setFactField("name");
        column2.setHeader("wid2");
        this.modelSynchronizer.appendColumn((BaseColumn)column1);
        this.modelSynchronizer.appendColumn((BaseColumn)column2);
        this.modelSynchronizer.appendRow();
        this.uiModel.setCellValue(0, 3, (GridCellValue)new BaseGridCellValue((Object)true));
        this.uiModel.setCellValue(0, 4, (GridCellValue)new BaseGridCellValue((Object)false));
        Assert.assertEquals((long)3L, (long)this.model.getActionCols().size());
        Assert.assertEquals((Object)column1, this.model.getActionCols().get(1));
        Assert.assertEquals((Object)column2, this.model.getActionCols().get(2));
        Assert.assertEquals((Object)true, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(3)).getBooleanValue());
        Assert.assertEquals((Object)false, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(4)).getBooleanValue());
        Assert.assertEquals((long)5L, (long)this.uiModel.getColumns().size());
        GridColumn uiModelColumn1_1 = (GridColumn)this.uiModel.getColumns().get(3);
        GridColumn uiModelColumn2_1 = (GridColumn)this.uiModel.getColumns().get(4);
        Assert.assertEquals((Object)"wid1", (Object)((GridColumn.HeaderMetaData)uiModelColumn1_1.getHeaderMetaData().get(1)).getTitle());
        Assert.assertEquals((Object)"wid2", (Object)((GridColumn.HeaderMetaData)uiModelColumn2_1.getHeaderMetaData().get(1)).getTitle());
        Assert.assertTrue((boolean)(uiModelColumn1_1 instanceof BooleanUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn2_1 instanceof BooleanUiColumn));
        Assert.assertEquals((long)3L, (long)uiModelColumn1_1.getIndex());
        Assert.assertEquals((long)4L, (long)uiModelColumn2_1.getIndex());
        Assert.assertEquals((Object)true, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn1_1.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)false, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn2_1.getIndex())).getValue().getValue());
        this.uiModel.moveColumnTo(4, uiModelColumn1_1);
        Assert.assertEquals((long)3L, (long)this.model.getActionCols().size());
        Assert.assertEquals((Object)column2, this.model.getActionCols().get(1));
        Assert.assertEquals((Object)column1, this.model.getActionCols().get(2));
        Assert.assertEquals((Object)false, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(3)).getBooleanValue());
        Assert.assertEquals((Object)true, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(4)).getBooleanValue());
        Assert.assertEquals((long)5L, (long)this.uiModel.getColumns().size());
        GridColumn uiModelColumn1_2 = (GridColumn)this.uiModel.getColumns().get(3);
        GridColumn uiModelColumn2_2 = (GridColumn)this.uiModel.getColumns().get(4);
        Assert.assertEquals((Object)"wid2", (Object)((GridColumn.HeaderMetaData)uiModelColumn1_2.getHeaderMetaData().get(1)).getTitle());
        Assert.assertEquals((Object)"wid1", (Object)((GridColumn.HeaderMetaData)uiModelColumn2_2.getHeaderMetaData().get(1)).getTitle());
        Assert.assertTrue((boolean)(uiModelColumn1_2 instanceof BooleanUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn2_2 instanceof BooleanUiColumn));
        Assert.assertEquals((long)4L, (long)uiModelColumn1_2.getIndex());
        Assert.assertEquals((long)3L, (long)uiModelColumn2_2.getIndex());
        Assert.assertEquals((Object)false, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn1_2.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)true, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn2_2.getIndex())).getValue().getValue());
    }

    @Test
    public void testMoveColumnTo_OutOfBounds() throws ModelSynchronizer.VetoException {
        ActionWorkItemInsertFactCol52 column1 = new ActionWorkItemInsertFactCol52();
        column1.setWorkItemName(WORK_ITEM_NAME);
        column1.setBoundName("$a");
        column1.setFactType("Applicant");
        column1.setFactField("age");
        column1.setHeader("wid1");
        ActionWorkItemInsertFactCol52 column2 = new ActionWorkItemInsertFactCol52();
        column2.setWorkItemName(WORK_ITEM_NAME);
        column2.setBoundName("$a");
        column2.setFactType("Applicant");
        column2.setFactField("name");
        column2.setHeader("wid2");
        this.modelSynchronizer.appendColumn((BaseColumn)column1);
        this.modelSynchronizer.appendColumn((BaseColumn)column2);
        this.modelSynchronizer.appendRow();
        this.uiModel.setCellValue(0, 3, (GridCellValue)new BaseGridCellValue((Object)true));
        this.uiModel.setCellValue(0, 4, (GridCellValue)new BaseGridCellValue((Object)false));
        Assert.assertEquals((long)3L, (long)this.model.getActionCols().size());
        Assert.assertEquals((Object)column1, this.model.getActionCols().get(1));
        Assert.assertEquals((Object)column2, this.model.getActionCols().get(2));
        Assert.assertEquals((Object)true, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(3)).getBooleanValue());
        Assert.assertEquals((Object)false, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(4)).getBooleanValue());
        Assert.assertEquals((long)5L, (long)this.uiModel.getColumns().size());
        GridColumn uiModelColumn1_1 = (GridColumn)this.uiModel.getColumns().get(3);
        GridColumn uiModelColumn2_1 = (GridColumn)this.uiModel.getColumns().get(4);
        Assert.assertEquals((Object)"wid1", (Object)((GridColumn.HeaderMetaData)uiModelColumn1_1.getHeaderMetaData().get(1)).getTitle());
        Assert.assertEquals((Object)"wid2", (Object)((GridColumn.HeaderMetaData)uiModelColumn2_1.getHeaderMetaData().get(1)).getTitle());
        Assert.assertTrue((boolean)(uiModelColumn1_1 instanceof BooleanUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn2_1 instanceof BooleanUiColumn));
        Assert.assertEquals((long)3L, (long)uiModelColumn1_1.getIndex());
        Assert.assertEquals((long)4L, (long)uiModelColumn2_1.getIndex());
        Assert.assertEquals((Object)true, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn1_1.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)false, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn2_1.getIndex())).getValue().getValue());
        this.uiModel.moveColumnTo(1, uiModelColumn1_1);
        Assert.assertEquals((long)3L, (long)this.model.getActionCols().size());
        Assert.assertEquals((Object)column1, this.model.getActionCols().get(1));
        Assert.assertEquals((Object)column2, this.model.getActionCols().get(2));
        Assert.assertEquals((Object)true, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(3)).getBooleanValue());
        Assert.assertEquals((Object)false, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(4)).getBooleanValue());
        Assert.assertEquals((long)5L, (long)this.uiModel.getColumns().size());
        GridColumn uiModelColumn1_2 = (GridColumn)this.uiModel.getColumns().get(3);
        GridColumn uiModelColumn2_2 = (GridColumn)this.uiModel.getColumns().get(4);
        Assert.assertEquals((Object)"wid1", (Object)((GridColumn.HeaderMetaData)uiModelColumn1_2.getHeaderMetaData().get(1)).getTitle());
        Assert.assertEquals((Object)"wid2", (Object)((GridColumn.HeaderMetaData)uiModelColumn2_2.getHeaderMetaData().get(1)).getTitle());
        Assert.assertTrue((boolean)(uiModelColumn1_2 instanceof BooleanUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn2_2 instanceof BooleanUiColumn));
        Assert.assertEquals((long)3L, (long)uiModelColumn1_2.getIndex());
        Assert.assertEquals((long)4L, (long)uiModelColumn2_2.getIndex());
        Assert.assertEquals((Object)true, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn1_2.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)false, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn2_2.getIndex())).getValue().getValue());
    }

    @Test
    public void testMoveColumnTo_MoveWorkItemInsertFactColRight_WithFollowingInsertFactCol() throws ModelSynchronizer.VetoException {
        ActionWorkItemInsertFactCol52 column1 = new ActionWorkItemInsertFactCol52();
        column1.setWorkItemName(WORK_ITEM_NAME);
        column1.setBoundName("$a");
        column1.setFactType("Applicant");
        column1.setFactField("age");
        column1.setHeader("wid1");
        ActionInsertFactCol52 column2 = new ActionInsertFactCol52();
        column2.setBoundName("$a");
        column2.setFactType("Applicant");
        column2.setFactField("name");
        column2.setHeader("name");
        this.modelSynchronizer.appendColumn((BaseColumn)column1);
        this.modelSynchronizer.appendColumn((BaseColumn)column2);
        this.modelSynchronizer.appendRow();
        this.uiModel.setCellValue(0, 3, (GridCellValue)new BaseGridCellValue((Object)true));
        this.uiModel.setCellValue(0, 4, (GridCellValue)new BaseGridCellValue((Object)"Fred"));
        this.assertGridDefinitionMovingWorkItemInsertFactColAndInsertFactCol(column1, column2);
        final GridColumn uiModelColumn1 = (GridColumn)this.uiModel.getColumns().get(2);
        final GridColumn uiModelColumn2 = (GridColumn)this.uiModel.getColumns().get(3);
        this.uiModel.moveColumnsTo(4, (List)new ArrayList<GridColumn<?>>(){
            {
                this.add(uiModelColumn1);
                this.add(uiModelColumn2);
            }
        });
        this.assertGridDefinitionMovingWorkItemInsertFactColAndInsertFactCol(column1, column2);
    }

    @Test
    public void testMoveColumnTo_MoveInsertFactColLeft_WithPrecedingWorkItemInsertFactCol() throws ModelSynchronizer.VetoException {
        ActionWorkItemInsertFactCol52 column1 = new ActionWorkItemInsertFactCol52();
        column1.setWorkItemName(WORK_ITEM_NAME);
        column1.setBoundName("$a");
        column1.setFactType("Applicant");
        column1.setFactField("age");
        column1.setHeader("wid1");
        ActionInsertFactCol52 column2 = new ActionInsertFactCol52();
        column2.setBoundName("$a");
        column2.setFactType("Applicant");
        column2.setFactField("name");
        column2.setHeader("name");
        this.modelSynchronizer.appendColumn((BaseColumn)column1);
        this.modelSynchronizer.appendColumn((BaseColumn)column2);
        this.modelSynchronizer.appendRow();
        this.uiModel.setCellValue(0, 3, (GridCellValue)new BaseGridCellValue((Object)true));
        this.uiModel.setCellValue(0, 4, (GridCellValue)new BaseGridCellValue((Object)"Fred"));
        this.assertGridDefinitionMovingWorkItemInsertFactColAndInsertFactCol(column1, column2);
        GridColumn uiModelColumn1 = (GridColumn)this.uiModel.getColumns().get(4);
        this.uiModel.moveColumnTo(2, uiModelColumn1);
        this.assertGridDefinitionMovingWorkItemInsertFactColAndInsertFactCol(column1, column2);
    }

    private void assertGridDefinitionMovingWorkItemInsertFactColAndInsertFactCol(ActionWorkItemInsertFactCol52 column1, ActionInsertFactCol52 column2) {
        Assert.assertEquals((long)3L, (long)this.model.getActionCols().size());
        Assert.assertEquals((Object)column1, this.model.getActionCols().get(1));
        Assert.assertEquals((Object)column2, this.model.getActionCols().get(2));
        Assert.assertEquals((Object)true, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(3)).getBooleanValue());
        Assert.assertEquals((Object)"Fred", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(4)).getStringValue());
        Assert.assertEquals((long)5L, (long)this.uiModel.getColumns().size());
        GridColumn uiModelColumn1_1 = (GridColumn)this.uiModel.getColumns().get(3);
        GridColumn uiModelColumn2_1 = (GridColumn)this.uiModel.getColumns().get(4);
        Assert.assertEquals((Object)"wid1", (Object)((GridColumn.HeaderMetaData)uiModelColumn1_1.getHeaderMetaData().get(1)).getTitle());
        Assert.assertEquals((Object)"name", (Object)((GridColumn.HeaderMetaData)uiModelColumn2_1.getHeaderMetaData().get(1)).getTitle());
        Assert.assertTrue((boolean)(uiModelColumn1_1 instanceof BooleanUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn2_1 instanceof StringUiColumn));
        Assert.assertEquals((long)3L, (long)uiModelColumn1_1.getIndex());
        Assert.assertEquals((long)4L, (long)uiModelColumn2_1.getIndex());
        Assert.assertEquals((Object)true, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn1_1.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"Fred", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn2_1.getIndex())).getValue().getValue());
    }
}

