/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.popovers.definitions;

import java.util.ArrayList;
import javax.enterprise.inject.Instance;
import org.drools.workbench.models.guided.dtable.shared.model.ActionInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionRetractFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.models.guided.dtable.shared.model.RowNumberCol52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.popovers.MockInstanceImpl;
import org.drools.workbench.screens.guided.dtable.client.widget.table.popovers.definitions.ActionInsertFactCol52DefinitionBuilder;
import org.drools.workbench.screens.guided.dtable.client.widget.table.popovers.definitions.ActionRetractFactCol52DefinitionBuilder;
import org.drools.workbench.screens.guided.dtable.client.widget.table.popovers.definitions.ActionSetFieldCol52DefinitionBuilder;
import org.drools.workbench.screens.guided.dtable.client.widget.table.popovers.definitions.ColumnDefinitionBuilder;
import org.drools.workbench.screens.guided.dtable.client.widget.table.popovers.definitions.ColumnDefinitionFactory;
import org.drools.workbench.screens.guided.dtable.client.widget.table.popovers.definitions.ConditionCol52DefinitionBuilder;
import org.drools.workbench.screens.guided.dtable.service.GuidedDecisionTableEditorService;
import org.jboss.errai.common.client.api.Caller;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.mocks.CallerMock;

@RunWith(value=MockitoJUnitRunner.class)
public class ColumnDefinitionFactoryTest {
    @Mock
    private GuidedDecisionTableEditorService service;
    private Caller<GuidedDecisionTableEditorService> serviceCaller;
    @Mock
    private GuidedDecisionTableView.Presenter dtPresenter;
    private GuidedDecisionTable52 model;
    @Mock
    private AsyncPackageDataModelOracle dmo;
    private ColumnDefinitionBuilder conditionCol52DefinitionBuilder;
    private ColumnDefinitionBuilder actionInsertFactCol52DefinitionBuilder;
    private ColumnDefinitionBuilder actionSetFieldCol52DefinitionBuilder;
    private ColumnDefinitionBuilder actionRetractFactCol52DefinitionBuilder;
    private ColumnDefinitionFactory columnDefinitionFactory;

    @Before
    public void setup() {
        this.model = new GuidedDecisionTable52();
        this.serviceCaller = new CallerMock((Object)this.service);
        this.conditionCol52DefinitionBuilder = (ColumnDefinitionBuilder)Mockito.spy((Object)new ConditionCol52DefinitionBuilder(this.serviceCaller));
        this.actionInsertFactCol52DefinitionBuilder = (ColumnDefinitionBuilder)Mockito.spy((Object)new ActionInsertFactCol52DefinitionBuilder(this.serviceCaller));
        this.actionSetFieldCol52DefinitionBuilder = (ColumnDefinitionBuilder)Mockito.spy((Object)new ActionSetFieldCol52DefinitionBuilder(this.serviceCaller));
        this.actionRetractFactCol52DefinitionBuilder = (ColumnDefinitionBuilder)Mockito.spy((Object)new ActionRetractFactCol52DefinitionBuilder(this.serviceCaller));
        Mockito.when((Object)this.dtPresenter.getModel()).thenReturn((Object)this.model);
        Mockito.when((Object)this.dtPresenter.getDataModelOracle()).thenReturn((Object)this.dmo);
        Mockito.when((Object)this.service.toSource((Path)Matchers.any(Path.class), Matchers.any(GuidedDecisionTable52.class))).thenReturn((Object)"source");
        Mockito.when((Object)this.dmo.getFieldType((String)Matchers.any(String.class), (String)Matchers.any(String.class))).thenReturn((Object)"String");
        Instance<ColumnDefinitionBuilder> buildersInstance = this.makeBuildersInstance();
        this.columnDefinitionFactory = new ColumnDefinitionFactory(buildersInstance);
    }

    @Test
    public void unknownColumnTypeDoesNotTriggerBuilder() {
        Callback callback = (Callback)Mockito.mock(Callback.class);
        this.columnDefinitionFactory.generateColumnDefinition(this.dtPresenter, (BaseColumn)new RowNumberCol52(), callback);
        ((Callback)Mockito.verify((Object)callback, (VerificationMode)Mockito.never())).callback(Matchers.any(String.class));
    }

    @Test
    public void knownColumnType_ConditionCol52() {
        Pattern52 p = new Pattern52();
        ConditionCol52 column = new ConditionCol52();
        p.getChildColumns().add(column);
        this.model.getConditions().add(p);
        Callback callback = (Callback)Mockito.mock(Callback.class);
        this.columnDefinitionFactory.generateColumnDefinition(this.dtPresenter, (BaseColumn)column, callback);
        ((ColumnDefinitionBuilder)Mockito.verify((Object)this.conditionCol52DefinitionBuilder, (VerificationMode)Mockito.times((int)1))).generateDefinition((GuidedDecisionTableView.Presenter)Mockito.eq((Object)this.dtPresenter), (BaseColumn)Mockito.eq((Object)column), (Callback)Matchers.any(Callback.class));
        ((Callback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).callback(Matchers.any(String.class));
    }

    @Test
    public void knownColumnType_ActionInsertFactCol52() {
        ActionInsertFactCol52 column = new ActionInsertFactCol52();
        Callback callback = (Callback)Mockito.mock(Callback.class);
        this.columnDefinitionFactory.generateColumnDefinition(this.dtPresenter, (BaseColumn)column, callback);
        ((ColumnDefinitionBuilder)Mockito.verify((Object)this.actionInsertFactCol52DefinitionBuilder, (VerificationMode)Mockito.times((int)1))).generateDefinition((GuidedDecisionTableView.Presenter)Mockito.eq((Object)this.dtPresenter), (BaseColumn)Mockito.eq((Object)column), (Callback)Matchers.any(Callback.class));
        ((Callback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).callback(Matchers.any(String.class));
    }

    @Test
    public void knownColumnType_ActionSetFieldCol52() {
        ActionSetFieldCol52 column = new ActionSetFieldCol52();
        Callback callback = (Callback)Mockito.mock(Callback.class);
        this.columnDefinitionFactory.generateColumnDefinition(this.dtPresenter, (BaseColumn)column, callback);
        ((ColumnDefinitionBuilder)Mockito.verify((Object)this.actionSetFieldCol52DefinitionBuilder, (VerificationMode)Mockito.times((int)1))).generateDefinition((GuidedDecisionTableView.Presenter)Mockito.eq((Object)this.dtPresenter), (BaseColumn)Mockito.eq((Object)column), (Callback)Matchers.any(Callback.class));
        ((Callback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).callback(Matchers.any(String.class));
    }

    @Test
    public void knownColumnType_ActionRetractFactCol52() {
        ActionRetractFactCol52 column = new ActionRetractFactCol52();
        Callback callback = (Callback)Mockito.mock(Callback.class);
        this.columnDefinitionFactory.generateColumnDefinition(this.dtPresenter, (BaseColumn)column, callback);
        ((ColumnDefinitionBuilder)Mockito.verify((Object)this.actionRetractFactCol52DefinitionBuilder, (VerificationMode)Mockito.times((int)1))).generateDefinition((GuidedDecisionTableView.Presenter)Mockito.eq((Object)this.dtPresenter), (BaseColumn)Mockito.eq((Object)column), (Callback)Matchers.any(Callback.class));
        ((Callback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).callback(Matchers.any(String.class));
    }

    private Instance<ColumnDefinitionBuilder> makeBuildersInstance() {
        ArrayList<ColumnDefinitionBuilder> builders = new ArrayList<ColumnDefinitionBuilder>();
        builders.add(this.conditionCol52DefinitionBuilder);
        builders.add(this.actionInsertFactCol52DefinitionBuilder);
        builders.add(this.actionSetFieldCol52DefinitionBuilder);
        builders.add(this.actionRetractFactCol52DefinitionBuilder);
        return new MockInstanceImpl<ColumnDefinitionBuilder>(builders);
    }
}

