/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.themes;

import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.GuidedDecisionTableUiModel;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.ModelSynchronizer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.themes.GuidedDecisionTableRenderer;
import org.drools.workbench.services.verifier.api.client.reporting.Severity;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.grid.columns.RowNumberColumn;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;

@RunWith(value=LienzoMockitoTestRunner.class)
public class GuidedDecisionTableRendererTest {
    @Mock
    private ModelSynchronizer synchronizer;
    @Mock
    private GridBodyRenderContext context;
    @Mock
    private BaseGridRendererHelper rendererHelper;
    @Mock
    private BaseGridRendererHelper.RenderingInformation renderingInformation;
    @Mock
    private BaseGridRendererHelper.RenderingBlockInformation bodyBlockInformation;
    @Mock
    private BaseGridRendererHelper.RenderingBlockInformation floatingBlockInformation;
    @Mock
    private Group parent;
    private GuidedDecisionTableUiModel uiModel;
    private GridColumn<?> uiColumn;
    private GuidedDecisionTableRenderer renderer;

    @Before
    public void setup() {
        this.uiModel = new GuidedDecisionTableUiModel(this.synchronizer);
        this.uiColumn = new RowNumberColumn();
        this.uiModel.appendColumn(this.uiColumn);
        this.uiModel.appendRow((GridRow)new BaseGridRow());
        this.renderer = new GuidedDecisionTableRenderer(this.uiModel, new GuidedDecisionTable52());
        ((BaseGridRendererHelper.RenderingInformation)Mockito.doReturn((Object)new ArrayList<Double>(){
            {
                this.add(20.0);
            }
        }).when((Object)this.renderingInformation)).getVisibleRowOffsets();
        ((GridBodyRenderContext)Mockito.doReturn((Object)new ArrayList<GridColumn<?>>(){
            {
                this.add(GuidedDecisionTableRendererTest.this.uiColumn);
            }
        }).when((Object)this.context)).getBlockColumns();
        ((BaseGridRendererHelper.RenderingInformation)Mockito.doReturn((Object)this.bodyBlockInformation).when((Object)this.renderingInformation)).getBodyBlockInformation();
        ((BaseGridRendererHelper.RenderingBlockInformation)Mockito.doReturn((Object)new ArrayList<GridColumn<?>>(){
            {
                this.add(GuidedDecisionTableRendererTest.this.uiColumn);
            }
        }).when((Object)this.bodyBlockInformation)).getColumns();
        ((BaseGridRendererHelper.RenderingInformation)Mockito.doReturn((Object)this.floatingBlockInformation).when((Object)this.renderingInformation)).getFloatingBlockInformation();
        ((BaseGridRendererHelper.RenderingBlockInformation)Mockito.doReturn(Collections.emptyList()).when((Object)this.floatingBlockInformation)).getColumns();
        ((GridBodyRenderContext)Mockito.doReturn((Object)this.renderer).when((Object)this.context)).getRenderer();
    }

    @Test
    public void testRenderBodyWithRowHighlights() {
        this.renderer.highlightRows(Severity.ERROR, Collections.singleton(1));
        List commands = this.renderer.renderBody((GridData)this.uiModel, this.context, this.rendererHelper, this.renderingInformation);
        this.assertRenderingCommands(commands, GridRenderer.RenderBodyGridBackgroundCommand.class, GridRenderer.RenderBodyGridLinesCommand.class, GridRenderer.RenderBodyGridContentCommand.class, GridRenderer.RenderSelectedCellsCommand.class);
    }

    @Test
    public void testRenderBodyWithNoRowHighlights() {
        this.renderer.clearHighlights();
        List commands = this.renderer.renderBody((GridData)this.uiModel, this.context, this.rendererHelper, this.renderingInformation);
        this.assertRenderingCommands(commands, GridRenderer.RenderBodyGridBackgroundCommand.class, GridRenderer.RenderBodyGridLinesCommand.class, GridRenderer.RenderBodyGridContentCommand.class);
    }

    @Test
    public void testRenderSelector() {
        GridRenderer.RendererCommand command = this.renderer.renderSelector(10.0, 20.0, this.renderingInformation);
        this.assertRenderingCommands(Collections.singletonList(command), GridRenderer.RenderSelectorCommand.class);
    }

    @Test
    public void testRenderSelectorIsSelectionLayer() {
        GridRenderer.RendererCommand command = this.renderer.renderSelector(10.0, 20.0, this.renderingInformation);
        command.execute((Object)this.makeGridRendererContext(true));
        ((Group)Mockito.verify((Object)this.parent, (VerificationMode)Mockito.never())).add((IPrimitive)Matchers.any(Group.class));
    }

    @Test
    public void testRenderSelectorIsNotSelectionLayer() {
        GridRenderer.RendererCommand command = this.renderer.renderSelector(10.0, 20.0, this.renderingInformation);
        command.execute((Object)this.makeGridRendererContext(false));
        ((Group)Mockito.verify((Object)this.parent)).add((IPrimitive)Matchers.any(Group.class));
    }

    private GridRenderer.GridRendererContext makeGridRendererContext(final boolean isSelectionLayer) {
        return new GridRenderer.GridRendererContext(){

            public Group getGroup() {
                return GuidedDecisionTableRendererTest.this.parent;
            }

            public boolean isSelectionLayer() {
                return isSelectionLayer;
            }
        };
    }

    @Test
    public void testRenderHeaderBodyDivider() {
        GridRenderer.RendererCommand command = this.renderer.renderHeaderBodyDivider(10.0);
        this.assertRenderingCommands(Collections.singletonList(command), GridRenderer.RenderHeaderGridLinesCommand.class);
    }

    @SafeVarargs
    private final void assertRenderingCommands(List<GridRenderer.RendererCommand> actualCommands, Class<? extends GridRenderer.RendererCommand> ... expectedTypes) {
        Assertions.assertThat(actualCommands).hasOnlyElementsOfTypes((Class[])expectedTypes);
        Arrays.asList(expectedTypes).forEach(type -> {
            AbstractListAssert cfr_ignored_0 = (AbstractListAssert)Assertions.assertThat((List)actualCommands).filteredOn(type::isInstance).hasSize(1);
        });
    }
}

