/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.utilities;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.drools.workbench.models.guided.dtable.shared.model.ActionInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.resources.GuidedDecisionTableResources;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.control.ColumnLabelWidget;
import org.drools.workbench.screens.guided.dtable.client.widget.table.utilities.ColumnUtilities;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.project.datamodel.oracle.DataType;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class ColumnUtilitiesTest {
    private static final String FACT_TYPE = "MyFactType";
    private static final String FIELD_NAME = "myField";
    @Mock
    private GuidedDecisionTable52 model;
    @Mock
    private AsyncPackageDataModelOracle oracle;
    private Pattern52 pattern;
    private ConditionCol52 column;
    private ColumnUtilities utilities;

    @Before
    public void setUp() {
        this.utilities = new ColumnUtilities(this.model, this.oracle);
        this.pattern = new Pattern52();
        this.column = new ConditionCol52();
        Mockito.when((Object)this.model.getPattern(this.column)).thenReturn((Object)this.pattern);
    }

    @Test
    public void getTypeSafeType_operatorIn() {
        this.column.setOperator("in");
        this.check();
    }

    @Test
    public void getTypeSafeType_operatorNotIn() {
        this.column.setOperator("not in");
        this.check();
    }

    @Test
    public void unknownDataTypeDefaultsToString() {
        Assert.assertEquals((Object)"String", (Object)this.utilities.getType((BaseColumn)this.column));
    }

    @Test
    public void knownDataTypeWithoutOperator() {
        this.pattern.setFactType(FACT_TYPE);
        this.column.setFactField(FIELD_NAME);
        this.column.setOperator(null);
        Assert.assertEquals((Object)"String", (Object)this.utilities.getType((BaseColumn)this.column));
    }

    @Test
    public void knownDataTypeWithOperator() {
        this.pattern.setFactType(FACT_TYPE);
        this.column.setFactField(FIELD_NAME);
        this.column.setOperator("==");
        Mockito.when((Object)this.oracle.getFieldType((String)Mockito.eq((Object)FACT_TYPE), (String)Mockito.eq((Object)FIELD_NAME))).thenReturn((Object)"Integer");
        Assert.assertEquals((Object)"Integer", (Object)this.utilities.getType((BaseColumn)this.column));
    }

    @Test
    public void testCanAcceptOtherwisePredicate() throws Exception {
        this.column.setConstraintValueType(5);
        Assert.assertFalse((boolean)ColumnUtilities.canAcceptOtherwiseValues((BaseColumn)this.column));
    }

    @Test
    public void testCanAcceptOtherwiseEqual() throws Exception {
        this.column.setConstraintValueType(1);
        this.column.setOperator("==");
        Assert.assertTrue((boolean)ColumnUtilities.canAcceptOtherwiseValues((BaseColumn)this.column));
    }

    @Test
    public void testCanAcceptOtherwiseNotEqual() throws Exception {
        this.column.setConstraintValueType(1);
        this.column.setOperator("!=");
        Assert.assertTrue((boolean)ColumnUtilities.canAcceptOtherwiseValues((BaseColumn)this.column));
    }

    @Test
    public void testCanAcceptOtherwiseWrongOperator() throws Exception {
        this.column.setConstraintValueType(1);
        this.column.setOperator("<");
        Assert.assertFalse((boolean)ColumnUtilities.canAcceptOtherwiseValues((BaseColumn)this.column));
    }

    @Test
    public void testGetValueConditionColumn() throws Exception {
        this.column.setFactField(FIELD_NAME);
        this.column.setFieldType("Integer");
        this.column.setValueList("a,1,1.1, ,-1, 123,456 , -789 ");
        Object[] valueList = this.utilities.getValueList((BaseColumn)this.column);
        Assertions.assertThat((Object[])valueList).containsExactly((Object[])new String[]{"1", "-1", "123", "456", "-789"});
    }

    @Test
    public void testGetValueSetFieldColumn() throws Exception {
        this.pattern.setFactType(FACT_TYPE);
        this.pattern.setBoundName("$a");
        Mockito.when((Object)this.model.getConditions()).thenReturn(Arrays.asList(this.pattern));
        ActionSetFieldCol52 column = new ActionSetFieldCol52();
        column.setFactField(FIELD_NAME);
        column.setBoundName("$a");
        column.setValueList("a,1,1.1, ,-1, 123,456 , -789 ");
        Mockito.when((Object)this.oracle.getFieldType(FACT_TYPE, FIELD_NAME)).thenReturn((Object)"Integer");
        Object[] valueList = this.utilities.getValueList((BaseColumn)column);
        Assertions.assertThat((Object[])valueList).containsExactly((Object[])new String[]{"1", "-1", "123", "456", "-789"});
    }

    @Test
    public void testGetValueInsertFactColumn() throws Exception {
        ActionInsertFactCol52 column = new ActionInsertFactCol52();
        column.setFactField(FIELD_NAME);
        column.setFactType(FACT_TYPE);
        column.setValueList("a,1,1.1, ,-1, 123,456 , -789 ");
        Mockito.when((Object)this.oracle.getFieldType(FACT_TYPE, FIELD_NAME)).thenReturn((Object)"Integer");
        Object[] valueList = this.utilities.getValueList((BaseColumn)column);
        Assertions.assertThat((Object[])valueList).containsExactly((Object[])new String[]{"1", "-1", "123", "456", "-789"});
    }

    @Test
    public void testSetColumnLabelStyleWhenHiddenPositive() throws Exception {
        ColumnLabelWidget label = (ColumnLabelWidget)Mockito.mock(ColumnLabelWidget.class);
        ColumnUtilities.setColumnLabelStyleWhenHidden((ColumnLabelWidget)label, (boolean)true);
        ((ColumnLabelWidget)Mockito.verify((Object)label)).addStyleName(GuidedDecisionTableResources.INSTANCE.css().columnLabelHidden());
    }

    @Test
    public void testSetColumnLabelStyleWhenHiddenNegative() throws Exception {
        ColumnLabelWidget label = (ColumnLabelWidget)Mockito.mock(ColumnLabelWidget.class);
        ColumnUtilities.setColumnLabelStyleWhenHidden((ColumnLabelWidget)label, (boolean)false);
        ((ColumnLabelWidget)Mockito.verify((Object)label)).removeStyleName(GuidedDecisionTableResources.INSTANCE.css().columnLabelHidden());
    }

    private void check() {
        Assert.assertEquals((Object)DataType.DataTypes.STRING, (Object)this.utilities.getTypeSafeType(this.pattern, this.column));
        Assert.assertEquals((Object)DataType.DataTypes.STRING, (Object)this.utilities.getTypeSafeType((BaseColumn)this.column));
        Assert.assertEquals((Object)"String", (Object)this.utilities.getType((BaseColumn)this.column));
        ((AsyncPackageDataModelOracle)Mockito.verify((Object)this.oracle, (VerificationMode)Mockito.never())).getFieldType(Matchers.anyString(), Matchers.anyString());
    }
}

