/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.pages;

import com.google.gwt.junit.GWTMockUtilities;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTColumnConfig52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.NewGuidedDecisionTableColumnWizard;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.AdditionalInfoPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.ConditionColumnPlugin;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class AdditionalInfoPageTest {
    private static final String ENTER_COLUMN_DESCRIPTION = "EnterColumnDescription";
    private static final String PICK_ANOTHER = "PickAnother";
    @Mock
    NewGuidedDecisionTableColumnWizard wizard;
    @Mock
    private ConditionColumnPlugin plugin;
    @Mock
    private ConditionCol52 editingCol;
    @Mock
    private AdditionalInfoPage.View view;
    @Mock
    private SimplePanel content;
    @Mock
    private TranslationService translationService;
    @Mock
    private GuidedDecisionTableView.Presenter presenter;
    private GuidedDecisionTable52 model;
    @InjectMocks
    private AdditionalInfoPage<ConditionColumnPlugin> page;

    public AdditionalInfoPageTest() {
        this.page = (AdditionalInfoPage)Mockito.spy((Object)new AdditionalInfoPage(this.view, this.translationService));
    }

    @BeforeClass
    public static void setupPreferences() {
        HashMap<String, String> preferences = new HashMap<String, String>(){
            {
                this.put("drools.dateformat", "dd/mm/yyyy");
            }
        };
        ApplicationPreferences.setUp((Map)preferences);
        GWTMockUtilities.disarm();
    }

    @Before
    public void setup() {
        Mockito.when((Object)this.page.plugin()).thenReturn((Object)this.plugin);
        this.model = new GuidedDecisionTable52();
        Mockito.when((Object)this.plugin.getPresenter()).thenReturn((Object)this.presenter);
        Mockito.when((Object)this.translationService.format("YouMustEnterAColumnHeaderValueDescription", new Object[0])).thenReturn((Object)ENTER_COLUMN_DESCRIPTION);
        Mockito.when((Object)this.translationService.format("ThatColumnNameIsAlreadyInUsePleasePickAnother", new Object[0])).thenReturn((Object)PICK_ANOTHER);
    }

    private void createEmptyModel() {
        Mockito.when((Object)this.presenter.getModel()).thenReturn((Object)this.model);
        Mockito.when((Object)this.wizard.getPresenter()).thenReturn((Object)this.presenter);
        ((AdditionalInfoPage)Mockito.doCallRealMethod().when(this.page)).init((NewGuidedDecisionTableColumnWizard)Mockito.any());
        ((AdditionalInfoPage)Mockito.doNothing().when(this.page)).initialise();
        this.page.init(this.wizard);
    }

    @Test
    public void testIsCompleteWhenHeaderIsNotEnabled() throws Exception {
        this.createEmptyModel();
        this.page.isComplete(Assert::assertFalse);
        ((AdditionalInfoPage.View)Mockito.verify((Object)this.view)).showWarning(ENTER_COLUMN_DESCRIPTION);
    }

    @Test
    public void testIsCompleteWhenHeaderIsEnabledButNotCompleted() throws Exception {
        this.createEmptyModel();
        Mockito.when((Object)this.plugin.editingCol()).thenReturn(Mockito.mock(ConditionCol52.class));
        this.page.enableHeader();
        this.page.isComplete(Assert::assertFalse);
        ((AdditionalInfoPage.View)Mockito.verify((Object)this.view)).showWarning(ENTER_COLUMN_DESCRIPTION);
    }

    @Test
    public void testIsCompleteWhenHeaderIsEnabledAndCompleted() throws Exception {
        this.createEmptyModel();
        Mockito.when((Object)this.plugin.getHeader()).thenReturn((Object)"header");
        this.page.enableHeader();
        this.page.isComplete(Assert::assertTrue);
        ((AdditionalInfoPage.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showWarning(ENTER_COLUMN_DESCRIPTION);
        ((AdditionalInfoPage.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showWarning(PICK_ANOTHER);
        ((AdditionalInfoPage.View)Mockito.verify((Object)this.view)).hideWarning();
    }

    @Test
    public void testNonUniqueColumn() throws Exception {
        this.createEmptyModel();
        Pattern52 parentCondition = new Pattern52();
        ConditionCol52 condition = new ConditionCol52();
        condition.setHeader("header");
        parentCondition.getChildColumns().add(condition);
        this.model.getConditions().add(parentCondition);
        Mockito.when((Object)this.plugin.getHeader()).thenReturn((Object)"header");
        Mockito.when((Object)this.plugin.isNewColumn()).thenReturn((Object)true);
        ((ConditionColumnPlugin)Mockito.doCallRealMethod().when((Object)this.plugin)).getAlreadyUsedColumnHeaders();
        this.page.enableHeader();
        this.page.isComplete(Assert::assertFalse);
        ((AdditionalInfoPage.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showWarning(ENTER_COLUMN_DESCRIPTION);
        ((AdditionalInfoPage.View)Mockito.verify((Object)this.view)).showWarning(PICK_ANOTHER);
    }

    @Test
    public void testGetHeader() throws Exception {
        this.page.getHeader();
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).getHeader();
    }

    @Test
    public void testSetHeader() throws Exception {
        this.page.setHeader("header");
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).setHeader((String)Mockito.eq((Object)"header"));
    }

    @Test
    public void testSetupHeaderWhenItIsEnabled() throws Exception {
        this.page.enableHeader();
        this.page.setupHeader();
        ((AdditionalInfoPage.View)Mockito.verify((Object)this.view)).showHeader();
    }

    @Test
    public void testSetupHeaderWhenItIsNotEnabled() throws Exception {
        this.page.setupHeader();
        ((AdditionalInfoPage.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showHeader();
    }

    @Test
    public void testSetupHideColumnWhenItIsEnabled() throws Exception {
        Mockito.when((Object)this.plugin.editingCol()).thenReturn((Object)this.editingCol);
        this.page.enableHideColumn();
        this.page.setupHideColumn();
        ((AdditionalInfoPage.View)Mockito.verify((Object)this.view)).showHideColumn(((Boolean)Mockito.any(Boolean.class)).booleanValue());
    }

    @Test
    public void testSetupHideColumnWhenItIsNotEnabled() throws Exception {
        this.page.setupHideColumn();
        ((AdditionalInfoPage.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showHideColumn(((Boolean)Mockito.any(Boolean.class)).booleanValue());
    }

    @Test
    public void testSetupLogicallyInsertWhenItIsEnabledAndItShouldBeShown() throws Exception {
        Mockito.when((Object)this.plugin.showLogicallyInsert()).thenReturn((Object)true);
        this.page.enableLogicallyInsert();
        this.page.setupLogicallyInsert();
        ((AdditionalInfoPage.View)Mockito.verify((Object)this.view)).showLogicallyInsert(false);
    }

    @Test
    public void testSetupLogicallyInsertWhenItIsEnabledAndItShouldNotBeShown() throws Exception {
        Mockito.when((Object)this.plugin.showLogicallyInsert()).thenReturn((Object)false);
        this.page.enableLogicallyInsert();
        this.page.setupLogicallyInsert();
        ((AdditionalInfoPage.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showLogicallyInsert(false);
    }

    @Test
    public void testSetupLogicallyInsertWhenItIsNotEnabled() throws Exception {
        this.page.setupLogicallyInsert();
        ((AdditionalInfoPage.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showLogicallyInsert(false);
    }

    @Test
    public void testSetupUpdateEngineWithChangesWhenItIsEnabledAndItShouldBeShown() throws Exception {
        Mockito.when((Object)this.plugin.showUpdateEngineWithChanges()).thenReturn((Object)true);
        this.page.enableUpdateEngineWithChanges();
        this.page.setupUpdateEngineWithChanges();
        ((AdditionalInfoPage.View)Mockito.verify((Object)this.view)).showUpdateEngineWithChanges(false);
    }

    @Test
    public void testSetupUpdateEngineWithChangesWhenItIsEnabledAndItShouldNotBeShown() throws Exception {
        Mockito.when((Object)this.plugin.showUpdateEngineWithChanges()).thenReturn((Object)false);
        this.page.enableUpdateEngineWithChanges();
        this.page.setupUpdateEngineWithChanges();
        ((AdditionalInfoPage.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showUpdateEngineWithChanges(false);
    }

    @Test
    public void testSetupUpdateEngineWithChangesWhenItIsNotEnabled() throws Exception {
        this.page.setupUpdateEngineWithChanges();
        ((AdditionalInfoPage.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showUpdateEngineWithChanges(false);
    }

    @Test
    public void testSetInsertLogical() throws Exception {
        Boolean value = Boolean.TRUE;
        this.page.setInsertLogical(value);
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).setInsertLogical(value);
    }

    @Test
    public void testUpdate() throws Exception {
        Boolean value = Boolean.TRUE;
        this.page.setUpdate(value);
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).setUpdate(value);
    }

    @Test
    public void testGetTitle() throws Exception {
        String errorKey = "AdditionalInfoPage.AdditionalInfo";
        String errorMessage = "Title";
        Mockito.when((Object)this.translationService.format("AdditionalInfoPage.AdditionalInfo", new Object[0])).thenReturn((Object)"Title");
        String title = this.page.getTitle();
        Assert.assertEquals((Object)"Title", (Object)title);
    }

    @Test
    public void testPrepareView() throws Exception {
        this.page.prepareView();
        ((AdditionalInfoPage.View)Mockito.verify((Object)this.view)).init(this.page);
    }

    @Test
    public void testAsWidget() {
        Widget contentWidget = this.page.asWidget();
        Assert.assertEquals((Object)contentWidget, (Object)this.content);
    }

    @Test
    public void testIsHeaderUniqueWhenColumnIsNewAndHeaderIsUnique() {
        HashSet<String> headers = this.set("header1", "header2");
        Mockito.when((Object)this.plugin.getOriginalColumnConfig52()).thenReturn(null);
        Mockito.when((Object)this.plugin.isNewColumn()).thenReturn((Object)true);
        Mockito.when((Object)this.plugin.getAlreadyUsedColumnHeaders()).thenReturn(headers);
        Mockito.when((Object)this.page.getHeader()).thenReturn((Object)"header3");
        Assert.assertTrue((boolean)this.page.isHeaderUnique());
    }

    @Test
    public void testIsHeaderUniqueWhenColumnIsNewAndHeaderIsNotUnique() {
        HashSet<String> headers = this.set("header1", "header2");
        Mockito.when((Object)this.plugin.getOriginalColumnConfig52()).thenReturn(null);
        Mockito.when((Object)this.plugin.isNewColumn()).thenReturn((Object)true);
        Mockito.when((Object)this.plugin.getAlreadyUsedColumnHeaders()).thenReturn(headers);
        Mockito.when((Object)this.page.getHeader()).thenReturn((Object)"header2");
        Assert.assertFalse((boolean)this.page.isHeaderUnique());
    }

    @Test
    public void testIsHeaderUniqueWhenColumnIsNotNewAndHeaderIsUnique() {
        HashSet<String> headers = this.set("header1", "header2", "header3");
        Mockito.when((Object)this.plugin.getOriginalColumnConfig52()).thenReturn((Object)this.column("header3"));
        Mockito.when((Object)this.plugin.isNewColumn()).thenReturn((Object)false);
        Mockito.when((Object)this.plugin.getAlreadyUsedColumnHeaders()).thenReturn(headers);
        Mockito.when((Object)this.page.getHeader()).thenReturn((Object)"header3");
        Assert.assertTrue((boolean)this.page.isHeaderUnique());
    }

    @Test
    public void testIsHeaderUniqueWhenColumnIsNotNewAndHeaderIsNotUnique() {
        HashSet<String> headers = this.set("header1", "header2", "header3");
        Mockito.when((Object)this.plugin.getOriginalColumnConfig52()).thenReturn((Object)this.column("header3"));
        Mockito.when((Object)this.plugin.isNewColumn()).thenReturn((Object)false);
        Mockito.when((Object)this.plugin.getAlreadyUsedColumnHeaders()).thenReturn(headers);
        Mockito.when((Object)this.page.getHeader()).thenReturn((Object)"header2");
        Assert.assertFalse((boolean)this.page.isHeaderUnique());
    }

    private DTColumnConfig52 column(String header) {
        DTColumnConfig52 dtColumnConfig52 = new DTColumnConfig52();
        dtColumnConfig52.setHeader(header);
        return dtColumnConfig52;
    }

    private HashSet<String> set(final String ... items) {
        return new HashSet<String>(){
            {
                for (String item : items) {
                    this.add(item);
                }
            }
        };
    }
}

