/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.pages;

import com.google.gwt.user.client.ui.ListBox;
import com.google.gwtmockito.GwtMockito;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.HashMap;
import java.util.Map;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.LimitedEntryConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.ValueOptionsPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.ConditionColumnPlugin;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.PatternWrapper;
import org.gwtbootstrap3.client.ui.TextBox;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.project.datamodel.oracle.DataType;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.callbacks.Callback;

@RunWith(value=GwtMockitoTestRunner.class)
public class ValueOptionsPageTest {
    @Mock
    private ConditionColumnPlugin plugin;
    @Mock
    private AsyncPackageDataModelOracle oracle;
    @Mock
    private GuidedDecisionTableView.Presenter presenter;
    @Mock
    private PatternWrapper patternWrapper;
    @Mock
    private Pattern52 pattern52;
    @Mock
    private ConditionCol52 editingCol;
    @Mock
    private GuidedDecisionTable52 model;
    @Mock
    private DTCellValue52 defaultValue;
    @Mock
    private ValueOptionsPage.View view;
    @Mock
    private TranslationService translationService;
    @Mock
    private TextBox disabledTextBox;
    @InjectMocks
    private ValueOptionsPage<ConditionColumnPlugin> page;

    public ValueOptionsPageTest() {
        this.page = (ValueOptionsPage)Mockito.spy((Object)new ValueOptionsPage(this.view, this.translationService));
    }

    @BeforeClass
    public static void staticSetup() {
        ApplicationPreferences.setUp((Map)new HashMap<String, String>(){
            {
                this.put("drools.dateformat", "dd-MM-yyyy");
            }
        });
    }

    @Before
    public void setup() {
        GwtMockito.useProviderForType(TextBox.class, aClass -> this.disabledTextBox);
        Mockito.when((Object)this.defaultValue.getDataType()).thenReturn((Object)DataType.DataTypes.STRING);
        Mockito.when((Object)this.editingCol.getDefaultValue()).thenReturn((Object)this.defaultValue);
        Mockito.when((Object)this.presenter.getModel()).thenReturn((Object)this.model);
        Mockito.when((Object)this.presenter.getDataModelOracle()).thenReturn((Object)this.oracle);
        Mockito.when((Object)this.plugin.patternWrapper()).thenReturn((Object)this.patternWrapper);
        Mockito.when((Object)this.plugin.editingCol()).thenReturn((Object)this.editingCol);
        Mockito.when((Object)this.plugin.getPresenter()).thenReturn((Object)this.presenter);
        Mockito.when((Object)this.plugin.editingPattern()).thenReturn((Object)this.pattern52);
        Mockito.when((Object)this.page.plugin()).thenReturn((Object)this.plugin);
        Mockito.when((Object)this.model.getTableFormat()).thenReturn((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY);
        ((ConditionColumnPlugin)Mockito.doCallRealMethod().when((Object)this.plugin)).defaultValueWidget();
    }

    @Test
    public void testNewDefaultValueWidget() throws Exception {
        Mockito.when((Object)this.editingCol.getValueList()).thenReturn((Object)"a,b,c");
        Assert.assertTrue((boolean)(this.page.newDefaultValueWidget() instanceof ListBox));
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).defaultValueWidget();
    }

    @Test
    public void testNewLimitedValueWidget() throws Exception {
        this.page.newLimitedValueWidget();
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).limitedValueWidget();
    }

    @Test
    public void testCanSetupCepOperatorsWhenItIsNotEnabled() throws Exception {
        Assert.assertFalse((boolean)this.page.canSetupCepOperators());
    }

    @Test
    public void testCanSetupCepOperatorsWhenItIsEnabledAndEditingPatternIsNotNull() throws Exception {
        Mockito.when((Object)this.plugin.editingPattern()).thenReturn((Object)this.pattern52);
        Mockito.when((Object)this.pattern52.getFactType()).thenReturn((Object)"factType");
        this.page.enableCepOperators();
        Assert.assertTrue((boolean)this.page.canSetupCepOperators());
    }

    @Test
    public void testCanSetupCepOperatorsWhenItIsEnabledAndEditingPatternIsNull() throws Exception {
        Mockito.when((Object)this.plugin.editingPattern()).thenReturn(null);
        this.page.enableCepOperators();
        Assert.assertFalse((boolean)this.page.canSetupCepOperators());
    }

    @Test
    public void testCanSetupDefaultValueWhenEditingColIsNull() throws Exception {
        Mockito.when((Object)this.plugin.editingCol()).thenReturn(null);
        Assert.assertFalse((boolean)this.page.canSetupDefaultValue());
    }

    @Test
    public void testCanSetupDefaultValueWhenEditingPatternIsNull() throws Exception {
        Mockito.when((Object)this.plugin.patternWrapper()).thenReturn(null);
        Assert.assertFalse((boolean)this.page.canSetupDefaultValue());
    }

    @Test
    public void testCanSetupDefaultValueWhenEditingColHasAnEmptyFactType() throws Exception {
        Mockito.when((Object)this.editingCol.getFactField()).thenReturn((Object)"");
        Assert.assertFalse((boolean)this.page.canSetupDefaultValue());
    }

    @Test
    public void testCanSetupDefaultValueWhenOperatorNeedsAValue() throws Exception {
        Mockito.when((Object)this.editingCol.getFactField()).thenReturn((Object)"factField");
        Mockito.when((Object)this.plugin.doesOperatorNeedValue()).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.page.canSetupDefaultValue());
    }

    @Test
    public void testCanSetupDefaultValueWhenTableFormatIsNotExtendedEntry() throws Exception {
        Mockito.when((Object)this.editingCol.getFactField()).thenReturn((Object)"factField");
        Mockito.when((Object)this.plugin.doesOperatorNeedValue()).thenReturn((Object)true);
        Mockito.when((Object)this.model.getTableFormat()).thenReturn((Object)GuidedDecisionTable52.TableFormat.LIMITED_ENTRY);
        Assert.assertFalse((boolean)this.page.canSetupDefaultValue());
    }

    @Test
    public void testCanSetupDefaultValueWhenItIsNotEnabled() throws Exception {
        Mockito.when((Object)this.plugin.getFactField()).thenReturn((Object)"factField");
        Mockito.when((Object)this.plugin.getFactType()).thenReturn((Object)"factType");
        Mockito.when((Object)this.plugin.doesOperatorNeedValue()).thenReturn((Object)true);
        Mockito.when((Object)this.model.getTableFormat()).thenReturn((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY);
        Assert.assertFalse((boolean)this.page.canSetupDefaultValue());
    }

    @Test
    public void testCanSetupDefaultValueWhenCanSetup() throws Exception {
        Mockito.when((Object)this.plugin.getFactField()).thenReturn((Object)"factField");
        Mockito.when((Object)this.plugin.getFactType()).thenReturn((Object)"factType");
        Mockito.when((Object)this.plugin.doesOperatorNeedValue()).thenReturn((Object)true);
        Mockito.when((Object)this.model.getTableFormat()).thenReturn((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY);
        this.page.enableDefaultValue();
        Assert.assertTrue((boolean)this.page.canSetupDefaultValue());
    }

    @Test
    public void testCanSetupLimitedValueWhenEditingColIsNull() throws Exception {
        Mockito.when((Object)this.plugin.editingCol()).thenReturn(null);
        Assert.assertFalse((boolean)this.page.canSetupLimitedValue());
    }

    @Test
    public void testCanSetupLimitedValueWhenEditingPatternIsNull() throws Exception {
        Mockito.when((Object)this.plugin.patternWrapper()).thenReturn(null);
        Assert.assertFalse((boolean)this.page.canSetupLimitedValue());
    }

    @Test
    public void testCanSetupLimitedValueWhenEditingColIsNotAnInstanceOfLimitedEntryConditionCol52() throws Exception {
        Mockito.when((Object)this.plugin.editingCol()).thenReturn((Object)new ConditionCol52());
        Assert.assertFalse((boolean)this.page.canSetupLimitedValue());
    }

    @Test
    public void testCanSetupLimitedValueWhenOperatorNeedsAValue() throws Exception {
        Mockito.when((Object)this.plugin.editingCol()).thenReturn((Object)new LimitedEntryConditionCol52());
        Mockito.when((Object)this.plugin.doesOperatorNeedValue()).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.page.canSetupLimitedValue());
    }

    @Test
    public void testCanSetupLimitedValueWhenTableFormatIsNotLimitedEntry() throws Exception {
        Mockito.when((Object)this.plugin.editingCol()).thenReturn((Object)new LimitedEntryConditionCol52());
        Mockito.when((Object)this.model.getTableFormat()).thenReturn((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY);
        Mockito.when((Object)this.plugin.doesOperatorNeedValue()).thenReturn((Object)true);
        Assert.assertFalse((boolean)this.page.canSetupLimitedValue());
    }

    @Test
    public void testCanSetupLimitedValueWhenCanSetup() throws Exception {
        Mockito.when((Object)this.plugin.getFactField()).thenReturn((Object)"factField");
        Mockito.when((Object)this.plugin.getFactType()).thenReturn((Object)"factType");
        Mockito.when((Object)this.model.getTableFormat()).thenReturn((Object)GuidedDecisionTable52.TableFormat.LIMITED_ENTRY);
        Mockito.when((Object)this.plugin.doesOperatorNeedValue()).thenReturn((Object)true);
        this.page.enableLimitedValue();
        Assert.assertTrue((boolean)this.page.canSetupLimitedValue());
    }

    @Test
    public void testIsFactTypeAnEventWhenCepOperatorsIsEnabled() throws Exception {
        this.page.enableCepOperators();
        Mockito.when((Object)this.plugin.editingPattern()).thenReturn((Object)this.pattern52);
        Mockito.when((Object)this.pattern52.getFactType()).thenReturn((Object)"factType");
        this.page.isFactTypeAnEvent(Assert::assertTrue);
        ((AsyncPackageDataModelOracle)Mockito.verify((Object)this.oracle)).isFactTypeAnEvent((String)Mockito.eq((Object)"factType"), (Callback)Mockito.any());
    }

    @Test
    public void testIsFactTypeAnEventWhenCepOperatorsIsNotEnabled() throws Exception {
        Mockito.when((Object)this.patternWrapper.getFactType()).thenReturn((Object)"factType");
        this.page.isFactTypeAnEvent(Assert::assertFalse);
    }

    @Test
    public void testValueListDisabledWhenEnumsPresent() throws Exception {
        this.page.enableValueList();
        Mockito.when((Object)this.pattern52.getFactType()).thenReturn((Object)"factType");
        Mockito.when((Object)this.plugin.getFactType()).thenReturn((Object)"factType");
        Mockito.when((Object)this.plugin.getFactField()).thenReturn((Object)"factField");
        Mockito.when((Object)this.plugin.doesOperatorAcceptValueList()).thenReturn((Object)true);
        Mockito.when((Object)this.oracle.hasEnums("factType", "factField")).thenReturn((Object)true);
        this.page.prepareView();
        ((ValueOptionsPage.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).hideValueList();
        ((ValueOptionsPage.View)Mockito.verify((Object)this.view)).disableValueList();
        ((AsyncPackageDataModelOracle)Mockito.verify((Object)this.oracle)).hasEnums("factType", "factField");
    }

    @Test
    public void testPrepareView() {
        this.page.prepareView();
        ((ValueOptionsPage)Mockito.verify(this.page)).markAsViewed();
        ((ValueOptionsPage)Mockito.verify(this.page)).setupValueList();
        ((ValueOptionsPage)Mockito.verify(this.page)).setupCepOperators();
        ((ValueOptionsPage)Mockito.verify(this.page)).setupDefaultValue();
        ((ValueOptionsPage)Mockito.verify(this.page)).setupLimitedValue();
    }

    @Test
    public void testSetupValueListWhenValueListIsNotEnabled() throws Exception {
        ((ValueOptionsPage)Mockito.doReturn((Object)false).when(this.page)).isValueListEnabled();
        this.page.setupValueList();
        ((ValueOptionsPage.View)Mockito.verify((Object)this.view)).hideValueList();
    }

    @Test
    public void testSetupValueListWhenValueListCanNotBeSetUp() throws Exception {
        ((ValueOptionsPage)Mockito.doReturn((Object)true).when(this.page)).isValueListEnabled();
        ((ValueOptionsPage)Mockito.doReturn((Object)false).when(this.page)).canSetupValueList();
        this.page.setupValueList();
        ((ValueOptionsPage.View)Mockito.verify((Object)this.view)).disableValueList();
        ((ValueOptionsPage.View)Mockito.verify((Object)this.view)).setValueListText("");
    }

    @Test
    public void testSetupValueListWhenValueListCanBeSetUp() throws Exception {
        ((ValueOptionsPage)Mockito.doReturn((Object)true).when(this.page)).isValueListEnabled();
        ((ValueOptionsPage)Mockito.doReturn((Object)true).when(this.page)).canSetupValueList();
        this.page.setupValueList();
        ((ValueOptionsPage.View)Mockito.verify((Object)this.view)).enableValueList();
        ((ValueOptionsPage.View)Mockito.verify((Object)this.view)).setValueListText((String)Mockito.any());
    }

    @Test
    public void testIsCompleteWhenValueOptionsPageIsNotCompleted() throws Exception {
        Mockito.when((Object)this.plugin.isValueOptionsPageCompleted()).thenReturn((Object)false);
        this.page.isComplete(Assert::assertFalse);
    }

    @Test
    public void testIsCompleteWhenValueOptionsPageIsCompleted() throws Exception {
        Mockito.when((Object)this.plugin.isValueOptionsPageCompleted()).thenReturn((Object)true);
        this.page.isComplete(Assert::assertTrue);
    }
}

