/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.List;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionRetractFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.LimitedEntryActionRetractFactCol52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.ModelSynchronizer;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.NewGuidedDecisionTableColumnWizard;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.AdditionalInfoPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.PatternToDeletePage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.ActionRetractFactPlugin;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.ConditionColumnPlugin;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.widgets.core.client.wizards.WizardPage;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageStatusChangeEvent;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class ActionRetractFactPluginTest {
    @Mock
    private NewGuidedDecisionTableColumnWizard wizard;
    @Mock
    private PatternToDeletePage patternToDeletePage;
    @Mock
    private AdditionalInfoPage<ConditionColumnPlugin> additionalInfoPage;
    @Mock
    private EventSourceMock<WizardPageStatusChangeEvent> changeEvent;
    @Mock
    private GuidedDecisionTableView.Presenter presenter;
    private GuidedDecisionTable52 model;
    @Mock
    private TranslationService translationService;
    @Mock
    private ActionRetractFactCol52 editingCol;
    @Mock
    private LimitedEntryActionRetractFactCol52 limitedEntryActionRetractFactCol52;
    @InjectMocks
    private ActionRetractFactPlugin plugin;

    public ActionRetractFactPluginTest() {
        this.plugin = (ActionRetractFactPlugin)Mockito.spy((Object)new ActionRetractFactPlugin(this.patternToDeletePage, this.additionalInfoPage, this.changeEvent, this.translationService));
    }

    @Before
    public void setUp() throws Exception {
        this.model = new GuidedDecisionTable52();
    }

    @Test
    public void testInit() throws Exception {
        this.model.setTableFormat(GuidedDecisionTable52.TableFormat.LIMITED_ENTRY);
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)this.model).when((Object)this.presenter)).getModel();
        ((NewGuidedDecisionTableColumnWizard)Mockito.doReturn((Object)this.presenter).when((Object)this.wizard)).getPresenter();
        this.plugin.init(this.wizard);
        ((ActionRetractFactPlugin)Mockito.verify((Object)this.plugin)).setupDefaultValues();
    }

    @Test
    public void testGetPagesWhenTableFormatIsLimitedEntry() throws Exception {
        this.model.setTableFormat(GuidedDecisionTable52.TableFormat.LIMITED_ENTRY);
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)this.model).when((Object)this.presenter)).getModel();
        List pages = this.plugin.getPages();
        boolean hasPatternToDeletePage = pages.stream().anyMatch(a -> a instanceof PatternToDeletePage);
        Assert.assertTrue((boolean)hasPatternToDeletePage);
        Assert.assertEquals((long)2L, (long)pages.size());
    }

    @Test
    public void testGetPagesWhenTableFormatIsNotLimitedEntry() throws Exception {
        this.model.setTableFormat(GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY);
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)this.model).when((Object)this.presenter)).getModel();
        List pages = this.plugin.getPages();
        boolean hasPatternToDeletePage = pages.stream().anyMatch(a -> a instanceof PatternToDeletePage);
        Assert.assertFalse((boolean)hasPatternToDeletePage);
        Assert.assertEquals((long)1L, (long)pages.size());
    }

    @Test
    public void testGenerateColumnWhenColumnIsNew() throws Exception {
        ActionRetractFactCol52 expectedColumn = (ActionRetractFactCol52)Mockito.mock(ActionRetractFactCol52.class);
        ((ActionRetractFactPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isNewColumn();
        ((ActionRetractFactPlugin)Mockito.doReturn((Object)expectedColumn).when((Object)this.plugin)).editingCol();
        Assert.assertTrue((boolean)this.plugin.generateColumn());
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)this.presenter)).appendColumn((ActionCol52)expectedColumn);
    }

    @Test
    public void testGenerateColumnWhenColumnIsNotNew() throws Exception {
        ActionRetractFactCol52 editingCol = (ActionRetractFactCol52)Mockito.mock(ActionRetractFactCol52.class);
        ActionRetractFactCol52 originalCol = (ActionRetractFactCol52)Mockito.mock(ActionRetractFactCol52.class);
        ((ActionRetractFactPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).isNewColumn();
        ((ActionRetractFactPlugin)Mockito.doReturn((Object)editingCol).when((Object)this.plugin)).editingCol();
        ((ActionRetractFactPlugin)Mockito.doReturn((Object)originalCol).when((Object)this.plugin)).originalCol();
        Assert.assertTrue((boolean)this.plugin.generateColumn());
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)this.presenter)).updateColumn((ActionCol52)originalCol, (ActionCol52)editingCol);
    }

    @Test
    public void testGenerateColumnWhenColumnIsNotNewAndVetoed() throws Exception {
        ((ActionRetractFactPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).isNewColumn();
        ((GuidedDecisionTableView.Presenter)Mockito.doThrow(ModelSynchronizer.VetoException.class).when((Object)this.presenter)).updateColumn((ActionCol52)Mockito.any(ActionCol52.class), (ActionCol52)Mockito.any(ActionCol52.class));
        Assert.assertFalse((boolean)this.plugin.generateColumn());
        ((NewGuidedDecisionTableColumnWizard)Mockito.verify((Object)this.wizard)).showGenericVetoError();
    }

    @Test
    public void testSetHeader() throws Exception {
        String header = "Header";
        ((ActionRetractFactPlugin)Mockito.doReturn((Object)this.editingCol).when((Object)this.plugin)).editingCol();
        this.plugin.setHeader("Header");
        ((ActionRetractFactCol52)Mockito.verify((Object)this.editingCol)).setHeader("Header");
        ((ActionRetractFactPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent(this.additionalInfoPage);
    }

    @Test
    public void testGetEditingColStringValue() throws Exception {
        DTCellValue52 cellValue52 = (DTCellValue52)Mockito.mock(DTCellValue52.class);
        ((LimitedEntryActionRetractFactCol52)Mockito.doReturn((Object)cellValue52).when((Object)this.limitedEntryActionRetractFactCol52)).getValue();
        ((ActionRetractFactPlugin)Mockito.doReturn((Object)this.limitedEntryActionRetractFactCol52).when((Object)this.plugin)).editingCol();
        this.plugin.getEditingColStringValue();
        ((DTCellValue52)Mockito.verify((Object)cellValue52)).getStringValue();
    }

    @Test
    public void testSetEditingColStringValue() throws Exception {
        DTCellValue52 cellValue52 = (DTCellValue52)Mockito.mock(DTCellValue52.class);
        String pattern = "pattern";
        ((LimitedEntryActionRetractFactCol52)Mockito.doReturn((Object)cellValue52).when((Object)this.limitedEntryActionRetractFactCol52)).getValue();
        ((ActionRetractFactPlugin)Mockito.doReturn((Object)this.limitedEntryActionRetractFactCol52).when((Object)this.plugin)).editingCol();
        this.plugin.setEditingColStringValue("pattern");
        ((DTCellValue52)Mockito.verify((Object)cellValue52)).setStringValue("pattern");
    }

    @Test
    public void testSetValueOptionsPageAsCompletedWhenItIsCompleted() throws Exception {
        ((ActionRetractFactPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isPatternToDeletePageCompleted();
        this.plugin.setPatternToDeletePageAsCompleted();
        ((ActionRetractFactPlugin)Mockito.verify((Object)this.plugin, (VerificationMode)Mockito.never())).setPatternToDeletePageCompleted(Boolean.TRUE);
        ((ActionRetractFactPlugin)Mockito.verify((Object)this.plugin, (VerificationMode)Mockito.never())).fireChangeEvent((WizardPage)this.patternToDeletePage);
    }

    @Test
    public void testSetValueOptionsPageAsCompletedWhenItIsNotCompleted() throws Exception {
        ((ActionRetractFactPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).isPatternToDeletePageCompleted();
        this.plugin.setPatternToDeletePageAsCompleted();
        ((ActionRetractFactPlugin)Mockito.verify((Object)this.plugin)).setPatternToDeletePageCompleted(Boolean.TRUE);
        ((ActionRetractFactPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.patternToDeletePage);
    }

    @Test
    public void testGetTitle() {
        String errorKey = "ActionRetractFactPlugin.DeleteAnExistingFact";
        String errorMessage = "Title";
        Mockito.when((Object)this.translationService.format("ActionRetractFactPlugin.DeleteAnExistingFact", new Object[0])).thenReturn((Object)"Title");
        String title = this.plugin.getTitle();
        Assert.assertEquals((Object)"Title", (Object)title);
    }

    @Test
    public void testGetHeader() {
        this.plugin.getHeader();
        ((ActionRetractFactCol52)Mockito.verify((Object)this.editingCol)).getHeader();
    }

    @Test
    public void testGetAlreadyUsedColumnNames() throws Exception {
        this.model.getActionCols().add(this.actionCol52("a"));
        this.model.getActionCols().add(this.actionCol52("b"));
        Mockito.when((Object)this.presenter.getModel()).thenReturn((Object)this.model);
        Assert.assertEquals((long)2L, (long)this.plugin.getAlreadyUsedColumnHeaders().size());
        Assert.assertTrue((boolean)this.plugin.getAlreadyUsedColumnHeaders().contains("a"));
        Assert.assertTrue((boolean)this.plugin.getAlreadyUsedColumnHeaders().contains("b"));
    }

    @Test
    public void testSetupDefaultValuesColumnIsNew() throws Exception {
        ActionRetractFactCol52 newColumn = (ActionRetractFactCol52)Mockito.mock(ActionRetractFactCol52.class);
        ((ActionRetractFactPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isNewColumn();
        ((ActionRetractFactPlugin)Mockito.doReturn((Object)newColumn).when((Object)this.plugin)).newColumn();
        ((ActionRetractFactPlugin)Mockito.doReturn((Object)newColumn).when((Object)this.plugin)).clone(newColumn);
        this.plugin.setupDefaultValues();
        Assert.assertEquals((Object)this.plugin.editingCol(), (Object)newColumn);
    }

    @Test
    public void testSetupDefaultValuesColumnIsNotNew() throws Exception {
        ActionRetractFactCol52 originalCol = (ActionRetractFactCol52)Mockito.mock(ActionRetractFactCol52.class);
        ((ActionRetractFactPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).isNewColumn();
        ((ActionRetractFactPlugin)Mockito.doReturn((Object)originalCol).when((Object)this.plugin)).originalCol();
        ((ActionRetractFactPlugin)Mockito.doReturn((Object)originalCol).when((Object)this.plugin)).clone(originalCol);
        this.plugin.setupDefaultValues();
        Assert.assertEquals((Object)this.plugin.editingCol(), (Object)originalCol);
    }

    private ActionCol52 actionCol52(final String header) {
        return new ActionCol52(){
            {
                this.setHeader(header);
            }
        };
    }
}

