/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTColumnConfig52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.ModelSynchronizer;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.NewGuidedDecisionTableColumnWizard;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.AdditionalInfoPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.FieldPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.PatternPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.ValueOptionsPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.ActionSetFactPlugin;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.ActionInsertFactWrapper;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.ActionSetFactWrapper;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.ActionWrapper;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.BaseDecisionTableColumnPlugin;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.DecisionTableColumnPlugin;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.DefaultWidgetFactory;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.LimitedWidgetFactory;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.PatternWrapper;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.project.datamodel.oracle.FieldAccessorsAndMutators;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.widgets.core.client.wizards.WizardPage;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageStatusChangeEvent;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
@WithClassesToStub(value={DefaultWidgetFactory.class, LimitedWidgetFactory.class})
public class ActionSetFactPluginTest {
    @Mock
    private PatternPage patternPage;
    @Mock
    private FieldPage fieldPage;
    @Mock
    private ValueOptionsPage<ActionSetFactPlugin> valueOptionsPage;
    @Mock
    private AdditionalInfoPage<ActionSetFactPlugin> additionalInfoPage;
    @Mock
    private GuidedDecisionTableView.Presenter presenter;
    @Mock
    private TranslationService translationService;
    @Mock
    private NewGuidedDecisionTableColumnWizard wizard;
    @Mock
    private EventSourceMock<WizardPageStatusChangeEvent> changeEvent;
    @Mock
    private AsyncPackageDataModelOracle oracle;
    @Mock
    private GuidedDecisionTable52 model;
    @InjectMocks
    private ActionSetFactPlugin plugin;

    public ActionSetFactPluginTest() {
        this.plugin = (ActionSetFactPlugin)Mockito.spy((Object)new ActionSetFactPlugin(this.patternPage, this.fieldPage, this.valueOptionsPage, this.additionalInfoPage, this.changeEvent, this.translationService));
    }

    @Before
    public void setup() {
        ((GuidedDecisionTable52)Mockito.doReturn((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY).when((Object)this.model)).getTableFormat();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)this.oracle).when((Object)this.presenter)).getDataModelOracle();
        ((ActionSetFactPlugin)Mockito.doReturn((Object)this.presenter).when((Object)this.plugin)).getPresenter();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)this.model).when((Object)this.presenter)).getModel();
    }

    @Test
    public void testGetTitle() {
        String errorKey = "ActionInsertFactPlugin.SetTheValueOfAField";
        String errorMessage = "Title";
        Mockito.when((Object)this.translationService.format("ActionInsertFactPlugin.SetTheValueOfAField", new Object[0])).thenReturn((Object)"Title");
        String title = this.plugin.getTitle();
        Assert.assertEquals((Object)"Title", (Object)title);
    }

    @Test
    public void testGetPages() {
        ((ActionSetFactPlugin)Mockito.doReturn((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY).when((Object)this.plugin)).tableFormat();
        List pages = this.plugin.getPages();
        Assert.assertEquals((long)4L, (long)pages.size());
    }

    @Test
    public void testGenerateColumn() {
        ActionCol52 actionCol52 = (ActionCol52)Mockito.mock(ActionCol52.class);
        ActionWrapper actionWrapper = (ActionWrapper)Mockito.mock(ActionWrapper.class);
        ((ActionWrapper)Mockito.doReturn((Object)actionCol52).when((Object)actionWrapper)).getActionCol52();
        ((ActionSetFactPlugin)Mockito.doReturn((Object)actionWrapper).when((Object)this.plugin)).editingWrapper();
        Boolean success = this.plugin.generateColumn();
        Assert.assertTrue((boolean)success);
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)this.presenter)).appendColumn(actionCol52);
    }

    @Test
    public void testGenerateColumnWhenColumnIsNotNewAndVetoed() throws Exception {
        ((ActionSetFactPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).isNewColumn();
        ((GuidedDecisionTableView.Presenter)Mockito.doThrow(ModelSynchronizer.VetoException.class).when((Object)this.presenter)).updateColumn((ActionCol52)Mockito.any(ActionCol52.class), (ActionCol52)Mockito.any(ActionCol52.class));
        Assert.assertFalse((boolean)this.plugin.generateColumn());
        ((NewGuidedDecisionTableColumnWizard)Mockito.verify((Object)this.wizard)).showGenericVetoError();
    }

    @Test
    public void testSetValueOptionsPageAsCompletedWhenItIsCompleted() throws Exception {
        ((ActionSetFactPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isValueOptionsPageCompleted();
        this.plugin.setValueOptionsPageAsCompleted();
        ((ActionSetFactPlugin)Mockito.verify((Object)this.plugin, (VerificationMode)Mockito.never())).setValueOptionsPageCompleted();
        ((ActionSetFactPlugin)Mockito.verify((Object)this.plugin, (VerificationMode)Mockito.never())).fireChangeEvent(this.valueOptionsPage);
    }

    @Test
    public void testSetValueOptionsPageAsCompletedWhenItIsNotCompleted() throws Exception {
        ((ActionSetFactPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).isValueOptionsPageCompleted();
        this.plugin.setValueOptionsPageAsCompleted();
        ((ActionSetFactPlugin)Mockito.verify((Object)this.plugin)).setValueOptionsPageCompleted();
        ((ActionSetFactPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent(this.valueOptionsPage);
    }

    @Test
    public void testSetEditingPattern() {
        ActionWrapper actionWrapper = (ActionWrapper)Mockito.mock(ActionWrapper.class);
        PatternWrapper patternWrapper = (PatternWrapper)Mockito.mock(PatternWrapper.class);
        Mockito.when((Object)this.plugin.editingWrapper()).thenReturn((Object)actionWrapper);
        Mockito.when((Object)patternWrapper.getFactType()).thenReturn((Object)"factType");
        Mockito.when((Object)patternWrapper.getBoundName()).thenReturn((Object)"boundName");
        this.plugin.setEditingPattern(patternWrapper);
        ((ActionWrapper)Mockito.verify((Object)actionWrapper)).setFactField("");
        ((ActionWrapper)Mockito.verify((Object)actionWrapper)).setFactType("factType");
        ((ActionWrapper)Mockito.verify((Object)actionWrapper)).setBoundName("boundName");
        ((ActionWrapper)Mockito.verify((Object)actionWrapper)).setType("");
        ((ActionSetFactPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.patternPage);
        ((ActionSetFactPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.fieldPage);
        ((ActionSetFactPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent(this.additionalInfoPage);
    }

    @Test
    public void testConstraintValue() {
        boolean expectedConstraintValue = false;
        int actualConstraintValue = this.plugin.constraintValue();
        Assert.assertEquals((long)0L, (long)actualConstraintValue);
    }

    @Test
    public void testGetFactType() {
        PatternWrapper patternWrapper = (PatternWrapper)Mockito.mock(PatternWrapper.class);
        String expectedFactType = "factType";
        Mockito.when((Object)patternWrapper.getFactType()).thenReturn((Object)"factType");
        Mockito.when((Object)this.plugin.patternWrapper()).thenReturn((Object)patternWrapper);
        String actualFactType = this.plugin.getFactType();
        ((PatternWrapper)Mockito.verify((Object)patternWrapper)).getFactType();
        Assert.assertEquals((Object)"factType", (Object)actualFactType);
    }

    @Test
    public void testGetAccessor() {
        FieldAccessorsAndMutators expectedAccessor = FieldAccessorsAndMutators.MUTATOR;
        FieldAccessorsAndMutators actualAccessor = this.plugin.getAccessor();
        Assert.assertEquals((Object)expectedAccessor, (Object)actualAccessor);
    }

    @Test
    public void testFilterEnumFields() {
        Assert.assertFalse((boolean)this.plugin.filterEnumFields());
    }

    @Test
    public void testGetFactField() {
        ActionWrapper actionWrapper = (ActionWrapper)Mockito.mock(ActionWrapper.class);
        String expectedFactField = "factField";
        Mockito.when((Object)actionWrapper.getFactField()).thenReturn((Object)"factField");
        Mockito.when((Object)this.plugin.editingWrapper()).thenReturn((Object)actionWrapper);
        String actualFactField = this.plugin.getFactField();
        ((ActionWrapper)Mockito.verify((Object)actionWrapper)).getFactField();
        Assert.assertEquals((Object)"factField", (Object)actualFactField);
    }

    @Test
    public void testSetFactFieldWhenFactPatternIsNew() {
        ActionInsertFactWrapper actionWrapper = (ActionInsertFactWrapper)Mockito.mock(ActionInsertFactWrapper.class);
        PatternWrapper patternWrapperMock = this.patternWrapperMock("factType", "boundName");
        ((ActionSetFactPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isNewFactPattern();
        ((ActionSetFactPlugin)Mockito.doReturn((Object)actionWrapper).when((Object)this.plugin)).newActionInsertFactWrapper();
        ((ActionSetFactPlugin)Mockito.doReturn((Object)patternWrapperMock).when((Object)this.plugin)).patternWrapper();
        ((AsyncPackageDataModelOracle)Mockito.doReturn((Object)"type").when((Object)this.oracle)).getFieldType((String)Mockito.any(), (String)Mockito.any());
        this.plugin.setFactField("selectedValue");
        ((ActionInsertFactWrapper)Mockito.verify((Object)actionWrapper)).setFactField((String)Mockito.eq((Object)"selectedValue"));
        ((ActionInsertFactWrapper)Mockito.verify((Object)actionWrapper)).setFactType((String)Mockito.eq((Object)"factType"));
        ((ActionInsertFactWrapper)Mockito.verify((Object)actionWrapper)).setBoundName((String)Mockito.eq((Object)"boundName"));
        ((ActionInsertFactWrapper)Mockito.verify((Object)actionWrapper)).setType((String)Mockito.eq((Object)"type"));
        ((ActionSetFactPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.fieldPage);
    }

    @Test
    public void testSetFactFieldWhenFactPatternIsNotNew() {
        ActionSetFactWrapper actionWrapper = (ActionSetFactWrapper)Mockito.spy((Object)new ActionSetFactWrapper((BaseDecisionTableColumnPlugin)this.plugin));
        Pattern52 patternMock = this.patternMock("factType");
        PatternWrapper patternWrapperMock = this.patternWrapperMock("factType", "boundName");
        ((ActionSetFactPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).isNewFactPattern();
        ((ActionSetFactPlugin)Mockito.doReturn((Object)actionWrapper).when((Object)this.plugin)).newActionSetFactWrapper();
        ((ActionSetFactPlugin)Mockito.doReturn((Object)patternWrapperMock).when((Object)this.plugin)).patternWrapper();
        ((GuidedDecisionTable52)Mockito.doReturn((Object)patternMock).when((Object)this.model)).getConditionPattern((String)Mockito.eq((Object)"boundName"));
        ((AsyncPackageDataModelOracle)Mockito.doReturn((Object)"type").when((Object)this.oracle)).getFieldType((String)Mockito.eq((Object)"factType"), (String)Mockito.eq((Object)"selectedValue"));
        this.plugin.setFactField("selectedValue");
        ((ActionSetFactWrapper)Mockito.verify((Object)actionWrapper)).setFactField((String)Mockito.eq((Object)"selectedValue"));
        ((ActionSetFactWrapper)Mockito.verify((Object)actionWrapper)).setFactType((String)Mockito.eq((Object)"factType"));
        ((ActionSetFactWrapper)Mockito.verify((Object)actionWrapper)).setBoundName((String)Mockito.eq((Object)"boundName"));
        ((ActionSetFactWrapper)Mockito.verify((Object)actionWrapper)).setType((String)Mockito.eq((Object)"type"));
        ((ActionSetFactPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.fieldPage);
    }

    @Test
    public void testSetFactFieldWhenColumnIsNotNew() {
        ActionInsertFactWrapper actionWrapper = (ActionInsertFactWrapper)Mockito.mock(ActionInsertFactWrapper.class);
        PatternWrapper patternWrapperMock = this.patternWrapperMock("factType", "boundName");
        ((ActionSetFactPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).isNewColumn();
        ((ActionSetFactPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isNewFactPattern();
        ((ActionSetFactPlugin)Mockito.doReturn((Object)actionWrapper).when((Object)this.plugin)).editingWrapper();
        ((ActionSetFactPlugin)Mockito.doReturn((Object)patternWrapperMock).when((Object)this.plugin)).patternWrapper();
        ((AsyncPackageDataModelOracle)Mockito.doReturn((Object)"type").when((Object)this.oracle)).getFieldType((String)Mockito.any(), (String)Mockito.any());
        this.plugin.setFactField("selectedValue");
        ((ActionInsertFactWrapper)Mockito.verify((Object)actionWrapper)).setFactField((String)Mockito.eq((Object)"selectedValue"));
        ((ActionInsertFactWrapper)Mockito.verify((Object)actionWrapper)).setFactType((String)Mockito.eq((Object)"factType"));
        ((ActionInsertFactWrapper)Mockito.verify((Object)actionWrapper)).setBoundName((String)Mockito.eq((Object)"boundName"));
        ((ActionInsertFactWrapper)Mockito.verify((Object)actionWrapper)).setType((String)Mockito.eq((Object)"type"));
        ((ActionSetFactPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.fieldPage);
        ((ActionSetFactPlugin)Mockito.verify((Object)this.plugin, (VerificationMode)Mockito.never())).newActionInsertFactWrapper();
    }

    private PatternWrapper patternWrapperMock(String factType, String boundName) {
        PatternWrapper patternWrapper = (PatternWrapper)Mockito.mock(PatternWrapper.class);
        ((PatternWrapper)Mockito.doReturn((Object)factType).when((Object)patternWrapper)).getFactType();
        ((PatternWrapper)Mockito.doReturn((Object)boundName).when((Object)patternWrapper)).getBoundName();
        return patternWrapper;
    }

    private Pattern52 patternMock(String factType) {
        Pattern52 pattern = (Pattern52)Mockito.mock(Pattern52.class);
        ((Pattern52)Mockito.doReturn((Object)factType).when((Object)pattern)).getFactType();
        return pattern;
    }

    @Test
    public void testEditingPattern() {
        PatternWrapper patternWrapper = (PatternWrapper)Mockito.mock(PatternWrapper.class);
        ((ActionSetFactPlugin)Mockito.doReturn((Object)patternWrapper).when((Object)this.plugin)).patternWrapper();
        Mockito.when((Object)patternWrapper.getFactType()).thenReturn((Object)"factType");
        Mockito.when((Object)patternWrapper.getBoundName()).thenReturn((Object)"boundName");
        Mockito.when((Object)patternWrapper.isNegated()).thenReturn((Object)false);
        Mockito.when((Object)patternWrapper.getEntryPointName()).thenReturn((Object)"entryPoint");
        Pattern52 pattern52 = this.plugin.editingPattern();
        Assert.assertEquals((Object)"factType", (Object)pattern52.getFactType());
        Assert.assertEquals((Object)"boundName", (Object)pattern52.getBoundName());
        Assert.assertEquals((Object)false, (Object)pattern52.isNegated());
        Assert.assertEquals((Object)"entryPoint", (Object)pattern52.getEntryPointName());
    }

    @Test
    public void testEditingCol() {
        ActionWrapper actionWrapper = (ActionWrapper)Mockito.mock(ActionWrapper.class);
        ((ActionSetFactPlugin)Mockito.doReturn((Object)actionWrapper).when((Object)this.plugin)).editingWrapper();
        this.plugin.editingCol();
        ((ActionWrapper)Mockito.verify((Object)actionWrapper)).getActionCol52();
    }

    @Test
    public void testGetHeader() {
        ActionWrapper actionWrapper = (ActionWrapper)Mockito.mock(ActionWrapper.class);
        ((ActionSetFactPlugin)Mockito.doReturn((Object)actionWrapper).when((Object)this.plugin)).editingWrapper();
        this.plugin.getHeader();
        ((ActionWrapper)Mockito.verify((Object)actionWrapper)).getHeader();
    }

    @Test
    public void testSetHeader() {
        ActionWrapper actionWrapper = (ActionWrapper)Mockito.mock(ActionWrapper.class);
        String header = "header";
        ((ActionSetFactPlugin)Mockito.doReturn((Object)actionWrapper).when((Object)this.plugin)).editingWrapper();
        this.plugin.setHeader("header");
        ((ActionWrapper)Mockito.verify((Object)actionWrapper)).setHeader("header");
        ((ActionSetFactPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent(this.additionalInfoPage);
    }

    @Test
    public void testSetInsertLogical() {
        ActionWrapper actionWrapper = (ActionWrapper)Mockito.mock(ActionWrapper.class);
        boolean insertLogical = false;
        ((ActionSetFactPlugin)Mockito.doReturn((Object)actionWrapper).when((Object)this.plugin)).editingWrapper();
        this.plugin.setInsertLogical(Boolean.valueOf(false));
        ((ActionWrapper)Mockito.verify((Object)actionWrapper)).setInsertLogical(false);
    }

    @Test
    public void testSetUpdate() {
        ActionWrapper actionWrapper = (ActionWrapper)Mockito.mock(ActionWrapper.class);
        boolean update = false;
        ((ActionSetFactPlugin)Mockito.doReturn((Object)actionWrapper).when((Object)this.plugin)).editingWrapper();
        this.plugin.setUpdate(Boolean.valueOf(false));
        ((ActionWrapper)Mockito.verify((Object)actionWrapper)).setUpdate(false);
    }

    @Test
    public void testShowUpdateEngineWithChangesWhenFactPatternIsNew() {
        ((ActionSetFactPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isNewFactPattern();
        boolean showUpdateEngineWithChanges = this.plugin.showUpdateEngineWithChanges();
        Assert.assertEquals((Object)false, (Object)showUpdateEngineWithChanges);
    }

    @Test
    public void testShowUpdateEngineWithChangesWhenFactPatternIsNotNew() {
        ((ActionSetFactPlugin)Mockito.doReturn((Object)Mockito.mock(ActionSetFactWrapper.class)).when((Object)this.plugin)).editingWrapper();
        boolean showUpdateEngineWithChanges = this.plugin.showUpdateEngineWithChanges();
        Assert.assertEquals((Object)true, (Object)showUpdateEngineWithChanges);
    }

    @Test
    public void testShowLogicallyInsertWhenFactPatternIsNew() {
        ((ActionSetFactPlugin)Mockito.doReturn((Object)Mockito.mock(ActionInsertFactWrapper.class)).when((Object)this.plugin)).editingWrapper();
        boolean showLogicallyInsert = this.plugin.showLogicallyInsert();
        Assert.assertEquals((Object)true, (Object)showLogicallyInsert);
    }

    @Test
    public void testShowLogicallyInsertWhenFactPatternIsNotNew() {
        ((ActionSetFactPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).isNewFactPattern();
        boolean showLogicallyInsert = this.plugin.showLogicallyInsert();
        Assert.assertEquals((Object)false, (Object)showLogicallyInsert);
    }

    @Test
    public void testGetValueList() {
        ActionWrapper actionWrapper = (ActionWrapper)Mockito.mock(ActionWrapper.class);
        ((ActionSetFactPlugin)Mockito.doReturn((Object)actionWrapper).when((Object)this.plugin)).editingWrapper();
        this.plugin.getValueList();
        ((ActionWrapper)Mockito.verify((Object)actionWrapper)).getValueList();
    }

    @Test
    public void testSetValueList() {
        ActionWrapper actionWrapper = (ActionWrapper)Mockito.mock(ActionWrapper.class);
        String valueList = "valueList";
        ((ActionSetFactPlugin)Mockito.doReturn((Object)actionWrapper).when((Object)this.plugin)).editingWrapper();
        this.plugin.setValueList("valueList");
        ((ActionWrapper)Mockito.verify((Object)actionWrapper)).setValueList("valueList");
    }

    @Test
    public void testTableFormat() {
        GuidedDecisionTable52.TableFormat expectedTableFormat = GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY;
        GuidedDecisionTable52 model = (GuidedDecisionTable52)Mockito.mock(GuidedDecisionTable52.class);
        Mockito.when((Object)model.getTableFormat()).thenReturn((Object)expectedTableFormat);
        Mockito.when((Object)this.presenter.getModel()).thenReturn((Object)model);
        GuidedDecisionTable52.TableFormat actualTableFormat = this.plugin.tableFormat();
        Assert.assertEquals((Object)expectedTableFormat, (Object)actualTableFormat);
    }

    @Test
    public void testDefaultValueWidget() {
        IsWidget defaultWidget = this.plugin.defaultValueWidget();
        Assert.assertNotNull((Object)defaultWidget);
    }

    @Test
    public void testLimitedValueWidget() {
        IsWidget limitedValueWidget = this.plugin.limitedValueWidget();
        Assert.assertNotNull((Object)limitedValueWidget);
    }

    @Test
    public void testInitializedPatternPage() {
        this.plugin.initializedPatternPage();
        ((PatternPage)Mockito.verify((Object)this.patternPage)).disableEntryPoint();
    }

    @Test
    public void testInitializedAdditionalInfoPage() throws Exception {
        this.plugin.initializedAdditionalInfoPage();
        ((AdditionalInfoPage)Mockito.verify(this.additionalInfoPage)).setPlugin((DecisionTableColumnPlugin)this.plugin);
        ((AdditionalInfoPage)Mockito.verify(this.additionalInfoPage)).enableHeader();
        ((AdditionalInfoPage)Mockito.verify(this.additionalInfoPage)).enableHideColumn();
        ((AdditionalInfoPage)Mockito.verify(this.additionalInfoPage)).enableLogicallyInsert();
    }

    @Test
    public void testInitializedValueOptionsPageWhenTableIsALimitedEntry() throws Exception {
        ((ActionSetFactPlugin)Mockito.doReturn((Object)GuidedDecisionTable52.TableFormat.LIMITED_ENTRY).when((Object)this.plugin)).tableFormat();
        this.plugin.initializedValueOptionsPage();
        ((ValueOptionsPage)Mockito.verify(this.valueOptionsPage)).setPlugin((DecisionTableColumnPlugin)this.plugin);
        ((ValueOptionsPage)Mockito.verify(this.valueOptionsPage)).enableLimitedValue();
    }

    @Test
    public void testGetAlreadyUsedColumnNames() throws Exception {
        GuidedDecisionTable52 model = new GuidedDecisionTable52();
        model.getActionCols().add(new ActionCol52(){
            {
                this.setHeader("a");
            }
        });
        model.getActionCols().add(new ActionCol52(){
            {
                this.setHeader("b");
            }
        });
        Mockito.when((Object)this.presenter.getModel()).thenReturn((Object)model);
        Assert.assertEquals((long)2L, (long)this.plugin.getAlreadyUsedColumnHeaders().size());
        Assert.assertTrue((boolean)this.plugin.getAlreadyUsedColumnHeaders().contains("a"));
        Assert.assertTrue((boolean)this.plugin.getAlreadyUsedColumnHeaders().contains("b"));
    }

    @Test
    public void testNewActionWrapperWhenColumnIsAnActionInsertFactCol52() throws Exception {
        GuidedDecisionTable52 model = (GuidedDecisionTable52)Mockito.mock(GuidedDecisionTable52.class);
        Mockito.when((Object)model.getTableFormat()).thenReturn((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY);
        Mockito.when((Object)this.presenter.getModel()).thenReturn((Object)model);
        ActionWrapper wrapper = this.plugin.newActionWrapper((DTColumnConfig52)Mockito.mock(ActionInsertFactCol52.class));
        Assert.assertTrue((boolean)(wrapper instanceof ActionInsertFactWrapper));
    }

    @Test
    public void testNewActionWrapperWhenColumnIsAnActionSetFactWrapper() throws Exception {
        GuidedDecisionTable52 model = (GuidedDecisionTable52)Mockito.mock(GuidedDecisionTable52.class);
        Mockito.when((Object)model.getTableFormat()).thenReturn((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY);
        Mockito.when((Object)this.presenter.getModel()).thenReturn((Object)model);
        ActionWrapper wrapper = this.plugin.newActionWrapper((DTColumnConfig52)Mockito.mock(ActionSetFieldCol52.class));
        Assert.assertTrue((boolean)(wrapper instanceof ActionSetFactWrapper));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testNewActionWrapperWhenColumnIsInvalid() throws Exception {
        GuidedDecisionTable52 model = (GuidedDecisionTable52)Mockito.mock(GuidedDecisionTable52.class);
        Mockito.when((Object)model.getTableFormat()).thenReturn((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY);
        Mockito.when((Object)this.presenter.getModel()).thenReturn((Object)model);
        this.plugin.newActionWrapper((DTColumnConfig52)Mockito.mock(ConditionCol52.class));
    }

    @Test
    public void testNewPatternWrapperWhenPatternIsFound() throws Exception {
        final PatternWrapper expectedWrapper = this.mockPatternWrapper("boundName");
        HashSet<PatternWrapper> actionWrappers = new HashSet<PatternWrapper>(){
            {
                this.add(expectedWrapper);
            }
        };
        ((ActionSetFactPlugin)Mockito.doReturn((Object)actionWrappers).when((Object)this.plugin)).getPatterns();
        PatternWrapper actualWrapper = this.plugin.newPatternWrapper(this.mockActionWrapper("boundName", "factType"));
        Assert.assertSame((Object)expectedWrapper, (Object)actualWrapper);
    }

    @Test
    public void testNewPatternWrapperWhenPatternIsNotFound() throws Exception {
        HashSet actionWrappers = new HashSet();
        ActionWrapper actionWrapper = this.mockActionWrapper("boundName", "factType");
        ((ActionSetFactPlugin)Mockito.doReturn(actionWrappers).when((Object)this.plugin)).getPatterns();
        PatternWrapper patternWrapper = this.plugin.newPatternWrapper(actionWrapper);
        Assert.assertEquals((Object)actionWrapper.getBoundName(), (Object)patternWrapper.getBoundName());
        Assert.assertEquals((Object)actionWrapper.getFactType(), (Object)patternWrapper.getFactType());
    }

    @Test
    public void testSetupValuesWhenColumnIsNew() throws Exception {
        ((ActionSetFactPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isNewColumn();
        this.plugin.setupValues();
        ((ActionSetFactPlugin)Mockito.verify((Object)this.plugin, (VerificationMode)Mockito.never())).setValueOptionsPageAsCompleted();
        ((ActionSetFactPlugin)Mockito.verify((Object)this.plugin, (VerificationMode)Mockito.never())).fireChangeEvent((WizardPage)this.patternPage);
        ((ActionSetFactPlugin)Mockito.verify((Object)this.plugin, (VerificationMode)Mockito.never())).fireChangeEvent((WizardPage)this.fieldPage);
        ((ActionSetFactPlugin)Mockito.verify((Object)this.plugin, (VerificationMode)Mockito.never())).fireChangeEvent(this.additionalInfoPage);
    }

    @Test
    public void testSetupValuesWhenColumnIsNotNew() throws Exception {
        DTColumnConfig52 column = (DTColumnConfig52)Mockito.mock(DTColumnConfig52.class);
        ActionWrapper actionWrapper = (ActionWrapper)Mockito.mock(ActionWrapper.class);
        PatternWrapper patternWrapper = (PatternWrapper)Mockito.mock(PatternWrapper.class);
        ((ActionSetFactPlugin)Mockito.doReturn((Object)column).when((Object)this.plugin)).getOriginalColumnConfig52();
        ((ActionSetFactPlugin)Mockito.doReturn((Object)actionWrapper).when((Object)this.plugin)).newActionWrapper(column);
        ((ActionSetFactPlugin)Mockito.doReturn((Object)patternWrapper).when((Object)this.plugin)).newPatternWrapper(actionWrapper);
        ((ActionSetFactPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).isNewColumn();
        this.plugin.setupValues();
        ((ActionSetFactPlugin)Mockito.verify((Object)this.plugin)).setValueOptionsPageAsCompleted();
        ((ActionSetFactPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.patternPage);
        ((ActionSetFactPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.fieldPage);
        ((ActionSetFactPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent(this.additionalInfoPage);
    }

    @Test
    public void testGenerateColumnWhenColumnIsNew() throws Exception {
        ActionCol52 actionCol52 = (ActionCol52)Mockito.mock(ActionCol52.class);
        ((ActionSetFactPlugin)Mockito.doReturn((Object)actionCol52).when((Object)this.plugin)).editingCol();
        ((ActionSetFactPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isNewColumn();
        Assert.assertTrue((boolean)this.plugin.generateColumn());
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)this.presenter)).appendColumn(actionCol52);
    }

    @Test
    public void testGenerateColumnWhenColumnIsNotNew() throws Exception {
        ActionCol52 editingCol = (ActionCol52)Mockito.mock(ActionCol52.class);
        ActionCol52 originalCol = (ActionCol52)Mockito.mock(ActionCol52.class);
        ((ActionSetFactPlugin)Mockito.doReturn((Object)editingCol).when((Object)this.plugin)).editingCol();
        ((ActionSetFactPlugin)Mockito.doReturn((Object)originalCol).when((Object)this.plugin)).originalCol();
        ((ActionSetFactPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).isNewColumn();
        Assert.assertTrue((boolean)this.plugin.generateColumn());
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)this.presenter)).updateColumn(originalCol, editingCol);
    }

    @Test
    public void testGetPatternsWhenColumnIsNew() throws Exception {
        this.mockPatterns();
        ((ActionSetFactPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isNewColumn();
        Set patterns = this.plugin.getPatterns();
        Assert.assertEquals((long)2L, (long)patterns.size());
        Assert.assertTrue((boolean)patterns.contains(new PatternWrapper("factType", "boundName", Boolean.valueOf(true))));
        Assert.assertTrue((boolean)patterns.contains(new PatternWrapper("factType", "boundName")));
    }

    @Test
    public void testGetPatternsWhenColumnIsNotNewButFactPatternIsNew() throws Exception {
        this.mockPatterns();
        ((ActionSetFactPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).isNewColumn();
        ((ActionSetFactPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isNewFactPattern();
        Set patterns = this.plugin.getPatterns();
        Assert.assertEquals((long)1L, (long)patterns.size());
        Assert.assertTrue((boolean)patterns.contains(new PatternWrapper("factType", "boundName")));
    }

    @Test
    public void testGetPatternsWhenColumnAndFactPatternAreNotNew() throws Exception {
        this.mockPatterns();
        ((ActionSetFactPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).isNewColumn();
        ((ActionSetFactPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).isNewFactPattern();
        Set patterns = this.plugin.getPatterns();
        Assert.assertEquals((long)1L, (long)patterns.size());
        Assert.assertTrue((boolean)patterns.contains(new PatternWrapper("factType", "boundName", Boolean.valueOf(true))));
    }

    @Test
    public void testIsHideColumn() {
        ActionWrapper actionWrapper = (ActionWrapper)Mockito.mock(ActionWrapper.class);
        ((ActionSetFactPlugin)Mockito.doReturn((Object)actionWrapper).when((Object)this.plugin)).editingWrapper();
        this.plugin.isHideColumn();
        ((ActionWrapper)Mockito.verify((Object)actionWrapper)).isHideColumn();
    }

    @Test
    public void testSetHideColumn() {
        boolean hideColumn = false;
        ActionWrapper actionWrapper = (ActionWrapper)Mockito.mock(ActionWrapper.class);
        ((ActionSetFactPlugin)Mockito.doReturn((Object)actionWrapper).when((Object)this.plugin)).editingWrapper();
        this.plugin.setHideColumn(false);
        ((ActionWrapper)Mockito.verify((Object)actionWrapper)).setHideColumn(false);
    }

    @Test
    public void testIsNewFactPatternWhenIsNew() throws Exception {
        this.mockPatterns();
        this.plugin.setEditingPattern(new PatternWrapper("factType", "bananna"));
        Assert.assertTrue((boolean)this.plugin.isNewFactPattern());
    }

    @Test
    public void testIsNewFactPatternWhenIsExisting() throws Exception {
        this.mockPatterns();
        this.plugin.setEditingPattern(new PatternWrapper("factType", "boundName"));
        Assert.assertFalse((boolean)this.plugin.isNewFactPattern());
    }

    @Test
    public void testIsFieldBindingValid() {
        Assert.assertTrue((boolean)this.plugin.isFieldBindingValid());
    }

    @Test
    public void testIsBindable() {
        Assert.assertFalse((boolean)this.plugin.isBindable());
    }

    private void mockPatterns() {
        GuidedDecisionTable52 model = (GuidedDecisionTable52)Mockito.mock(GuidedDecisionTable52.class);
        List<Pattern52> patterns = Collections.singletonList(this.fakePattern());
        List<ActionCol52> actions = Arrays.asList(this.fakeActionCol(), this.fakeActionCol());
        Mockito.when((Object)model.getConditions()).thenReturn(patterns);
        Mockito.when((Object)model.getActionCols()).thenReturn(actions);
        Mockito.when((Object)this.presenter.getModel()).thenReturn((Object)model);
    }

    private ActionWrapper mockActionWrapper(String boundName, String factType) {
        ActionWrapper wrapper = (ActionWrapper)Mockito.mock(ActionWrapper.class);
        Mockito.when((Object)wrapper.getBoundName()).thenReturn((Object)boundName);
        Mockito.when((Object)wrapper.getFactType()).thenReturn((Object)factType);
        return wrapper;
    }

    private PatternWrapper mockPatternWrapper(String boundName) {
        PatternWrapper wrapper = (PatternWrapper)Mockito.mock(PatternWrapper.class);
        Mockito.when((Object)wrapper.getBoundName()).thenReturn((Object)boundName);
        return wrapper;
    }

    private Pattern52 fakePattern() {
        return new Pattern52(){
            {
                this.setFactType("factType");
                this.setBoundName("boundName");
                this.setNegated(true);
            }
        };
    }

    private ActionInsertFactCol52 fakeActionCol() {
        return new ActionInsertFactCol52(){
            {
                this.setFactType("factType");
                this.setBoundName("boundName");
            }
        };
    }
}

