/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins;

import org.drools.workbench.models.guided.dtable.shared.model.MetadataCol52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.MetaDataColumnPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.MetaDataColumnPlugin;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageStatusChangeEvent;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=MockitoJUnitRunner.class)
public class MetaDataColumnPluginTest {
    @Mock
    private GuidedDecisionTableView.Presenter presenter;
    @Mock
    private MetaDataColumnPage page;
    @Mock
    private TranslationService translationService;
    @Mock
    private EventSourceMock<WizardPageStatusChangeEvent> changeEvent;
    @InjectMocks
    private MetaDataColumnPlugin plugin;

    public MetaDataColumnPluginTest() {
        this.plugin = new MetaDataColumnPlugin(this.page, this.changeEvent, this.translationService);
    }

    @Test
    public void testGetTitle() {
        String errorKey = "MetaDataColumnPlugin.AddMetadataColumn";
        String errorMessage = "Title";
        Mockito.when((Object)this.translationService.format("MetaDataColumnPlugin.AddMetadataColumn", new Object[0])).thenReturn((Object)"Title");
        String title = this.plugin.getTitle();
        Assert.assertEquals((Object)"Title", (Object)title);
    }

    @Test
    public void testGetPages() throws Exception {
        Assert.assertEquals((long)1L, (long)this.plugin.getPages().size());
    }

    @Test
    public void testGenerateColumnWhenMetaDataIsValid() throws Exception {
        String metaData = "metaData";
        ArgumentCaptor colCaptor = ArgumentCaptor.forClass(MetadataCol52.class);
        this.plugin.setMetaData("metaData");
        Mockito.when((Object)this.presenter.isMetaDataUnique((String)Mockito.eq((Object)"metaData"))).thenReturn((Object)true);
        Boolean success = this.plugin.generateColumn();
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)this.presenter)).appendColumn((MetadataCol52)colCaptor.capture());
        Assert.assertTrue((boolean)success);
        Assert.assertTrue((boolean)((MetadataCol52)colCaptor.getValue()).isHideColumn());
        Assert.assertEquals((Object)"metaData", (Object)((MetadataCol52)colCaptor.getValue()).getMetadata());
    }

    @Test
    public void testSetMetaData() throws Exception {
        String metaData = "metaData";
        this.plugin.setMetaData("metaData");
        Assert.assertEquals((Object)"metaData", (Object)this.plugin.getMetaData());
        ((EventSourceMock)Mockito.verify(this.changeEvent)).fire(Matchers.any(WizardPageStatusChangeEvent.class));
    }
}

